/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.cluster.bridge;

import java.util.ArrayList;
import java.util.UUID;
import org.apache.activemq.artemis.api.core.ActiveMQException;
import org.apache.activemq.artemis.api.core.Message;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.api.core.client.ClientMessage;
import org.apache.activemq.artemis.api.core.client.ClientProducer;
import org.apache.activemq.artemis.api.core.client.ClientSession;
import org.apache.activemq.artemis.api.core.client.TopologyMember;
import org.apache.activemq.artemis.core.client.impl.TopologyMemberImpl;
import org.apache.activemq.artemis.core.server.cluster.MessageFlowRecord;
import org.apache.activemq.artemis.core.server.cluster.impl.ClusterConnectionBridge;
import org.apache.activemq.artemis.core.server.cluster.impl.ClusterConnectionImpl;
import org.apache.activemq.artemis.core.server.cluster.impl.MessageLoadBalancingType;
import org.apache.activemq.artemis.tests.integration.cluster.distribution.ClusterTestBase;
import org.apache.activemq.artemis.tests.util.Wait;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;

public class ClusteredBridgeReconnectTest
extends ClusterTestBase {
    @Test
    public void testReconnectBridge() throws Exception {
        ClientMessage msg;
        this.setupServer(0, this.isFileStorage(), this.isNetty());
        this.setupServer(1, this.isFileStorage(), this.isNetty());
        this.setupClusterConnection("cluster0", "queues", MessageLoadBalancingType.ON_DEMAND, 1, this.isNetty(), 0, 1);
        this.setupClusterConnection("cluster1", "queues", MessageLoadBalancingType.ON_DEMAND, 1, this.isNetty(), 1, 0);
        this.startServers(0, 1);
        this.setupSessionFactory(0, this.isNetty());
        this.setupSessionFactory(1, this.isNetty());
        this.createQueue(0, "queues.testaddress", "queue0", null, true);
        this.createQueue(1, "queues.testaddress", "queue0", null, true);
        this.addConsumer(0, 0, "queue0", null);
        this.addConsumer(1, 1, "queue0", null);
        this.waitForBindings(0, "queues.testaddress", 1, 1, true);
        this.waitForBindings(1, "queues.testaddress", 1, 1, true);
        this.waitForBindings(0, "queues.testaddress", 1, 1, false);
        this.waitForBindings(1, "queues.testaddress", 1, 1, false);
        ClientSession session0 = this.sfs[0].createSession();
        ClientSession session1 = this.sfs[0].createSession();
        session0.start();
        session1.start();
        ClientProducer producer = session0.createProducer("queues.testaddress");
        int NUMBER_OF_MESSAGES = 100;
        Assert.assertEquals((long)1L, (long)this.servers[0].getClusterManager().getClusterConnections().size());
        ClusterConnectionImpl connection = this.servers[0].getClusterManager().getClusterConnections().toArray(new ClusterConnectionImpl[0])[0];
        Assert.assertEquals((long)1L, (long)connection.getRecords().size());
        MessageFlowRecord record = connection.getRecords().values().toArray(new MessageFlowRecord[1])[0];
        ClusterConnectionBridge bridge = (ClusterConnectionBridge)record.getBridge();
        Wait.assertEquals((int)2, () -> bridge.getSessionFactory().getServerLocator().getTopology().getMembers().size());
        ArrayList originalmembers = new ArrayList(bridge.getSessionFactory().getServerLocator().getTopology().getMembers());
        for (int i = 0; i < NUMBER_OF_MESSAGES; ++i) {
            ClientMessage msg2 = session0.createMessage(true);
            producer.send((Message)msg2);
            session0.commit();
            if (i != 17) continue;
            bridge.getSessionFactory().getConnection().fail(new ActiveMQException("failed once!"));
        }
        Wait.assertEquals((int)2, () -> bridge.getSessionFactory().getServerLocator().getTopology().getMembers().size());
        ArrayList afterReconnectedMembers = new ArrayList(bridge.getSessionFactory().getServerLocator().getTopology().getMembers());
        boolean allFound = true;
        for (TopologyMemberImpl originalMember : originalmembers) {
            boolean found = false;
            for (TopologyMember reconnectedMember : afterReconnectedMembers) {
                if (!originalMember.equals((Object)reconnectedMember)) continue;
                found = true;
                break;
            }
            if (found) continue;
            allFound = false;
        }
        Assert.assertTrue((String)"The topology is slightly different after a reconnect", (boolean)allFound);
        int cons0Count = 0;
        int cons1Count = 0;
        while ((msg = this.consumers[0].getConsumer().receive(1000L)) != null) {
            ++cons0Count;
            msg.acknowledge();
            session0.commit();
        }
        while ((msg = this.consumers[1].getConsumer().receive(1000L)) != null) {
            ++cons1Count;
            msg.acknowledge();
            session1.commit();
        }
        Assert.assertEquals((String)("cons0 = " + cons0Count + ", cons1 = " + cons1Count), (long)NUMBER_OF_MESSAGES, (long)(cons0Count + cons1Count));
        session0.commit();
        session1.commit();
        connection = this.servers[0].getClusterManager().getClusterConnections().toArray(new ClusterConnectionImpl[0])[0];
        Assert.assertEquals((long)1L, (long)connection.getRecords().size());
        Assert.assertNotNull((Object)bridge.getSessionFactory());
        this.stopServers(0, 1);
    }

    @Test
    public void testClusterBridgeAddRemoteBinding() throws Exception {
        ClientMessage msg;
        String ADDRESS = "queues.testaddress";
        String QUEUE = UUID.randomUUID().toString();
        this.setupServer(0, this.isFileStorage(), this.isNetty());
        this.setupServer(1, this.isFileStorage(), this.isNetty());
        this.setupClusterConnection("cluster0", "queues", MessageLoadBalancingType.ON_DEMAND, 1, this.isNetty(), 0, 1);
        this.setupClusterConnection("cluster1", "queues", MessageLoadBalancingType.ON_DEMAND, 1, this.isNetty(), 1, 0);
        this.startServers(0, 1);
        this.setupSessionFactory(0, this.isNetty());
        this.setupSessionFactory(1, this.isNetty());
        this.createQueue(0, "queues.testaddress", QUEUE, null, false);
        this.addConsumer(0, 0, QUEUE, null);
        this.waitForBindings(0, "queues.testaddress", 1, 1, true);
        this.waitForBindings(1, "queues.testaddress", 0, 0, true);
        this.waitForBindings(0, "queues.testaddress", 0, 0, false);
        this.waitForBindings(1, "queues.testaddress", 1, 1, false);
        ClientSession session0 = this.sfs[0].createSession();
        ClientSession session1 = this.sfs[1].createSession();
        session0.start();
        session1.start();
        ClientProducer producer1 = session1.createProducer("queues.testaddress");
        int NUMBER_OF_MESSAGES = 10;
        for (int i = 0; i < NUMBER_OF_MESSAGES; ++i) {
            msg = session1.createMessage(true);
            producer1.send((Message)msg);
            session1.commit();
        }
        int cons0Count = 0;
        while ((msg = this.consumers[0].getConsumer().receive(1000L)) != null) {
            ++cons0Count;
            msg.acknowledge();
            session0.commit();
        }
        ClusteredBridgeReconnectTest.assertEquals((long)NUMBER_OF_MESSAGES, (long)cons0Count);
        this.removeConsumer(0);
        this.servers[0].getManagementService().enableNotifications(false);
        this.servers[0].destroyQueue(new SimpleString(QUEUE));
        this.servers[0].getManagementService().enableNotifications(true);
        this.createQueue(0, "queues.testaddress", QUEUE, null, false);
        this.addConsumer(0, 0, QUEUE, null);
        this.waitForBindings(0, "queues.testaddress", 1, 1, true);
        this.waitForBindings(1, "queues.testaddress", 0, 0, true);
        this.waitForBindings(0, "queues.testaddress", 0, 0, false);
        this.waitForBindings(1, "queues.testaddress", 1, 1, false);
        for (int i = 0; i < NUMBER_OF_MESSAGES; ++i) {
            ClientMessage msg2 = session1.createMessage(true);
            producer1.send((Message)msg2);
            session1.commit();
        }
        cons0Count = 0;
        while ((msg = this.consumers[0].getConsumer().receive(2000L)) != null) {
            ++cons0Count;
            msg.acknowledge();
            session0.commit();
        }
        ClusteredBridgeReconnectTest.assertEquals((long)NUMBER_OF_MESSAGES, (long)cons0Count);
        this.stopServers(0, 1);
    }

    @Override
    @After
    public void tearDown() throws Exception {
        this.closeAllConsumers();
        this.closeAllSessionFactories();
        this.closeAllServerLocatorsFactories();
        super.tearDown();
    }

    public boolean isNetty() {
        return true;
    }
}

