/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.auth.realm.jdbc;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.sql.DataSource;
import org.wildfly.common.Assert;
import org.wildfly.security.auth.realm.jdbc.ColumnMapper;
import org.wildfly.security.auth.realm.jdbc.JdbcSecurityRealm;
import org.wildfly.security.auth.realm.jdbc.JdbcSecurityRealmBuilder;
import org.wildfly.security.auth.realm.jdbc.QueryConfiguration;

public class QueryBuilder
extends JdbcSecurityRealmBuilder {
    private final String sql;
    private final JdbcSecurityRealmBuilder parent;
    private List<ColumnMapper> mappers = new ArrayList<ColumnMapper>();
    private DataSource dataSource;

    QueryBuilder(String sql, JdbcSecurityRealmBuilder parent) {
        Assert.checkNotNullParam("sql", sql);
        Assert.checkNotNullParam("parent", parent);
        this.sql = sql;
        this.parent = parent;
    }

    public QueryBuilder withMapper(ColumnMapper ... mapper) {
        this.mappers.addAll(Arrays.asList(mapper));
        return this;
    }

    public QueryBuilder from(DataSource dataSource) {
        this.dataSource = dataSource;
        return this;
    }

    @Override
    public QueryBuilder principalQuery(String sql) {
        return this.parent.principalQuery(sql);
    }

    @Override
    public JdbcSecurityRealm build() {
        return this.parent.build();
    }

    QueryConfiguration buildQuery() {
        return new QueryConfiguration(this.sql, this.dataSource, this.mappers);
    }
}

