/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.scattered.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.function.BiFunction;
import java.util.function.Supplier;
import org.infinispan.commands.CommandsFactory;
import org.infinispan.commands.ReplicableCommand;
import org.infinispan.commands.remote.RenewBiasCommand;
import org.infinispan.commands.remote.RevokeBiasCommand;
import org.infinispan.commons.time.TimeService;
import org.infinispan.commons.util.ByRef;
import org.infinispan.commons.util.IntSet;
import org.infinispan.commons.util.IntSets;
import org.infinispan.configuration.cache.ClusteringConfiguration;
import org.infinispan.configuration.cache.Configuration;
import org.infinispan.distribution.DistributionInfo;
import org.infinispan.distribution.DistributionManager;
import org.infinispan.distribution.ch.ConsistentHash;
import org.infinispan.distribution.ch.KeyPartitioner;
import org.infinispan.factories.annotations.ComponentName;
import org.infinispan.factories.annotations.Inject;
import org.infinispan.factories.annotations.Start;
import org.infinispan.factories.scopes.Scope;
import org.infinispan.factories.scopes.Scopes;
import org.infinispan.notifications.Listener;
import org.infinispan.notifications.cachelistener.CacheNotifier;
import org.infinispan.notifications.cachelistener.annotation.TopologyChanged;
import org.infinispan.notifications.cachelistener.event.TopologyChangedEvent;
import org.infinispan.remoting.inboundhandler.DeliverOrder;
import org.infinispan.remoting.rpc.RpcManager;
import org.infinispan.remoting.transport.Address;
import org.infinispan.remoting.transport.impl.MapResponseCollector;
import org.infinispan.scattered.BiasManager;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

@Listener
@Scope(value=Scopes.NAMED_CACHE)
public class BiasManagerImpl
implements BiasManager {
    private static Log log = LogFactory.getLog(BiasManager.class);
    private ConcurrentMap<Object, LocalBias> localBias = new ConcurrentHashMap<Object, LocalBias>();
    private ConcurrentMap<Object, RemoteBias> remoteBias = new ConcurrentHashMap<Object, RemoteBias>();
    private long renewLeasePeriod;
    @Inject
    CacheNotifier cacheNotifier;
    @Inject
    Configuration configuration;
    @Inject
    TimeService timeService;
    @Inject
    DistributionManager distributionManager;
    @Inject
    CommandsFactory commandsFactory;
    @Inject
    RpcManager rpcManager;
    @Inject
    KeyPartitioner keyPartitioner;
    @ComponentName(value="org.infinispan.executors.expiration")
    @Inject
    ScheduledExecutorService executor;

    @Start
    public void start() {
        this.executor.scheduleAtFixedRate(this::removeOldBiasses, 0L, this.configuration.expiration().wakeUpInterval(), TimeUnit.MILLISECONDS);
        this.executor.scheduleAtFixedRate(this::renewLocalBiasses, 0L, this.configuration.expiration().wakeUpInterval(), TimeUnit.MILLISECONDS);
        this.renewLeasePeriod = this.configuration.clustering().biasLifespan() - this.configuration.clustering().remoteTimeout();
        this.configuration.clustering().attributes().attribute(ClusteringConfiguration.REMOTE_TIMEOUT).addListener((a, ignored) -> {
            this.renewLeasePeriod = this.configuration.clustering().biasLifespan() - (Long)a.get();
        });
        this.cacheNotifier.addListener(this);
    }

    @TopologyChanged
    public void onTopologyChange(TopologyChangedEvent event) {
        ConsistentHash ch = event.getWriteConsistentHashAtEnd();
        IntSet localSegments = ch.getMembers().contains(this.rpcManager.getAddress()) ? IntSets.from(ch.getSegmentsForOwner(this.rpcManager.getAddress())) : IntSets.immutableEmptySet();
        this.remoteBias.keySet().removeIf(key -> !localSegments.contains(this.keyPartitioner.getSegment(key)));
        ConsistentHash previousHash = event.getReadConsistentHashAtStart();
        if (previousHash != null && !previousHash.getMembers().contains(this.rpcManager.getAddress())) {
            this.localBias.clear();
        }
    }

    private void removeOldBiasses() {
        log.trace("Purging old biasses");
        long minTimestamp = this.timeService.wallClockTime() - this.configuration.clustering().biasLifespan();
        this.remoteBias.forEach((key, bias) -> {
            if (((RemoteBias)bias).acquiredTimestamp < minTimestamp && ((RemoteBias)bias).revoking == null) {
                RemoteBias bias3 = this.remoteBias.computeIfPresent(key, (k, bias2) -> {
                    ((RemoteBias)bias2).revoking = ((RemoteBias)bias2).biased;
                    ((RemoteBias)bias2).future = new CompletableFuture();
                    return bias2;
                });
                if (bias3 == null) {
                    return;
                }
                if (log.isTraceEnabled()) {
                    log.tracef("Revoking old bias for key %s from %s", key, bias3.biased);
                }
                RevokeBiasCommand revokeBiasCommand = this.commandsFactory.buildRevokeBiasCommand(null, 0L, 0, Collections.singleton(key));
                this.rpcManager.invokeCommand(bias3.biased, (ReplicableCommand)revokeBiasCommand, MapResponseCollector.ignoreLeavers(), this.rpcManager.getSyncRpcOptions()).whenComplete((nil, throwable) -> {
                    CompletableFuture future = bias3.future;
                    if (throwable != null) {
                        if (log.isTraceEnabled()) {
                            log.tracef((Throwable)throwable, "Bias revocation for %s failed", key);
                        }
                        this.remoteBias.compute(key, (k, bias4) -> {
                            assert (bias4 != null);
                            ((RemoteBias)bias4).revoking = null;
                            ((RemoteBias)bias4).future = null;
                            return bias4;
                        });
                    } else {
                        this.remoteBias.remove(key);
                        if (log.isTraceEnabled()) {
                            log.tracef("Bias for %s has been revoked", key);
                        }
                    }
                    future.complete(null);
                });
            }
        });
        log.trace("Purge completed");
    }

    private void renewLocalBiasses() {
        log.trace("Renewing local biasses");
        long timestamp = this.timeService.wallClockTime();
        int batchSize = this.configuration.clustering().invalidationBatchSize();
        HashMap toRenew = new HashMap();
        this.localBias.forEach((key, bias) -> {
            DistributionInfo distribution;
            if (((LocalBias)bias).acquisitionTimestamp + this.renewLeasePeriod < timestamp && ((LocalBias)bias).lastAccessTimestamp > ((LocalBias)bias).acquisitionTimestamp && (distribution = this.distributionManager.getCacheTopology().getDistribution(key)).primary() != null) {
                Collection keys = toRenew.computeIfAbsent(distribution.primary(), a -> new ArrayList(batchSize));
                keys.add(key);
                ((LocalBias)bias).acquisitionTimestamp = timestamp;
                if (keys.size() >= batchSize) {
                    RenewBiasCommand renewBiasCommand = this.commandsFactory.buildRenewBiasCommand(keys.toArray(new Object[batchSize]));
                    this.rpcManager.sendTo(distribution.primary(), renewBiasCommand, DeliverOrder.NONE);
                    keys.clear();
                }
            }
        });
        for (Map.Entry entry : toRenew.entrySet()) {
            Collection keys = (Collection)entry.getValue();
            if (keys.isEmpty()) continue;
            RenewBiasCommand renewBiasCommand = this.commandsFactory.buildRenewBiasCommand(keys.toArray(new Object[keys.size()]));
            this.rpcManager.sendTo((Address)entry.getKey(), renewBiasCommand, DeliverOrder.NONE);
        }
        log.trace("Renewal completed local biasses");
    }

    @Override
    public void addLocalBias(Object key, int topologyId) {
        int currentTopologyId = this.distributionManager.getCacheTopology().getTopologyId();
        if (topologyId >= currentTopologyId) {
            if (log.isTraceEnabled()) {
                log.tracef("%s: adding local bias for %s in topology %d", this.rpcManager.getAddress(), key, topologyId);
            }
            this.localBias.put(key, new LocalBias(this.timeService.wallClockTime()));
        } else if (log.isTraceEnabled()) {
            log.tracef("%s: not adding local bias for %s in topology %d as current topology is %d", new Object[]{this.rpcManager.getAddress(), key, topologyId, currentTopologyId});
        }
    }

    @Override
    public void revokeLocalBias(Object key) {
        if (log.isTraceEnabled()) {
            log.tracef("%s: revoking local bias for %s", this.rpcManager.getAddress(), key);
        }
        this.localBias.remove(key);
    }

    @Override
    public void revokeLocalBiasForSegments(IntSet segments) {
        this.localBias.keySet().removeIf(key -> segments.contains(this.keyPartitioner.getSegment(key)));
    }

    @Override
    public boolean hasLocalBias(Object key) {
        LocalBias localBias = (LocalBias)this.localBias.get(key);
        if (log.isTraceEnabled()) {
            log.tracef("%s: local bias for %s? %s", this.rpcManager.getAddress(), key, localBias);
        }
        if (localBias != null && this.renewLeasePeriod > 0L) {
            localBias.lastAccessTimestamp = this.timeService.wallClockTime();
        }
        return localBias != null;
    }

    @Override
    public List<Address> getRemoteBias(Object key) {
        RemoteBias remoteBias = (RemoteBias)this.remoteBias.get(key);
        return remoteBias != null ? remoteBias.biased : null;
    }

    @Override
    public BiasManager.Revocation startRevokingRemoteBias(Object key, Address newBiased) {
        ByRef ref = new ByRef(null);
        this.remoteBias.compute(key, (k, bias) -> {
            if (bias == null) {
                if (log.isTraceEnabled()) {
                    log.tracef("No bias for %s no need to revoke.", key);
                }
                return new RemoteBias(newBiased, this.timeService.wallClockTime());
            }
            if (((RemoteBias)bias).revoking == null) {
                ArrayList revoking;
                if (((RemoteBias)bias).biased.contains(newBiased)) {
                    if (((RemoteBias)bias).biased.size() == 1) {
                        if (log.isTraceEnabled()) {
                            log.tracef("Not revoking bias for %s as the new biased is the same as previous: %s", k, newBiased);
                        }
                        ((RemoteBias)bias).acquiredTimestamp = this.timeService.wallClockTime();
                        return bias;
                    }
                    revoking = new ArrayList(((RemoteBias)bias).biased);
                    revoking.remove(newBiased);
                } else {
                    revoking = ((RemoteBias)bias).biased;
                }
                if (log.isTraceEnabled()) {
                    log.tracef("Revoking remote bias for %s, %s -> %s", key, ((RemoteBias)bias).biased, newBiased);
                }
                ((RemoteBias)bias).revoking = revoking;
                ((RemoteBias)bias).newBiased = Collections.singletonList(newBiased);
                ((RemoteBias)bias).future = new CompletableFuture();
                ref.set((Object)new RevocationImpl(k, revoking, ((RemoteBias)bias).future));
                return bias;
            }
            if (log.isTraceEnabled()) {
                log.tracef("Revocation already in progress for %s, %s -> %s", key, ((RemoteBias)bias).revoking, ((RemoteBias)bias).newBiased);
            }
            ref.set((Object)new RevocationImpl(k, null, ((RemoteBias)bias).future));
            return bias;
        });
        return (BiasManager.Revocation)ref.get();
    }

    @Override
    public void renewRemoteBias(Object key, Address origin) {
        RemoteBias bias = (RemoteBias)this.remoteBias.get(key);
        if (bias != null) {
            bias.acquiredTimestamp = this.timeService.wallClockTime();
        }
    }

    @Override
    public void clear() {
        this.localBias.clear();
        this.remoteBias.clear();
    }

    private static class LocalBias {
        private volatile long acquisitionTimestamp;
        private volatile long lastAccessTimestamp;

        public LocalBias(long timestamp) {
            this.acquisitionTimestamp = this.lastAccessTimestamp = timestamp;
        }

        public String toString() {
            return "LocalBias{acq=" + this.acquisitionTimestamp + ", last=" + this.lastAccessTimestamp + '}';
        }
    }

    private class RevocationImpl
    implements BiasManager.Revocation,
    BiFunction<Object, RemoteBias, RemoteBias> {
        private final Object key;
        private final List<Address> biased;
        private final CompletableFuture<?> future;

        private RevocationImpl(Object key, List<Address> biased, CompletableFuture<?> future) {
            this.key = key;
            this.biased = biased;
            this.future = future;
        }

        @Override
        public boolean shouldRevoke() {
            return this.biased != null;
        }

        @Override
        public List<Address> biased() {
            return this.biased;
        }

        @Override
        public void complete() {
            BiasManagerImpl.this.remoteBias.compute(this.key, this);
        }

        @Override
        public RemoteBias apply(Object key, RemoteBias bias) {
            if (bias == null) {
                log.tracef("Missing bias information for %s", key);
                return null;
            }
            bias.biased = bias.newBiased;
            bias.revoking = null;
            bias.newBiased = null;
            bias.acquiredTimestamp = BiasManagerImpl.this.timeService.wallClockTime();
            bias.future = null;
            if (log.isTraceEnabled()) {
                log.tracef("Bias for %s has been transferred to %s", key, bias.biased);
            }
            this.future.complete(null);
            return bias;
        }

        @Override
        public void fail() {
            BiasManagerImpl.this.remoteBias.compute(this.key, (k, bias) -> {
                if (bias == null) {
                    log.tracef("Missing bias information for %s", this.key);
                    return null;
                }
                if (log.isTraceEnabled()) {
                    log.tracef("Bias transfer for %s to %s failed, keeping %s", this.key, ((RemoteBias)bias).newBiased, ((RemoteBias)bias).biased);
                }
                ((RemoteBias)bias).revoking = null;
                ((RemoteBias)bias).newBiased = null;
                ((RemoteBias)bias).future = null;
                this.future.complete(null);
                return bias;
            });
        }

        @Override
        public CompletionStage<?> toCompletionStage() {
            return this.future;
        }

        @Override
        public <T> CompletableFuture<T> handleCompose(Supplier<CompletionStage<T>> supplier) {
            return ((CompletableFuture)this.future.handle((nil, throwable) -> null)).thenCompose(nil -> (CompletionStage)supplier.get());
        }
    }

    private static class RemoteBias {
        private List<Address> biased;
        private List<Address> revoking;
        private List<Address> newBiased;
        private CompletableFuture<?> future;
        private long acquiredTimestamp;

        public RemoteBias(Address newBiased, long acquiredTimestamp) {
            this.biased = Collections.singletonList(newBiased);
            this.acquiredTimestamp = acquiredTimestamp;
        }
    }
}

