/*
 * Decompiled with CFR 0.152.
 */
package org.jberet.creation;

import jakarta.batch.api.BatchProperty;
import jakarta.batch.runtime.context.JobContext;
import jakarta.batch.runtime.context.StepContext;
import jakarta.enterprise.inject.Produces;
import jakarta.enterprise.inject.spi.InjectionPoint;
import java.io.File;
import java.lang.reflect.Field;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.URI;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedExceptionAction;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.jar.JarFile;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import java.util.zip.ZipFile;
import javax.management.ObjectName;
import org.jberet._private.BatchLogger;
import org.jberet.creation.ArtifactCreationContext;
import org.jberet.creation.ValueConverter;
import org.jberet.job.model.Properties;
import org.wildfly.security.manager.WildFlySecurityManager;

public class BatchBeanProducer {
    @Produces
    public JobContext getJobContext() {
        return ArtifactCreationContext.getCurrentArtifactCreationContext().jobContext;
    }

    @Produces
    public StepContext getStepContext() {
        return ArtifactCreationContext.getCurrentArtifactCreationContext().stepContext;
    }

    @Produces
    @BatchProperty
    public Integer getInt(InjectionPoint injectionPoint) {
        Integer i = (Integer)this.getProperty(injectionPoint);
        if (i == null) {
            Class<?> fType = ((Field)injectionPoint.getMember()).getType();
            return fType == Integer.class ? null : Integer.valueOf(0);
        }
        return i;
    }

    @Produces
    @BatchProperty
    public int[] getIntArray(InjectionPoint injectionPoint) {
        return (int[])this.getProperty(injectionPoint);
    }

    @Produces
    @BatchProperty
    public Integer[] getIntegerArray(InjectionPoint injectionPoint) {
        return (Integer[])this.getProperty(injectionPoint);
    }

    @Produces
    @BatchProperty
    public Long getLong(InjectionPoint injectionPoint) {
        Long l = (Long)this.getProperty(injectionPoint);
        if (l == null) {
            Class<?> fType = ((Field)injectionPoint.getMember()).getType();
            return fType == Long.class ? null : Long.valueOf(0L);
        }
        return l;
    }

    @Produces
    @BatchProperty
    public Long[] getBigLongArray(InjectionPoint injectionPoint) {
        return (Long[])this.getProperty(injectionPoint);
    }

    @Produces
    @BatchProperty
    public long[] getLongArray(InjectionPoint injectionPoint) {
        return (long[])this.getProperty(injectionPoint);
    }

    @Produces
    @BatchProperty
    public Short getShort(InjectionPoint injectionPoint) {
        Short sh = (Short)this.getProperty(injectionPoint);
        if (sh == null) {
            Class<?> fType = ((Field)injectionPoint.getMember()).getType();
            return fType == Short.class ? null : Short.valueOf((short)0);
        }
        return sh;
    }

    @Produces
    @BatchProperty
    public Short[] getBigShortArray(InjectionPoint injectionPoint) {
        return (Short[])this.getProperty(injectionPoint);
    }

    @Produces
    @BatchProperty
    public short[] getShortArray(InjectionPoint injectionPoint) {
        return (short[])this.getProperty(injectionPoint);
    }

    @Produces
    @BatchProperty
    public Byte getByte(InjectionPoint injectionPoint) {
        Byte b = (Byte)this.getProperty(injectionPoint);
        if (b == null) {
            Class<?> fType = ((Field)injectionPoint.getMember()).getType();
            return fType == Byte.class ? null : Byte.valueOf((byte)0);
        }
        return b;
    }

    @Produces
    @BatchProperty
    public Byte[] getBigByteArray(InjectionPoint injectionPoint) {
        return (Byte[])this.getProperty(injectionPoint);
    }

    @Produces
    @BatchProperty
    public byte[] getByteArray(InjectionPoint injectionPoint) {
        return (byte[])this.getProperty(injectionPoint);
    }

    @Produces
    @BatchProperty
    public Character getCharacter(InjectionPoint injectionPoint) {
        Character ch = (Character)this.getProperty(injectionPoint);
        if (ch == null) {
            Class<?> fType = ((Field)injectionPoint.getMember()).getType();
            return fType == Character.class ? null : Character.valueOf('\u0000');
        }
        return ch;
    }

    @Produces
    @BatchProperty
    public Character[] getCharacterArray(InjectionPoint injectionPoint) {
        return (Character[])this.getProperty(injectionPoint);
    }

    @Produces
    @BatchProperty
    public char[] getCharArray(InjectionPoint injectionPoint) {
        return (char[])this.getProperty(injectionPoint);
    }

    @Produces
    @BatchProperty
    public Float getFloat(InjectionPoint injectionPoint) {
        Float f = (Float)this.getProperty(injectionPoint);
        if (f == null) {
            Class<?> fType = ((Field)injectionPoint.getMember()).getType();
            return fType == Float.class ? null : Float.valueOf(0.0f);
        }
        return f;
    }

    @Produces
    @BatchProperty
    public Float[] getBigFloatArray(InjectionPoint injectionPoint) {
        return (Float[])this.getProperty(injectionPoint);
    }

    @Produces
    @BatchProperty
    public float[] getFloatArray(InjectionPoint injectionPoint) {
        return (float[])this.getProperty(injectionPoint);
    }

    @Produces
    @BatchProperty
    public Double getDouble(InjectionPoint injectionPoint) {
        Double d = (Double)this.getProperty(injectionPoint);
        if (d == null) {
            Class<?> fType = ((Field)injectionPoint.getMember()).getType();
            return fType == Double.class ? null : Double.valueOf(0.0);
        }
        return d;
    }

    @Produces
    @BatchProperty
    public Double[] getBigDoubleArray(InjectionPoint injectionPoint) {
        return (Double[])this.getProperty(injectionPoint);
    }

    @Produces
    @BatchProperty
    public double[] getDoubleArray(InjectionPoint injectionPoint) {
        return (double[])this.getProperty(injectionPoint);
    }

    @Produces
    @BatchProperty
    public Boolean getBoolean(InjectionPoint injectionPoint) {
        Boolean b = (Boolean)this.getProperty(injectionPoint);
        if (b == null) {
            Class<?> fType = ((Field)injectionPoint.getMember()).getType();
            return fType == Boolean.class ? null : Boolean.FALSE;
        }
        return b;
    }

    @Produces
    @BatchProperty
    public Boolean[] getBigBooleanArray(InjectionPoint injectionPoint) {
        return (Boolean[])this.getProperty(injectionPoint);
    }

    @Produces
    @BatchProperty
    public boolean[] getBooleanArray(InjectionPoint injectionPoint) {
        return (boolean[])this.getProperty(injectionPoint);
    }

    @Produces
    @BatchProperty
    public String getString(InjectionPoint injectionPoint) {
        return (String)this.getProperty(injectionPoint);
    }

    @Produces
    @BatchProperty
    public String[] getStringArray(InjectionPoint injectionPoint) {
        return (String[])this.getProperty(injectionPoint);
    }

    @Produces
    @BatchProperty
    public Date getDate(InjectionPoint injectionPoint) {
        return (Date)this.getProperty(injectionPoint);
    }

    @Produces
    @BatchProperty
    public Date[] getDateArray(InjectionPoint injectionPoint) {
        return (Date[])this.getProperty(injectionPoint);
    }

    @Produces
    @BatchProperty
    public Class getClazz(InjectionPoint injectionPoint) {
        return (Class)this.getProperty(injectionPoint);
    }

    @Produces
    @BatchProperty
    public Class[] getClazzArray(InjectionPoint injectionPoint) {
        return (Class[])this.getProperty(injectionPoint);
    }

    @Produces
    @BatchProperty
    public Inet4Address getInet4Address(InjectionPoint injectionPoint) {
        return (Inet4Address)this.getProperty(injectionPoint);
    }

    @Produces
    @BatchProperty
    public Inet6Address getInet6Address(InjectionPoint injectionPoint) {
        return (Inet6Address)this.getProperty(injectionPoint);
    }

    @Produces
    @BatchProperty
    public Map getMap(InjectionPoint injectionPoint) {
        return (Map)this.getProperty(injectionPoint);
    }

    @Produces
    @BatchProperty
    public Map<String, String> getStringMap(InjectionPoint injectionPoint) {
        return (Map)this.getProperty(injectionPoint);
    }

    @Produces
    @BatchProperty
    public Set getSet(InjectionPoint injectionPoint) {
        return (Set)this.getProperty(injectionPoint);
    }

    @Produces
    @BatchProperty
    public Set<String> getStringSet(InjectionPoint injectionPoint) {
        return (Set)this.getProperty(injectionPoint);
    }

    @Produces
    @BatchProperty
    public Logger getLogger(InjectionPoint injectionPoint) {
        return (Logger)this.getProperty(injectionPoint);
    }

    @Produces
    @BatchProperty
    public Pattern getPattern(InjectionPoint injectionPoint) {
        return (Pattern)this.getProperty(injectionPoint);
    }

    @Produces
    @BatchProperty
    public ObjectName getObjectName(InjectionPoint injectionPoint) {
        return (ObjectName)this.getProperty(injectionPoint);
    }

    @Produces
    @BatchProperty
    public List getList(InjectionPoint injectionPoint) {
        return (List)this.getProperty(injectionPoint);
    }

    @Produces
    @BatchProperty
    public List<String> getStringList(InjectionPoint injectionPoint) {
        return (List)this.getProperty(injectionPoint);
    }

    @Produces
    @BatchProperty
    public BigInteger getBigInteger(InjectionPoint injectionPoint) {
        return (BigInteger)this.getProperty(injectionPoint);
    }

    @Produces
    @BatchProperty
    public BigInteger[] getBigIntegerArray(InjectionPoint injectionPoint) {
        return (BigInteger[])this.getProperty(injectionPoint);
    }

    @Produces
    @BatchProperty
    public BigDecimal getBigDecimal(InjectionPoint injectionPoint) {
        return (BigDecimal)this.getProperty(injectionPoint);
    }

    @Produces
    @BatchProperty
    public BigDecimal[] getBigDecimalArray(InjectionPoint injectionPoint) {
        return (BigDecimal[])this.getProperty(injectionPoint);
    }

    @Produces
    @BatchProperty
    public URL getURL(InjectionPoint injectionPoint) {
        return (URL)this.getProperty(injectionPoint);
    }

    @Produces
    @BatchProperty
    public URL[] getURLArray(InjectionPoint injectionPoint) {
        return (URL[])this.getProperty(injectionPoint);
    }

    @Produces
    @BatchProperty
    public URI getURI(InjectionPoint injectionPoint) {
        return (URI)this.getProperty(injectionPoint);
    }

    @Produces
    @BatchProperty
    public URI[] getURIArray(InjectionPoint injectionPoint) {
        return (URI[])this.getProperty(injectionPoint);
    }

    @Produces
    @BatchProperty
    public File getFile(InjectionPoint injectionPoint) {
        return (File)this.getProperty(injectionPoint);
    }

    @Produces
    @BatchProperty
    public File[] getFileArray(InjectionPoint injectionPoint) {
        return (File[])this.getProperty(injectionPoint);
    }

    @Produces
    @BatchProperty
    public ZipFile[] getZipFileArray(InjectionPoint injectionPoint) {
        return (ZipFile[])this.getProperty(injectionPoint);
    }

    @Produces
    @BatchProperty
    public JarFile getJarFile(InjectionPoint injectionPoint) {
        return (JarFile)this.getProperty(injectionPoint);
    }

    @Produces
    @BatchProperty
    public JarFile[] getJarFileArray(InjectionPoint injectionPoint) {
        return (JarFile[])this.getProperty(injectionPoint);
    }

    @Produces
    @BatchProperty
    public StringBuilder getStringBuilder(InjectionPoint injectionPoint) {
        return (StringBuilder)this.getProperty(injectionPoint);
    }

    @Produces
    @BatchProperty
    public StringBuffer getStringBuffer(InjectionPoint injectionPoint) {
        return (StringBuffer)this.getProperty(injectionPoint);
    }

    private <T> T getProperty(InjectionPoint injectionPoint) {
        String rawVal;
        BatchProperty batchProperty = (BatchProperty)injectionPoint.getAnnotated().getAnnotation(BatchProperty.class);
        String propName = batchProperty.name();
        final Field field = (Field)injectionPoint.getMember();
        if (propName.length() == 0) {
            propName = field.getName();
        }
        ArtifactCreationContext ac = ArtifactCreationContext.getCurrentArtifactCreationContext();
        Properties properties = ac.properties;
        String string = rawVal = properties == null ? null : properties.get(propName);
        if (rawVal == null) {
            try {
                Object fieldVal;
                Class beanClass = injectionPoint.getBean().getBeanClass();
                final Object o = beanClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                if (WildFlySecurityManager.isChecking()) {
                    fieldVal = AccessController.doPrivileged(new PrivilegedExceptionAction<Object>(){

                        @Override
                        public Object run() throws Exception {
                            if (!field.isAccessible()) {
                                field.setAccessible(true);
                            }
                            return field.get(o);
                        }
                    });
                } else {
                    if (!field.isAccessible()) {
                        field.setAccessible(true);
                    }
                    fieldVal = field.get(o);
                }
                return (T)fieldVal;
            }
            catch (Exception e) {
                BatchLogger.LOGGER.tracef(e, "Failed to get the default value for undefined batch property %s, will use null.", propName);
                return null;
            }
        }
        if (rawVal.isEmpty()) {
            return null;
        }
        Class<String> fieldType = field.getType();
        return (T)(fieldType.isAssignableFrom(String.class) ? rawVal : ValueConverter.convertFieldValue(rawVal, fieldType, field, ac.jobContext.getClassLoader()));
    }
}

