/*
 * Decompiled with CFR 0.152.
 */
package org.jberet.repository;

import jakarta.batch.runtime.BatchStatus;
import jakarta.batch.runtime.JobExecution;
import jakarta.batch.runtime.JobInstance;
import jakarta.batch.runtime.Metric;
import jakarta.batch.runtime.StepExecution;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Properties;
import java.util.Scanner;
import java.util.function.BiFunction;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.sql.DataSource;
import org.jberet._private.BatchLogger;
import org.jberet._private.BatchMessages;
import org.jberet.repository.AbstractPersistentRepository;
import org.jberet.repository.ApplicationAndJobName;
import org.jberet.repository.SoftReference;
import org.jberet.repository.TableColumns;
import org.jberet.runtime.AbstractStepExecution;
import org.jberet.runtime.JobExecutionImpl;
import org.jberet.runtime.JobInstanceImpl;
import org.jberet.runtime.PartitionExecutionImpl;
import org.jberet.runtime.StepExecutionImpl;
import org.jberet.util.BatchUtil;
import org.wildfly.security.manager.WildFlySecurityManager;

public final class JdbcRepository
extends AbstractPersistentRepository {
    public static final String DDL_FILE_NAME_KEY = "ddl-file";
    public static final String SQL_FILE_NAME_KEY = "sql-file";
    public static final String DATASOURCE_JNDI_KEY = "datasource-jndi";
    public static final String DB_URL_KEY = "db-url";
    public static final String DB_USER_KEY = "db-user";
    public static final String DB_PASSWORD_KEY = "db-password";
    public static final String DB_PROPERTIES_KEY = "db-properties";
    public static final String DB_PROPERTY_DELIM = ":";
    public static final String DB_TABLE_PREFIX_KEY = "db-table-prefix";
    public static final String DB_TABLE_SUFFIX_KEY = "db-table-suffix";
    private static final String DEFAULT_DB_URL = "jdbc:h2:~/jberet-repo";
    private static final String DEFAULT_SQL_FILE = "sql/jberet-sql.properties";
    private static final String DEFAULT_DDL_FILE = "sql/jberet.ddl";
    private static final String SELECT_ALL_JOB_INSTANCES = "select-all-job-instances";
    private static final String COUNT_JOB_INSTANCES_BY_JOB_NAME = "count-job-instances-by-job-name";
    private static final String SELECT_JOB_INSTANCES_BY_JOB_NAME = "select-job-instances-by-job-name";
    private static final String SELECT_JOB_INSTANCE = "select-job-instance";
    private static final String INSERT_JOB_INSTANCE = "insert-job-instance";
    private static final String SELECT_ALL_JOB_EXECUTIONS = "select-all-job-executions";
    private static final String SELECT_JOB_EXECUTIONS_BY_JOB_INSTANCE_ID = "select-job-executions-by-job-instance-id";
    private static final String SELECT_RUNNING_JOB_EXECUTIONS_BY_JOB_NAME = "select-running-job-executions-by-job-name";
    private static final String SELECT_JOB_EXECUTIONS_BY_JOB_NAME = "select-job-executions-by-job-name";
    private static final String SELECT_JOB_EXECUTION = "select-job-execution";
    private static final String INSERT_JOB_EXECUTION = "insert-job-execution";
    private static final String UPDATE_JOB_EXECUTION = "update-job-execution";
    private static final String UPDATE_JOB_EXECUTION_AND_PARAMETERS = "update-job-execution-and-parameters";
    private static final String UPDATE_JOB_EXECUTION_PARTIAL = "update-job-execution-partial";
    private static final String STOP_JOB_EXECUTION = "stop-job-execution";
    private static final String SELECT_ALL_STEP_EXECUTIONS = "select-all-step-executions";
    private static final String SELECT_STEP_EXECUTIONS_BY_JOB_EXECUTION_ID = "select-step-executions-by-job-execution-id";
    private static final String SELECT_STEP_EXECUTION = "select-step-execution";
    private static final String INSERT_STEP_EXECUTION = "insert-step-execution";
    private static final String UPDATE_STEP_EXECUTION = "update-step-execution";
    private static final String UPDATE_STEP_EXECUTION_IF_NOT_STOPPING = "update-step-execution-if-not-stopping";
    private static final String STOP_STEP_EXECUTION = "stop-step-execution";
    private static final String FIND_ORIGINAL_STEP_EXECUTION = "find-original-step-execution";
    private static final String COUNT_STEP_EXECUTIONS_BY_JOB_INSTANCE_ID = "count-step-executions-by-job-instance-id";
    private static final String COUNT_PARTITION_EXECUTIONS = "count-partition-executions";
    private static final String SELECT_PARTITION_EXECUTIONS_BY_STEP_EXECUTION_ID = "select-partition-executions-by-step-execution-id";
    private static final String INSERT_PARTITION_EXECUTION = "insert-partition-execution";
    private static final String UPDATE_PARTITION_EXECUTION = "update-partition-execution";
    private static final String UPDATE_PARTITION_EXECUTION_IF_NOT_STOPPING = "update-partition-execution-if-not-stopping";
    private static final String STOP_PARTITION_EXECUTION = "stop-partition-execution";
    private final DataSource dataSource;
    private final String dbUrl;
    private final String userDefinedDdlFile;
    private final Properties dbProperties;
    private final Properties sqls = new Properties();
    private boolean isOracle;
    private int[] idIndexInOracle;

    public static JdbcRepository create(Properties configProperties) {
        return new JdbcRepository(configProperties);
    }

    public JdbcRepository(Properties configProperties) {
        String dataSourceName = configProperties.getProperty(DATASOURCE_JNDI_KEY);
        this.dbProperties = new Properties();
        this.userDefinedDdlFile = configProperties.getProperty(DDL_FILE_NAME_KEY);
        if (dataSourceName != null) {
            dataSourceName = dataSourceName.trim();
        }
        if (dataSourceName != null && !dataSourceName.isEmpty()) {
            this.dbUrl = null;
            try {
                this.dataSource = (DataSource)InitialContext.doLookup(dataSourceName);
            }
            catch (NamingException e) {
                throw BatchMessages.MESSAGES.failToLookupDataSource(e, dataSourceName);
            }
        } else {
            String s;
            String dbPassword;
            String dbUrl = configProperties.getProperty(DB_URL_KEY);
            this.dataSource = null;
            if (dbUrl != null) {
                dbUrl = dbUrl.trim();
            }
            if (dbUrl == null || dbUrl.isEmpty()) {
                dbUrl = DEFAULT_DB_URL;
            }
            this.dbUrl = dbUrl;
            String dbUser = configProperties.getProperty(DB_USER_KEY);
            if (dbUser != null) {
                this.dbProperties.setProperty("user", dbUser.trim());
            }
            if ((dbPassword = configProperties.getProperty(DB_PASSWORD_KEY)) != null) {
                this.dbProperties.setProperty("password", dbPassword.trim());
            }
            if ((s = configProperties.getProperty(DB_PROPERTIES_KEY)) != null) {
                String[] ss;
                for (String kv : ss = s.trim().split(DB_PROPERTY_DELIM)) {
                    int equalSign = kv.indexOf(61);
                    if (equalSign <= 0) continue;
                    this.dbProperties.setProperty(kv.substring(0, equalSign), kv.substring(equalSign + 1));
                }
            }
        }
        this.createTables(configProperties);
    }

    public JdbcRepository(DataSource dataSource) {
        this(dataSource, new Properties());
    }

    public JdbcRepository(DataSource dataSource, Properties configProperties) {
        if (dataSource == null) {
            throw BatchMessages.MESSAGES.nullVar("dataSource");
        }
        if (configProperties == null) {
            throw BatchMessages.MESSAGES.nullVar("configProperties");
        }
        this.dbProperties = new Properties();
        this.userDefinedDdlFile = configProperties.getProperty(DDL_FILE_NAME_KEY);
        this.dataSource = dataSource;
        this.dbUrl = null;
        this.createTables(configProperties);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private void createTables(Properties configProperties) {
        block42: {
            String sqlFile = configProperties.getProperty(SQL_FILE_NAME_KEY);
            if (sqlFile != null) {
                sqlFile = sqlFile.trim();
            }
            if (sqlFile == null || sqlFile.isEmpty()) {
                sqlFile = DEFAULT_SQL_FILE;
            }
            String tablePrefix = configProperties.getProperty(DB_TABLE_PREFIX_KEY, "").trim();
            String tableSuffix = configProperties.getProperty(DB_TABLE_SUFFIX_KEY, "").trim();
            Pattern tableNamesPattern = tablePrefix.length() > 0 || tableSuffix.length() > 0 ? Pattern.compile("JOB_INSTANCE|JOB_EXECUTION|STEP_EXECUTION|PARTITION_EXECUTION") : null;
            InputStream sqlResource = JdbcRepository.getClassLoader(false).getResourceAsStream(sqlFile);
            try {
                if (sqlResource == null) {
                    throw BatchMessages.MESSAGES.failToLoadSqlProperties(null, sqlFile);
                }
                this.sqls.load(sqlResource);
                if (tableNamesPattern != null) {
                    BatchLogger.LOGGER.tracef("Applying batch job repository table prefix %s and suffix %s%n", tablePrefix, tableSuffix);
                    this.sqls.replaceAll((BiFunction<? super Object, ? super Object, ?>)((BiFunction<Object, Object, Object>)(k, v) -> JdbcRepository.addPrefixSuffix((String)v, tablePrefix, tableSuffix, tableNamesPattern)));
                }
            }
            catch (IOException e) {
                throw BatchMessages.MESSAGES.failToLoadSqlProperties(e, sqlFile);
            }
            finally {
                if (sqlResource != null) {
                    try {
                        sqlResource.close();
                    }
                    catch (IOException e) {
                        BatchLogger.LOGGER.failToClose(e, InputStream.class, sqlResource);
                    }
                }
            }
            String countPartitionExecutions = this.sqls.getProperty(COUNT_PARTITION_EXECUTIONS);
            Connection connection1 = this.getConnection();
            ResultSet rs = null;
            PreparedStatement countPartitionExecutionStatement = null;
            PreparedStatement countJobInstancesStatement = null;
            InputStream ddlResource = null;
            String databaseProductName = "";
            try {
                databaseProductName = connection1.getMetaData().getDatabaseProductName().trim();
            }
            catch (SQLException e) {
                BatchLogger.LOGGER.failToGetDatabaseProductName(e, connection1);
                this.close(connection1, null, null, null);
                connection1 = this.getConnection();
            }
            catch (Exception e) {
                BatchLogger.LOGGER.failToGetDatabaseProductName(e, connection1);
            }
            if (databaseProductName.startsWith("Oracle")) {
                this.isOracle = true;
                this.idIndexInOracle = new int[]{1};
            }
            countPartitionExecutionStatement = connection1.prepareStatement(countPartitionExecutions);
            rs = countPartitionExecutionStatement.executeQuery();
            this.close(connection1, countPartitionExecutionStatement, countJobInstancesStatement, rs);
            try {
                if (ddlResource != null) {
                    ddlResource.close();
                }
                break block42;
            }
            catch (Exception e) {
                BatchLogger.LOGGER.failToClose(e, InputStream.class, ddlResource);
            }
            break block42;
            catch (SQLException e) {
                try {
                    String ddlFile = this.getDDLLocation(databaseProductName);
                    ddlResource = JdbcRepository.getClassLoader(false).getResourceAsStream(ddlFile);
                    if (ddlResource == null) {
                        throw BatchMessages.MESSAGES.failToLoadDDL(ddlFile);
                    }
                    Scanner scanner = new Scanner(ddlResource).useDelimiter("!!");
                    Connection connection2 = null;
                    Statement batchDDLStatement = null;
                    try {
                        connection2 = this.getConnection();
                        batchDDLStatement = connection2.createStatement();
                        while (scanner.hasNext()) {
                            String ddlEntry = scanner.next().trim();
                            if (ddlEntry.isEmpty()) continue;
                            if (tableNamesPattern != null) {
                                ddlEntry = JdbcRepository.addPrefixSuffix(ddlEntry, tablePrefix, tableSuffix, tableNamesPattern);
                            }
                            batchDDLStatement.addBatch(ddlEntry);
                            BatchLogger.LOGGER.addDDLEntry(ddlEntry);
                        }
                        scanner.close();
                        batchDDLStatement.executeBatch();
                        BatchLogger.LOGGER.tableCreated(ddlFile);
                    }
                    catch (Exception e1) {
                        try {
                            String countJobInstances = this.sqls.getProperty(COUNT_JOB_INSTANCES_BY_JOB_NAME);
                            countJobInstancesStatement = connection1.prepareStatement(countJobInstances);
                            countJobInstancesStatement.setString(1, "A");
                            rs = countJobInstancesStatement.executeQuery();
                            BatchLogger.LOGGER.tracef("This invocation needed to create tables since they didn't exit, but failed to create because they've been created by another concurrent invocation, so ignore the exception and return normally: %s", e1);
                        }
                        catch (SQLException sqle) {
                            throw BatchMessages.MESSAGES.failToCreateTables(e1, databaseProductName, ddlFile);
                        }
                    }
                    finally {
                        this.close(connection2, batchDDLStatement, null, null);
                    }
                    this.close(connection1, countPartitionExecutionStatement, countJobInstancesStatement, rs);
                }
                catch (Throwable throwable) {
                    this.close(connection1, countPartitionExecutionStatement, countJobInstancesStatement, rs);
                    try {
                        if (ddlResource != null) {
                            ddlResource.close();
                        }
                    }
                    catch (Exception e2) {
                        BatchLogger.LOGGER.failToClose(e2, InputStream.class, ddlResource);
                    }
                    throw throwable;
                }
                try {
                    if (ddlResource != null) {
                        ddlResource.close();
                    }
                }
                catch (Exception e3) {
                    BatchLogger.LOGGER.failToClose(e3, InputStream.class, ddlResource);
                }
            }
        }
    }

    @Override
    void insertJobInstance(JobInstanceImpl jobInstance) {
        String insert = this.sqls.getProperty(INSERT_JOB_INSTANCE);
        Connection connection = this.getConnection();
        ResultSet rs = null;
        PreparedStatement preparedStatement = null;
        try {
            preparedStatement = this.isOracle ? connection.prepareStatement(insert, this.idIndexInOracle) : connection.prepareStatement(insert, 1);
            preparedStatement.setString(1, jobInstance.getJobName());
            preparedStatement.setString(2, jobInstance.getApplicationName());
            preparedStatement.executeUpdate();
            rs = preparedStatement.getGeneratedKeys();
            rs.next();
            jobInstance.setId(rs.getLong(1));
            BatchLogger.LOGGER.persisted(jobInstance, jobInstance.getInstanceId());
            this.close(connection, preparedStatement, null, rs);
        }
        catch (Exception e) {
            try {
                throw BatchMessages.MESSAGES.failToRunQuery(e, insert);
            }
            catch (Throwable throwable) {
                this.close(connection, preparedStatement, null, rs);
                throw throwable;
            }
        }
    }

    @Override
    public List<JobInstance> getJobInstances(String jobName) {
        boolean selectAll = jobName == null || jobName.equals("*");
        String select = selectAll ? this.sqls.getProperty(SELECT_ALL_JOB_INSTANCES) : this.sqls.getProperty(SELECT_JOB_INSTANCES_BY_JOB_NAME);
        Connection connection = this.getConnection();
        ResultSet rs = null;
        PreparedStatement preparedStatement = null;
        ArrayList<JobInstance> result = new ArrayList<JobInstance>();
        try {
            preparedStatement = connection.prepareStatement(select);
            if (!selectAll) {
                preparedStatement.setString(1, jobName);
            }
            rs = preparedStatement.executeQuery();
            while (rs.next()) {
                JobInstanceImpl jobInstance1;
                long i = rs.getLong("JOBINSTANCEID");
                SoftReference ref = (SoftReference)this.jobInstances.get(i);
                JobInstanceImpl jobInstanceImpl = jobInstance1 = ref != null ? (JobInstanceImpl)ref.get() : null;
                if (jobInstance1 == null) {
                    String appName = rs.getString("APPLICATIONNAME");
                    if (selectAll) {
                        String goodJobName = rs.getString("JOBNAME");
                        jobInstance1 = new JobInstanceImpl(this.getJob(new ApplicationAndJobName(appName, goodJobName)), appName, goodJobName);
                    } else {
                        jobInstance1 = new JobInstanceImpl(this.getJob(new ApplicationAndJobName(appName, jobName)), appName, jobName);
                    }
                    jobInstance1.setId(i);
                    this.jobInstances.put(i, new SoftReference<JobInstanceImpl, Long>(jobInstance1, this.jobInstanceReferenceQueue, i));
                }
                result.add(jobInstance1);
            }
            this.close(connection, preparedStatement, null, rs);
        }
        catch (Exception e) {
            try {
                throw BatchMessages.MESSAGES.failToRunQuery(e, select);
            }
            catch (Throwable throwable) {
                this.close(connection, preparedStatement, null, rs);
                throw throwable;
            }
        }
        return result;
    }

    @Override
    public JobInstanceImpl getJobInstance(long jobInstanceId) {
        JobInstanceImpl result = super.getJobInstance(jobInstanceId);
        if (result != null) {
            return result;
        }
        String select = this.sqls.getProperty(SELECT_JOB_INSTANCE);
        Connection connection = this.getConnection();
        ResultSet rs = null;
        PreparedStatement preparedStatement = null;
        try {
            preparedStatement = connection.prepareStatement(select);
            preparedStatement.setLong(1, jobInstanceId);
            rs = preparedStatement.executeQuery();
            if (rs.next()) {
                SoftReference jobInstanceSoftReference = (SoftReference)this.jobInstances.get(jobInstanceId);
                JobInstanceImpl jobInstanceImpl = result = jobInstanceSoftReference != null ? (JobInstanceImpl)jobInstanceSoftReference.get() : null;
                if (result == null) {
                    String appName = rs.getString("APPLICATIONNAME");
                    String goodJobName = rs.getString("JOBNAME");
                    result = new JobInstanceImpl(this.getJob(new ApplicationAndJobName(appName, goodJobName)), appName, goodJobName);
                    result.setId(jobInstanceId);
                    this.jobInstances.put(jobInstanceId, new SoftReference<JobInstanceImpl, Long>(result, this.jobInstanceReferenceQueue, jobInstanceId));
                }
            }
            this.close(connection, preparedStatement, null, rs);
        }
        catch (Exception e) {
            try {
                throw BatchMessages.MESSAGES.failToRunQuery(e, select);
            }
            catch (Throwable throwable) {
                this.close(connection, preparedStatement, null, rs);
                throw throwable;
            }
        }
        return result;
    }

    @Override
    public int getJobInstanceCount(String jobName) {
        String select = this.sqls.getProperty(COUNT_JOB_INSTANCES_BY_JOB_NAME);
        Connection connection = this.getConnection();
        ResultSet rs = null;
        PreparedStatement preparedStatement = null;
        int count = 0;
        try {
            preparedStatement = connection.prepareStatement(select);
            preparedStatement.setString(1, jobName);
            rs = preparedStatement.executeQuery();
            if (rs.next()) {
                count = rs.getInt(1);
            }
            this.close(connection, preparedStatement, null, rs);
        }
        catch (Exception e) {
            try {
                throw BatchMessages.MESSAGES.failToRunQuery(e, select);
            }
            catch (Throwable throwable) {
                this.close(connection, preparedStatement, null, rs);
                throw throwable;
            }
        }
        return count;
    }

    @Override
    void insertJobExecution(JobExecutionImpl jobExecution) {
        String insert = this.sqls.getProperty(INSERT_JOB_EXECUTION);
        Connection connection = this.getConnection();
        ResultSet rs = null;
        PreparedStatement preparedStatement = null;
        try {
            preparedStatement = this.isOracle ? connection.prepareStatement(insert, this.idIndexInOracle) : connection.prepareStatement(insert, 1);
            preparedStatement.setLong(1, jobExecution.getJobInstance().getInstanceId());
            preparedStatement.setTimestamp(2, JdbcRepository.createTimestamp(jobExecution.getCreateTime()));
            preparedStatement.setString(3, jobExecution.getBatchStatus().name());
            preparedStatement.setString(4, BatchUtil.propertiesToString(jobExecution.getJobParameters()));
            preparedStatement.executeUpdate();
            rs = preparedStatement.getGeneratedKeys();
            rs.next();
            jobExecution.setId(rs.getLong(1));
            BatchLogger.LOGGER.persisted(jobExecution, jobExecution.getExecutionId());
            this.close(connection, preparedStatement, null, rs);
        }
        catch (Exception e) {
            try {
                throw BatchMessages.MESSAGES.failToRunQuery(e, insert);
            }
            catch (Throwable throwable) {
                this.close(connection, preparedStatement, null, rs);
                throw throwable;
            }
        }
    }

    @Override
    public void updateJobExecution(JobExecutionImpl jobExecution, boolean fullUpdate, boolean saveJobParameters) {
        super.updateJobExecution(jobExecution, fullUpdate, saveJobParameters);
        String update = fullUpdate ? (saveJobParameters ? this.sqls.getProperty(UPDATE_JOB_EXECUTION_AND_PARAMETERS) : this.sqls.getProperty(UPDATE_JOB_EXECUTION)) : this.sqls.getProperty(UPDATE_JOB_EXECUTION_PARTIAL);
        Connection connection = this.getConnection();
        PreparedStatement preparedStatement = null;
        try {
            preparedStatement = connection.prepareStatement(update);
            if (fullUpdate) {
                preparedStatement.setTimestamp(1, JdbcRepository.createTimestamp(jobExecution.getEndTime()));
                preparedStatement.setTimestamp(2, JdbcRepository.createTimestamp(jobExecution.getLastUpdatedTime()));
                preparedStatement.setString(3, jobExecution.getBatchStatus().name());
                preparedStatement.setString(4, jobExecution.getExitStatus());
                preparedStatement.setString(5, jobExecution.combineRestartPositionAndUser());
                if (saveJobParameters) {
                    preparedStatement.setString(6, BatchUtil.propertiesToString(jobExecution.getJobParameters()));
                    preparedStatement.setLong(7, jobExecution.getExecutionId());
                } else {
                    preparedStatement.setLong(6, jobExecution.getExecutionId());
                }
            } else {
                preparedStatement.setTimestamp(1, JdbcRepository.createTimestamp(jobExecution.getLastUpdatedTime()));
                preparedStatement.setTimestamp(2, JdbcRepository.createTimestamp(jobExecution.getStartTime()));
                preparedStatement.setString(3, jobExecution.getBatchStatus().name());
                preparedStatement.setLong(4, jobExecution.getExecutionId());
            }
            preparedStatement.executeUpdate();
        }
        catch (Exception e) {
            throw BatchMessages.MESSAGES.failToRunQuery(e, update);
        }
        finally {
            this.close(connection, preparedStatement, null, null);
        }
    }

    @Override
    public void stopJobExecution(JobExecutionImpl jobExecution) {
        super.stopJobExecution(jobExecution);
        Object[] stopExecutionSqls = new String[]{this.sqls.getProperty(STOP_JOB_EXECUTION), this.sqls.getProperty(STOP_STEP_EXECUTION), this.sqls.getProperty(STOP_PARTITION_EXECUTION)};
        String jobExecutionIdString = String.valueOf(jobExecution.getExecutionId());
        String newBatchStatus = BatchStatus.STOPPING.toString();
        Connection connection = this.getConnection();
        Statement stmt = null;
        try {
            stmt = connection.createStatement();
            for (Object sql : stopExecutionSqls) {
                stmt.addBatch(((String)sql).replace("?", jobExecutionIdString));
            }
            stmt.executeBatch();
        }
        catch (Exception e) {
            throw BatchMessages.MESSAGES.failToRunQuery(e, Arrays.toString(stopExecutionSqls));
        }
        finally {
            this.close(connection, stmt, null, null);
        }
    }

    @Override
    public JobExecutionImpl getJobExecution(long jobExecutionId) {
        JobExecutionImpl result = super.getJobExecution(jobExecutionId);
        if (result != null && !this.isExecutionStale(result)) {
            return result;
        }
        String select = this.sqls.getProperty(SELECT_JOB_EXECUTION);
        Connection connection = this.getConnection();
        ResultSet rs = null;
        PreparedStatement preparedStatement = null;
        try {
            preparedStatement = connection.prepareStatement(select);
            preparedStatement.setLong(1, jobExecutionId);
            rs = preparedStatement.executeQuery();
            if (rs.next()) {
                SoftReference ref = (SoftReference)this.jobExecutions.get(jobExecutionId);
                result = ref != null ? (JobExecutionImpl)ref.get() : null;
                long jobInstanceId = rs.getLong("JOBINSTANCEID");
                if (result == null) {
                    result = new JobExecutionImpl(this.getJobInstance(jobInstanceId), jobExecutionId, BatchUtil.stringToProperties(rs.getString("JOBPARAMETERS")), rs.getTimestamp("CREATETIME"), rs.getTimestamp("STARTTIME"), rs.getTimestamp("ENDTIME"), rs.getTimestamp("LASTUPDATEDTIME"), rs.getString("BATCHSTATUS"), rs.getString("EXITSTATUS"), rs.getString("RESTARTPOSITION"));
                    this.jobExecutions.put(jobExecutionId, new SoftReference<JobExecutionImpl, Long>(result, this.jobExecutionReferenceQueue, jobExecutionId));
                } else if (result.getEndTime() == null && rs.getTimestamp("ENDTIME") != null) {
                    Properties jobParameters1 = BatchUtil.stringToProperties(rs.getString("JOBPARAMETERS"));
                    result = new JobExecutionImpl(this.getJobInstance(jobInstanceId), jobExecutionId, BatchUtil.stringToProperties(rs.getString("JOBPARAMETERS")), rs.getTimestamp("CREATETIME"), rs.getTimestamp("STARTTIME"), rs.getTimestamp("ENDTIME"), rs.getTimestamp("LASTUPDATEDTIME"), rs.getString("BATCHSTATUS"), rs.getString("EXITSTATUS"), rs.getString("RESTARTPOSITION"));
                    this.jobExecutions.replace(jobExecutionId, new SoftReference<JobExecutionImpl, Long>(result, this.jobExecutionReferenceQueue, jobExecutionId));
                }
            }
            this.close(connection, preparedStatement, null, rs);
        }
        catch (Exception e) {
            try {
                throw BatchMessages.MESSAGES.failToRunQuery(e, select);
            }
            catch (Throwable throwable) {
                this.close(connection, preparedStatement, null, rs);
                throw throwable;
            }
        }
        return result;
    }

    @Override
    public List<JobExecution> getJobExecutions(JobInstance jobInstance) {
        String select;
        long jobInstanceId = 0L;
        if (jobInstance == null) {
            select = this.sqls.getProperty(SELECT_ALL_JOB_EXECUTIONS);
        } else {
            select = this.sqls.getProperty(SELECT_JOB_EXECUTIONS_BY_JOB_INSTANCE_ID);
            jobInstanceId = jobInstance.getInstanceId();
        }
        ArrayList<JobExecution> result = new ArrayList<JobExecution>();
        Connection connection = this.getConnection();
        ResultSet rs = null;
        PreparedStatement preparedStatement = null;
        try {
            preparedStatement = connection.prepareStatement(select);
            if (jobInstance != null) {
                preparedStatement.setLong(1, jobInstanceId);
            }
            rs = preparedStatement.executeQuery();
            while (rs.next()) {
                Properties jobParameters1;
                JobExecutionImpl jobExecution1;
                long executionId = rs.getLong("JOBEXECUTIONID");
                SoftReference ref = (SoftReference)this.jobExecutions.get(executionId);
                JobExecutionImpl jobExecutionImpl = jobExecution1 = ref != null ? (JobExecutionImpl)ref.get() : null;
                if (jobExecution1 == null) {
                    if (jobInstance == null) {
                        jobInstanceId = rs.getLong("JOBINSTANCEID");
                    }
                    jobParameters1 = BatchUtil.stringToProperties(rs.getString("JOBPARAMETERS"));
                    jobExecution1 = new JobExecutionImpl(this.getJobInstance(jobInstanceId), executionId, jobParameters1, rs.getTimestamp("CREATETIME"), rs.getTimestamp("STARTTIME"), rs.getTimestamp("ENDTIME"), rs.getTimestamp("LASTUPDATEDTIME"), rs.getString("BATCHSTATUS"), rs.getString("EXITSTATUS"), rs.getString("RESTARTPOSITION"));
                    this.jobExecutions.put(executionId, new SoftReference<JobExecutionImpl, Long>(jobExecution1, this.jobExecutionReferenceQueue, executionId));
                } else if (jobExecution1.getEndTime() == null && rs.getTimestamp("ENDTIME") != null) {
                    jobParameters1 = BatchUtil.stringToProperties(rs.getString("JOBPARAMETERS"));
                    jobExecution1 = new JobExecutionImpl(this.getJobInstance(jobInstanceId), executionId, jobParameters1, rs.getTimestamp("CREATETIME"), rs.getTimestamp("STARTTIME"), rs.getTimestamp("ENDTIME"), rs.getTimestamp("LASTUPDATEDTIME"), rs.getString("BATCHSTATUS"), rs.getString("EXITSTATUS"), rs.getString("RESTARTPOSITION"));
                    this.jobExecutions.replace(executionId, new SoftReference<JobExecutionImpl, Long>(jobExecution1, this.jobExecutionReferenceQueue, executionId));
                }
                result.add(jobExecution1);
            }
            this.close(connection, preparedStatement, null, rs);
        }
        catch (Exception e) {
            try {
                throw BatchMessages.MESSAGES.failToRunQuery(e, select);
            }
            catch (Throwable throwable) {
                this.close(connection, preparedStatement, null, rs);
                throw throwable;
            }
        }
        return result;
    }

    private boolean isExecutionStale(JobExecutionImpl jobExecution) {
        BatchStatus jobStatus = jobExecution.getBatchStatus();
        return !jobStatus.equals((Object)BatchStatus.COMPLETED) && !jobStatus.equals((Object)BatchStatus.FAILED) && !jobStatus.equals((Object)BatchStatus.STOPPED) && !jobStatus.equals((Object)BatchStatus.ABANDONED) && jobExecution.getStepExecutions().size() < 1;
    }

    @Override
    public List<Long> getRunningExecutions(String jobName) {
        String select = this.sqls.getProperty(SELECT_RUNNING_JOB_EXECUTIONS_BY_JOB_NAME);
        return this.getJobExecutions0(select, jobName, true);
    }

    @Override
    public List<Long> getJobExecutionsByJob(String jobName) {
        String select = this.sqls.getProperty(SELECT_JOB_EXECUTIONS_BY_JOB_NAME);
        return this.getJobExecutions0(select, jobName, false);
    }

    @Override
    void insertStepExecution(StepExecutionImpl stepExecution, JobExecutionImpl jobExecution) {
        String insert = this.sqls.getProperty(INSERT_STEP_EXECUTION);
        Connection connection = this.getConnection();
        ResultSet rs = null;
        PreparedStatement preparedStatement = null;
        try {
            preparedStatement = this.isOracle ? connection.prepareStatement(insert, this.idIndexInOracle) : connection.prepareStatement(insert, 1);
            preparedStatement.setLong(1, jobExecution.getExecutionId());
            preparedStatement.setString(2, stepExecution.getStepName());
            preparedStatement.setTimestamp(3, new Timestamp(stepExecution.getStartTime().getTime()));
            preparedStatement.setString(4, stepExecution.getBatchStatus().name());
            preparedStatement.executeUpdate();
            rs = preparedStatement.getGeneratedKeys();
            rs.next();
            stepExecution.setId(rs.getLong(1));
            BatchLogger.LOGGER.persisted(stepExecution, stepExecution.getStepExecutionId());
            this.close(connection, preparedStatement, null, rs);
        }
        catch (Exception e) {
            try {
                throw BatchMessages.MESSAGES.failToRunQuery(e, insert);
            }
            catch (Throwable throwable) {
                this.close(connection, preparedStatement, null, rs);
                throw throwable;
            }
        }
    }

    @Override
    public void updateStepExecution(StepExecution stepExecution) {
        this.updateStepExecution0(stepExecution, this.sqls.getProperty(UPDATE_STEP_EXECUTION));
    }

    @Override
    public int savePersistentDataIfNotStopping(JobExecution jobExecution, AbstractStepExecution stepOrPartitionExecution) {
        if (stepOrPartitionExecution instanceof StepExecutionImpl) {
            return this.updateStepExecution0(stepOrPartitionExecution, this.sqls.getProperty(UPDATE_STEP_EXECUTION_IF_NOT_STOPPING));
        }
        return this.updatePartitionExecution((PartitionExecutionImpl)stepOrPartitionExecution, this.sqls.getProperty(UPDATE_PARTITION_EXECUTION_IF_NOT_STOPPING));
    }

    @Override
    public void savePersistentData(JobExecution jobExecution, AbstractStepExecution stepOrPartitionExecution) {
        super.savePersistentData(jobExecution, stepOrPartitionExecution);
        if (stepOrPartitionExecution instanceof StepExecutionImpl) {
            this.updateStepExecution(stepOrPartitionExecution);
        } else {
            this.updatePartitionExecution((PartitionExecutionImpl)stepOrPartitionExecution, this.sqls.getProperty(UPDATE_PARTITION_EXECUTION));
        }
    }

    @Override
    List<StepExecution> selectStepExecutions(Long jobExecutionId, ClassLoader classLoader) {
        String select = jobExecutionId == null ? this.sqls.getProperty(SELECT_ALL_STEP_EXECUTIONS) : this.sqls.getProperty(SELECT_STEP_EXECUTIONS_BY_JOB_EXECUTION_ID);
        Connection connection = this.getConnection();
        ResultSet rs = null;
        PreparedStatement preparedStatement = null;
        ArrayList<StepExecution> result = new ArrayList<StepExecution>();
        try {
            preparedStatement = connection.prepareStatement(select);
            if (jobExecutionId != null) {
                preparedStatement.setLong(1, jobExecutionId);
            }
            rs = preparedStatement.executeQuery();
            this.createStepExecutionsFromResultSet(rs, result, false, classLoader);
            this.close(connection, preparedStatement, null, rs);
        }
        catch (Exception e) {
            try {
                throw BatchMessages.MESSAGES.failToRunQuery(e, select);
            }
            catch (Throwable throwable) {
                this.close(connection, preparedStatement, null, rs);
                throw throwable;
            }
        }
        return result;
    }

    @Override
    public void addPartitionExecution(StepExecutionImpl enclosingStepExecution, PartitionExecutionImpl partitionExecution) {
        super.addPartitionExecution(enclosingStepExecution, partitionExecution);
        String insert = this.sqls.getProperty(INSERT_PARTITION_EXECUTION);
        Connection connection = this.getConnection();
        PreparedStatement preparedStatement = null;
        try {
            preparedStatement = connection.prepareStatement(insert);
            preparedStatement.setInt(1, partitionExecution.getPartitionId());
            preparedStatement.setLong(2, partitionExecution.getStepExecutionId());
            preparedStatement.setString(3, partitionExecution.getBatchStatus().name());
            preparedStatement.executeUpdate();
        }
        catch (Exception e) {
            throw BatchMessages.MESSAGES.failToRunQuery(e, insert);
        }
        finally {
            this.close(connection, preparedStatement, null, null);
        }
    }

    @Override
    public StepExecutionImpl findOriginalStepExecutionForRestart(String stepName, JobExecutionImpl jobExecutionToRestart, ClassLoader classLoader) {
        StepExecutionImpl result = super.findOriginalStepExecutionForRestart(stepName, jobExecutionToRestart, classLoader);
        if (result != null) {
            return result;
        }
        String select = this.sqls.getProperty(FIND_ORIGINAL_STEP_EXECUTION);
        Connection connection = this.getConnection();
        ResultSet rs = null;
        ArrayList<StepExecution> results = new ArrayList<StepExecution>();
        PreparedStatement preparedStatement = null;
        try {
            preparedStatement = connection.prepareStatement(select);
            preparedStatement.setLong(1, jobExecutionToRestart.getJobInstance().getInstanceId());
            preparedStatement.setString(2, stepName);
            rs = preparedStatement.executeQuery();
            this.createStepExecutionsFromResultSet(rs, results, true, classLoader);
            this.close(connection, preparedStatement, null, rs);
        }
        catch (Exception e) {
            try {
                throw BatchMessages.MESSAGES.failToRunQuery(e, select);
            }
            catch (Throwable throwable) {
                this.close(connection, preparedStatement, null, rs);
                throw throwable;
            }
        }
        return results.size() > 0 ? (StepExecutionImpl)results.get(0) : null;
    }

    @Override
    public List<PartitionExecutionImpl> getPartitionExecutions(long stepExecutionId, StepExecutionImpl stepExecution, boolean notCompletedOnly, ClassLoader classLoader) {
        List<PartitionExecutionImpl> result = super.getPartitionExecutions(stepExecutionId, stepExecution, notCompletedOnly, classLoader);
        if (result != null && !result.isEmpty()) {
            return result;
        }
        String select = this.sqls.getProperty(SELECT_PARTITION_EXECUTIONS_BY_STEP_EXECUTION_ID);
        Connection connection = this.getConnection();
        ResultSet rs = null;
        PreparedStatement preparedStatement = null;
        result = new ArrayList<PartitionExecutionImpl>();
        try {
            preparedStatement = connection.prepareStatement(select);
            preparedStatement.setLong(1, stepExecutionId);
            rs = preparedStatement.executeQuery();
            while (rs.next()) {
                String batchStatusValue = rs.getString("BATCHSTATUS");
                if (notCompletedOnly && BatchStatus.COMPLETED.name().equals(batchStatusValue)) continue;
                result.add(new PartitionExecutionImpl(rs.getInt("PARTITIONEXECUTIONID"), rs.getLong("STEPEXECUTIONID"), stepExecution.getStepName(), BatchStatus.valueOf((String)batchStatusValue), rs.getString("EXITSTATUS"), (Serializable)rs.getBytes("PERSISTENTUSERDATA"), (Serializable)rs.getBytes("READERCHECKPOINTINFO"), (Serializable)rs.getBytes("WRITERCHECKPOINTINFO")));
            }
            this.close(connection, preparedStatement, null, rs);
        }
        catch (Exception e) {
            try {
                throw BatchMessages.MESSAGES.failToRunQuery(e, select);
            }
            catch (Throwable throwable) {
                this.close(connection, preparedStatement, null, rs);
                throw throwable;
            }
        }
        return result;
    }

    private int updatePartitionExecution(PartitionExecutionImpl partitionExecution, String updateSql) {
        Connection connection = this.getConnection();
        PreparedStatement preparedStatement = null;
        try {
            preparedStatement = connection.prepareStatement(updateSql);
            preparedStatement.setString(1, partitionExecution.getBatchStatus().name());
            preparedStatement.setString(2, partitionExecution.getExitStatus());
            preparedStatement.setString(3, TableColumns.formatException(partitionExecution.getException()));
            preparedStatement.setBytes(4, partitionExecution.getPersistentUserDataSerialized());
            preparedStatement.setBytes(5, partitionExecution.getReaderCheckpointInfoSerialized());
            preparedStatement.setBytes(6, partitionExecution.getWriterCheckpointInfoSerialized());
            preparedStatement.setInt(7, partitionExecution.getPartitionId());
            preparedStatement.setLong(8, partitionExecution.getStepExecutionId());
            int n = preparedStatement.executeUpdate();
            return n;
        }
        catch (Exception e) {
            throw BatchMessages.MESSAGES.failToRunQuery(e, updateSql);
        }
        finally {
            this.close(connection, preparedStatement, null, null);
        }
    }

    private int updateStepExecution0(StepExecution stepExecution, String updateSql) {
        Connection connection = this.getConnection();
        StepExecutionImpl stepExecutionImpl = (StepExecutionImpl)stepExecution;
        PreparedStatement preparedStatement = null;
        try {
            preparedStatement = connection.prepareStatement(updateSql);
            preparedStatement.setTimestamp(1, JdbcRepository.createTimestamp(stepExecution.getEndTime()));
            preparedStatement.setString(2, stepExecution.getBatchStatus().name());
            preparedStatement.setString(3, stepExecution.getExitStatus());
            preparedStatement.setString(4, TableColumns.formatException(stepExecutionImpl.getException()));
            preparedStatement.setBytes(5, stepExecutionImpl.getPersistentUserDataSerialized());
            preparedStatement.setLong(6, stepExecutionImpl.getStepMetrics().get(Metric.MetricType.READ_COUNT));
            preparedStatement.setLong(7, stepExecutionImpl.getStepMetrics().get(Metric.MetricType.WRITE_COUNT));
            preparedStatement.setLong(8, stepExecutionImpl.getStepMetrics().get(Metric.MetricType.COMMIT_COUNT));
            preparedStatement.setLong(9, stepExecutionImpl.getStepMetrics().get(Metric.MetricType.ROLLBACK_COUNT));
            preparedStatement.setLong(10, stepExecutionImpl.getStepMetrics().get(Metric.MetricType.READ_SKIP_COUNT));
            preparedStatement.setLong(11, stepExecutionImpl.getStepMetrics().get(Metric.MetricType.PROCESS_SKIP_COUNT));
            preparedStatement.setLong(12, stepExecutionImpl.getStepMetrics().get(Metric.MetricType.FILTER_COUNT));
            preparedStatement.setLong(13, stepExecutionImpl.getStepMetrics().get(Metric.MetricType.WRITE_SKIP_COUNT));
            preparedStatement.setBytes(14, stepExecutionImpl.getReaderCheckpointInfoSerialized());
            preparedStatement.setBytes(15, stepExecutionImpl.getWriterCheckpointInfoSerialized());
            preparedStatement.setLong(16, stepExecution.getStepExecutionId());
            int n = preparedStatement.executeUpdate();
            return n;
        }
        catch (Exception e) {
            throw BatchMessages.MESSAGES.failToRunQuery(e, updateSql);
        }
        finally {
            this.close(connection, preparedStatement, null, null);
        }
    }

    private void createStepExecutionsFromResultSet(ResultSet rs, List<StepExecution> result, boolean top1, ClassLoader classLoader) throws SQLException, ClassNotFoundException, IOException {
        while (rs.next()) {
            StepExecutionImpl e = new StepExecutionImpl(rs.getLong("STEPEXECUTIONID"), rs.getString("STEPNAME"), rs.getTimestamp("STARTTIME"), rs.getTimestamp("ENDTIME"), rs.getString("BATCHSTATUS"), rs.getString("EXITSTATUS"), (Serializable)rs.getBytes("PERSISTENTUSERDATA"), rs.getInt("READCOUNT"), rs.getInt("WRITECOUNT"), rs.getInt("COMMITCOUNT"), rs.getInt("ROLLBACKCOUNT"), rs.getInt("READSKIPCOUNT"), rs.getInt("PROCESSSKIPCOUNT"), rs.getInt("FILTERCOUNT"), rs.getInt("WRITESKIPCOUNT"), (Serializable)rs.getBytes("READERCHECKPOINTINFO"), (Serializable)rs.getBytes("WRITERCHECKPOINTINFO"));
            result.add(e);
            if (!top1) continue;
            return;
        }
    }

    @Override
    public int countStepStartTimes(String stepName, long jobInstanceId) {
        String select = this.sqls.getProperty(COUNT_STEP_EXECUTIONS_BY_JOB_INSTANCE_ID);
        Connection connection = this.getConnection();
        ResultSet rs = null;
        PreparedStatement preparedStatement = null;
        int count = 0;
        try {
            preparedStatement = connection.prepareStatement(select);
            preparedStatement.setString(1, stepName);
            preparedStatement.setLong(2, jobInstanceId);
            rs = preparedStatement.executeQuery();
            if (rs.next()) {
                count = rs.getInt(1);
            }
            this.close(connection, preparedStatement, null, rs);
        }
        catch (Exception e) {
            try {
                throw BatchMessages.MESSAGES.failToRunQuery(e, select);
            }
            catch (Throwable throwable) {
                this.close(connection, preparedStatement, null, rs);
                throw throwable;
            }
        }
        return count;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void executeStatements(String statements, String statementsResourcePath) throws SQLException {
        List<String> statementList;
        String delim = ";";
        Connection connection = this.getConnection();
        if (statements == null) {
            InputStream statementsResource = null;
            try {
                statementsResource = JdbcRepository.getClassLoader(true).getResourceAsStream(statementsResourcePath);
                if (statementsResource == null) {
                    throw BatchMessages.MESSAGES.failToLoadSqlProperties(null, statementsResourcePath);
                }
                statementList = new ArrayList<String>();
                Scanner scanner = new Scanner(statementsResource).useDelimiter(";");
                while (scanner.hasNext()) {
                    statementList.add(scanner.next());
                }
                scanner.close();
            }
            finally {
                if (statementsResource != null) {
                    try {
                        statementsResource.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
        statementList = Arrays.asList(statements.split(";"));
        Statement st = null;
        try {
            st = connection.createStatement();
            if (statementList.size() <= 1) {
                st.executeUpdate(statementList.get(0));
            } else {
                for (String s : statementList) {
                    String sqlEntry = s.trim();
                    if (sqlEntry.isEmpty()) continue;
                    st.addBatch(sqlEntry);
                }
                st.executeBatch();
            }
        }
        finally {
            this.close(connection, st, null, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<Long> getJobExecutions0(String selectSql, String jobName, boolean runningExecutionsOnly) {
        ArrayList<Long> result = new ArrayList<Long>();
        Connection connection = null;
        ResultSet rs = null;
        PreparedStatement preparedStatement = null;
        try {
            connection = this.getConnection();
            preparedStatement = connection.prepareStatement(selectSql);
            preparedStatement.setString(1, jobName);
            rs = preparedStatement.executeQuery();
            while (rs.next()) {
                long i = rs.getLong(1);
                result.add(i);
            }
            this.close(connection, preparedStatement, null, rs);
        }
        catch (Exception e) {
            try {
                List<Long> cachedExecutionIds = this.getCachedJobExecutions(jobName, runningExecutionsOnly);
                for (Long i : cachedExecutionIds) {
                    if (result.contains(i)) continue;
                    result.add(i);
                }
                BatchLogger.LOGGER.failedGetJobExecutions(e, jobName, result);
                this.close(connection, preparedStatement, null, rs);
            }
            catch (Throwable throwable) {
                this.close(connection, preparedStatement, null, rs);
                throw throwable;
            }
        }
        return result;
    }

    private Connection getConnection() {
        if (this.dataSource != null) {
            try {
                return this.dataSource.getConnection();
            }
            catch (SQLException e) {
                throw BatchMessages.MESSAGES.failToObtainConnection(e, this.dataSource);
            }
        }
        try {
            return DriverManager.getConnection(this.dbUrl, this.dbProperties);
        }
        catch (Exception e) {
            throw BatchMessages.MESSAGES.failToObtainConnection(e, this.dbUrl, this.dbProperties);
        }
    }

    private void close(Connection conn, Statement stmt1, Statement stmt2, ResultSet rs) {
        if (rs != null) {
            try {
                rs.close();
            }
            catch (SQLException e) {
                BatchLogger.LOGGER.failToClose(e, ResultSet.class, rs);
            }
        }
        if (stmt1 != null) {
            try {
                stmt1.close();
            }
            catch (SQLException e) {
                BatchLogger.LOGGER.failToClose(e, PreparedStatement.class, stmt1);
            }
        }
        if (stmt2 != null) {
            try {
                stmt2.close();
            }
            catch (SQLException e) {
                BatchLogger.LOGGER.failToClose(e, PreparedStatement.class, stmt2);
            }
        }
        if (conn != null) {
            try {
                conn.close();
            }
            catch (SQLException e) {
                BatchLogger.LOGGER.failToClose(e, Connection.class, conn);
            }
        }
    }

    private String getDDLLocation(String databaseProductName) {
        String ddlFile = this.userDefinedDdlFile;
        if (ddlFile != null && !(ddlFile = ddlFile.trim()).isEmpty()) {
            BatchLogger.LOGGER.ddlFileAndDatabaseProductName(ddlFile, databaseProductName);
            return ddlFile;
        }
        ddlFile = databaseProductName.contains("MySQL") ? "sql/jberet-mysql.ddl" : (databaseProductName.startsWith("Oracle") ? "sql/jberet-oracle.ddl" : (databaseProductName.contains("PostgreSQL") || databaseProductName.contains("EnterpriseDB") ? "sql/jberet-postgresql.ddl" : (databaseProductName.startsWith("Microsoft SQL Server") ? "sql/jberet-mssqlserver.ddl" : (databaseProductName.contains("DB2") ? "sql/jberet-db2.ddl" : (databaseProductName.contains("Adaptive Server Enterprise") || databaseProductName.contains("Sybase") ? "sql/jberet-sybase.ddl" : (databaseProductName.contains("Derby") ? "sql/jberet-derby.ddl" : (databaseProductName.startsWith("Firebird") ? "sql/jberet-firebird.ddl" : DEFAULT_DDL_FILE)))))));
        BatchLogger.LOGGER.ddlFileAndDatabaseProductName(ddlFile, databaseProductName);
        return ddlFile;
    }

    private static ClassLoader getClassLoader(final boolean isContextClassLoader) {
        if (WildFlySecurityManager.isChecking()) {
            return AccessController.doPrivileged(new PrivilegedAction<ClassLoader>(){

                @Override
                public ClassLoader run() {
                    return isContextClassLoader ? Thread.currentThread().getContextClassLoader() : JdbcRepository.class.getClassLoader();
                }
            });
        }
        return isContextClassLoader ? Thread.currentThread().getContextClassLoader() : JdbcRepository.class.getClassLoader();
    }

    private static Timestamp createTimestamp(Date date) {
        if (date == null) {
            return null;
        }
        return new Timestamp(date.getTime());
    }

    private static String addPrefixSuffix(String input, String prefix, String suffix, Pattern pattern) {
        Matcher matcher = pattern.matcher(input);
        StringBuffer sb = new StringBuffer();
        while (matcher.find()) {
            String replacement;
            int start = matcher.start();
            if (start > 0 && input.charAt(start - 1) == '_') continue;
            String matchedContent = matcher.group();
            String string = replacement = prefix.length() > 0 ? prefix + matchedContent : matchedContent;
            if (suffix.length() > 0) {
                replacement = replacement + suffix;
            }
            matcher.appendReplacement(sb, replacement);
        }
        matcher.appendTail(sb);
        return sb.toString();
    }
}

