/*
 * Decompiled with CFR 0.152.
 */
package org.jberet.runtime;

import jakarta.batch.runtime.BatchStatus;
import jakarta.batch.runtime.Metric;
import jakarta.batch.runtime.StepExecution;
import java.io.Serializable;
import java.util.List;
import org.jberet.runtime.AbstractExecution;
import org.jberet.runtime.PartitionExecutionImpl;
import org.jberet.runtime.SerializableData;
import org.jberet.runtime.metric.StepMetrics;

public abstract class AbstractStepExecution
extends AbstractExecution
implements StepExecution {
    private static final long serialVersionUID = 1L;
    private long id;
    private String stepName;
    private SerializableData persistentUserData;
    private SerializableData readerCheckpointInfo;
    private SerializableData writerCheckpointInfo;
    private SerializableData exception;
    StepMetrics stepMetrics = new StepMetrics();

    public abstract List<PartitionExecutionImpl> getPartitionExecutions();

    AbstractStepExecution() {
    }

    AbstractStepExecution(String stepName) {
        this.stepName = stepName;
        this.startTime = System.currentTimeMillis();
    }

    AbstractStepExecution(long id, String stepName, Serializable persistentUserData, Serializable readerCheckpointInfo, Serializable writerCheckpointInfo) {
        this.id = id;
        this.stepName = stepName;
        this.persistentUserData = SerializableData.of(persistentUserData);
        this.readerCheckpointInfo = SerializableData.of(readerCheckpointInfo);
        this.writerCheckpointInfo = SerializableData.of(writerCheckpointInfo);
    }

    AbstractStepExecution(AbstractStepExecution step) {
        this(step.id, step.stepName, step.persistentUserData, step.readerCheckpointInfo, step.writerCheckpointInfo);
    }

    public void setId(long id) {
        this.id = id;
    }

    @Override
    protected AbstractStepExecution clone() throws CloneNotSupportedException {
        throw new CloneNotSupportedException();
    }

    public long getStepExecutionId() {
        return this.id;
    }

    public String getStepName() {
        return this.stepName;
    }

    public Serializable getPersistentUserData() {
        return AbstractStepExecution.deserialize(this.persistentUserData);
    }

    public byte[] getPersistentUserDataSerialized() {
        return this.persistentUserData == null ? null : this.persistentUserData.getSerialized();
    }

    public void setPersistentUserData(Serializable persistentUserData) {
        this.persistentUserData = SerializableData.of(persistentUserData);
    }

    public Metric[] getMetrics() {
        return this.stepMetrics.getMetrics();
    }

    public StepMetrics getStepMetrics() {
        return this.stepMetrics;
    }

    public Exception getException() {
        return (Exception)AbstractStepExecution.deserialize(this.exception);
    }

    public void setException(Exception exception) {
        this.exception = SerializableData.of(exception);
    }

    @Override
    public void setBatchStatus(BatchStatus batchStatus) {
        super.setBatchStatus(batchStatus);
        if (batchStatus == BatchStatus.COMPLETED || batchStatus == BatchStatus.FAILED || batchStatus == BatchStatus.STOPPED) {
            this.endTime = System.currentTimeMillis();
        }
    }

    public Serializable getReaderCheckpointInfo() {
        return AbstractStepExecution.deserialize(this.readerCheckpointInfo);
    }

    public byte[] getReaderCheckpointInfoSerialized() {
        return this.readerCheckpointInfo == null ? null : this.readerCheckpointInfo.getSerialized();
    }

    public void setReaderCheckpointInfo(Serializable readerCheckpointInfo) {
        this.readerCheckpointInfo = SerializableData.of(readerCheckpointInfo);
    }

    public Serializable getWriterCheckpointInfo() {
        return AbstractStepExecution.deserialize(this.writerCheckpointInfo);
    }

    public byte[] getWriterCheckpointInfoSerialized() {
        return this.writerCheckpointInfo == null ? null : this.writerCheckpointInfo.getSerialized();
    }

    public void setWriterCheckpointInfo(Serializable writerCheckpointInfo) {
        this.writerCheckpointInfo = SerializableData.of(writerCheckpointInfo);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof AbstractStepExecution)) {
            return false;
        }
        AbstractStepExecution that = (AbstractStepExecution)o;
        if (this.id != that.id) {
            return false;
        }
        return this.stepName.equals(that.stepName);
    }

    public int hashCode() {
        int result = (int)(this.id ^ this.id >>> 32);
        result = 31 * result + this.stepName.hashCode();
        return result;
    }

    private static Serializable deserialize(SerializableData data) {
        if (data == null) {
            return null;
        }
        return data.deserialize();
    }
}

