/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.paging.cursor.impl;

import org.apache.activemq.artemis.core.paging.PagedMessage;
import org.apache.activemq.artemis.core.paging.cursor.NonExistentPage;
import org.apache.activemq.artemis.core.paging.cursor.PageCache;
import org.apache.activemq.artemis.core.paging.cursor.PagePosition;
import org.apache.activemq.artemis.core.paging.impl.Page;
import org.jboss.logging.Logger;

public class PageReader
implements PageCache {
    private static final Logger logger = Logger.getLogger(PageReader.class);
    private final Page page;
    private final int numberOfMessages;

    public PageReader(Page page, int numberOfMessages) {
        this.page = page;
        this.numberOfMessages = numberOfMessages;
    }

    @Override
    public long getPageId() {
        return this.page.getPageId();
    }

    @Override
    public int getNumberOfMessages() {
        return this.numberOfMessages;
    }

    protected synchronized PagedMessage[] readMessages() {
        try {
            this.openPage();
            PagedMessage[] pagedMessageArray = this.page.read().toArray(new PagedMessage[this.numberOfMessages]);
            return pagedMessageArray;
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage(), e);
        }
        finally {
            this.close();
        }
    }

    public boolean isLive() {
        return false;
    }

    public synchronized PagedMessage getMessage(PagePosition pagePosition, boolean throwException, boolean keepOpen) {
        if (pagePosition.getMessageNr() >= this.getNumberOfMessages()) {
            if (throwException) {
                throw new NonExistentPage("Invalid messageNumber passed = " + pagePosition + " on " + this);
            }
            return null;
        }
        boolean previouslyClosed = true;
        try {
            PagedMessage msg;
            previouslyClosed = this.openPage();
            if (pagePosition.getFileOffset() != -1) {
                msg = this.page.readMessage(pagePosition.getFileOffset(), pagePosition.getMessageNr(), pagePosition.getMessageNr());
            } else {
                if (logger.isTraceEnabled()) {
                    logger.trace((Object)("get message from pos " + pagePosition), (Throwable)new Exception("trace get message without file offset"));
                }
                msg = this.page.readMessage(0, 0, pagePosition.getMessageNr());
            }
            PagedMessage pagedMessage = msg;
            return pagedMessage;
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage(), e);
        }
        finally {
            if (!keepOpen && previouslyClosed) {
                this.close();
            }
        }
    }

    @Override
    public synchronized PagedMessage getMessage(PagePosition pagePosition) {
        return this.getMessage(pagePosition, false, false);
    }

    boolean openPage() throws Exception {
        if (!this.page.getFile().isOpen()) {
            this.page.getFile().open();
            return true;
        }
        return false;
    }

    @Override
    public synchronized void close() {
        try {
            this.page.close(false, false);
        }
        catch (Exception e) {
            logger.warn((Object)("Closing page " + this.page.getPageId() + " occurs exception:"), (Throwable)e);
        }
    }

    public String toString() {
        return "PageReader::page=" + this.getPageId() + " numberOfMessages = " + this.numberOfMessages;
    }
}

