/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.spi.core.security.jaas;

import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.MessageDigest;
import java.security.Principal;
import java.security.SecureRandom;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.crypto.Mac;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.auth.login.LoginException;
import org.apache.activemq.artemis.spi.core.security.jaas.AuditLoginModule;
import org.apache.activemq.artemis.spi.core.security.jaas.DigestCallback;
import org.apache.activemq.artemis.spi.core.security.jaas.HmacCallback;
import org.apache.activemq.artemis.spi.core.security.jaas.PropertiesLoader;
import org.apache.activemq.artemis.spi.core.security.jaas.RolePrincipal;
import org.apache.activemq.artemis.spi.core.security.jaas.SCRAMMechanismCallback;
import org.apache.activemq.artemis.spi.core.security.jaas.UserPrincipal;
import org.apache.activemq.artemis.spi.core.security.scram.SCRAM;
import org.apache.activemq.artemis.spi.core.security.scram.ScramException;
import org.apache.activemq.artemis.spi.core.security.scram.ScramUtils;
import org.apache.activemq.artemis.spi.core.security.scram.StringPrep;
import org.apache.activemq.artemis.spi.core.security.scram.UserData;
import org.apache.activemq.artemis.utils.PasswordMaskingUtil;

public class SCRAMPropertiesLoginModule
extends PropertiesLoader
implements AuditLoginModule {
    private static final String SEPARATOR_MECHANISM = "|";
    private static final String SEPARATOR_PARAMETER = ":";
    private static final int MIN_ITERATIONS = 4096;
    private static final SecureRandom RANDOM_GENERATOR = new SecureRandom();
    private Subject subject;
    private CallbackHandler callbackHandler;
    private Properties users;
    private Map<String, Set<String>> roles;
    private UserData userData;
    private String user;
    private final Set<Principal> principals = new HashSet<Principal>();

    @Override
    public void initialize(Subject subject, CallbackHandler callbackHandler, Map<String, ?> sharedState, Map<String, ?> options) {
        this.subject = subject;
        this.callbackHandler = callbackHandler;
        this.init(options);
        this.users = this.load("org.apache.activemq.jaas.properties.user", "user", options).getProps();
        this.roles = this.load("org.apache.activemq.jaas.properties.role", "role", options).invertedPropertiesValuesMap();
    }

    @Override
    public boolean login() throws LoginException {
        NameCallback nameCallback = new NameCallback("Username: ");
        this.executeCallbacks(nameCallback);
        this.user = nameCallback.getName();
        SCRAMMechanismCallback mechanismCallback = new SCRAMMechanismCallback();
        this.executeCallbacks(mechanismCallback);
        SCRAM scram = SCRAMPropertiesLoginModule.getTypeByString(mechanismCallback.getMechanism());
        if (this.user == null) {
            this.userData = this.generateUserData(null);
        } else {
            String password = this.users.getProperty(this.user + SEPARATOR_MECHANISM + scram.name());
            if (password == null) {
                password = this.users.getProperty(this.user);
            }
            if (PasswordMaskingUtil.isEncMasked((String)password)) {
                String[] unwrap = PasswordMaskingUtil.unwrap((String)password).split(SEPARATOR_PARAMETER);
                this.userData = new UserData(unwrap[0], Integer.parseInt(unwrap[1]), unwrap[2], unwrap[3]);
            } else {
                this.userData = this.generateUserData(password);
            }
        }
        return true;
    }

    private UserData generateUserData(String plainTextPassword) throws LoginException {
        if (plainTextPassword == null) {
            byte[] randomPassword = new byte[256];
            RANDOM_GENERATOR.nextBytes(randomPassword);
            plainTextPassword = new String(randomPassword);
        }
        DigestCallback digestCallback = new DigestCallback();
        HmacCallback hmacCallback = new HmacCallback();
        this.executeCallbacks(digestCallback, hmacCallback);
        byte[] salt = SCRAMPropertiesLoginModule.generateSalt();
        try {
            ScramUtils.NewPasswordStringData data = ScramUtils.byteArrayToStringData(ScramUtils.newPassword(plainTextPassword, salt, 4096, digestCallback.getDigest(), hmacCallback.getHmac()));
            return new UserData(data.salt, data.iterations, data.serverKey, data.storedKey);
        }
        catch (ScramException e) {
            throw new LoginException();
        }
    }

    private static byte[] generateSalt() {
        byte[] salt = new byte[32];
        RANDOM_GENERATOR.nextBytes(salt);
        return salt;
    }

    private void executeCallbacks(Callback ... callbacks) throws LoginException {
        try {
            this.callbackHandler.handle(callbacks);
        }
        catch (IOException | UnsupportedCallbackException e) {
            throw new LoginException();
        }
    }

    @Override
    public boolean commit() throws LoginException {
        if (this.userData == null) {
            throw new LoginException();
        }
        this.subject.getPublicCredentials().add(this.userData);
        Set<UserPrincipal> authenticatedUsers = this.subject.getPrincipals(UserPrincipal.class);
        UserPrincipal principal = new UserPrincipal(this.user);
        this.principals.add(principal);
        authenticatedUsers.add(principal);
        for (UserPrincipal userPrincipal : authenticatedUsers) {
            Set<String> matchedRoles = this.roles.get(userPrincipal.getName());
            if (matchedRoles == null) continue;
            for (String entry : matchedRoles) {
                this.principals.add(new RolePrincipal(entry));
            }
        }
        this.subject.getPrincipals().addAll(this.principals);
        return true;
    }

    @Override
    public boolean abort() throws LoginException {
        return true;
    }

    @Override
    public boolean logout() throws LoginException {
        this.subject.getPrincipals().removeAll(this.principals);
        this.principals.clear();
        this.subject.getPublicCredentials().remove(this.userData);
        this.userData = null;
        return true;
    }

    public static void main(String[] args) throws GeneralSecurityException, ScramException, StringPrep.StringPrepError, IOException {
        if (args.length < 2) {
            System.out.println("Usage: " + SCRAMPropertiesLoginModule.class.getSimpleName() + " <username> <password> [<iterations>]");
            System.out.println("\ttype: " + SCRAMPropertiesLoginModule.getSupportedTypes());
            System.out.println("\titerations desired number of iteration (min value: 4096)");
            return;
        }
        String username = args[0];
        String password = args[1];
        Properties properties = new Properties();
        String encodedUser = StringPrep.prepAsQueryString(username);
        for (SCRAM scram : SCRAM.values()) {
            int iterations;
            MessageDigest digest = MessageDigest.getInstance(scram.getDigest());
            Mac hmac = Mac.getInstance(scram.getHmac());
            byte[] salt = SCRAMPropertiesLoginModule.generateSalt();
            if (args.length > 2) {
                iterations = Integer.parseInt(args[2]);
                if (iterations < 4096) {
                    throw new IllegalArgumentException("minimum of 4096 required!");
                }
            } else {
                iterations = 4096;
            }
            ScramUtils.NewPasswordStringData data = ScramUtils.byteArrayToStringData(ScramUtils.newPassword(password, salt, iterations, digest, hmac));
            String encodedPassword = PasswordMaskingUtil.wrap((String)(data.salt + SEPARATOR_PARAMETER + data.iterations + SEPARATOR_PARAMETER + data.serverKey + SEPARATOR_PARAMETER + data.storedKey));
            properties.setProperty(encodedUser + SEPARATOR_MECHANISM + scram.name(), encodedPassword);
        }
        properties.store(System.out, "Insert the lines stating with '" + encodedUser + "' into the desired user properties file");
    }

    private static SCRAM getTypeByString(String type) {
        SCRAM scram = Arrays.stream(SCRAM.values()).filter(v -> v.getName().equals(type)).findFirst().orElseThrow(() -> new IllegalArgumentException("unkown type " + type + ", supported ones are " + SCRAMPropertiesLoginModule.getSupportedTypes()));
        return scram;
    }

    private static String getSupportedTypes() {
        return String.join((CharSequence)", ", (CharSequence[])Arrays.stream(SCRAM.values()).map(SCRAM::getName).toArray(String[]::new));
    }
}

