/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jasper.el;

import jakarta.el.ArrayELResolver;
import jakarta.el.BeanELResolver;
import jakarta.el.CompositeELResolver;
import jakarta.el.ELContext;
import jakarta.el.ELException;
import jakarta.el.ELResolver;
import jakarta.el.ListELResolver;
import jakarta.el.MapELResolver;
import jakarta.el.PropertyNotFoundException;
import jakarta.el.ResourceBundleELResolver;
import jakarta.el.StaticFieldELResolver;
import jakarta.servlet.jsp.el.ImplicitObjectELResolver;
import jakarta.servlet.jsp.el.ScopedAttributeELResolver;
import java.util.List;

public class JasperELResolver
extends CompositeELResolver {
    private static final int STANDARD_RESOLVERS_COUNT = 9;
    private int size;
    private ELResolver[] resolvers;
    private final int appResolversSize;

    public JasperELResolver(List<ELResolver> appResolvers, ELResolver streamResolver) {
        this.appResolversSize = appResolvers.size();
        this.resolvers = new ELResolver[this.appResolversSize + 9];
        this.size = 0;
        this.add((ELResolver)new ImplicitObjectELResolver());
        for (ELResolver appResolver : appResolvers) {
            this.add(appResolver);
        }
        this.add(streamResolver);
        this.add((ELResolver)new StaticFieldELResolver());
        this.add((ELResolver)new MapELResolver());
        this.add((ELResolver)new ResourceBundleELResolver());
        this.add((ELResolver)new ListELResolver());
        this.add((ELResolver)new ArrayELResolver());
        this.add((ELResolver)new BeanELResolver());
        this.add((ELResolver)new ScopedAttributeELResolver());
    }

    public synchronized void add(ELResolver elResolver) {
        super.add(elResolver);
        if (this.resolvers.length > this.size) {
            this.resolvers[this.size] = elResolver;
        } else {
            ELResolver[] nr = new ELResolver[this.size + 1];
            System.arraycopy(this.resolvers, 0, nr, 0, this.size);
            nr[this.size] = elResolver;
            this.resolvers = nr;
        }
        ++this.size;
    }

    public Object getValue(ELContext context, Object base, Object property) throws NullPointerException, PropertyNotFoundException, ELException {
        int start;
        context.setPropertyResolved(false);
        Object result = null;
        if (base == null) {
            int index = 1 + this.appResolversSize;
            for (int i = 0; i < index; ++i) {
                result = this.resolvers[i].getValue(context, base, property);
                if (!context.isPropertyResolved()) continue;
                return result;
            }
            start = index + 7;
        } else {
            start = 1;
        }
        for (int i = start; i < this.size; ++i) {
            result = this.resolvers[i].getValue(context, base, property);
            if (!context.isPropertyResolved()) continue;
            return result;
        }
        return null;
    }

    public Object invoke(ELContext context, Object base, Object method, Class<?>[] paramTypes, Object[] params) {
        int i;
        String targetMethod = JasperELResolver.coerceToString(method);
        if (targetMethod.length() == 0) {
            throw new ELException((Throwable)new NoSuchMethodException());
        }
        context.setPropertyResolved(false);
        Object result = null;
        int index = 1 + this.appResolversSize + 2;
        for (i = 1; i < index; ++i) {
            result = this.resolvers[i].invoke(context, base, (Object)targetMethod, (Class[])paramTypes, params);
            if (!context.isPropertyResolved()) continue;
            return result;
        }
        for (i = index += 4; i < this.size; ++i) {
            result = this.resolvers[i].invoke(context, base, (Object)targetMethod, (Class[])paramTypes, params);
            if (!context.isPropertyResolved()) continue;
            return result;
        }
        return null;
    }

    private static final String coerceToString(Object obj) {
        if (obj == null) {
            return "";
        }
        if (obj instanceof String) {
            return (String)obj;
        }
        if (obj instanceof Enum) {
            return ((Enum)obj).name();
        }
        return obj.toString();
    }
}

