/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.undertow.deployment;

import io.undertow.server.HandlerWrapper;
import io.undertow.server.HttpHandler;
import io.undertow.server.HttpServerExchange;
import io.undertow.servlet.handlers.ServletPathMatch;
import io.undertow.servlet.handlers.ServletRequestContext;
import io.undertow.util.AttachmentKey;

class RewriteCorrectingHandlerWrappers {
    private static final AttachmentKey<String> OLD_RELATIVE_PATH = AttachmentKey.create(String.class);

    RewriteCorrectingHandlerWrappers() {
    }

    static class PostWrapper
    implements HandlerWrapper {
        PostWrapper() {
        }

        public HttpHandler wrap(final HttpHandler handler) {
            return new HttpHandler(){

                public void handleRequest(HttpServerExchange exchange) throws Exception {
                    String old = (String)exchange.getAttachment(OLD_RELATIVE_PATH);
                    if (!old.equals(exchange.getRelativePath())) {
                        ServletRequestContext src = (ServletRequestContext)exchange.getAttachment(ServletRequestContext.ATTACHMENT_KEY);
                        ServletPathMatch info = src.getDeployment().getServletPaths().getServletHandlerByPath(exchange.getRelativePath());
                        src.setCurrentServlet(info.getServletChain());
                        src.setServletPathMatch(info);
                    }
                    handler.handleRequest(exchange);
                }
            };
        }
    }

    static class PreWrapper
    implements HandlerWrapper {
        PreWrapper() {
        }

        public HttpHandler wrap(final HttpHandler handler) {
            return new HttpHandler(){

                public void handleRequest(HttpServerExchange exchange) throws Exception {
                    exchange.putAttachment(OLD_RELATIVE_PATH, (Object)exchange.getRelativePath());
                    handler.handleRequest(exchange);
                }
            };
        }
    }
}

