/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.taglib.jsf_core;

import com.sun.faces.util.FacesLogger;
import com.sun.faces.util.MessageUtils;
import jakarta.el.ELContext;
import jakarta.el.ValueExpression;
import jakarta.faces.FacesException;
import jakarta.faces.context.FacesContext;
import jakarta.faces.validator.Validator;
import jakarta.faces.webapp.ValidatorELTag;
import jakarta.servlet.jsp.JspException;
import java.util.logging.Level;
import java.util.logging.Logger;

public class AbstractValidatorTag
extends ValidatorELTag {
    private static final long serialVersionUID = 8941293586160549920L;
    private static final Logger LOGGER = FacesLogger.TAGLIB.getLogger();
    protected ValueExpression binding = null;
    protected ValueExpression validatorId = null;

    public void setBinding(ValueExpression binding) {
        this.binding = binding;
    }

    public void setValidatorId(ValueExpression validatorId) {
        this.validatorId = validatorId;
    }

    protected Validator createValidator() throws JspException {
        try {
            return AbstractValidatorTag.createValidator(this.validatorId, this.binding, FacesContext.getCurrentInstance());
        }
        catch (FacesException fe) {
            throw new JspException(fe.getCause());
        }
    }

    protected static Validator createValidator(ValueExpression validatorId, ValueExpression binding, FacesContext facesContext) {
        ELContext elContext = facesContext.getELContext();
        Validator validator = null;
        if (binding != null) {
            try {
                validator = (Validator)binding.getValue(elContext);
                if (validator != null) {
                    return validator;
                }
            }
            catch (Exception e) {
                throw new FacesException((Throwable)e);
            }
        }
        if (validatorId != null) {
            try {
                String validatorIdVal = (String)validatorId.getValue(elContext);
                validator = facesContext.getApplication().createValidator(validatorIdVal);
                if (validator != null && binding != null) {
                    binding.setValue(elContext, (Object)validator);
                }
            }
            catch (Exception e) {
                throw new FacesException((Throwable)e);
            }
        }
        if (validator == null && LOGGER.isLoggable(Level.WARNING)) {
            LOGGER.log(Level.WARNING, MessageUtils.getExceptionMessageString("com.sun.faces.CANNOT_VALIDATE", validatorId != null ? validatorId.getExpressionString() : "", binding != null ? binding.getExpressionString() : ""));
        }
        return validator;
    }
}

