/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.cli.factory.security;

import jakarta.xml.bind.annotation.XmlRootElement;
import org.apache.activemq.artemis.cli.factory.security.SecurityHandler;
import org.apache.activemq.artemis.dto.SecurityDTO;
import org.apache.activemq.artemis.spi.core.security.ActiveMQSecurityManager;
import org.apache.activemq.artemis.utils.FactoryFinder;

public class SecurityManagerFactory {
    public static ActiveMQSecurityManager create(SecurityDTO config) throws Exception {
        if (config == null) {
            throw new Exception("No security manager configured!");
        }
        FactoryFinder finder = new FactoryFinder("META-INF/services/org/apache/activemq/artemis/broker/security/");
        SecurityHandler securityHandler = (SecurityHandler)finder.newInstance(config.getClass().getAnnotation(XmlRootElement.class).name());
        return securityHandler.createSecurityManager(config);
    }
}

