/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.saml.metadata.resolver.impl;

import com.google.common.base.Function;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.security.NoSuchAlgorithmException;
import net.shibboleth.utilities.java.support.codec.StringDigester;
import net.shibboleth.utilities.java.support.primitive.StringSupport;
import net.shibboleth.utilities.java.support.resolver.CriteriaSet;
import org.opensaml.core.criterion.EntityIdCriterion;

public class EntityIDDigestGenerator
implements Function<CriteriaSet, String> {
    @Nonnull
    private StringDigester digester;
    @Nullable
    private String prefix;
    @Nullable
    private String suffix;
    @Nullable
    private String separator;

    public EntityIDDigestGenerator() {
        this(null, null, null, null);
    }

    public EntityIDDigestGenerator(@Nullable StringDigester valueDigester, @Nullable String keyPrefix, @Nullable String keySuffix, @Nullable String valueSeparator) {
        this.prefix = StringSupport.trimOrNull((String)keyPrefix);
        this.suffix = StringSupport.trimOrNull((String)keySuffix);
        this.separator = StringSupport.trimOrNull((String)valueSeparator);
        this.digester = valueDigester;
        if (this.digester == null) {
            try {
                this.digester = new StringDigester("SHA-1", StringDigester.OutputFormat.HEX_LOWER);
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                // empty catch block
            }
        }
    }

    public String apply(CriteriaSet criteria) {
        if (criteria == null || !criteria.contains(EntityIdCriterion.class)) {
            return null;
        }
        String digested = this.digester.apply(((EntityIdCriterion)criteria.get(EntityIdCriterion.class)).getEntityId());
        return this.buildKey(digested);
    }

    protected String buildKey(@Nonnull String keyValue) {
        if (this.prefix == null && this.suffix == null) {
            return keyValue;
        }
        StringBuffer buffer = new StringBuffer();
        if (this.prefix != null) {
            buffer.append(this.prefix);
            if (this.separator != null) {
                buffer.append(this.separator);
            }
        }
        buffer.append(keyValue);
        if (this.suffix != null) {
            if (this.separator != null) {
                buffer.append(this.separator);
            }
            buffer.append(this.suffix);
        }
        return buffer.toString();
    }
}

