/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.server.deployment;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.jboss.as.server.Services;
import org.jboss.as.server.deployment.MountType;
import org.jboss.as.server.logging.ServerLogger;
import org.jboss.msc.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.jboss.threads.JBossThreadFactory;
import org.jboss.vfs.TempFileProvider;
import org.jboss.vfs.VFS;
import org.jboss.vfs.VFSUtils;
import org.jboss.vfs.VirtualFile;

public interface DeploymentMountProvider {
    public static final ServiceName SERVICE_NAME = ServiceName.JBOSS.append(new String[]{"deployment-mount-provider"});

    public Closeable mountDeploymentContent(VirtualFile var1, VirtualFile var2, MountType var3) throws IOException;

    public static class Factory {
        public static void addService(ServiceTarget serviceTarget) {
            ServiceBuilder sb = serviceTarget.addService(SERVICE_NAME);
            Consumer dmpConsumer = sb.provides(new ServiceName[]{SERVICE_NAME});
            Supplier<ExecutorService> esSupplier = Services.requireServerExecutor(sb);
            sb.setInstance((Service)new ServerDeploymentRepositoryImpl(dmpConsumer, esSupplier));
            sb.install();
        }

        private static class ServerDeploymentRepositoryImpl
        implements DeploymentMountProvider,
        Service {
            private final Consumer<DeploymentMountProvider> deploymentMountProviderConsumer;
            private final Supplier<ExecutorService> executorSupplier;
            private volatile TempFileProvider tempFileProvider;
            private volatile ScheduledExecutorService scheduledExecutorService;

            private ServerDeploymentRepositoryImpl(Consumer<DeploymentMountProvider> deploymentMountProviderConsumer, Supplier<ExecutorService> executorSupplier) {
                this.deploymentMountProviderConsumer = deploymentMountProviderConsumer;
                this.executorSupplier = executorSupplier;
            }

            @Override
            public Closeable mountDeploymentContent(VirtualFile contents, VirtualFile mountPoint, MountType type) throws IOException {
                assert (contents != null) : "null contents";
                switch (type) {
                    case ZIP: {
                        return VFS.mountZip((VirtualFile)contents, (VirtualFile)mountPoint, (TempFileProvider)this.tempFileProvider);
                    }
                    case EXPANDED: {
                        return VFS.mountZipExpanded((VirtualFile)contents, (VirtualFile)mountPoint, (TempFileProvider)this.tempFileProvider);
                    }
                    case REAL: {
                        return VFS.mountReal((File)contents.getPhysicalFile(), (VirtualFile)mountPoint);
                    }
                }
                throw ServerLogger.ROOT_LOGGER.unknownMountType(type);
            }

            public void start(StartContext context) throws StartException {
                try {
                    JBossThreadFactory threadFactory = AccessController.doPrivileged(new PrivilegedAction<JBossThreadFactory>(){

                        @Override
                        public JBossThreadFactory run() {
                            return new JBossThreadFactory(new ThreadGroup("ServerDeploymentRepository-temp-threads"), Boolean.valueOf(true), null, "%G - %t", null, null);
                        }
                    });
                    this.scheduledExecutorService = Executors.newScheduledThreadPool(2, (ThreadFactory)threadFactory);
                    this.tempFileProvider = TempFileProvider.create((String)"temp", (ScheduledExecutorService)this.scheduledExecutorService, (boolean)true);
                    this.deploymentMountProviderConsumer.accept(this);
                }
                catch (IOException e) {
                    throw ServerLogger.ROOT_LOGGER.failedCreatingTempProvider(e);
                }
                ServerLogger.ROOT_LOGGER.debugf("%s started", DeploymentMountProvider.class.getSimpleName());
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void stop(final StopContext context) {
                Runnable r = new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        try {
                            deploymentMountProviderConsumer.accept(null);
                            VFSUtils.safeClose((Closeable)tempFileProvider);
                        }
                        finally {
                            try {
                                ScheduledExecutorService ses = scheduledExecutorService;
                                scheduledExecutorService = null;
                                if (ses != null) {
                                    ses.shutdown();
                                }
                                ServerLogger.ROOT_LOGGER.debugf("%s stopped", DeploymentMountProvider.class.getSimpleName());
                            }
                            finally {
                                context.complete();
                            }
                        }
                    }
                };
                ExecutorService executorService = this.executorSupplier.get();
                try {
                    try {
                        executorService.execute(r);
                    }
                    catch (RejectedExecutionException e) {
                        r.run();
                    }
                }
                finally {
                    context.asynchronous();
                }
            }
        }
    }
}

