/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.soteria.authorization.spi.impl;

import jakarta.ejb.EJBContext;
import jakarta.enterprise.inject.spi.CDI;
import jakarta.security.enterprise.CallerPrincipal;
import jakarta.security.jacc.PolicyContext;
import jakarta.security.jacc.PolicyContextException;
import jakarta.servlet.http.HttpServletRequest;
import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.security.Principal;
import java.security.acl.Group;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.security.auth.Subject;
import org.glassfish.soteria.authorization.EJB;

public class SubjectParser {
    private static Object geronimoPolicyConfigurationFactoryInstance;
    private static ConcurrentMap<String, Map<Principal, Set<String>>> geronimoContextToRoleMapping;
    private Map<String, List<String>> groupToRoles = new HashMap<String, List<String>>();
    private boolean isJboss;
    private boolean isLiberty;
    private boolean oneToOneMapping;
    private boolean anyAuthenticatedUserRoleMapped = false;

    public static void onFactoryCreated() {
        SubjectParser.tryInitGeronimo();
    }

    private static void tryInitGeronimo() {
        try {
            geronimoPolicyConfigurationFactoryInstance = Class.forName("org.apache.geronimo.security.jacc.mappingprovider.GeronimoPolicyConfigurationFactory").newInstance();
            geronimoContextToRoleMapping = new ConcurrentHashMap<String, Map<Principal, Set<String>>>();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void onPolicyConfigurationCreated(final String contextID) {
        if (geronimoPolicyConfigurationFactoryInstance != null) {
            try {
                Class<?> geronimoPolicyConfigurationClass = Class.forName("org.apache.geronimo.security.jacc.mappingprovider.GeronimoPolicyConfiguration");
                Object geronimoPolicyConfigurationProxy = Proxy.newProxyInstance(SubjectParser.class.getClassLoader(), new Class[]{geronimoPolicyConfigurationClass}, new InvocationHandler(){

                    @Override
                    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                        if (method.getName().equals("setPrincipalRoleMapping")) {
                            geronimoContextToRoleMapping.put(contextID, (Map)args[0]);
                        }
                        return null;
                    }
                });
                Class.forName("org.apache.geronimo.security.jacc.mappingprovider.GeronimoPolicyConfigurationFactory").getMethod("setPolicyConfiguration", String.class, geronimoPolicyConfigurationClass).invoke(geronimoPolicyConfigurationFactoryInstance, contextID, geronimoPolicyConfigurationProxy);
            }
            catch (ClassNotFoundException | IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException | InvocationTargetException exception) {
                // empty catch block
            }
        }
    }

    public SubjectParser(String contextID, Collection<String> allDeclaredRoles) {
        if (this.tryGlassFish(contextID, allDeclaredRoles)) {
            return;
        }
        if (this.tryJBoss()) {
            return;
        }
        if (this.tryLiberty()) {
            return;
        }
        if (this.tryWebLogic(contextID, allDeclaredRoles)) {
            return;
        }
        if (this.tryGeronimo(contextID, allDeclaredRoles)) {
            return;
        }
        this.oneToOneMapping = true;
    }

    public List<String> getMappedRolesFromPrincipals(Principal[] principals) {
        return this.getMappedRolesFromPrincipals(Arrays.asList(principals));
    }

    public boolean isAnyAuthenticatedUserRoleMapped() {
        return this.anyAuthenticatedUserRoleMapped;
    }

    public Principal getCallerPrincipalFromPrincipals(Iterable<Principal> principals) {
        if (this.isJboss) {
            try {
                Subject subject = (Subject)PolicyContext.getContext((String)"javax.security.auth.Subject.container");
                if (subject == null) {
                    return null;
                }
                return this.doGetCallerPrincipalFromPrincipals(subject.getPrincipals());
            }
            catch (PolicyContextException policyContextException) {
                return null;
            }
        }
        return this.doGetCallerPrincipalFromPrincipals(principals);
    }

    public List<String> getMappedRolesFromPrincipals(Iterable<Principal> principals) {
        List groups;
        block7: {
            groups = null;
            if (this.isLiberty || this.isJboss) {
                try {
                    Subject subject = (Subject)PolicyContext.getContext((String)"javax.security.auth.Subject.container");
                    if (subject == null) {
                        return Collections.emptyList();
                    }
                    if (this.isLiberty) {
                        Set<Hashtable> tables = subject.getPrivateCredentials(Hashtable.class);
                        if (tables != null && !tables.isEmpty()) {
                            Hashtable table = tables.iterator().next();
                            groups = (List)table.get("com.ibm.wsspi.security.cred.groups");
                        }
                        break block7;
                    }
                    groups = this.getGroupsFromPrincipals(subject.getPrincipals());
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            } else {
                groups = this.getGroupsFromPrincipals(principals);
            }
        }
        return this.mapGroupsToRoles(groups);
    }

    private List<String> mapGroupsToRoles(List<String> groups) {
        if (this.oneToOneMapping) {
            return groups;
        }
        ArrayList<String> roles = new ArrayList<String>();
        for (String group : groups) {
            if (!this.groupToRoles.containsKey(group)) continue;
            roles.addAll((Collection<String>)this.groupToRoles.get(group));
        }
        return roles;
    }

    private boolean tryJBoss() {
        try {
            Class.forName("org.jboss.as.security.service.JaccService", false, Thread.currentThread().getContextClassLoader());
            this.isJboss = true;
            this.oneToOneMapping = true;
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    private boolean tryLiberty() {
        this.isLiberty = System.getProperty("wlp.server.name") != null;
        this.oneToOneMapping = true;
        return this.isLiberty;
    }

    private boolean tryGlassFish(String contextID, Collection<String> allDeclaredRoles) {
        try {
            Class<?> SecurityRoleMapperFactoryClass = Class.forName("org.glassfish.deployment.common.SecurityRoleMapperFactory");
            Object factoryInstance = Class.forName("org.glassfish.internal.api.Globals").getMethod("get", SecurityRoleMapperFactoryClass.getClass()).invoke(null, SecurityRoleMapperFactoryClass);
            Object securityRoleMapperInstance = SecurityRoleMapperFactoryClass.getMethod("getRoleMapper", String.class).invoke(factoryInstance, contextID);
            Map roleToSubjectMap = (Map)Class.forName("org.glassfish.deployment.common.SecurityRoleMapper").getMethod("getRoleToSubjectMapping", new Class[0]).invoke(securityRoleMapperInstance, new Object[0]);
            for (String role : allDeclaredRoles) {
                if (!roleToSubjectMap.containsKey(role)) continue;
                Set<Principal> principals = ((Subject)roleToSubjectMap.get(role)).getPrincipals();
                List<String> groups = this.getGroupsFromPrincipals(principals);
                for (String group : groups) {
                    if (!this.groupToRoles.containsKey(group)) {
                        this.groupToRoles.put(group, new ArrayList());
                    }
                    this.groupToRoles.get(group).add(role);
                }
                if (!"**".equals(role) || groups.isEmpty()) continue;
                this.anyAuthenticatedUserRoleMapped = true;
            }
            return true;
        }
        catch (ClassNotFoundException | IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            return false;
        }
    }

    private boolean tryWebLogic(String contextID, Collection<String> allDeclaredRoles) {
        try {
            Class<?> roleMapperFactoryClass = Class.forName("weblogic.security.jacc.RoleMapperFactory");
            Object roleMapperFactoryInstance = roleMapperFactoryClass.getMethod("getRoleMapperFactory", new Class[0]).invoke(null, new Object[0]);
            Object roleMapperInstance = roleMapperFactoryClass.getMethod("getRoleMapperForContextID", String.class).invoke(roleMapperFactoryInstance, contextID);
            Map roleToPrincipalNamesMap = (Map)Class.forName("weblogic.security.jacc.simpleprovider.RoleMapperImpl").getMethod("getRolesToPrincipalNames", new Class[0]).invoke(roleMapperInstance, new Object[0]);
            for (String role : allDeclaredRoles) {
                if (!roleToPrincipalNamesMap.containsKey(role)) continue;
                List<Object> groupsOrUserNames = Arrays.asList((Object[])roleToPrincipalNamesMap.get(role));
                for (String groupOrUserName : (String[])roleToPrincipalNamesMap.get(role)) {
                    if (!this.groupToRoles.containsKey(groupOrUserName)) {
                        this.groupToRoles.put(groupOrUserName, new ArrayList());
                    }
                    this.groupToRoles.get(groupOrUserName).add(role);
                }
                if (!"**".equals(role) || groupsOrUserNames.isEmpty()) continue;
                this.anyAuthenticatedUserRoleMapped = true;
            }
            return true;
        }
        catch (ClassNotFoundException | IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            return false;
        }
    }

    private boolean tryGeronimo(String contextID, Collection<String> allDeclaredRoles) {
        if (geronimoContextToRoleMapping != null) {
            if (geronimoContextToRoleMapping.containsKey(contextID)) {
                Map principalsToRoles = (Map)geronimoContextToRoleMapping.get(contextID);
                for (Map.Entry entry : principalsToRoles.entrySet()) {
                    for (String group : this.principalToGroups((Principal)entry.getKey())) {
                        if (!this.groupToRoles.containsKey(group)) {
                            this.groupToRoles.put(group, new ArrayList());
                        }
                        this.groupToRoles.get(group).addAll((Collection)entry.getValue());
                        if (!((Set)entry.getValue()).contains("**")) continue;
                        this.anyAuthenticatedUserRoleMapped = true;
                    }
                }
            }
            return true;
        }
        return false;
    }

    public List<String> getGroupsFromPrincipals(Iterable<Principal> principals) {
        ArrayList<String> groups = new ArrayList<String>();
        for (Principal principal : principals) {
            if (!this.principalToGroups(principal, groups)) continue;
            return groups;
        }
        return groups;
    }

    public List<String> principalToGroups(Principal principal) {
        ArrayList<String> groups = new ArrayList<String>();
        this.principalToGroups(principal, groups);
        return groups;
    }

    private Principal doGetCallerPrincipalFromPrincipals(Iterable<Principal> principals) {
        try {
            return ((HttpServletRequest)CDI.current().select(HttpServletRequest.class, new Annotation[0]).get()).getUserPrincipal();
        }
        catch (Exception exception) {
            EJBContext ejbContext = EJB.getEJBContext();
            if (ejbContext != null) {
                return this.getVendorCallerPrincipal(ejbContext.getCallerPrincipal(), true);
            }
            for (Principal principal : principals) {
                Principal vendorCallerPrincipal = this.getVendorCallerPrincipal(principal, false);
                if (vendorCallerPrincipal == null) continue;
                return vendorCallerPrincipal;
            }
            return null;
        }
    }

    private Principal getVendorCallerPrincipal(Principal principal, boolean isEjb) {
        switch (principal.getClass().getName()) {
            case "org.glassfish.security.common.PrincipalImpl": {
                return this.getAuthenticatedPrincipal(principal, "ANONYMOUS", isEjb);
            }
            case "weblogic.security.principal.WLSUserImpl": {
                return this.getAuthenticatedPrincipal(principal, "<anonymous>", isEjb);
            }
            case "com.ibm.ws.security.authentication.principals.WSPrincipal": {
                return this.getAuthenticatedPrincipal(principal, "UNAUTHENTICATED", isEjb);
            }
            case "org.jboss.security.SimplePrincipal": {
                return this.getAuthenticatedPrincipal(principal, "anonymous", isEjb);
            }
            case "org.jboss.security.SimpleGroup": {
                Enumeration groupMembers;
                if (!principal.getName().equals("CallerPrincipal") || !(principal instanceof Group) || !(groupMembers = ((Group)principal).members()).hasMoreElements()) break;
                return this.getAuthenticatedPrincipal((Principal)groupMembers.nextElement(), "anonymous", isEjb);
            }
            case "org.apache.tomee.catalina.TomcatSecurityService$TomcatUser": {
                try {
                    Principal tomeePrincipal = (Principal)Class.forName("org.apache.catalina.realm.GenericPrincipal").getMethod("getUserPrincipal", new Class[0]).invoke(Class.forName("org.apache.tomee.catalina.TomcatSecurityService$TomcatUser").getMethod("getTomcatPrincipal", new Class[0]).invoke((Object)principal, new Object[0]), new Object[0]);
                    return this.getAuthenticatedPrincipal(tomeePrincipal, "guest", isEjb);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        if (CallerPrincipal.class.isAssignableFrom(principal.getClass())) {
            return principal;
        }
        return null;
    }

    private Principal getAuthenticatedPrincipal(Principal principal, String anonymousCallerName, boolean isEjb) {
        if (isEjb && anonymousCallerName.equals(principal.getName())) {
            return null;
        }
        return principal;
    }

    public boolean principalToGroups(Principal principal, List<String> groups) {
        switch (principal.getClass().getName()) {
            case "org.glassfish.security.common.Group": 
            case "org.apache.geronimo.security.realm.providers.GeronimoGroupPrincipal": 
            case "weblogic.security.principal.WLSGroupImpl": 
            case "jeus.security.resource.GroupPrincipalImpl": {
                groups.add(principal.getName());
                break;
            }
            case "org.jboss.security.SimpleGroup": {
                if (principal.getName().equals("Roles") && principal instanceof Group) {
                    Group rolesGroup = (Group)principal;
                    for (Principal groupPrincipal : Collections.list(rolesGroup.members())) {
                        groups.add(groupPrincipal.getName());
                    }
                    return true;
                }
            }
            case "org.apache.tomee.catalina.TomcatSecurityService$TomcatUser": {
                try {
                    groups.addAll(Arrays.asList((String[])Class.forName("org.apache.catalina.realm.GenericPrincipal").getMethod("getRoles", new Class[0]).invoke(Class.forName("org.apache.tomee.catalina.TomcatSecurityService$TomcatUser").getMethod("getTomcatPrincipal", new Class[0]).invoke((Object)principal, new Object[0]), new Object[0])));
                    break;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        return false;
    }
}

