/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.soteria.mechanisms;

import jakarta.enterprise.inject.spi.CDI;
import jakarta.security.enterprise.AuthenticationException;
import jakarta.security.enterprise.AuthenticationStatus;
import jakarta.security.enterprise.authentication.mechanism.http.BasicAuthenticationMechanismDefinition;
import jakarta.security.enterprise.authentication.mechanism.http.HttpAuthenticationMechanism;
import jakarta.security.enterprise.authentication.mechanism.http.HttpMessageContext;
import jakarta.security.enterprise.credential.Credential;
import jakarta.security.enterprise.credential.Password;
import jakarta.security.enterprise.credential.UsernamePasswordCredential;
import jakarta.security.enterprise.identitystore.CredentialValidationResult;
import jakarta.security.enterprise.identitystore.IdentityStoreHandler;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.xml.bind.DatatypeConverter;
import java.lang.annotation.Annotation;
import java.security.Principal;
import org.glassfish.soteria.Utils;

public class BasicAuthenticationMechanism
implements HttpAuthenticationMechanism {
    private final BasicAuthenticationMechanismDefinition basicAuthenticationMechanismDefinition;

    public BasicAuthenticationMechanism(BasicAuthenticationMechanismDefinition basicAuthenticationMechanismDefinition) {
        this.basicAuthenticationMechanismDefinition = basicAuthenticationMechanismDefinition;
    }

    public AuthenticationStatus validateRequest(HttpServletRequest request, HttpServletResponse response, HttpMessageContext httpMsgContext) throws AuthenticationException {
        IdentityStoreHandler identityStoreHandler;
        CredentialValidationResult result;
        Object[] credentials = this.getCredentials(request);
        if (!Utils.isEmpty(credentials) && (result = (identityStoreHandler = (IdentityStoreHandler)CDI.current().select(IdentityStoreHandler.class, new Annotation[0]).get()).validate((Credential)new UsernamePasswordCredential((String)credentials[0], new Password((String)credentials[1])))).getStatus() == CredentialValidationResult.Status.VALID) {
            return httpMsgContext.notifyContainerAboutLogin((Principal)result.getCallerPrincipal(), result.getCallerGroups());
        }
        if (httpMsgContext.isProtected()) {
            response.setHeader("WWW-Authenticate", String.format("Basic realm=\"%s\"", this.basicAuthenticationMechanismDefinition.realmName()));
            return httpMsgContext.responseUnauthorized();
        }
        return httpMsgContext.doNothing();
    }

    private String[] getCredentials(HttpServletRequest request) {
        String authorizationHeader = request.getHeader("Authorization");
        if (!Utils.isEmpty(authorizationHeader) && authorizationHeader.startsWith("Basic ")) {
            return new String(DatatypeConverter.parseBase64Binary((String)authorizationHeader.substring(6))).split(":");
        }
        return null;
    }
}

