/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.elytron.oidc;

import java.util.ArrayList;
import org.jboss.as.server.deployment.DeploymentPhaseContext;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.as.server.deployment.DeploymentUnitProcessor;
import org.jboss.as.web.common.VirtualHttpServerMechanismFactoryMarkerUtility;
import org.jboss.as.web.common.WarMetaData;
import org.jboss.metadata.javaee.spec.ParamValueMetaData;
import org.jboss.metadata.web.jboss.JBossWebMetaData;
import org.jboss.metadata.web.spec.ListenerMetaData;
import org.jboss.metadata.web.spec.LoginConfigMetaData;
import org.wildfly.extension.elytron.oidc.OidcConfigService;
import org.wildfly.extension.elytron.oidc.OidcDeploymentMarker;
import org.wildfly.extension.elytron.oidc._private.ElytronOidcLogger;
import org.wildfly.security.http.oidc.OidcConfigurationServletListener;

class OidcActivationProcessor
implements DeploymentUnitProcessor {
    private static final String OIDC_AUTH_METHOD = "OIDC";

    OidcActivationProcessor() {
    }

    public void deploy(DeploymentPhaseContext phaseContext) throws DeploymentUnitProcessingException {
        LoginConfigMetaData loginConfig;
        OidcConfigService configService;
        DeploymentUnit deploymentUnit = phaseContext.getDeploymentUnit();
        WarMetaData warMetaData = (WarMetaData)deploymentUnit.getAttachment(WarMetaData.ATTACHMENT_KEY);
        if (warMetaData == null) {
            return;
        }
        JBossWebMetaData webMetaData = warMetaData.getMergedJBossWebMetaData();
        if (webMetaData == null) {
            webMetaData = new JBossWebMetaData();
            warMetaData.setMergedJBossWebMetaData(webMetaData);
        }
        if ((configService = OidcConfigService.getInstance()).isSecureDeployment(deploymentUnit) && configService.isDeploymentConfigured(deploymentUnit)) {
            this.addOidcAuthDataAndConfig(phaseContext, configService, webMetaData);
        }
        if ((loginConfig = webMetaData.getLoginConfig()) != null && loginConfig.getAuthMethod().equals(OIDC_AUTH_METHOD)) {
            ListenerMetaData listenerMetaData = new ListenerMetaData();
            listenerMetaData.setListenerClass(OidcConfigurationServletListener.class.getName());
            webMetaData.getListeners().add(listenerMetaData);
            ElytronOidcLogger.ROOT_LOGGER.tracef("Activating OIDC for deployment %s.", deploymentUnit.getName());
            OidcDeploymentMarker.mark(deploymentUnit);
            VirtualHttpServerMechanismFactoryMarkerUtility.virtualMechanismFactoryRequired((DeploymentUnit)deploymentUnit);
        }
    }

    private void addOidcAuthDataAndConfig(DeploymentPhaseContext phaseContext, OidcConfigService service, JBossWebMetaData webMetaData) throws DeploymentUnitProcessingException {
        DeploymentUnit deploymentUnit = phaseContext.getDeploymentUnit();
        this.addJSONDataAsContextParam(service.getJSON(deploymentUnit), webMetaData);
        LoginConfigMetaData loginConfig = webMetaData.getLoginConfig();
        if (loginConfig == null) {
            loginConfig = new LoginConfigMetaData();
            webMetaData.setLoginConfig(loginConfig);
        }
        loginConfig.setAuthMethod(OIDC_AUTH_METHOD);
        ElytronOidcLogger.ROOT_LOGGER.deploymentSecured(deploymentUnit.getName());
    }

    private void addJSONDataAsContextParam(String json, JBossWebMetaData webMetaData) {
        ArrayList<ParamValueMetaData> contextParams = webMetaData.getContextParams();
        if (contextParams == null) {
            contextParams = new ArrayList<ParamValueMetaData>();
        }
        ParamValueMetaData param = new ParamValueMetaData();
        param.setParamName("org.wildfly.security.http.oidc.json.config");
        param.setParamValue(json);
        contextParams.add(param);
        webMetaData.setContextParams(contextParams);
    }
}

