/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.plugins.server.servlet;

import jakarta.servlet.ServletOutputStream;
import jakarta.servlet.WriteListener;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.ws.rs.core.MultivaluedMap;
import jakarta.ws.rs.core.NewCookie;
import java.io.IOException;
import java.io.OutputStream;
import java.util.LinkedList;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.atomic.AtomicBoolean;
import org.jboss.resteasy.core.ResteasyContext;
import org.jboss.resteasy.plugins.server.servlet.HttpServletResponseHeaders;
import org.jboss.resteasy.spi.AsyncOutputStream;
import org.jboss.resteasy.spi.HttpRequest;
import org.jboss.resteasy.spi.HttpResponse;
import org.jboss.resteasy.spi.ResteasyProviderFactory;

public class HttpServletResponseWrapper
implements HttpResponse {
    protected final HttpServletResponse response;
    protected int status = 200;
    protected MultivaluedMap<String, Object> outputHeaders;
    protected final ResteasyProviderFactory factory;
    private OutputStream outputStream;
    protected volatile boolean suppressExceptionDuringChunkedTransfer = true;
    protected final HttpServletRequest request;
    protected final Map<Class<?>, Object> contextDataMap;

    public void setSuppressExceptionDuringChunkedTransfer(boolean suppressExceptionDuringChunkedTransfer) {
        this.suppressExceptionDuringChunkedTransfer = suppressExceptionDuringChunkedTransfer;
    }

    public boolean suppressExceptionDuringChunkedTransfer() {
        return this.suppressExceptionDuringChunkedTransfer;
    }

    public HttpServletResponseWrapper(HttpServletResponse response, HttpServletRequest request, ResteasyProviderFactory factory) {
        this.response = response;
        this.request = request;
        this.outputHeaders = new HttpServletResponseHeaders(response, factory);
        this.factory = factory;
        this.contextDataMap = ResteasyContext.getContextDataMap();
    }

    public int getStatus() {
        return this.status;
    }

    public void setStatus(int status) {
        this.status = status;
        this.response.setStatus(status);
    }

    public MultivaluedMap<String, Object> getOutputHeaders() {
        return this.outputHeaders;
    }

    public synchronized OutputStream getOutputStream() throws IOException {
        if (this.outputStream == null) {
            this.outputStream = new DeferredOutputStream();
        }
        return this.outputStream;
    }

    public synchronized void setOutputStream(OutputStream os) {
        this.outputStream = os;
    }

    public void addNewCookie(NewCookie cookie) {
        this.outputHeaders.add((Object)"Set-Cookie", (Object)cookie);
    }

    public void sendError(int status) throws IOException {
        this.response.sendError(status);
    }

    public void sendError(int status, String message) throws IOException {
        this.response.sendError(status, message);
    }

    public boolean isCommitted() {
        return this.response.isCommitted();
    }

    public void reset() {
        this.response.reset();
        this.outputHeaders = new HttpServletResponseHeaders(this.response, this.factory);
    }

    public void flushBuffer() throws IOException {
        this.response.flushBuffer();
    }

    protected class DeferredOutputStream
    extends AsyncOutputStream
    implements WriteListener {
        private final ServletOutputStream out;
        private final Queue<AsyncOperation> asyncQueue = new LinkedList<AsyncOperation>();
        private final AtomicBoolean asyncRegistered;
        private AsyncOperation lastAsyncOperation;
        private volatile boolean asyncListenerCalled;

        DeferredOutputStream() throws IOException {
            this.out = HttpServletResponseWrapper.this.response.getOutputStream();
            this.asyncRegistered = new AtomicBoolean();
        }

        public void write(int i) throws IOException {
            this.out.write(i);
        }

        public void write(byte[] bytes) throws IOException {
            this.out.write(bytes);
        }

        public void write(byte[] bytes, int i, int i1) throws IOException {
            this.out.write(bytes, i, i1);
        }

        public void flush() throws IOException {
            this.out.flush();
        }

        public void close() throws IOException {
        }

        public CompletionStage<Void> asyncFlush() {
            FlushOperation op = new FlushOperation((OutputStream)((Object)this));
            this.queue(op);
            return op.future;
        }

        public CompletionStage<Void> asyncWrite(byte[] bytes, int offset, int length) {
            WriteOperation op = new WriteOperation((OutputStream)((Object)this), bytes, offset, length);
            this.queue(op);
            return op.future;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void queue(AsyncOperation op) {
            HttpRequest resteasyRequest = (HttpRequest)HttpServletResponseWrapper.this.contextDataMap.get(HttpRequest.class);
            if (HttpServletResponseWrapper.this.request.isAsyncStarted() && !resteasyRequest.getAsyncContext().isOnInitialRequest()) {
                boolean flush = false;
                if (this.asyncRegistered.compareAndSet(false, true)) {
                    this.out.setWriteListener((WriteListener)this);
                }
                DeferredOutputStream deferredOutputStream = this;
                synchronized (deferredOutputStream) {
                    if (this.asyncListenerCalled && this.out.isReady()) {
                        this.asyncQueue.add(op);
                        flush = true;
                    } else {
                        this.asyncQueue.add(op);
                    }
                }
                if (flush) {
                    this.flushQueue();
                }
            } else {
                op.work(null);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void flushQueue() {
            DeferredOutputStream deferredOutputStream = this;
            synchronized (deferredOutputStream) {
                if (this.lastAsyncOperation != null) {
                    if (!this.lastAsyncOperation.future.isDone()) {
                        return;
                    }
                    this.lastAsyncOperation = null;
                }
                while (this.out.isReady() && (this.lastAsyncOperation = this.asyncQueue.poll()) != null) {
                    this.lastAsyncOperation.work(this.out);
                }
            }
        }

        public void onWritePossible() {
            this.asyncListenerCalled = true;
            this.flushQueue();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onError(Throwable t) {
            DeferredOutputStream deferredOutputStream = this;
            synchronized (deferredOutputStream) {
                AsyncOperation op;
                this.asyncListenerCalled = true;
                if (this.lastAsyncOperation != null) {
                    this.lastAsyncOperation.future.completeExceptionally(t);
                    this.lastAsyncOperation = null;
                }
                while ((op = this.asyncQueue.poll()) != null) {
                    if (op.future.isDone()) continue;
                    op.future.completeExceptionally(t);
                }
            }
        }
    }

    public class FlushOperation
    extends AsyncOperation {
        public FlushOperation(OutputStream os) {
            super(os);
        }

        @Override
        protected void doWork(ServletOutputStream sos) {
            try {
                if (sos == null || sos.isReady()) {
                    this.stream.flush();
                    this.future.complete(null);
                }
            }
            catch (IOException e) {
                this.future.completeExceptionally(e);
            }
        }

        public String toString() {
            return "[flush]";
        }
    }

    public class WriteOperation
    extends AsyncOperation {
        private final byte[] bytes;
        private final int offset;
        private final int length;

        public WriteOperation(OutputStream stream, byte[] bytes, int offset, int length) {
            super(stream);
            this.bytes = bytes;
            this.offset = offset;
            this.length = length;
        }

        @Override
        protected void doWork(ServletOutputStream sos) {
            try {
                if (sos == null || sos.isReady()) {
                    this.stream.write(this.bytes, this.offset, this.length);
                    this.future.complete(null);
                }
            }
            catch (IOException e) {
                this.future.completeExceptionally(e);
            }
        }

        public String toString() {
            return "[write: " + new String(this.bytes) + "]";
        }
    }

    public abstract class AsyncOperation {
        final CompletableFuture<Void> future = new CompletableFuture();
        final OutputStream stream;

        public AsyncOperation(OutputStream stream) {
            this.stream = stream;
        }

        public void work(ServletOutputStream sos) {
            try (ResteasyContext.CloseableContext c = ResteasyContext.addCloseableContextDataLevel(HttpServletResponseWrapper.this.contextDataMap);){
                this.doWork(sos);
            }
        }

        protected abstract void doWork(ServletOutputStream var1);
    }
}

