/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.amqp;

import jakarta.jms.Connection;
import jakarta.jms.ConnectionFactory;
import jakarta.jms.Destination;
import jakarta.jms.Message;
import jakarta.jms.MessageProducer;
import jakarta.jms.Session;
import jakarta.jms.TextMessage;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.OutputStream;
import java.io.PrintStream;
import java.nio.charset.StandardCharsets;
import org.apache.activemq.artemis.cli.commands.tools.PrintData;
import org.apache.activemq.artemis.core.config.Configuration;
import org.apache.activemq.artemis.core.config.FileDeploymentManager;
import org.apache.activemq.artemis.core.config.impl.FileConfiguration;
import org.apache.activemq.artemis.core.config.impl.SecurityConfiguration;
import org.apache.activemq.artemis.core.deployers.Deployable;
import org.apache.activemq.artemis.core.server.ActiveMQServer;
import org.apache.activemq.artemis.core.server.impl.ActiveMQServerImpl;
import org.apache.activemq.artemis.jms.server.config.impl.FileJMSConfiguration;
import org.apache.activemq.artemis.spi.core.security.ActiveMQJAASSecurityManager;
import org.apache.activemq.artemis.spi.core.security.ActiveMQSecurityManager;
import org.apache.activemq.artemis.spi.core.security.jaas.InVMLoginModule;
import org.apache.activemq.artemis.tests.util.ActiveMQTestBase;
import org.apache.activemq.artemis.tests.util.CFUtil;
import org.apache.activemq.artemis.tests.util.RandomUtil;
import org.junit.Assert;
import org.junit.Test;

public class AMQPPrintDataTest
extends ActiveMQTestBase {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testPrintDataWithAMQP() throws Exception {
        String random = RandomUtil.randomString();
        ActiveMQServer server = this.addServer(this.getActiveMQServer("dataprint/etc/broker.xml"));
        try {
            server.getConfiguration().setPersistenceEnabled(true);
            server.start();
            ConnectionFactory factory = CFUtil.createConnectionFactory("AMQP", "tcp://localhost:61616");
            Connection connection = factory.createConnection();
            Session session = connection.createSession(false, 1);
            MessageProducer producer = session.createProducer((Destination)session.createQueue("q1"));
            TextMessage message = session.createTextMessage("hello");
            message.setStringProperty("hello", "world:" + random);
            producer.send((Message)message);
            connection.close();
            server.stop();
            System.setProperty("artemis.instance", ((Object)((Object)this)).getClass().getClassLoader().getResource("dataprint").getFile());
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            PrintStream printStream = new PrintStream((OutputStream)byteArrayOutputStream, true, StandardCharsets.UTF_8.name());
            PrintData.printData((File)server.getConfiguration().getBindingsLocation().getAbsoluteFile(), (File)server.getConfiguration().getJournalLocation().getAbsoluteFile(), (File)server.getConfiguration().getPagingLocation().getAbsoluteFile(), (PrintStream)printStream, (boolean)false, (boolean)false);
            Assert.assertTrue((boolean)byteArrayOutputStream.toString().contains(random));
        }
        finally {
            try {
                server.stop();
            }
            catch (Exception exception) {}
        }
    }

    protected ActiveMQServer getActiveMQServer(String brokerConfig) throws Exception {
        FileConfiguration fc = new FileConfiguration();
        FileJMSConfiguration fileConfiguration = new FileJMSConfiguration();
        FileDeploymentManager deploymentManager = new FileDeploymentManager(brokerConfig);
        deploymentManager.addDeployable((Deployable)fc);
        deploymentManager.addDeployable((Deployable)fileConfiguration);
        deploymentManager.readConfiguration();
        ActiveMQJAASSecurityManager sm = new ActiveMQJAASSecurityManager(InVMLoginModule.class.getName(), new SecurityConfiguration());
        AMQPPrintDataTest.recreateDirectory((String)fc.getBindingsDirectory());
        AMQPPrintDataTest.recreateDirectory((String)fc.getJournalDirectory());
        AMQPPrintDataTest.recreateDirectory((String)fc.getPagingDirectory());
        AMQPPrintDataTest.recreateDirectory((String)fc.getLargeMessagesDirectory());
        return this.addServer((ActiveMQServer)new ActiveMQServerImpl((Configuration)fc, (ActiveMQSecurityManager)sm));
    }
}

