/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.amqp;

import jakarta.jms.Connection;
import jakarta.jms.ConnectionFactory;
import jakarta.jms.Destination;
import jakarta.jms.Message;
import jakarta.jms.MessageConsumer;
import jakarta.jms.MessageProducer;
import jakarta.jms.Queue;
import jakarta.jms.Session;
import jakarta.jms.TextMessage;
import java.util.Arrays;
import java.util.Collection;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.activemq.artemis.api.core.QueueConfiguration;
import org.apache.activemq.artemis.api.core.RoutingType;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.jms.client.ActiveMQConnectionFactory;
import org.apache.activemq.artemis.tests.integration.amqp.JMSClientTestSupport;
import org.apache.qpid.jms.JmsConnectionFactory;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class ExtremeCancelsTest
extends JMSClientTestSupport {
    private SimpleString anycastAddress = new SimpleString("theQueue");
    private boolean isAMQP;

    @Override
    protected String getConfiguredProtocols() {
        return "AMQP,OPENWIRE,CORE";
    }

    public ExtremeCancelsTest(boolean isAMQP) {
        this.isAMQP = isAMQP;
    }

    @Parameterized.Parameters(name="{index}: isAMQP={0}")
    public static Collection<Object[]> parameters() {
        return Arrays.asList({true}, {false});
    }

    @Test(timeout=120000L)
    public void testLotsOfCloseOpenConsumer() throws Exception {
        this.server.createQueue(new QueueConfiguration(this.anycastAddress).setRoutingType(RoutingType.ANYCAST));
        final AtomicInteger errors = new AtomicInteger(0);
        final AtomicBoolean runnning = new AtomicBoolean(true);
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                try {
                    ConnectionFactory factory = ExtremeCancelsTest.this.createCF();
                    Connection connection = factory.createConnection();
                    Session session = connection.createSession();
                    connection.start();
                    Queue queue = session.createQueue(ExtremeCancelsTest.this.anycastAddress.toString());
                    while (runnning.get()) {
                        MessageConsumer consumer = session.createConsumer((Destination)queue);
                        TextMessage message = (TextMessage)consumer.receive(100L);
                        if (message == null) continue;
                        consumer.close();
                    }
                    connection.close();
                }
                catch (Exception e) {
                    e.printStackTrace();
                    errors.incrementAndGet();
                }
            }
        };
        Thread[] consumers = new Thread[10];
        for (int i = 0; i < consumers.length; ++i) {
            consumers[i] = new Thread(runnable);
            consumers[i].start();
        }
        ConnectionFactory factory = this.createCF();
        Connection connection = factory.createConnection();
        Session session = connection.createSession();
        Queue queue = session.createQueue(this.anycastAddress.toString());
        MessageProducer producer = session.createProducer((Destination)queue);
        int NUMBER_OF_MESSAGES = 500;
        for (int i = 0; i < 500; ++i) {
            producer.send((Message)session.createTextMessage("Hello guys " + i));
        }
        runnning.set(false);
        for (Thread c : consumers) {
            c.join();
        }
        Assert.assertEquals((long)0L, (long)errors.get());
    }

    private ConnectionFactory createCF() {
        if (this.isAMQP) {
            return new JmsConnectionFactory(this.getBrokerQpidJMSConnectionURI());
        }
        return new ActiveMQConnectionFactory("tcp://localhost:5672");
    }
}

