/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.amqp;

import jakarta.jms.BytesMessage;
import jakarta.jms.Connection;
import jakarta.jms.Destination;
import jakarta.jms.JMSException;
import jakarta.jms.Message;
import jakarta.jms.MessageConsumer;
import jakarta.jms.MessageProducer;
import jakarta.jms.Session;
import jakarta.jms.TextMessage;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import org.apache.activemq.artemis.api.core.QueueConfiguration;
import org.apache.activemq.artemis.api.core.RoutingType;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.api.core.management.QueueControl;
import org.apache.activemq.artemis.core.postoffice.QueueBinding;
import org.apache.activemq.artemis.core.server.ActiveMQServer;
import org.apache.activemq.artemis.core.server.Queue;
import org.apache.activemq.artemis.core.server.impl.AddressInfo;
import org.apache.activemq.artemis.core.server.impl.LastValueQueue;
import org.apache.activemq.artemis.core.settings.impl.AddressSettings;
import org.apache.activemq.artemis.tests.integration.amqp.JMSClientTestSupport;
import org.apache.activemq.artemis.tests.util.Wait;
import org.apache.activemq.artemis.utils.RetryRule;
import org.jboss.logging.Logger;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class JMSNonDestructiveTest
extends JMSClientTestSupport {
    private static final Logger logger = Logger.getLogger(JMSNonDestructiveTest.class);
    @Rule
    public RetryRule retryRule = new RetryRule(2);
    private static final String NON_DESTRUCTIVE_QUEUE_NAME = "NON_DESTRUCTIVE_QUEUE";
    private static final String NON_DESTRUCTIVE_EXPIRY_QUEUE_NAME = "NON_DESTRUCTIVE_EXPIRY_QUEUE";
    private static final String NON_DESTRUCTIVE_LVQ_QUEUE_NAME = "NON_DESTRUCTIVE_LVQ_QUEUE";
    private static final String NON_DESTRUCTIVE_TOMBSTONE_LVQ_QUEUE_NAME = "NON_DESTRUCTIVE_LVQ_TOMBSTONE_QUEUE";
    private JMSClientTestSupport.ConnectionSupplier AMQPConnection = () -> this.createConnection();
    private JMSClientTestSupport.ConnectionSupplier CoreConnection = () -> this.createCoreConnection();
    protected final boolean persistenceEnabled;
    protected final long scanPeriod;

    public JMSNonDestructiveTest(boolean persistenceEnabled, long scanPeriod) {
        this.persistenceEnabled = persistenceEnabled;
        this.scanPeriod = scanPeriod;
    }

    @Parameterized.Parameters(name="persistenceEnabled={0}, scanPeriod={1}")
    public static Collection<Object[]> data() {
        Object[][] params = new Object[][]{{false, 100}, {true, 100}, {true, -1}};
        return Arrays.asList(params);
    }

    @Override
    protected String getConfiguredProtocols() {
        return "AMQP,OPENWIRE,CORE";
    }

    @Override
    protected void addConfiguration(ActiveMQServer server) {
        server.getConfiguration().setPersistenceEnabled(this.persistenceEnabled);
        server.getConfiguration().setMessageExpiryScanPeriod(this.scanPeriod);
        server.getAddressSettingsRepository().addMatch(NON_DESTRUCTIVE_QUEUE_NAME, (Object)new AddressSettings().setDefaultNonDestructive(true));
        server.getAddressSettingsRepository().addMatch(NON_DESTRUCTIVE_EXPIRY_QUEUE_NAME, (Object)new AddressSettings().setDefaultNonDestructive(true).setExpiryDelay(Long.valueOf(100L)));
        server.getAddressSettingsRepository().addMatch(NON_DESTRUCTIVE_LVQ_QUEUE_NAME, (Object)new AddressSettings().setDefaultLastValueQueue(true).setDefaultNonDestructive(true));
        server.getAddressSettingsRepository().addMatch(NON_DESTRUCTIVE_TOMBSTONE_LVQ_QUEUE_NAME, (Object)new AddressSettings().setDefaultLastValueQueue(true).setDefaultNonDestructive(true));
    }

    @Override
    protected void createAddressAndQueues(ActiveMQServer server) throws Exception {
        super.createAddressAndQueues(server);
        server.addAddressInfo(new AddressInfo(SimpleString.toSimpleString((String)NON_DESTRUCTIVE_QUEUE_NAME), RoutingType.ANYCAST));
        server.createQueue(new QueueConfiguration(NON_DESTRUCTIVE_QUEUE_NAME).setRoutingType(RoutingType.ANYCAST));
        server.addAddressInfo(new AddressInfo(SimpleString.toSimpleString((String)NON_DESTRUCTIVE_EXPIRY_QUEUE_NAME), RoutingType.ANYCAST));
        server.createQueue(new QueueConfiguration(NON_DESTRUCTIVE_EXPIRY_QUEUE_NAME).setRoutingType(RoutingType.ANYCAST));
        server.addAddressInfo(new AddressInfo(SimpleString.toSimpleString((String)NON_DESTRUCTIVE_LVQ_QUEUE_NAME), RoutingType.ANYCAST));
        server.createQueue(new QueueConfiguration(NON_DESTRUCTIVE_LVQ_QUEUE_NAME).setRoutingType(RoutingType.ANYCAST));
        server.addAddressInfo(new AddressInfo(SimpleString.toSimpleString((String)NON_DESTRUCTIVE_TOMBSTONE_LVQ_QUEUE_NAME), RoutingType.ANYCAST));
        server.createQueue(new QueueConfiguration(NON_DESTRUCTIVE_TOMBSTONE_LVQ_QUEUE_NAME).setRoutingType(RoutingType.ANYCAST));
    }

    @Test
    public void testNonDestructiveAMQPProducerAMQPConsumer() throws Exception {
        this.testNonDestructive(this.AMQPConnection, this.AMQPConnection);
    }

    @Test
    public void testNonDestructiveCoreProducerCoreConsumer() throws Exception {
        this.testNonDestructive(this.CoreConnection, this.CoreConnection);
    }

    @Test
    public void testNonDestructiveCoreProducerAMQPConsumer() throws Exception {
        this.testNonDestructive(this.CoreConnection, this.AMQPConnection);
    }

    @Test
    public void testNonDestructiveAMQPProducerCoreConsumer() throws Exception {
        this.testNonDestructive(this.AMQPConnection, this.CoreConnection);
    }

    @Test
    public void testNonDestructiveLVQWithConsumerFirstCore() throws Exception {
        this.testNonDestructiveLVQWithConsumerFirst(this.CoreConnection);
    }

    @Test
    public void testNonDestructiveLVQWithConsumerFirstAMQP() throws Exception {
        this.testNonDestructiveLVQWithConsumerFirst(this.AMQPConnection);
    }

    public void testNonDestructive(JMSClientTestSupport.ConnectionSupplier producerConnectionSupplier, JMSClientTestSupport.ConnectionSupplier consumerConnectionSupplier) throws Exception {
        this.testNonDestructiveSingle(producerConnectionSupplier, consumerConnectionSupplier);
        this.testNonDestructiveDualConsumer(producerConnectionSupplier, consumerConnectionSupplier);
        this.testNonDestructiveExpiry(producerConnectionSupplier, consumerConnectionSupplier);
        this.testNonDestructiveMulitpleMessages(producerConnectionSupplier, consumerConnectionSupplier);
        this.testNonDestructiveMulitpleMessagesDualConsumer(producerConnectionSupplier, consumerConnectionSupplier);
        this.testNonDestructiveLVQ(producerConnectionSupplier, consumerConnectionSupplier);
        this.testNonDestructiveLVQTombstone(producerConnectionSupplier, consumerConnectionSupplier);
    }

    public void testNonDestructiveSingle(JMSClientTestSupport.ConnectionSupplier producerConnectionSupplier, JMSClientTestSupport.ConnectionSupplier consumerConnectionSupplier) throws Exception {
        this.sendMessage(producerConnectionSupplier, NON_DESTRUCTIVE_QUEUE_NAME);
        QueueBinding queueBinding = (QueueBinding)this.server.getPostOffice().getBinding(SimpleString.toSimpleString((String)NON_DESTRUCTIVE_QUEUE_NAME));
        JMSNonDestructiveTest.assertEquals((String)"Ensure Message count", (long)1L, (long)queueBinding.getQueue().getMessageCount());
        this.receive(consumerConnectionSupplier, NON_DESTRUCTIVE_QUEUE_NAME);
        JMSNonDestructiveTest.assertEquals((String)"Ensure Message count", (long)1L, (long)queueBinding.getQueue().getMessageCount());
        this.receive(consumerConnectionSupplier, NON_DESTRUCTIVE_QUEUE_NAME);
        JMSNonDestructiveTest.assertEquals((String)"Ensure Message count", (long)1L, (long)queueBinding.getQueue().getMessageCount());
        QueueControl control = (QueueControl)this.server.getManagementService().getResource("queue.NON_DESTRUCTIVE_QUEUE");
        control.removeAllMessages();
        JMSNonDestructiveTest.assertEquals((String)"Message count after clearing queue via queue control should be 0", (long)0L, (long)queueBinding.getQueue().getMessageCount());
    }

    public void testNonDestructiveDualConsumer(JMSClientTestSupport.ConnectionSupplier producerConnectionSupplier, JMSClientTestSupport.ConnectionSupplier consumerConnectionSupplier) throws Exception {
        this.sendMessage(producerConnectionSupplier, NON_DESTRUCTIVE_QUEUE_NAME);
        QueueBinding queueBinding = (QueueBinding)this.server.getPostOffice().getBinding(SimpleString.toSimpleString((String)NON_DESTRUCTIVE_QUEUE_NAME));
        JMSNonDestructiveTest.assertEquals((String)"Ensure Message count", (long)1L, (long)queueBinding.getQueue().getMessageCount());
        this.receiveDualConsumer(consumerConnectionSupplier, NON_DESTRUCTIVE_QUEUE_NAME);
        JMSNonDestructiveTest.assertEquals((String)"Ensure Message count", (long)1L, (long)queueBinding.getQueue().getMessageCount());
        this.receiveDualConsumer(consumerConnectionSupplier, NON_DESTRUCTIVE_QUEUE_NAME);
        JMSNonDestructiveTest.assertEquals((String)"Ensure Message count", (long)1L, (long)queueBinding.getQueue().getMessageCount());
        QueueControl control = (QueueControl)this.server.getManagementService().getResource("queue.NON_DESTRUCTIVE_QUEUE");
        control.removeAllMessages();
        JMSNonDestructiveTest.assertEquals((String)"Message count after clearing queue via queue control should be 0", (long)0L, (long)queueBinding.getQueue().getMessageCount());
    }

    public void testNonDestructiveExpiry(JMSClientTestSupport.ConnectionSupplier producerConnectionSupplier, JMSClientTestSupport.ConnectionSupplier consumerConnectionSupplier) throws Exception {
        this.sendMessage(producerConnectionSupplier, NON_DESTRUCTIVE_EXPIRY_QUEUE_NAME);
        QueueBinding queueBinding = (QueueBinding)this.server.getPostOffice().getBinding(SimpleString.toSimpleString((String)NON_DESTRUCTIVE_EXPIRY_QUEUE_NAME));
        JMSNonDestructiveTest.assertEquals((String)"Ensure Message count", (long)1L, (long)queueBinding.getQueue().getMessageCount());
        this.receive(consumerConnectionSupplier, NON_DESTRUCTIVE_EXPIRY_QUEUE_NAME);
        Wait.assertEquals((long)1L, () -> ((Queue)queueBinding.getQueue()).getMessageCount());
        Wait.waitFor(() -> queueBinding.getQueue().getMessageCount() == 0L, (long)200L);
        this.receiveNull(consumerConnectionSupplier, NON_DESTRUCTIVE_EXPIRY_QUEUE_NAME);
        JMSNonDestructiveTest.assertEquals((String)"Ensure Message count", (long)0L, (long)queueBinding.getQueue().getMessageCount());
        QueueControl control = (QueueControl)this.server.getManagementService().getResource("queue.NON_DESTRUCTIVE_EXPIRY_QUEUE");
        control.removeAllMessages();
        JMSNonDestructiveTest.assertEquals((String)"Message count after clearing queue via queue control should be 0", (long)0L, (long)queueBinding.getQueue().getMessageCount());
    }

    public void testNonDestructiveMulitpleMessages(JMSClientTestSupport.ConnectionSupplier producerConnectionSupplier, JMSClientTestSupport.ConnectionSupplier consumerConnectionSupplier) throws Exception {
        this.sendMessage(producerConnectionSupplier, NON_DESTRUCTIVE_QUEUE_NAME, 0);
        this.sendMessage(producerConnectionSupplier, NON_DESTRUCTIVE_QUEUE_NAME, 1);
        this.sendMessage(producerConnectionSupplier, NON_DESTRUCTIVE_QUEUE_NAME, 2);
        QueueBinding queueBinding = (QueueBinding)this.server.getPostOffice().getBinding(SimpleString.toSimpleString((String)NON_DESTRUCTIVE_QUEUE_NAME));
        JMSNonDestructiveTest.assertEquals((String)"Ensure Message count", (long)3L, (long)queueBinding.getQueue().getMessageCount());
        this.receive(consumerConnectionSupplier, NON_DESTRUCTIVE_QUEUE_NAME, 3);
        this.receive(consumerConnectionSupplier, NON_DESTRUCTIVE_QUEUE_NAME, 3);
        QueueControl control = (QueueControl)this.server.getManagementService().getResource("queue.NON_DESTRUCTIVE_QUEUE");
        control.removeAllMessages();
        JMSNonDestructiveTest.assertEquals((String)"Message count after clearing queue via queue control should be 0", (long)0L, (long)queueBinding.getQueue().getMessageCount());
    }

    public void testNonDestructiveMulitpleMessagesDualConsumer(JMSClientTestSupport.ConnectionSupplier producerConnectionSupplier, JMSClientTestSupport.ConnectionSupplier consumerConnectionSupplier) throws Exception {
        this.sendMessage(producerConnectionSupplier, NON_DESTRUCTIVE_QUEUE_NAME, 0);
        this.sendMessage(producerConnectionSupplier, NON_DESTRUCTIVE_QUEUE_NAME, 1);
        this.sendMessage(producerConnectionSupplier, NON_DESTRUCTIVE_QUEUE_NAME, 2);
        QueueBinding queueBinding = (QueueBinding)this.server.getPostOffice().getBinding(SimpleString.toSimpleString((String)NON_DESTRUCTIVE_QUEUE_NAME));
        JMSNonDestructiveTest.assertEquals((String)"Ensure Message count", (long)3L, (long)queueBinding.getQueue().getMessageCount());
        this.receiveDualConsumer(consumerConnectionSupplier, NON_DESTRUCTIVE_QUEUE_NAME, 3);
        this.receiveDualConsumer(consumerConnectionSupplier, NON_DESTRUCTIVE_QUEUE_NAME, 3);
        QueueControl control = (QueueControl)this.server.getManagementService().getResource("queue.NON_DESTRUCTIVE_QUEUE");
        control.removeAllMessages();
        JMSNonDestructiveTest.assertEquals((String)"Message count after clearing queue via queue control should be 0", (long)0L, (long)queueBinding.getQueue().getMessageCount());
    }

    public void testNonDestructiveLVQ(JMSClientTestSupport.ConnectionSupplier producerConnectionSupplier, JMSClientTestSupport.ConnectionSupplier consumerConnectionSupplier) throws Exception {
        this.sendLVQ(producerConnectionSupplier, NON_DESTRUCTIVE_LVQ_QUEUE_NAME, org.apache.activemq.artemis.api.core.Message.HDR_LAST_VALUE_NAME.toString());
        QueueBinding queueBinding = (QueueBinding)this.server.getPostOffice().getBinding(SimpleString.toSimpleString((String)NON_DESTRUCTIVE_LVQ_QUEUE_NAME));
        JMSNonDestructiveTest.assertEquals((String)"Ensure Message count", (long)1L, (long)queueBinding.getQueue().getMessageCount());
        Thread.sleep(10L);
        this.receiveLVQ(consumerConnectionSupplier, NON_DESTRUCTIVE_LVQ_QUEUE_NAME, org.apache.activemq.artemis.api.core.Message.HDR_LAST_VALUE_NAME.toString());
        JMSNonDestructiveTest.assertEquals((String)"Ensure Message count", (long)1L, (long)queueBinding.getQueue().getMessageCount());
        this.receiveLVQ(consumerConnectionSupplier, NON_DESTRUCTIVE_LVQ_QUEUE_NAME, org.apache.activemq.artemis.api.core.Message.HDR_LAST_VALUE_NAME.toString());
        JMSNonDestructiveTest.assertEquals((String)"Ensure Message count", (long)1L, (long)queueBinding.getQueue().getMessageCount());
        this.sendLVQ(producerConnectionSupplier, NON_DESTRUCTIVE_LVQ_QUEUE_NAME, org.apache.activemq.artemis.api.core.Message.HDR_LAST_VALUE_NAME.toString());
        JMSNonDestructiveTest.assertEquals((String)"Ensure Message count", (long)1L, (long)queueBinding.getQueue().getMessageCount());
        Thread.sleep(10L);
        this.receiveLVQ(consumerConnectionSupplier, NON_DESTRUCTIVE_LVQ_QUEUE_NAME, org.apache.activemq.artemis.api.core.Message.HDR_LAST_VALUE_NAME.toString());
        JMSNonDestructiveTest.assertEquals((String)"Ensure Message count", (long)1L, (long)queueBinding.getQueue().getMessageCount());
        QueueControl control = (QueueControl)this.server.getManagementService().getResource("queue.NON_DESTRUCTIVE_LVQ_QUEUE");
        control.removeAllMessages();
        JMSNonDestructiveTest.assertEquals((String)"Message count after clearing queue via queue control should be 0", (long)0L, (long)queueBinding.getQueue().getMessageCount());
    }

    public void testNonDestructiveLVQWithConsumerFirst(JMSClientTestSupport.ConnectionSupplier connectionSupplier) throws Exception {
        Throwable throwable;
        Session session;
        ExecutorService executor = Executors.newFixedThreadPool(1);
        CountDownLatch consumerSetup = new CountDownLatch(1);
        CountDownLatch consumerComplete = new CountDownLatch(1);
        executor.submit(() -> {
            try (Connection connection = connectionSupplier.createConnection();
                 Session session = connection.createSession(false, 1);
                 MessageConsumer messageConsumer = session.createConsumer((Destination)session.createQueue(NON_DESTRUCTIVE_LVQ_QUEUE_NAME));){
                connection.start();
                consumerSetup.countDown();
                BytesMessage messageReceived = (BytesMessage)messageConsumer.receive(5000L);
                JMSNonDestructiveTest.assertNotNull((Object)messageReceived);
                consumerComplete.countDown();
            }
            catch (Exception e) {
                JMSNonDestructiveTest.fail((String)e.getMessage());
            }
            consumerComplete.countDown();
        });
        consumerSetup.await(5L, TimeUnit.SECONDS);
        try (Connection connection = connectionSupplier.createConnection();){
            session = connection.createSession(false, 1);
            throwable = null;
            try {
                MessageProducer producer = session.createProducer((Destination)session.createQueue(NON_DESTRUCTIVE_LVQ_QUEUE_NAME));
                BytesMessage message = session.createBytesMessage();
                message.writeUTF("mills " + System.currentTimeMillis());
                message.setStringProperty("_AMQ_LVQ_NAME", "STOCK_NAME");
                producer.send((Message)message);
                consumerComplete.await(5L, TimeUnit.SECONDS);
                message = session.createBytesMessage();
                message.writeUTF("mills " + System.currentTimeMillis());
                message.setStringProperty("_AMQ_LVQ_NAME", "STOCK_NAME");
                producer.send((Message)message);
            }
            catch (Throwable producer) {
                throwable = producer;
                throw producer;
            }
            finally {
                if (session != null) {
                    if (throwable != null) {
                        try {
                            session.close();
                        }
                        catch (Throwable producer) {
                            throwable.addSuppressed(producer);
                        }
                    } else {
                        session.close();
                    }
                }
            }
        }
        connection = connectionSupplier.createConnection();
        var6_6 = null;
        try {
            session = connection.createSession(false, 1);
            throwable = null;
            try (MessageConsumer messageConsumer = session.createConsumer((Destination)session.createQueue(NON_DESTRUCTIVE_LVQ_QUEUE_NAME));){
                connection.start();
                BytesMessage messageReceived = (BytesMessage)messageConsumer.receive(5000L);
                JMSNonDestructiveTest.assertNotNull((Object)messageReceived);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (session != null) {
                    if (throwable != null) {
                        try {
                            session.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                    } else {
                        session.close();
                    }
                }
            }
        }
        catch (Throwable throwable4) {
            var6_6 = throwable4;
            throw throwable4;
        }
        finally {
            if (connection != null) {
                if (var6_6 != null) {
                    try {
                        connection.close();
                    }
                    catch (Throwable throwable5) {
                        var6_6.addSuppressed(throwable5);
                    }
                } else {
                    connection.close();
                }
            }
        }
        executor.shutdownNow();
    }

    public void testNonDestructiveLVQTombstone(JMSClientTestSupport.ConnectionSupplier producerConnectionSupplier, JMSClientTestSupport.ConnectionSupplier consumerConnectionSupplier) throws Exception {
        int tombstoneTimeToLive = 500;
        QueueBinding queueBinding = (QueueBinding)this.server.getPostOffice().getBinding(SimpleString.toSimpleString((String)NON_DESTRUCTIVE_TOMBSTONE_LVQ_QUEUE_NAME));
        LastValueQueue lastValueQueue = (LastValueQueue)queueBinding.getQueue();
        this.sendLVQ(producerConnectionSupplier, NON_DESTRUCTIVE_TOMBSTONE_LVQ_QUEUE_NAME, org.apache.activemq.artemis.api.core.Message.HDR_LAST_VALUE_NAME.toString());
        JMSNonDestructiveTest.assertEquals((String)"Ensure Message count", (long)1L, (long)lastValueQueue.getMessageCount());
        Thread.sleep(10L);
        this.receiveLVQ(consumerConnectionSupplier, NON_DESTRUCTIVE_TOMBSTONE_LVQ_QUEUE_NAME, org.apache.activemq.artemis.api.core.Message.HDR_LAST_VALUE_NAME.toString());
        this.sendLVQTombstone(producerConnectionSupplier, NON_DESTRUCTIVE_TOMBSTONE_LVQ_QUEUE_NAME, org.apache.activemq.artemis.api.core.Message.HDR_LAST_VALUE_NAME.toString(), tombstoneTimeToLive);
        JMSNonDestructiveTest.assertEquals((String)"Ensure Message count", (long)1L, (long)lastValueQueue.getMessageCount());
        Thread.sleep(10L);
        this.receiveLVQTombstone(consumerConnectionSupplier, NON_DESTRUCTIVE_TOMBSTONE_LVQ_QUEUE_NAME, org.apache.activemq.artemis.api.core.Message.HDR_LAST_VALUE_NAME.toString());
        this.receiveLVQTombstone(consumerConnectionSupplier, NON_DESTRUCTIVE_TOMBSTONE_LVQ_QUEUE_NAME, org.apache.activemq.artemis.api.core.Message.HDR_LAST_VALUE_NAME.toString());
        JMSNonDestructiveTest.assertEquals((String)"Ensure Message count", (long)1L, (long)lastValueQueue.getLastValueKeys().size());
        Thread.sleep(tombstoneTimeToLive * 3);
        this.receiveLVQAssertEmpty(consumerConnectionSupplier, NON_DESTRUCTIVE_TOMBSTONE_LVQ_QUEUE_NAME);
        JMSNonDestructiveTest.assertEquals((String)"Ensure Message count", (long)0L, (long)lastValueQueue.getMessageCount());
        JMSNonDestructiveTest.assertEquals((String)"Ensure Message count", (long)0L, (long)lastValueQueue.getLastValueKeys().size());
    }

    @Test
    public void testMessageCount() throws Exception {
        this.sendMessage(this.CoreConnection, NON_DESTRUCTIVE_QUEUE_NAME);
        QueueBinding queueBinding = (QueueBinding)this.server.getPostOffice().getBinding(SimpleString.toSimpleString((String)NON_DESTRUCTIVE_QUEUE_NAME));
        JMSNonDestructiveTest.assertEquals((String)"Ensure Message count", (long)1L, (long)queueBinding.getQueue().getMessageCount());
        this.receive(this.CoreConnection, NON_DESTRUCTIVE_QUEUE_NAME);
        JMSNonDestructiveTest.assertEquals((String)"Ensure Message count", (long)1L, (long)queueBinding.getQueue().getMessageCount());
        this.sendMessage(this.CoreConnection, NON_DESTRUCTIVE_QUEUE_NAME);
        JMSNonDestructiveTest.assertEquals((String)"Ensure Message count", (long)2L, (long)queueBinding.getQueue().getMessageCount());
        this.receive(this.CoreConnection, NON_DESTRUCTIVE_QUEUE_NAME);
        JMSNonDestructiveTest.assertEquals((String)"Ensure Message count", (long)2L, (long)queueBinding.getQueue().getMessageCount());
        QueueControl control = (QueueControl)this.server.getManagementService().getResource("queue.NON_DESTRUCTIVE_QUEUE");
        control.removeAllMessages();
        JMSNonDestructiveTest.assertEquals((String)"Message count after clearing queue via queue control should be 0", (long)0L, (long)queueBinding.getQueue().getMessageCount());
    }

    private void receive(JMSClientTestSupport.ConnectionSupplier consumerConnectionSupplier, String queueName, int i) throws JMSException {
        try (Connection consumerConnection = consumerConnectionSupplier.createConnection();){
            Session consumerSession = consumerConnection.createSession(false, 1);
            jakarta.jms.Queue consumerQueue = consumerSession.createQueue(queueName);
            MessageConsumer consumer = consumerSession.createConsumer((Destination)consumerQueue);
            for (int j = 0; j < i; ++j) {
                TextMessage msg = (TextMessage)consumer.receive(200L);
                JMSNonDestructiveTest.assertNotNull((Object)msg);
                JMSNonDestructiveTest.assertEquals((Object)Integer.toString(j), (Object)msg.getText());
            }
            TextMessage msg = (TextMessage)consumer.receiveNoWait();
            JMSNonDestructiveTest.assertNull((Object)msg);
            consumer.close();
        }
    }

    private void receive(JMSClientTestSupport.ConnectionSupplier consumerConnectionSupplier, String queueName) throws JMSException {
        try (Connection consumerConnection = consumerConnectionSupplier.createConnection();){
            Session consumerSession = consumerConnection.createSession(false, 1);
            jakarta.jms.Queue consumerQueue = consumerSession.createQueue(queueName);
            MessageConsumer consumer = consumerSession.createConsumer((Destination)consumerQueue);
            TextMessage msg = (TextMessage)consumer.receive(2000L);
            JMSNonDestructiveTest.assertNotNull((Object)msg);
            consumer.close();
        }
    }

    private void receiveNull(JMSClientTestSupport.ConnectionSupplier consumerConnectionSupplier, String queueName) throws JMSException {
        try (Connection consumerConnection = consumerConnectionSupplier.createConnection();){
            Session consumerSession = consumerConnection.createSession(false, 1);
            jakarta.jms.Queue consumerQueue = consumerSession.createQueue(queueName);
            MessageConsumer consumer = consumerSession.createConsumer((Destination)consumerQueue);
            TextMessage msg = (TextMessage)consumer.receiveNoWait();
            JMSNonDestructiveTest.assertNull((Object)msg);
            consumer.close();
        }
    }

    private void receiveDualConsumer(JMSClientTestSupport.ConnectionSupplier consumerConnectionSupplier, String queueName) throws JMSException {
        try (Connection consumerConnection = consumerConnectionSupplier.createConnection();
             Connection consumerConnection2 = consumerConnectionSupplier.createConnection();){
            MessageConsumer consumer = this.createConsumer(consumerConnection, queueName);
            MessageConsumer consumer2 = this.createConsumer(consumerConnection2, queueName);
            TextMessage msg = (TextMessage)consumer.receive(2000L);
            TextMessage msg2 = (TextMessage)consumer2.receive(2000L);
            JMSNonDestructiveTest.assertNotNull((Object)msg);
            JMSNonDestructiveTest.assertNotNull((Object)msg2);
            consumer.close();
            consumer2.close();
        }
    }

    private void receiveDualConsumer(JMSClientTestSupport.ConnectionSupplier consumerConnectionSupplier, String queueName, int i) throws JMSException {
        try (Connection consumerConnection = consumerConnectionSupplier.createConnection();
             Connection consumerConnection2 = consumerConnectionSupplier.createConnection();){
            MessageConsumer consumer = this.createConsumer(consumerConnection, queueName);
            MessageConsumer consumer2 = this.createConsumer(consumerConnection2, queueName);
            for (int j = 0; j < i; ++j) {
                TextMessage msg = (TextMessage)consumer.receive(200L);
                TextMessage msg2 = (TextMessage)consumer2.receive(200L);
                JMSNonDestructiveTest.assertNotNull((Object)msg);
                JMSNonDestructiveTest.assertNotNull((Object)msg2);
                JMSNonDestructiveTest.assertEquals((Object)Integer.toString(j), (Object)msg.getText());
                JMSNonDestructiveTest.assertEquals((Object)Integer.toString(j), (Object)msg2.getText());
            }
            TextMessage msg = (TextMessage)consumer.receiveNoWait();
            JMSNonDestructiveTest.assertNull((Object)msg);
            TextMessage msg2 = (TextMessage)consumer2.receiveNoWait();
            JMSNonDestructiveTest.assertNull((Object)msg2);
            consumer.close();
            consumer2.close();
        }
    }

    private MessageConsumer createConsumer(Connection connection, String queueName) throws JMSException {
        connection.start();
        Session consumerSession = connection.createSession(false, 1);
        jakarta.jms.Queue consumerQueue = consumerSession.createQueue(queueName);
        return consumerSession.createConsumer((Destination)consumerQueue);
    }

    private void sendMessage(JMSClientTestSupport.ConnectionSupplier producerConnectionSupplier, String queueName) throws JMSException {
        this.sendMessage(producerConnectionSupplier, queueName, 0);
    }

    private void sendMessage(JMSClientTestSupport.ConnectionSupplier producerConnectionSupplier, String queueName, int i) throws JMSException {
        try (Connection connection = producerConnectionSupplier.createConnection();
             Session session = connection.createSession();
             MessageProducer producer = session.createProducer((Destination)session.createQueue(queueName));){
            TextMessage message1 = session.createTextMessage();
            message1.setText(Integer.toString(i));
            producer.send((Message)message1);
        }
    }

    private void receiveLVQ(JMSClientTestSupport.ConnectionSupplier consumerConnectionSupplier, String queueName, String lastValueKey) throws JMSException {
        try (Connection connection = consumerConnectionSupplier.createConnection();
             Session session = connection.createSession();
             MessageConsumer consumer = session.createConsumer((Destination)session.createQueue(queueName));){
            TextMessage msg = (TextMessage)consumer.receive(1000L);
            JMSNonDestructiveTest.assertNotNull((Object)msg);
            JMSNonDestructiveTest.assertEquals((Object)"KEY", (Object)msg.getStringProperty(lastValueKey));
            JMSNonDestructiveTest.assertEquals((Object)"how are you", (Object)msg.getText());
        }
    }

    private void sendLVQ(JMSClientTestSupport.ConnectionSupplier producerConnectionSupplier, String queueName, String lastValueKey) throws JMSException {
        try (Connection connection = producerConnectionSupplier.createConnection();
             Session session = connection.createSession();
             MessageProducer producer = session.createProducer((Destination)session.createQueue(queueName));){
            TextMessage message1 = session.createTextMessage();
            message1.setStringProperty(lastValueKey, "KEY");
            message1.setText("hello");
            producer.send((Message)message1);
            TextMessage message2 = session.createTextMessage();
            message2.setStringProperty(lastValueKey, "KEY");
            message2.setText("how are you");
            producer.send((Message)message2);
        }
    }

    private void receiveLVQTombstone(JMSClientTestSupport.ConnectionSupplier consumerConnectionSupplier, String queueName, String lastValueKey) throws JMSException {
        try (Connection connection = consumerConnectionSupplier.createConnection();
             Session session = connection.createSession();
             MessageConsumer consumer = session.createConsumer((Destination)session.createQueue(queueName));){
            TextMessage msg = (TextMessage)consumer.receive(1000L);
            JMSNonDestructiveTest.assertNotNull((Object)msg);
            JMSNonDestructiveTest.assertEquals((Object)"KEY", (Object)msg.getStringProperty(lastValueKey));
            JMSNonDestructiveTest.assertEquals((Object)"tombstone", (Object)msg.getText());
        }
    }

    private void receiveLVQAssertEmpty(JMSClientTestSupport.ConnectionSupplier consumerConnectionSupplier, String queueName) throws JMSException {
        try (Connection connection = consumerConnectionSupplier.createConnection();
             Session session = connection.createSession();
             MessageConsumer consumer = session.createConsumer((Destination)session.createQueue(queueName));){
            TextMessage msg = (TextMessage)consumer.receiveNoWait();
            JMSNonDestructiveTest.assertNull((Object)msg);
        }
    }

    private void sendLVQTombstone(JMSClientTestSupport.ConnectionSupplier producerConnectionSupplier, String queueName, String lastValueKey, int tombstoneTimeToLive) throws JMSException {
        try (Connection connection = producerConnectionSupplier.createConnection();
             Session session = connection.createSession();
             MessageProducer producer = session.createProducer((Destination)session.createQueue(queueName));){
            TextMessage message1 = session.createTextMessage();
            message1.setStringProperty(lastValueKey, "KEY");
            message1.setText("tombstone");
            producer.send((Message)message1, 2, 4, (long)tombstoneTimeToLive);
        }
    }

    @Test
    public void testMultipleLastValuesCore() throws Exception {
        this.testMultipleLastValues(this.CoreConnection);
    }

    @Test
    public void testMultipleLastValuesAMQP() throws Exception {
        this.testMultipleLastValues(this.AMQPConnection);
    }

    private void testMultipleLastValues(JMSClientTestSupport.ConnectionSupplier connectionSupplier) throws Exception {
        int GROUP_COUNT = 5;
        int MESSAGE_COUNT_PER_GROUP = 25;
        int PRODUCER_COUNT = 5;
        HashMap results = new HashMap();
        for (int i = 0; i < 5; ++i) {
            results.put(i + "", new ArrayList());
        }
        HashMap<String, Integer> dups = new HashMap<String, Integer>();
        ArrayList<Producer> producers = new ArrayList<Producer>();
        Throwable object = null;
        try (Connection connection = connectionSupplier.createConnection();){
            Object tm;
            Session session = connection.createSession(false, 2);
            jakarta.jms.Queue queue = session.createQueue(NON_DESTRUCTIVE_LVQ_QUEUE_NAME);
            MessageConsumer consumer = session.createConsumer((Destination)queue);
            connection.start();
            for (int i = 0; i < 5; ++i) {
                producers.add(new Producer(connectionSupplier, 25, 5, i));
            }
            for (Producer producer : producers) {
                new Thread(producer).start();
            }
            while ((tm = (TextMessage)consumer.receive(500L)) != null) {
                ((List)results.get(tm.getStringProperty("lastval"))).add(tm.getText());
                tm.acknowledge();
            }
            for (Producer producer : producers) {
                JMSNonDestructiveTest.assertFalse((String)"Producer failed!", (boolean)producer.failed);
            }
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            throw throwable;
        }
        for (Map.Entry entry : results.entrySet()) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("Messages received with lastval=" + (String)entry.getKey() + " (");
            for (String s : (List)entry.getValue()) {
                int occurrences = Collections.frequency((Collection)entry.getValue(), s);
                if (occurrences > 1 && !dups.containsValue(Integer.parseInt(s))) {
                    dups.put(s, occurrences);
                }
                stringBuilder.append(s + ",");
            }
            logger.info((Object)(stringBuilder + ")"));
        }
        if (dups.size() > 0) {
            StringBuffer sb = new StringBuffer();
            for (Map.Entry entry : dups.entrySet()) {
                sb.append((String)entry.getKey() + "(" + entry.getValue() + "),");
            }
            Assert.fail((String)("Duplicate messages received " + sb));
        }
        Wait.assertEquals((Long)5L, () -> this.server.locateQueue(NON_DESTRUCTIVE_LVQ_QUEUE_NAME).getMessageCount(), (long)2000L, (long)100L, (boolean)false);
    }

    private class Producer
    implements Runnable {
        private final JMSClientTestSupport.ConnectionSupplier connectionSupplier;
        private final int messageCount;
        private final int groupCount;
        private final int offset;
        public boolean failed = false;

        Producer(JMSClientTestSupport.ConnectionSupplier connectionSupplier, int messageCount, int groupCount, int offset) {
            this.connectionSupplier = connectionSupplier;
            this.messageCount = messageCount;
            this.groupCount = groupCount;
            this.offset = offset;
        }

        @Override
        public void run() {
            try (Connection connection = this.connectionSupplier.createConnection();){
                Session session = connection.createSession(false, 2);
                jakarta.jms.Queue queue = session.createQueue(JMSNonDestructiveTest.NON_DESTRUCTIVE_LVQ_QUEUE_NAME);
                MessageProducer producer = session.createProducer((Destination)queue);
                int startingPoint = this.offset * (this.messageCount * this.groupCount);
                int messagesToSend = this.messageCount * this.groupCount;
                for (int i = startingPoint; i < messagesToSend + startingPoint; ++i) {
                    String lastval = "" + i % this.groupCount;
                    TextMessage message = session.createTextMessage();
                    message.setText("" + i);
                    message.setStringProperty("data", "" + i);
                    message.setStringProperty("lastval", lastval);
                    message.setStringProperty(org.apache.activemq.artemis.api.core.Message.HDR_LAST_VALUE_NAME.toString(), lastval);
                    producer.send((Message)message);
                }
            }
            catch (JMSException e) {
                e.printStackTrace();
                this.failed = true;
                return;
            }
        }
    }
}

