/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.amqp;

import jakarta.jms.Connection;
import jakarta.jms.Destination;
import jakarta.jms.Message;
import jakarta.jms.MessageConsumer;
import jakarta.jms.MessageProducer;
import jakarta.jms.QueueBrowser;
import jakarta.jms.Session;
import jakarta.jms.TextMessage;
import java.util.Enumeration;
import java.util.concurrent.TimeUnit;
import org.apache.activemq.artemis.core.server.Queue;
import org.apache.activemq.artemis.tests.integration.amqp.JMSClientTestSupport;
import org.apache.activemq.artemis.tests.util.Wait;
import org.apache.qpid.jms.JmsConnection;
import org.apache.qpid.jms.policy.JmsDefaultPrefetchPolicy;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JMSQueueBrowserTest
extends JMSClientTestSupport {
    protected static final Logger LOG = LoggerFactory.getLogger(JMSQueueBrowserTest.class);

    @Test(timeout=60000L)
    public void testBrowseAllInQueueZeroPrefetch() throws Exception {
        int count;
        int MSG_COUNT = 5;
        JmsConnection connection = (JmsConnection)this.createConnection();
        ((JmsDefaultPrefetchPolicy)connection.getPrefetchPolicy()).setAll(0);
        connection.start();
        Session session = connection.createSession(false, 1);
        JMSQueueBrowserTest.assertNotNull((Object)session);
        jakarta.jms.Queue queue = session.createQueue(this.getQueueName());
        this.sendMessages(this.name.getMethodName(), 5, false);
        Queue queueView = this.getProxyToQueue(this.getQueueName());
        Wait.assertEquals((long)5L, () -> ((Queue)queueView).getMessageCount());
        QueueBrowser browser = session.createBrowser(queue);
        JMSQueueBrowserTest.assertNotNull((Object)browser);
        Enumeration enumeration = browser.getEnumeration();
        for (count = 0; count < 5 && enumeration.hasMoreElements(); ++count) {
            Message msg = (Message)enumeration.nextElement();
            JMSQueueBrowserTest.assertNotNull((Object)msg);
            LOG.debug("Recv: {}", (Object)msg);
        }
        LOG.debug("Received all expected message, checking that hasMoreElements returns false");
        JMSQueueBrowserTest.assertFalse((boolean)enumeration.hasMoreElements());
        JMSQueueBrowserTest.assertEquals((long)5L, (long)count);
    }

    @Test(timeout=40000L)
    public void testCreateQueueBrowser() throws Exception {
        Connection connection = this.createConnection();
        connection.start();
        Session session = connection.createSession(false, 1);
        JMSQueueBrowserTest.assertNotNull((Object)session);
        jakarta.jms.Queue queue = session.createQueue(this.getQueueName());
        session.createConsumer((Destination)queue).close();
        QueueBrowser browser = session.createBrowser(queue);
        JMSQueueBrowserTest.assertNotNull((Object)browser);
        Queue queueView = this.getProxyToQueue(this.getQueueName());
        JMSQueueBrowserTest.assertEquals((long)0L, (long)queueView.getMessageCount());
    }

    @Test(timeout=40000L)
    public void testNoMessagesBrowserHasNoElements() throws Exception {
        Connection connection = this.createConnection();
        connection.start();
        Session session = connection.createSession(false, 1);
        JMSQueueBrowserTest.assertNotNull((Object)session);
        jakarta.jms.Queue queue = session.createQueue(this.getQueueName());
        session.createConsumer((Destination)queue).close();
        QueueBrowser browser = session.createBrowser(queue);
        JMSQueueBrowserTest.assertNotNull((Object)browser);
        Queue queueView = this.getProxyToQueue(this.getQueueName());
        JMSQueueBrowserTest.assertEquals((long)0L, (long)queueView.getMessageCount());
        Enumeration enumeration = browser.getEnumeration();
        JMSQueueBrowserTest.assertFalse((boolean)enumeration.hasMoreElements());
    }

    @Test(timeout=30000L)
    public void testBroseOneInQueue() throws Exception {
        Connection connection = this.createConnection();
        connection.start();
        Session session = connection.createSession(false, 1);
        jakarta.jms.Queue queue = session.createQueue(this.getQueueName());
        MessageProducer producer = session.createProducer((Destination)queue);
        producer.send((Message)session.createTextMessage("hello"));
        producer.close();
        QueueBrowser browser = session.createBrowser(queue);
        Enumeration enumeration = browser.getEnumeration();
        while (enumeration.hasMoreElements()) {
            Message m = (Message)enumeration.nextElement();
            JMSQueueBrowserTest.assertTrue((boolean)(m instanceof TextMessage));
            LOG.debug("Browsed message {} from Queue {}", (Object)m, (Object)queue);
        }
        browser.close();
        MessageConsumer consumer = session.createConsumer((Destination)queue);
        Message msg = consumer.receive(5000L);
        JMSQueueBrowserTest.assertNotNull((Object)msg);
        JMSQueueBrowserTest.assertTrue((boolean)(msg instanceof TextMessage));
    }

    @Test(timeout=60000L)
    public void testBrowseAllInQueue() throws Exception {
        Connection connection = this.createConnection();
        connection.start();
        Session session = connection.createSession(false, 1);
        JMSQueueBrowserTest.assertNotNull((Object)session);
        jakarta.jms.Queue queue = session.createQueue(this.getQueueName());
        this.sendMessages(this.name.getMethodName(), 5, false);
        Queue queueView = this.getProxyToQueue(this.getQueueName());
        Wait.assertEquals((long)5L, () -> ((Queue)queueView).getMessageCount());
        QueueBrowser browser = session.createBrowser(queue);
        JMSQueueBrowserTest.assertNotNull((Object)browser);
        Enumeration enumeration = browser.getEnumeration();
        int count = 0;
        while (enumeration.hasMoreElements()) {
            Message msg = (Message)enumeration.nextElement();
            JMSQueueBrowserTest.assertNotNull((Object)msg);
            LOG.debug("Recv: {}", (Object)msg);
            ++count;
            TimeUnit.MILLISECONDS.sleep(50L);
        }
        JMSQueueBrowserTest.assertFalse((boolean)enumeration.hasMoreElements());
        JMSQueueBrowserTest.assertEquals((long)5L, (long)count);
    }

    @Test(timeout=60000L)
    public void testBrowseAllInQueuePrefetchOne() throws Exception {
        Connection connection = this.createConnection();
        connection.start();
        Session session = connection.createSession(false, 1);
        JMSQueueBrowserTest.assertNotNull((Object)session);
        jakarta.jms.Queue queue = session.createQueue(this.getQueueName());
        this.sendMessages(this.name.getMethodName(), 5, false);
        Queue queueView = this.getProxyToQueue(this.getQueueName());
        Wait.assertEquals((long)5L, () -> ((Queue)queueView).getMessageCount());
        QueueBrowser browser = session.createBrowser(queue);
        JMSQueueBrowserTest.assertNotNull((Object)browser);
        Enumeration enumeration = browser.getEnumeration();
        int count = 0;
        while (enumeration.hasMoreElements()) {
            Message msg = (Message)enumeration.nextElement();
            JMSQueueBrowserTest.assertNotNull((Object)msg);
            LOG.debug("Recv: {}", (Object)msg);
            ++count;
        }
        JMSQueueBrowserTest.assertFalse((boolean)enumeration.hasMoreElements());
        JMSQueueBrowserTest.assertEquals((long)5L, (long)count);
    }

    @Test(timeout=40000L)
    public void testBrowseAllInQueueTxSession() throws Exception {
        Connection connection = this.createConnection();
        connection.start();
        Session session = connection.createSession(true, 0);
        JMSQueueBrowserTest.assertNotNull((Object)session);
        jakarta.jms.Queue queue = session.createQueue(this.getQueueName());
        this.sendMessages(this.name.getMethodName(), 5, false);
        Queue queueView = this.getProxyToQueue(this.getQueueName());
        Wait.assertEquals((long)5L, () -> ((Queue)queueView).getMessageCount());
        QueueBrowser browser = session.createBrowser(queue);
        JMSQueueBrowserTest.assertNotNull((Object)browser);
        Enumeration enumeration = browser.getEnumeration();
        int count = 0;
        while (enumeration.hasMoreElements()) {
            Message msg = (Message)enumeration.nextElement();
            JMSQueueBrowserTest.assertNotNull((Object)msg);
            LOG.debug("Recv: {}", (Object)msg);
            ++count;
        }
        JMSQueueBrowserTest.assertFalse((boolean)enumeration.hasMoreElements());
        JMSQueueBrowserTest.assertEquals((long)5L, (long)count);
    }

    @Test(timeout=40000L)
    public void testQueueBrowserInTxSessionLeavesOtherWorkUnaffected() throws Exception {
        Connection connection = this.createConnection();
        connection.start();
        Session session = connection.createSession(true, 0);
        JMSQueueBrowserTest.assertNotNull((Object)session);
        jakarta.jms.Queue queue = session.createQueue(this.getQueueName());
        this.sendMessages(this.name.getMethodName(), 5, false);
        Queue queueView = this.getProxyToQueue(this.getQueueName());
        Wait.assertEquals((long)5L, () -> ((Queue)queueView).getMessageCount());
        MessageProducer txProducer = session.createProducer((Destination)queue);
        for (int i = 0; i < 5; ++i) {
            txProducer.send(session.createMessage());
        }
        JMSQueueBrowserTest.assertEquals((long)5L, (long)queueView.getMessageCount());
        QueueBrowser browser = session.createBrowser(queue);
        JMSQueueBrowserTest.assertNotNull((Object)browser);
        Enumeration enumeration = browser.getEnumeration();
        int count = 0;
        while (enumeration.hasMoreElements()) {
            Message msg = (Message)enumeration.nextElement();
            JMSQueueBrowserTest.assertNotNull((Object)msg);
            LOG.debug("Recv: {}", (Object)msg);
            ++count;
        }
        JMSQueueBrowserTest.assertFalse((boolean)enumeration.hasMoreElements());
        JMSQueueBrowserTest.assertEquals((long)5L, (long)count);
        browser.close();
        Wait.assertEquals((long)5L, () -> ((Queue)queueView).getMessageCount());
        session.commit();
        Wait.assertEquals((long)10L, () -> ((Queue)queueView).getMessageCount());
    }

    @Test(timeout=60000L)
    public void testBrowseAllInQueueSmallPrefetch() throws Exception {
        Connection connection = this.createConnection();
        connection.start();
        int MSG_COUNT = 30;
        Session session = connection.createSession(false, 1);
        JMSQueueBrowserTest.assertNotNull((Object)session);
        jakarta.jms.Queue queue = session.createQueue(this.getQueueName());
        this.sendMessages(this.name.getMethodName(), 30, false);
        Queue queueView = this.getProxyToQueue(this.getQueueName());
        Wait.assertEquals((long)30L, () -> ((Queue)queueView).getMessageCount());
        QueueBrowser browser = session.createBrowser(queue);
        JMSQueueBrowserTest.assertNotNull((Object)browser);
        Enumeration enumeration = browser.getEnumeration();
        int count = 0;
        while (enumeration.hasMoreElements()) {
            Message msg = (Message)enumeration.nextElement();
            JMSQueueBrowserTest.assertNotNull((Object)msg);
            LOG.debug("Recv: {}", (Object)msg);
            ++count;
        }
        JMSQueueBrowserTest.assertFalse((boolean)enumeration.hasMoreElements());
        JMSQueueBrowserTest.assertEquals((long)30L, (long)count);
    }
}

