/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.amqp;

import jakarta.jms.Connection;
import jakarta.jms.ConnectionFactory;
import jakarta.jms.Destination;
import jakarta.jms.JMSException;
import jakarta.jms.Message;
import jakarta.jms.MessageConsumer;
import jakarta.jms.MessageListener;
import jakarta.jms.MessageProducer;
import jakarta.jms.Session;
import jakarta.jms.TextMessage;
import jakarta.jms.Topic;
import jakarta.jms.TopicSubscriber;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.IntStream;
import javax.naming.InitialContext;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.tests.integration.amqp.JMSClientTestSupport;
import org.apache.activemq.artemis.utils.Wait;
import org.apache.qpid.jms.JmsConnectionFactory;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Test;

public class TopicDurableTests
extends JMSClientTestSupport {
    @Test
    public void testMessageDurableSubscription() throws Exception {
        JmsConnectionFactory connectionFactory = new JmsConnectionFactory(this.getBrokerQpidJMSConnectionURI() + "?jms.clientID=jmsTopicClient");
        Connection connection = connectionFactory.createConnection();
        connection.start();
        this.instanceLog.debug((Object)"testMessageDurableSubscription");
        Session session = connection.createSession(false, 1);
        Topic testTopic = session.createTopic("jmsTopic");
        String sub1ID = "sub1DurSub";
        String sub2ID = "sub2DurSub";
        TopicSubscriber subscriber1 = session.createDurableSubscriber(testTopic, sub1ID);
        TopicSubscriber subscriber2 = session.createDurableSubscriber(testTopic, sub2ID);
        MessageProducer messageProducer = session.createProducer((Destination)testTopic);
        int count = 100;
        String batchPrefix = "First";
        List<Message> listMsgs = this.generateMessages(session, batchPrefix, count);
        this.sendMessages(messageProducer, listMsgs);
        this.instanceLog.debug((Object)"First batch messages sent");
        List<Message> recvd1 = this.receiveMessages((MessageConsumer)subscriber1, count);
        List<Message> recvd2 = this.receiveMessages((MessageConsumer)subscriber2, count);
        TopicDurableTests.assertThat((Object)recvd1.size(), (Matcher)CoreMatchers.is((Object)count));
        this.assertMessageContent(recvd1, batchPrefix);
        this.instanceLog.debug((Object)(sub1ID + " :First batch messages received"));
        TopicDurableTests.assertThat((Object)recvd2.size(), (Matcher)CoreMatchers.is((Object)count));
        this.assertMessageContent(recvd2, batchPrefix);
        this.instanceLog.debug((Object)(sub2ID + " :First batch messages received"));
        subscriber1.close();
        this.instanceLog.debug((Object)(sub1ID + " : closed"));
        batchPrefix = "Second";
        listMsgs = this.generateMessages(session, batchPrefix, count);
        this.sendMessages(messageProducer, listMsgs);
        this.instanceLog.debug((Object)"Second batch messages sent");
        recvd2 = this.receiveMessages((MessageConsumer)subscriber2, count);
        TopicDurableTests.assertThat((Object)recvd2.size(), (Matcher)CoreMatchers.is((Object)count));
        this.assertMessageContent(recvd2, batchPrefix);
        this.instanceLog.debug((Object)(sub2ID + " :Second batch messages received"));
        subscriber1 = session.createDurableSubscriber(testTopic, sub1ID);
        this.instanceLog.debug((Object)(sub1ID + " :connected"));
        recvd1 = this.receiveMessages((MessageConsumer)subscriber1, count);
        TopicDurableTests.assertThat((Object)recvd1.size(), (Matcher)CoreMatchers.is((Object)count));
        this.assertMessageContent(recvd1, batchPrefix);
        this.instanceLog.debug((Object)(sub1ID + " :Second batch messages received"));
        subscriber1.close();
        subscriber2.close();
        session.unsubscribe(sub1ID);
        session.unsubscribe(sub2ID);
    }

    @Test
    public void testSharedNonDurableSubscription() throws Exception {
        int iterations = 10;
        for (int i = 0; i < iterations; ++i) {
            this.instanceLog.debug((Object)("testSharedNonDurableSubscription; iteration: " + i));
            JmsConnectionFactory connectionFactory1 = new JmsConnectionFactory(this.getBrokerQpidJMSConnectionURI());
            Connection connection1 = connectionFactory1.createConnection();
            Hashtable<String, String> env2 = new Hashtable<String, String>();
            env2.put("java.naming.factory.initial", "org.apache.qpid.jms.jndi.JmsInitialContextFactory");
            env2.put("connectionfactory.qpidConnectionFactory", "amqp://localhost:5672");
            env2.put("topic.jmsTopic", "jmsTopic");
            InitialContext context2 = new InitialContext(env2);
            ConnectionFactory connectionFactory2 = (ConnectionFactory)context2.lookup("qpidConnectionFactory");
            Connection connection2 = connectionFactory2.createConnection();
            connection1.start();
            connection2.start();
            Session session = connection1.createSession(false, 1);
            Session session2 = connection2.createSession(false, 1);
            Topic testTopic = session.createTopic("jmsTopic");
            String subID = "sharedConsumerNonDurable123";
            MessageConsumer subscriber1 = session.createSharedConsumer(testTopic, subID);
            MessageConsumer subscriber2 = session2.createSharedConsumer(testTopic, subID);
            MessageConsumer subscriber3 = session2.createSharedConsumer(testTopic, subID);
            MessageProducer messageProducer = session.createProducer((Destination)testTopic);
            messageProducer.setDeliveryMode(1);
            int count = 10;
            List<Message> listMsgs = this.generateMessages(session, count);
            List<CompletableFuture<List<Message>>> results = this.receiveMessagesAsync(count, subscriber1, subscriber2, subscriber3);
            this.sendMessages(messageProducer, listMsgs);
            this.instanceLog.debug((Object)"messages sent");
            TopicDurableTests.assertThat((String)"Each message should be received only by one consumer", (Object)(results.get(0).get(20L, TimeUnit.SECONDS).size() + results.get(1).get(20L, TimeUnit.SECONDS).size() + results.get(2).get(20L, TimeUnit.SECONDS).size()), (Matcher)CoreMatchers.is((Object)count));
            this.instanceLog.debug((Object)"messages received");
            connection1.stop();
            connection2.stop();
            subscriber1.close();
            subscriber2.close();
            session.close();
            session2.close();
            connection1.close();
            connection2.close();
            Wait.assertTrue(() -> this.server.getAddressInfo(SimpleString.toSimpleString((String)"jmsTopic")) == null, (long)2000L, (long)100L);
        }
    }

    private void sendMessages(MessageProducer producer, List<Message> messages) {
        messages.forEach(m -> {
            try {
                producer.send(m);
            }
            catch (JMSException e) {
                e.printStackTrace();
            }
        });
    }

    protected List<Message> receiveMessages(MessageConsumer consumer, int count) {
        return this.receiveMessages(consumer, count, 0L);
    }

    protected List<Message> receiveMessages(MessageConsumer consumer, int count, long timeout) {
        ArrayList<Message> recvd = new ArrayList<Message>();
        IntStream.range(0, count).forEach(i -> {
            try {
                recvd.add(timeout > 0L ? consumer.receive(timeout) : consumer.receive());
            }
            catch (JMSException e) {
                e.printStackTrace();
            }
        });
        return recvd;
    }

    protected void assertMessageContent(List<Message> msgs, String content) {
        msgs.forEach(m -> {
            try {
                TopicDurableTests.assertTrue((boolean)((TextMessage)m).getText().contains(content));
            }
            catch (JMSException e) {
                e.printStackTrace();
            }
        });
    }

    protected List<Message> generateMessages(Session session, int count) {
        return this.generateMessages(session, "", count);
    }

    protected List<Message> generateMessages(Session session, String prefix, int count) {
        ArrayList<Message> messages = new ArrayList<Message>();
        StringBuilder sb = new StringBuilder();
        IntStream.range(0, count).forEach(i -> {
            try {
                messages.add((Message)session.createTextMessage(sb.append(prefix).append("testMessage").append(i).toString()));
                sb.setLength(0);
            }
            catch (JMSException e) {
                e.printStackTrace();
            }
        });
        return messages;
    }

    protected List<CompletableFuture<List<Message>>> receiveMessagesAsync(int count, MessageConsumer ... consumer) throws JMSException {
        AtomicInteger totalCount = new AtomicInteger(count);
        ArrayList<CompletableFuture<List<Message>>> resultsList = new ArrayList<CompletableFuture<List<Message>>>();
        ArrayList receivedResList = new ArrayList();
        for (int i = 0; i < consumer.length; ++i) {
            int index = i;
            resultsList.add(new CompletableFuture());
            receivedResList.add(new ArrayList());
            MessageListener myListener = message -> {
                this.instanceLog.debug((Object)("Mesages received" + message + " count: " + totalCount.get()));
                ((List)receivedResList.get(index)).add(message);
                if (totalCount.decrementAndGet() == 0) {
                    for (int j = 0; j < consumer.length; ++j) {
                        ((CompletableFuture)resultsList.get(j)).complete(receivedResList.get(j));
                    }
                }
            };
            consumer[i].setMessageListener(myListener);
        }
        return resultsList;
    }
}

