/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.client;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.UnpooledByteBufAllocator;
import java.util.UUID;
import org.apache.activemq.artemis.api.core.ActiveMQBuffer;
import org.apache.activemq.artemis.api.core.ActiveMQBuffers;
import org.apache.activemq.artemis.api.core.Message;
import org.apache.activemq.artemis.api.core.QueueConfiguration;
import org.apache.activemq.artemis.api.core.RoutingType;
import org.apache.activemq.artemis.api.core.client.ClientConsumer;
import org.apache.activemq.artemis.api.core.client.ClientMessage;
import org.apache.activemq.artemis.api.core.client.ClientProducer;
import org.apache.activemq.artemis.api.core.client.ClientSession;
import org.apache.activemq.artemis.api.core.client.ClientSessionFactory;
import org.apache.activemq.artemis.api.core.client.ServerLocator;
import org.apache.activemq.artemis.core.client.impl.ClientMessageImpl;
import org.apache.activemq.artemis.core.server.ActiveMQServer;
import org.apache.activemq.artemis.tests.util.ActiveMQTestBase;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class MessageBufferTest
extends ActiveMQTestBase {
    protected ActiveMQServer server;
    protected ClientSession session;
    protected ClientSessionFactory sf;
    protected ServerLocator locator;

    @Before
    public void setUp() throws Exception {
        super.setUp();
        this.server = this.createServer(false, this.createDefaultInVMConfig());
        this.server.start();
        this.locator = this.createInVMNonHALocator();
        this.sf = this.createSessionFactory(this.locator);
        this.session = this.addClientSession(this.sf.createSession(false, true, true));
    }

    @Test
    public void simpleTest() throws Exception {
        String data = "Simple Text " + UUID.randomUUID().toString();
        String queueName = "simpleQueue";
        String addressName = "simpleAddress";
        this.session.createQueue(new QueueConfiguration("simpleQueue").setAddress("simpleAddress").setRoutingType(RoutingType.ANYCAST));
        ClientProducer producer = this.session.createProducer("simpleAddress");
        ClientMessageImpl message = (ClientMessageImpl)this.session.createMessage(true);
        message.getBodyBuffer().writeString(data);
        for (int i = 0; i < 100; ++i) {
            message.putStringProperty("key", "int" + i);
            message.getBodyBuffer().resetReaderIndex();
            producer.send((Message)message);
            this.session.commit();
            Assert.assertTrue((String)"Message body growing indefinitely and unexpectedly", (message.getBodySize() < 1000 ? (byte)1 : 0) != 0);
        }
        producer.send((Message)message);
        producer.close();
        ClientConsumer consumer = this.session.createConsumer("simpleQueue");
        this.session.start();
        MessageBufferTest.assertNotNull((Object)message);
        message.acknowledge();
        MessageBufferTest.assertEquals((Object)data, (Object)message.getBodyBuffer().readString());
    }

    @Test
    public void simpleTestBytes() throws Exception {
        ByteBuf buf = UnpooledByteBufAllocator.DEFAULT.buffer(1500);
        for (int i = 0; i < 1024; ++i) {
            buf.writeByte((int)MessageBufferTest.getSamplebyte((long)i));
        }
        String queueName = "simpleQueue";
        String addressName = "simpleAddress";
        this.session.createQueue(new QueueConfiguration("simpleQueue").setAddress("simpleAddress").setRoutingType(RoutingType.ANYCAST));
        ClientProducer producer = this.session.createProducer("simpleAddress");
        ClientMessageImpl message = (ClientMessageImpl)this.session.createMessage(true);
        Assert.assertEquals((long)1024L, (long)buf.readableBytes());
        message.getBodyBuffer().writeBytes(buf, 0, buf.readableBytes());
        producer.send((Message)message);
        this.session.commit();
        producer.close();
        ClientConsumer consumer = this.session.createConsumer("simpleQueue");
        this.session.start();
        ClientMessage message2 = consumer.receive(5000L);
        Assert.assertNotNull((Object)message2);
        Assert.assertEquals((long)1024L, (long)message2.getBodySize());
        ActiveMQBuffer buffer = message2.getDataBuffer();
        Assert.assertEquals((long)1024L, (long)message2.getBodySize());
        ActiveMQBuffer bodyBuffer = message2.getBodyBuffer();
        Assert.assertEquals((long)1024L, (long)message2.getBodySize());
        ActiveMQBuffer result = ActiveMQBuffers.fixedBuffer((int)message2.getBodyBufferSize());
        buffer.readBytes(result);
        Assert.assertEquals((long)1024L, (long)result.readableBytes());
        for (int i = 0; i < 1024; ++i) {
            Assert.assertEquals((long)MessageBufferTest.getSamplebyte((long)i), (long)result.readByte());
        }
        MessageBufferTest.assertNotNull((Object)message2);
        message2.acknowledge();
    }
}

