/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.client;

import java.io.File;
import java.lang.management.ManagementFactory;
import java.nio.ByteBuffer;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import javax.transaction.xa.Xid;
import org.apache.activemq.artemis.api.core.ActiveMQBuffer;
import org.apache.activemq.artemis.api.core.ActiveMQException;
import org.apache.activemq.artemis.api.core.Message;
import org.apache.activemq.artemis.api.core.Pair;
import org.apache.activemq.artemis.api.core.QueueConfiguration;
import org.apache.activemq.artemis.api.core.RoutingType;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.api.core.client.ClientConsumer;
import org.apache.activemq.artemis.api.core.client.ClientMessage;
import org.apache.activemq.artemis.api.core.client.ClientProducer;
import org.apache.activemq.artemis.api.core.client.ClientSession;
import org.apache.activemq.artemis.api.core.client.ClientSessionFactory;
import org.apache.activemq.artemis.api.core.client.SendAcknowledgementHandler;
import org.apache.activemq.artemis.api.core.client.ServerLocator;
import org.apache.activemq.artemis.core.config.Configuration;
import org.apache.activemq.artemis.core.config.impl.SecurityConfiguration;
import org.apache.activemq.artemis.core.io.IOCallback;
import org.apache.activemq.artemis.core.io.SequentialFile;
import org.apache.activemq.artemis.core.journal.Journal;
import org.apache.activemq.artemis.core.journal.JournalLoadInformation;
import org.apache.activemq.artemis.core.paging.PageTransactionInfo;
import org.apache.activemq.artemis.core.paging.PagedMessage;
import org.apache.activemq.artemis.core.paging.PagingManager;
import org.apache.activemq.artemis.core.paging.PagingStore;
import org.apache.activemq.artemis.core.paging.cursor.PagePosition;
import org.apache.activemq.artemis.core.persistence.AddressBindingInfo;
import org.apache.activemq.artemis.core.persistence.AddressQueueStatus;
import org.apache.activemq.artemis.core.persistence.GroupingInfo;
import org.apache.activemq.artemis.core.persistence.OperationContext;
import org.apache.activemq.artemis.core.persistence.QueueBindingInfo;
import org.apache.activemq.artemis.core.persistence.StorageManager;
import org.apache.activemq.artemis.core.persistence.config.PersistedAddressSetting;
import org.apache.activemq.artemis.core.persistence.config.PersistedDivertConfiguration;
import org.apache.activemq.artemis.core.persistence.config.PersistedRole;
import org.apache.activemq.artemis.core.persistence.config.PersistedSecuritySetting;
import org.apache.activemq.artemis.core.persistence.config.PersistedUser;
import org.apache.activemq.artemis.core.persistence.impl.PageCountPending;
import org.apache.activemq.artemis.core.postoffice.Binding;
import org.apache.activemq.artemis.core.postoffice.PostOffice;
import org.apache.activemq.artemis.core.replication.ReplicationManager;
import org.apache.activemq.artemis.core.server.ActiveMQServer;
import org.apache.activemq.artemis.core.server.LargeServerMessage;
import org.apache.activemq.artemis.core.server.MessageReference;
import org.apache.activemq.artemis.core.server.RouteContextList;
import org.apache.activemq.artemis.core.server.files.FileStoreMonitor;
import org.apache.activemq.artemis.core.server.group.impl.GroupBinding;
import org.apache.activemq.artemis.core.server.impl.ActiveMQServerImpl;
import org.apache.activemq.artemis.core.server.impl.AddressInfo;
import org.apache.activemq.artemis.core.server.impl.JournalLoader;
import org.apache.activemq.artemis.core.transaction.ResourceManager;
import org.apache.activemq.artemis.core.transaction.Transaction;
import org.apache.activemq.artemis.jms.client.ActiveMQConnectionFactory;
import org.apache.activemq.artemis.spi.core.security.ActiveMQJAASSecurityManager;
import org.apache.activemq.artemis.spi.core.security.ActiveMQSecurityManager;
import org.apache.activemq.artemis.spi.core.security.jaas.InVMLoginModule;
import org.apache.activemq.artemis.tests.util.SpawnedTestBase;
import org.apache.activemq.artemis.tests.util.Wait;
import org.apache.activemq.artemis.utils.ArtemisCloseable;
import org.apache.activemq.artemis.utils.SpawnedVMSupport;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class SendAckFailTest
extends SpawnedTestBase {
    @Before
    @After
    public void deleteDirectory() throws Exception {
        SendAckFailTest.deleteDirectory((File)new File("./target/send-ack"));
    }

    public String getJournalDir(int index, boolean backup) {
        return "./target/send-ack/journal";
    }

    protected String getBindingsDir(int index, boolean backup) {
        return "./target/send-ack/binding";
    }

    protected String getPageDir(int index, boolean backup) {
        return "./target/send-ack/page";
    }

    protected String getLargeMessagesDir(int index, boolean backup) {
        return "./target/send-ack/large-message";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSend() throws Exception {
        Process process = SpawnedVMSupport.spawnVM((String)SendAckFailTest.class.getName(), (String[])new String[0]);
        ActiveMQServer server = null;
        try {
            final HashSet listSent = new HashSet();
            Thread t = null;
            ActiveMQConnectionFactory factory = new ActiveMQConnectionFactory();
            ServerLocator locator = factory.getServerLocator();
            locator.setConfirmationWindowSize(0).setInitialConnectAttempts(10000).setRetryInterval(10L).setBlockOnDurableSend(false).setReconnectAttempts(0);
            ClientSessionFactory sf = locator.createSessionFactory();
            final ClientSession session = sf.createSession();
            session.createAddress(SimpleString.toSimpleString((String)"T1"), RoutingType.ANYCAST, true);
            session.createQueue(new QueueConfiguration("T1").setRoutingType(RoutingType.ANYCAST));
            final ClientProducer producer = session.createProducer("T1");
            session.setSendAcknowledgementHandler(new SendAcknowledgementHandler(){

                public void sendAcknowledged(Message message) {
                    listSent.add(message.getIntProperty("myid"));
                }
            });
            t = new Thread(){

                @Override
                public void run() {
                    for (int i = 0; i < 5000; ++i) {
                        try {
                            producer.send((Message)session.createMessage(true).putIntProperty("myid", i));
                            continue;
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                            break;
                        }
                    }
                }
            };
            t.start();
            Wait.waitFor(() -> listSent.size() > 100, (long)5000L, (long)10L);
            Assert.assertTrue((boolean)process.waitFor(1L, TimeUnit.MINUTES));
            server = this.startServer(false);
            factory = new ActiveMQConnectionFactory();
            locator = factory.getServerLocator();
            sf = locator.createSessionFactory();
            session = sf.createSession();
            ClientConsumer consumer = session.createConsumer("T1");
            session.start();
            for (int i = 0; i < listSent.size(); ++i) {
                ClientMessage message = consumer.receive(1000L);
                if (message == null) {
                    for (Integer msgi : listSent) {
                        this.instanceLog.debug((Object)("Message " + msgi + " was lost"));
                    }
                    SendAckFailTest.fail((String)"missed messages!");
                }
                message.acknowledge();
                if (listSent.remove(message.getIntProperty("myid"))) continue;
                this.instanceLog.debug((Object)("Message " + message + " with id " + message.getIntProperty("myid") + " received in duplicate"));
                SendAckFailTest.fail((String)("Message " + message + " with id " + message.getIntProperty("myid") + " received in duplicate"));
            }
        }
        finally {
            if (process != null) {
                process.destroy();
            }
            if (server != null) {
                server.stop();
            }
        }
    }

    public static void main(String[] arg) {
        SendAckFailTest test = new SendAckFailTest();
        test.startServer(true);
    }

    public ActiveMQServer startServer(final boolean fail) {
        try {
            final AtomicInteger count = new AtomicInteger(0);
            ActiveMQJAASSecurityManager securityManager = new ActiveMQJAASSecurityManager(InVMLoginModule.class.getName(), new SecurityConfiguration());
            Configuration configuration = this.createDefaultConfig(true);
            if (fail) {
                new Thread(){

                    @Override
                    public void run() {
                        try {
                            Thread.sleep(10000L);
                            System.err.println("Halting process, protecting the CI from rogue processes");
                            Runtime.getRuntime().halt(-1);
                        }
                        catch (Throwable throwable) {
                            // empty catch block
                        }
                    }
                }.start();
            }
            ActiveMQServerImpl server = new ActiveMQServerImpl(configuration, ManagementFactory.getPlatformMBeanServer(), (ActiveMQSecurityManager)securityManager){

                public StorageManager createStorageManager() {
                    StorageManager original = super.createStorageManager();
                    return new StorageManagerDelegate(original){

                        @Override
                        public void storeMessage(Message message) throws Exception {
                            if (fail && count.incrementAndGet() == 110) {
                                Thread.sleep(100L);
                                Runtime.getRuntime().halt(-1);
                            }
                            super.storeMessage(message);
                        }
                    };
                }
            };
            this.instanceLog.debug((Object)("Location::" + server.getConfiguration().getJournalLocation().getAbsolutePath()));
            this.addServer((ActiveMQServer)server);
            server.start();
            return server;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private class StorageManagerDelegate
    implements StorageManager {
        private final StorageManager manager;

        public void start() throws Exception {
            this.manager.start();
        }

        public LargeServerMessage largeMessageCreated(long id, LargeServerMessage largeMessage) throws Exception {
            return this.manager.largeMessageCreated(id, largeMessage);
        }

        public void stop() throws Exception {
            this.manager.stop();
        }

        public void updateQueueBinding(long tx, Binding binding) throws Exception {
            this.manager.updateQueueBinding(tx, binding);
        }

        public boolean isStarted() {
            return this.manager.isStarted();
        }

        public long generateID() {
            return this.manager.generateID();
        }

        public long getCurrentID() {
            return this.manager.getCurrentID();
        }

        public void criticalError(Throwable error) {
            this.manager.criticalError(error);
        }

        public OperationContext getContext() {
            return this.manager.getContext();
        }

        public void lineUpContext() {
            this.manager.lineUpContext();
        }

        public OperationContext newContext(Executor executor) {
            return this.manager.newContext(executor);
        }

        public OperationContext newSingleThreadContext() {
            return this.manager.newSingleThreadContext();
        }

        public void setContext(OperationContext context) {
            this.manager.setContext(context);
        }

        public void stop(boolean ioCriticalError, boolean sendFailover) throws Exception {
            this.manager.stop(ioCriticalError, sendFailover);
        }

        public void pageClosed(SimpleString storeName, int pageNumber) {
            this.manager.pageClosed(storeName, pageNumber);
        }

        public void pageDeleted(SimpleString storeName, int pageNumber) {
            this.manager.pageDeleted(storeName, pageNumber);
        }

        public void pageWrite(PagedMessage message, int pageNumber) {
            this.manager.pageWrite(message, pageNumber);
        }

        public void afterCompleteOperations(IOCallback run) {
            this.manager.afterCompleteOperations(run);
        }

        public void afterStoreOperations(IOCallback run) {
            this.manager.afterStoreOperations(run);
        }

        public boolean waitOnOperations(long timeout) throws Exception {
            return this.manager.waitOnOperations(timeout);
        }

        public void waitOnOperations() throws Exception {
            this.manager.waitOnOperations();
        }

        public void beforePageRead() throws Exception {
            this.manager.beforePageRead();
        }

        public boolean beforePageRead(long timeout, TimeUnit unit) throws InterruptedException {
            return this.manager.beforePageRead(timeout, unit);
        }

        public void afterPageRead() throws Exception {
            this.manager.afterPageRead();
        }

        public ByteBuffer allocateDirectBuffer(int size) {
            return this.manager.allocateDirectBuffer(size);
        }

        public void freeDirectBuffer(ByteBuffer buffer) {
            this.manager.freeDirectBuffer(buffer);
        }

        public void clearContext() {
            this.manager.clearContext();
        }

        public void confirmPendingLargeMessageTX(Transaction transaction, long messageID, long recordID) throws Exception {
            this.manager.confirmPendingLargeMessageTX(transaction, messageID, recordID);
        }

        public void confirmPendingLargeMessage(long recordID) throws Exception {
            this.manager.confirmPendingLargeMessage(recordID);
        }

        public void storeMessage(Message message) throws Exception {
            this.manager.storeMessage(message);
        }

        public void storeReference(long queueID, long messageID, boolean last) throws Exception {
            this.manager.storeReference(queueID, messageID, last);
        }

        public void deleteMessage(long messageID) throws Exception {
            this.manager.deleteMessage(messageID);
        }

        public void storeAcknowledge(long queueID, long messageID) throws Exception {
            this.manager.storeAcknowledge(queueID, messageID);
        }

        public void storeCursorAcknowledge(long queueID, PagePosition position) throws Exception {
            this.manager.storeCursorAcknowledge(queueID, position);
        }

        public void updateDeliveryCount(MessageReference ref) throws Exception {
            this.manager.updateDeliveryCount(ref);
        }

        public void updateScheduledDeliveryTime(MessageReference ref) throws Exception {
            this.manager.updateScheduledDeliveryTime(ref);
        }

        public void storeDuplicateID(SimpleString address, byte[] duplID, long recordID) throws Exception {
            this.manager.storeDuplicateID(address, duplID, recordID);
        }

        public void deleteDuplicateID(long recordID) throws Exception {
            this.manager.deleteDuplicateID(recordID);
        }

        public void storeMessageTransactional(long txID, Message message) throws Exception {
            this.manager.storeMessageTransactional(txID, message);
        }

        public void storeReferenceTransactional(long txID, long queueID, long messageID) throws Exception {
            this.manager.storeReferenceTransactional(txID, queueID, messageID);
        }

        public void storeAcknowledgeTransactional(long txID, long queueID, long messageID) throws Exception {
            this.manager.storeAcknowledgeTransactional(txID, queueID, messageID);
        }

        public void storeCursorAcknowledgeTransactional(long txID, long queueID, PagePosition position) throws Exception {
            this.manager.storeCursorAcknowledgeTransactional(txID, queueID, position);
        }

        public void deleteCursorAcknowledgeTransactional(long txID, long ackID) throws Exception {
            this.manager.deleteCursorAcknowledgeTransactional(txID, ackID);
        }

        public void deleteCursorAcknowledge(long ackID) throws Exception {
            this.manager.deleteCursorAcknowledge(ackID);
        }

        public void storePageCompleteTransactional(long txID, long queueID, PagePosition position) throws Exception {
            this.manager.storePageCompleteTransactional(txID, queueID, position);
        }

        public void deletePageComplete(long ackID) throws Exception {
            this.manager.deletePageComplete(ackID);
        }

        public void updateScheduledDeliveryTimeTransactional(long txID, MessageReference ref) throws Exception {
            this.manager.updateScheduledDeliveryTimeTransactional(txID, ref);
        }

        public void storeDuplicateIDTransactional(long txID, SimpleString address, byte[] duplID, long recordID) throws Exception {
            this.manager.storeDuplicateIDTransactional(txID, address, duplID, recordID);
        }

        public void updateDuplicateIDTransactional(long txID, SimpleString address, byte[] duplID, long recordID) throws Exception {
            this.manager.updateDuplicateIDTransactional(txID, address, duplID, recordID);
        }

        public void deleteDuplicateIDTransactional(long txID, long recordID) throws Exception {
            this.manager.deleteDuplicateIDTransactional(txID, recordID);
        }

        public LargeServerMessage createLargeMessage() {
            return this.manager.createLargeMessage();
        }

        public LargeServerMessage createLargeMessage(long id, Message message) throws Exception {
            return this.manager.createLargeMessage(id, message);
        }

        public SequentialFile createFileForLargeMessage(long messageID, StorageManager.LargeMessageExtension extension) {
            return this.manager.createFileForLargeMessage(messageID, extension);
        }

        public void prepare(long txID, Xid xid) throws Exception {
            this.manager.prepare(txID, xid);
        }

        public void commit(long txID) throws Exception {
            this.manager.commit(txID);
        }

        public void commit(long txID, boolean lineUpContext) throws Exception {
            this.manager.commit(txID, lineUpContext);
        }

        public void rollback(long txID) throws Exception {
            this.manager.rollback(txID);
        }

        public void rollbackBindings(long txID) throws Exception {
            this.manager.rollbackBindings(txID);
        }

        public void commitBindings(long txID) throws Exception {
            this.manager.commitBindings(txID);
        }

        public void storePageTransaction(long txID, PageTransactionInfo pageTransaction) throws Exception {
            this.manager.storePageTransaction(txID, pageTransaction);
        }

        public void updatePageTransaction(long txID, PageTransactionInfo pageTransaction, int depage) throws Exception {
            this.manager.updatePageTransaction(txID, pageTransaction, depage);
        }

        public void deletePageTransactional(long recordID) throws Exception {
            this.manager.deletePageTransactional(recordID);
        }

        public JournalLoadInformation loadMessageJournal(PostOffice postOffice, PagingManager pagingManager, ResourceManager resourceManager, Map<Long, QueueBindingInfo> queueInfos, Map<SimpleString, List<Pair<byte[], Long>>> duplicateIDMap, Set<Pair<Long, Long>> pendingLargeMessages, List<PageCountPending> pendingNonTXPageCounter, JournalLoader journalLoader) throws Exception {
            return this.manager.loadMessageJournal(postOffice, pagingManager, resourceManager, queueInfos, duplicateIDMap, pendingLargeMessages, pendingNonTXPageCounter, journalLoader);
        }

        public long storeHeuristicCompletion(Xid xid, boolean isCommit) throws Exception {
            return this.manager.storeHeuristicCompletion(xid, isCommit);
        }

        public void deleteHeuristicCompletion(long id) throws Exception {
            this.manager.deleteHeuristicCompletion(id);
        }

        public void addQueueBinding(long tx, Binding binding) throws Exception {
            this.manager.addQueueBinding(tx, binding);
        }

        public void deleteQueueBinding(long tx, long queueBindingID) throws Exception {
            this.manager.deleteQueueBinding(tx, queueBindingID);
        }

        public long storeQueueStatus(long queueID, AddressQueueStatus status) throws Exception {
            return this.manager.storeQueueStatus(queueID, status);
        }

        public void deleteQueueStatus(long recordID) throws Exception {
            this.manager.deleteQueueStatus(recordID);
        }

        public long storeAddressStatus(long addressID, AddressQueueStatus status) throws Exception {
            return this.manager.storeAddressStatus(addressID, status);
        }

        public void deleteAddressStatus(long recordID) throws Exception {
            this.manager.deleteAddressStatus(recordID);
        }

        public void addAddressBinding(long tx, AddressInfo addressInfo) throws Exception {
            this.manager.addAddressBinding(tx, addressInfo);
        }

        public void deleteAddressBinding(long tx, long addressBindingID) throws Exception {
            this.manager.deleteAddressBinding(tx, addressBindingID);
        }

        public JournalLoadInformation loadBindingJournal(List<QueueBindingInfo> queueBindingInfos, List<GroupingInfo> groupingInfos, List<AddressBindingInfo> addressBindingInfos) throws Exception {
            return this.manager.loadBindingJournal(queueBindingInfos, groupingInfos, addressBindingInfos);
        }

        public void addGrouping(GroupBinding groupBinding) throws Exception {
            this.manager.addGrouping(groupBinding);
        }

        public void deleteGrouping(long tx, GroupBinding groupBinding) throws Exception {
            this.manager.deleteGrouping(tx, groupBinding);
        }

        public void storeAddressSetting(PersistedAddressSetting addressSetting) throws Exception {
            this.manager.storeAddressSetting(addressSetting);
        }

        public void deleteAddressSetting(SimpleString addressMatch) throws Exception {
            this.manager.deleteAddressSetting(addressMatch);
        }

        public List<PersistedAddressSetting> recoverAddressSettings() throws Exception {
            return this.manager.recoverAddressSettings();
        }

        public void storeSecuritySetting(PersistedSecuritySetting persistedRoles) throws Exception {
            this.manager.storeSecuritySetting(persistedRoles);
        }

        public void deleteSecuritySetting(SimpleString addressMatch) throws Exception {
            this.manager.deleteSecuritySetting(addressMatch);
        }

        public List<PersistedSecuritySetting> recoverSecuritySettings() throws Exception {
            return this.manager.recoverSecuritySettings();
        }

        public void storeDivertConfiguration(PersistedDivertConfiguration persistedDivertConfiguration) throws Exception {
        }

        public void deleteDivertConfiguration(String divertName) throws Exception {
        }

        public List<PersistedDivertConfiguration> recoverDivertConfigurations() {
            return null;
        }

        public void storeUser(PersistedUser persistedUser) throws Exception {
            this.manager.storeUser(persistedUser);
        }

        public void deleteUser(String username) throws Exception {
            this.manager.deleteUser(username);
        }

        public Map<String, PersistedUser> getPersistedUsers() {
            return this.manager.getPersistedUsers();
        }

        public void storeRole(PersistedRole persistedRole) throws Exception {
            this.manager.storeRole(persistedRole);
        }

        public void deleteRole(String role) throws Exception {
            this.manager.deleteRole(role);
        }

        public Map<String, PersistedRole> getPersistedRoles() {
            return this.manager.getPersistedRoles();
        }

        public long storePageCounter(long txID, long queueID, long value, long size) throws Exception {
            return this.manager.storePageCounter(txID, queueID, value, size);
        }

        public long storePendingCounter(long queueID, long pageID) throws Exception {
            return this.manager.storePendingCounter(queueID, pageID);
        }

        public void deleteIncrementRecord(long txID, long recordID) throws Exception {
            this.manager.deleteIncrementRecord(txID, recordID);
        }

        public void deletePageCounter(long txID, long recordID) throws Exception {
            this.manager.deletePageCounter(txID, recordID);
        }

        public void deletePendingPageCounter(long txID, long recordID) throws Exception {
            this.manager.deletePendingPageCounter(txID, recordID);
        }

        public long storePageCounterInc(long txID, long queueID, int add, long size) throws Exception {
            return this.manager.storePageCounterInc(txID, queueID, add, size);
        }

        public long storePageCounterInc(long queueID, int add, long size) throws Exception {
            return this.manager.storePageCounterInc(queueID, add, size);
        }

        public Journal getBindingsJournal() {
            return this.manager.getBindingsJournal();
        }

        public Journal getMessageJournal() {
            return this.manager.getMessageJournal();
        }

        public void startReplication(ReplicationManager replicationManager, PagingManager pagingManager, String nodeID, boolean autoFailBack, long initialReplicationSyncTimeout) throws Exception {
            this.manager.startReplication(replicationManager, pagingManager, nodeID, autoFailBack, initialReplicationSyncTimeout);
        }

        public boolean addToPage(PagingStore store, Message msg, Transaction tx, RouteContextList listCtx) throws Exception {
            return this.manager.addToPage(store, msg, tx, listCtx);
        }

        public void stopReplication() {
            this.manager.stopReplication();
        }

        public void addBytesToLargeMessage(SequentialFile appendFile, long messageID, byte[] bytes) throws Exception {
            this.manager.addBytesToLargeMessage(appendFile, messageID, bytes);
        }

        public void storeID(long journalID, long id) throws Exception {
            this.manager.storeID(journalID, id);
        }

        public void deleteID(long journalD) throws Exception {
            this.manager.deleteID(journalD);
        }

        public ArtemisCloseable closeableReadLock() {
            return this.manager.closeableReadLock();
        }

        public void persistIdGenerator() {
            this.manager.persistIdGenerator();
        }

        public void injectMonitor(FileStoreMonitor monitor) throws Exception {
            this.manager.injectMonitor(monitor);
        }

        public void deleteLargeMessageBody(LargeServerMessage largeServerMessage) throws ActiveMQException {
            this.manager.deleteLargeMessageBody(largeServerMessage);
        }

        public void largeMessageClosed(LargeServerMessage largeServerMessage) throws ActiveMQException {
            this.manager.largeMessageClosed(largeServerMessage);
        }

        public void addBytesToLargeMessage(SequentialFile file, long messageId, ActiveMQBuffer bytes) throws Exception {
            this.manager.addBytesToLargeMessage(file, messageId, bytes);
        }

        StorageManagerDelegate(StorageManager manager) {
            this.manager = manager;
        }
    }
}

