/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.client;

import jakarta.jms.Connection;
import jakarta.jms.Destination;
import jakarta.jms.Message;
import jakarta.jms.MessageConsumer;
import jakarta.jms.MessageProducer;
import jakarta.jms.Session;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.activemq.artemis.api.core.QueueConfiguration;
import org.apache.activemq.artemis.api.core.RoutingType;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.core.server.ActiveMQServer;
import org.apache.activemq.artemis.core.server.Queue;
import org.apache.activemq.artemis.core.server.impl.AddressInfo;
import org.apache.activemq.artemis.jms.client.ActiveMQConnectionFactory;
import org.apache.activemq.artemis.tests.util.ActiveMQTestBase;
import org.junit.Assert;
import org.junit.Test;

public class UpdateQueueTest
extends ActiveMQTestBase {
    @Test
    public void testUpdateQueueWithNullUser() throws Exception {
        ActiveMQServer server = this.createServer(true, true);
        ActiveMQConnectionFactory factory = new ActiveMQConnectionFactory();
        server.start();
        SimpleString ADDRESS = SimpleString.toSimpleString((String)"queue.0");
        SimpleString user = new SimpleString("newUser");
        Queue queue = server.createQueue(new QueueConfiguration(ADDRESS).setRoutingType(RoutingType.ANYCAST).setUser(user));
        Long originalID = queue.getID();
        Assert.assertEquals((Object)user, (Object)queue.getUser());
        Connection conn = factory.createConnection();
        Session session = conn.createSession(false, 1);
        MessageProducer prod = session.createProducer((Destination)session.createQueue(ADDRESS.toString()));
        for (int i = 0; i < 100; ++i) {
            prod.send((Message)session.createTextMessage("message " + i));
        }
        server.updateQueue(new QueueConfiguration(ADDRESS).setRoutingType(RoutingType.ANYCAST).setMaxConsumers(Integer.valueOf(1)).setExclusive(Boolean.valueOf(false)));
        conn.close();
        factory.close();
        server.stop();
        server.start();
        this.validateBindingRecords(server, (byte)21, 2);
        queue = server.locateQueue(ADDRESS);
        Assert.assertNotNull((String)"queue not found", (Object)queue);
        Assert.assertEquals((String)"newUser", (Object)user, (Object)queue.getUser());
        factory = new ActiveMQConnectionFactory();
        conn = factory.createConnection();
        session = conn.createSession(false, 1);
        MessageConsumer consumer = session.createConsumer((Destination)session.createQueue(ADDRESS.toString()));
        conn.start();
        for (int i = 0; i < 100; ++i) {
            Assert.assertNotNull((Object)consumer.receive(5000L));
        }
        Assert.assertNull((Object)consumer.receiveNoWait());
        Assert.assertEquals((long)1L, (long)queue.getMaxConsumers());
        conn.close();
        Assert.assertEquals((Object)originalID, (Object)server.locateQueue(ADDRESS).getID());
        server.stop();
        server.start();
        this.validateBindingRecords(server, (byte)21, 2);
        server.stop();
    }

    @Test
    public void testUpdateQueue() throws Exception {
        ActiveMQServer server = this.createServer(true, true);
        ActiveMQConnectionFactory factory = new ActiveMQConnectionFactory();
        server.start();
        SimpleString ADDRESS = SimpleString.toSimpleString((String)"queue.0");
        Queue queue = server.createQueue(new QueueConfiguration(ADDRESS).setRoutingType(RoutingType.ANYCAST));
        Long originalID = queue.getID();
        Assert.assertNull((Object)queue.getUser());
        Connection conn = factory.createConnection();
        Session session = conn.createSession(false, 1);
        MessageProducer prod = session.createProducer((Destination)session.createQueue(ADDRESS.toString()));
        for (int i = 0; i < 100; ++i) {
            prod.send((Message)session.createTextMessage("message " + i));
        }
        server.updateQueue(new QueueConfiguration(ADDRESS.toString()).setRoutingType(RoutingType.ANYCAST).setMaxConsumers(Integer.valueOf(1)).setPurgeOnNoConsumers(Boolean.valueOf(false)).setExclusive(Boolean.valueOf(true)).setGroupRebalance(Boolean.valueOf(true)).setGroupBuckets(Integer.valueOf(5)).setGroupFirstKey("gfk").setNonDestructive(Boolean.valueOf(true)).setConsumersBeforeDispatch(Integer.valueOf(1)).setDelayBeforeDispatch(Long.valueOf(10L)).setUser("newUser").setRingSize(Long.valueOf(180L)));
        conn.close();
        factory.close();
        server.stop();
        server.start();
        this.validateBindingRecords(server, (byte)21, 2);
        queue = server.locateQueue(ADDRESS);
        Assert.assertNotNull((String)"queue not found", (Object)queue);
        Assert.assertEquals((long)1L, (long)queue.getMaxConsumers());
        Assert.assertEquals((Object)false, (Object)queue.isPurgeOnNoConsumers());
        Assert.assertEquals((Object)true, (Object)queue.isExclusive());
        Assert.assertEquals((Object)true, (Object)queue.isGroupRebalance());
        Assert.assertEquals((long)5L, (long)queue.getGroupBuckets());
        Assert.assertEquals((Object)"gfk", (Object)queue.getGroupFirstKey().toString());
        Assert.assertEquals((Object)true, (Object)queue.isNonDestructive());
        Assert.assertEquals((long)1L, (long)queue.getConsumersBeforeDispatch());
        Assert.assertEquals((long)10L, (long)queue.getDelayBeforeDispatch());
        Assert.assertEquals((Object)"newUser", (Object)queue.getUser().toString());
        Assert.assertEquals((long)180L, (long)queue.getRingSize());
        factory = new ActiveMQConnectionFactory();
        conn = factory.createConnection();
        session = conn.createSession(false, 1);
        MessageConsumer consumer = session.createConsumer((Destination)session.createQueue(ADDRESS.toString()));
        conn.start();
        for (int i = 0; i < 100; ++i) {
            Assert.assertNotNull((Object)consumer.receive(5000L));
        }
        Assert.assertNull((Object)consumer.receiveNoWait());
        conn.close();
        Assert.assertEquals((Object)originalID, (Object)server.locateQueue(ADDRESS).getID());
        server.stop();
        server.start();
        this.validateBindingRecords(server, (byte)21, 2);
        server.stop();
    }

    private void validateBindingRecords(ActiveMQServer server, byte type, int expected) throws Exception {
        HashMap counts = this.countBindingJournal(server.getConfiguration());
        Assert.assertEquals((long)expected, (long)((AtomicInteger)counts.get(type)).intValue());
    }

    @Test
    public void testUpdateAddress() throws Exception {
        ActiveMQServer server = this.createServer(true, true);
        ActiveMQConnectionFactory factory = new ActiveMQConnectionFactory();
        server.start();
        SimpleString ADDRESS = SimpleString.toSimpleString((String)"queue.0");
        AddressInfo infoAdded = new AddressInfo(ADDRESS, RoutingType.ANYCAST);
        server.addAddressInfo(infoAdded);
        server.updateAddressInfo(ADDRESS, infoAdded.getRoutingTypes());
        server.stop();
        server.start();
        AddressInfo infoAfterRestart = server.getPostOffice().getAddressInfo(ADDRESS);
        Assert.assertEquals((long)infoAdded.getId(), (long)infoAfterRestart.getId());
        EnumSet<RoutingType> completeSet = EnumSet.allOf(RoutingType.class);
        server.updateAddressInfo(ADDRESS, completeSet);
        server.stop();
        server.start();
        infoAfterRestart = server.getPostOffice().getAddressInfo(ADDRESS);
        Assert.assertNotEquals((long)infoAdded.getId(), (long)infoAfterRestart.getId());
    }
}

