/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.cluster.distribution;

import org.apache.activemq.artemis.api.core.client.ActiveMQClient;
import org.apache.activemq.artemis.api.core.client.ClientSessionFactory;
import org.apache.activemq.artemis.api.core.client.ServerLocator;
import org.apache.activemq.artemis.tests.integration.cluster.distribution.SymmetricClusterTest;
import org.junit.Test;

public class NettySymmetricClusterTest
extends SymmetricClusterTest {
    @Override
    protected boolean isNetty() {
        return true;
    }

    @Test
    public void testConnectionLoadBalancingUsingInitialConnectors() throws Exception {
        int i;
        int i2;
        String ADDRESS = "queues.testaddress";
        String QUEUE = "queue0";
        String URL2 = "(tcp://localhost:61616,tcp://localhost:61617)?useTopologyForLoadBalancing=false";
        int CONNECTION_COUNT = 50;
        this.setupCluster();
        this.startServers();
        for (i2 = 0; i2 < 5; ++i2) {
            this.setupSessionFactory(i2, this.isNetty());
        }
        for (i2 = 0; i2 < 5; ++i2) {
            this.createQueue(i2, "queues.testaddress", "queue0", null, false);
        }
        for (i2 = 0; i2 < 5; ++i2) {
            this.addConsumer(i2, i2, "queue0", null);
        }
        for (i2 = 0; i2 < 5; ++i2) {
            this.waitForBindings(i2, "queues.testaddress", 1, 1, true);
        }
        for (i2 = 0; i2 < 5; ++i2) {
            this.waitForBindings(i2, "queues.testaddress", 4, 4, false);
        }
        int[] baseline = new int[5];
        for (int i3 = 0; i3 < 5; ++i3) {
            baseline[i3] = this.servers[i3].getActiveMQServerControl().getConnectionCount();
        }
        ClientSessionFactory[] clientSessionFactories = new ClientSessionFactory[50];
        ServerLocator locator = ActiveMQClient.createServerLocator((String)"(tcp://localhost:61616,tcp://localhost:61617)?useTopologyForLoadBalancing=false");
        for (i = 0; i < 50; ++i) {
            clientSessionFactories[i] = this.addSessionFactory(locator.createSessionFactory());
        }
        NettySymmetricClusterTest.assertEquals((long)25L, (long)(this.servers[0].getActiveMQServerControl().getConnectionCount() - baseline[0]));
        NettySymmetricClusterTest.assertEquals((long)25L, (long)(this.servers[1].getActiveMQServerControl().getConnectionCount() - baseline[1]));
        for (i = 0; i < 50; ++i) {
            clientSessionFactories[i].close();
        }
        locator.setUseTopologyForLoadBalancing(true);
        for (i = 0; i < 50; ++i) {
            clientSessionFactories[i] = this.addSessionFactory(locator.createSessionFactory());
        }
        for (i = 0; i < 5; ++i) {
            NettySymmetricClusterTest.assertTrue((this.servers[i].getActiveMQServerControl().getConnectionCount() - baseline[i] < 25 ? (byte)1 : 0) != 0);
        }
    }
}

