/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.journal;

import java.io.File;
import java.io.FilenameFilter;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.LockSupport;
import org.apache.activemq.artemis.api.core.Message;
import org.apache.activemq.artemis.api.core.Pair;
import org.apache.activemq.artemis.core.config.Configuration;
import org.apache.activemq.artemis.core.config.impl.ConfigurationImpl;
import org.apache.activemq.artemis.core.io.IOCallback;
import org.apache.activemq.artemis.core.io.SequentialFile;
import org.apache.activemq.artemis.core.io.SequentialFileFactory;
import org.apache.activemq.artemis.core.io.nio.NIOSequentialFileFactory;
import org.apache.activemq.artemis.core.journal.EncoderPersister;
import org.apache.activemq.artemis.core.journal.impl.AbstractJournalUpdateTask;
import org.apache.activemq.artemis.core.journal.impl.JournalCompactor;
import org.apache.activemq.artemis.core.journal.impl.JournalFile;
import org.apache.activemq.artemis.core.journal.impl.JournalFileImpl;
import org.apache.activemq.artemis.core.journal.impl.JournalImpl;
import org.apache.activemq.artemis.core.journal.impl.dataformat.ByteArrayEncoding;
import org.apache.activemq.artemis.core.message.impl.CoreMessage;
import org.apache.activemq.artemis.core.persistence.OperationContext;
import org.apache.activemq.artemis.core.persistence.Persister;
import org.apache.activemq.artemis.core.persistence.impl.journal.JournalStorageManager;
import org.apache.activemq.artemis.core.persistence.impl.journal.OperationContextImpl;
import org.apache.activemq.artemis.tests.unit.core.journal.impl.JournalImplTestBase;
import org.apache.activemq.artemis.tests.unit.core.journal.impl.fakes.SimpleEncoding;
import org.apache.activemq.artemis.tests.util.ActiveMQTestBase;
import org.apache.activemq.artemis.utils.ActiveMQThreadFactory;
import org.apache.activemq.artemis.utils.ExecutorFactory;
import org.apache.activemq.artemis.utils.IDGenerator;
import org.apache.activemq.artemis.utils.SimpleIDGenerator;
import org.apache.activemq.artemis.utils.actors.OrderedExecutorFactory;
import org.apache.activemq.artemis.utils.critical.CriticalAnalyzer;
import org.apache.activemq.artemis.utils.critical.EmptyCriticalAnalyzer;
import org.jboss.logging.Logger;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;

public class NIOJournalCompactTest
extends JournalImplTestBase {
    private static final Logger logger = Logger.getLogger(NIOJournalCompactTest.class);
    private static final int NUMBER_OF_RECORDS = 100;
    IDGenerator idGenerator = new SimpleIDGenerator(100000L);

    @Test
    public void testControlFile() throws Exception {
        ArrayList<JournalFileImpl> dataFiles = new ArrayList<JournalFileImpl>();
        for (int i = 0; i < 5; ++i) {
            SequentialFile file = this.fileFactory.createSequentialFile("file-" + i + ".tst");
            dataFiles.add(new JournalFileImpl(file, 0L, 2));
        }
        ArrayList<JournalFileImpl> newFiles = new ArrayList<JournalFileImpl>();
        for (int i = 0; i < 3; ++i) {
            SequentialFile file = this.fileFactory.createSequentialFile("file-" + i + ".tst.new");
            newFiles.add(new JournalFileImpl(file, 0L, 2));
        }
        ArrayList<Pair> renames = new ArrayList<Pair>();
        renames.add(new Pair((Object)"a", (Object)"b"));
        renames.add(new Pair((Object)"c", (Object)"d"));
        AbstractJournalUpdateTask.writeControlFile((SequentialFileFactory)this.fileFactory, dataFiles, newFiles, renames);
        ArrayList strDataFiles = new ArrayList();
        ArrayList strNewFiles = new ArrayList();
        ArrayList renamesRead = new ArrayList();
        Assert.assertNotNull((Object)JournalCompactor.readControlFile((SequentialFileFactory)this.fileFactory, strDataFiles, strNewFiles, renamesRead));
        Assert.assertEquals((long)dataFiles.size(), (long)strDataFiles.size());
        Assert.assertEquals((long)newFiles.size(), (long)strNewFiles.size());
        Assert.assertEquals((long)renames.size(), (long)renamesRead.size());
        Iterator iterDataFiles = strDataFiles.iterator();
        for (JournalFile journalFile : dataFiles) {
            Assert.assertEquals((Object)journalFile.getFile().getFileName(), iterDataFiles.next());
        }
        Assert.assertFalse((boolean)iterDataFiles.hasNext());
        Iterator iterNewFiles = strNewFiles.iterator();
        for (JournalFile journalFile : newFiles) {
            Assert.assertEquals((Object)journalFile.getFile().getFileName(), iterNewFiles.next());
        }
        Assert.assertFalse((boolean)iterNewFiles.hasNext());
        Iterator iterator = renames.iterator();
        for (Pair rename : renamesRead) {
            Pair original = (Pair)iterator.next();
            Assert.assertEquals((Object)original.getA(), (Object)rename.getA());
            Assert.assertEquals((Object)original.getB(), (Object)rename.getB());
        }
        Assert.assertFalse((boolean)iterNewFiles.hasNext());
    }

    @Test
    public void testCrashRenamingFiles() throws Exception {
        this.internalCompactTest(false, false, true, false, false, false, false, false, false, false, true, false, false);
    }

    @Test
    public void testCrashDuringCompacting() throws Exception {
        this.internalCompactTest(false, false, true, false, false, false, false, false, false, false, false, false, false);
    }

    @Test
    public void testCompactwithPendingXACommit() throws Exception {
        this.internalCompactTest(true, false, false, false, false, false, false, true, false, false, true, true, true);
    }

    @Test
    public void testCompactwithPendingXAPrepareAndCommit() throws Exception {
        this.internalCompactTest(false, true, false, false, false, false, false, true, false, false, true, true, true);
    }

    @Test
    public void testCompactwithPendingXAPrepareAndDelayedCommit() throws Exception {
        this.internalCompactTest(false, true, false, false, false, false, false, true, false, true, true, true, true);
    }

    @Test
    public void testCompactwithPendingCommit() throws Exception {
        this.internalCompactTest(true, false, false, false, false, false, false, true, false, false, true, true, true);
    }

    @Test
    public void testCompactwithDelayedCommit() throws Exception {
        this.internalCompactTest(false, true, false, false, false, false, false, true, false, true, true, true, true);
    }

    @Test
    public void testCompactwithPendingCommitFollowedByDelete() throws Exception {
        this.internalCompactTest(false, false, false, false, false, false, false, true, true, false, true, true, true);
    }

    @Test
    public void testCompactwithConcurrentUpdateAndDeletes() throws Exception {
        this.internalCompactTest(false, false, true, false, true, true, false, false, false, false, true, true, true);
        this.tearDown();
        this.setUp();
        this.internalCompactTest(false, false, true, false, true, false, true, false, false, false, true, true, true);
    }

    @Test
    public void testCompactwithConcurrentDeletes() throws Exception {
        this.internalCompactTest(false, false, true, false, false, true, false, false, false, false, true, true, true);
        this.tearDown();
        this.setUp();
        this.internalCompactTest(false, false, true, false, false, false, true, false, false, false, true, true, true);
    }

    @Test
    public void testCompactwithConcurrentUpdates() throws Exception {
        this.internalCompactTest(false, false, true, false, true, false, false, false, false, false, true, true, true);
    }

    @Test
    public void testCompactWithConcurrentAppend() throws Exception {
        this.internalCompactTest(false, false, true, true, false, false, false, false, false, false, true, true, true);
    }

    @Test
    public void testCompactFirstFileReclaimed() throws Exception {
        this.setup(2, 61440, false);
        boolean recordType = false;
        this.journal = new JournalImpl(this.fileSize, this.minFiles, this.minFiles, 0, 0, this.fileFactory, this.filePrefix, this.fileExtension, this.maxAIO);
        this.journal.start();
        this.journal.loadInternalOnly();
        this.journal.appendAddRecord(1L, (byte)0, "test".getBytes(), true);
        this.journal.forceMoveNextFile();
        this.journal.appendUpdateRecord(1L, (byte)0, "update".getBytes(), true);
        this.journal.appendDeleteRecord(1L, true);
        this.journal.appendAddRecord(2L, (byte)0, "finalRecord".getBytes(), true);
        for (int i = 10; i < 100; ++i) {
            this.journal.appendAddRecord((long)i, (byte)0, ("tst" + i).getBytes(), true);
            this.journal.forceMoveNextFile();
            this.journal.appendUpdateRecord((long)i, (byte)0, ("uptst" + i).getBytes(), true);
            this.journal.appendDeleteRecord((long)i, true);
        }
        this.journal.testCompact();
        this.journal.stop();
        ArrayList records1 = new ArrayList();
        ArrayList preparedRecords = new ArrayList();
        this.journal.start();
        this.journal.load(records1, preparedRecords, null);
        NIOJournalCompactTest.assertEquals((long)1L, (long)records1.size());
    }

    @Test
    public void testCompactPrepareRestart() throws Exception {
        this.setup(2, 61440, false);
        this.createJournal();
        this.startJournal();
        this.load();
        this.startCompact();
        this.addTx(1L, 2L);
        this.prepare(1L, new SimpleEncoding(10, 0));
        this.finishCompact();
        this.stopJournal();
        this.createJournal();
        this.startJournal();
        this.loadAndCheck();
        this.startCompact();
        this.commit(1L);
        this.finishCompact();
        this.journal.testCompact();
        this.stopJournal();
        this.createJournal();
        this.startJournal();
        this.loadAndCheck();
    }

    @Test
    public void testCompactPrepareRestart2() throws Exception {
        this.setup(2, 61440, false);
        this.createJournal();
        this.startJournal();
        this.load();
        this.addTx(1L, 2L);
        this.prepare(1L, new SimpleEncoding(10, 0));
        this.stopJournal();
        this.createJournal();
        this.startJournal();
        this.loadAndCheck();
        this.startCompact();
        this.commit(1L);
        this.finishCompact();
        this.journal.testCompact();
        this.stopJournal();
        this.createJournal();
        this.startJournal();
        this.loadAndCheck();
    }

    @Test
    public void testCompactPrepareRestart3() throws Exception {
        this.setup(2, 61440, false);
        this.createJournal();
        this.startJournal();
        this.load();
        this.addTx(1L, 2L, 3L);
        this.prepare(1L, new SimpleEncoding(10, 0));
        this.startCompact();
        this.commit(1L);
        this.finishCompact();
        this.journal.testCompact();
        this.stopJournal();
        this.createJournal();
        this.startJournal();
        this.loadAndCheck();
    }

    @Test
    public void testOnRollback() throws Exception {
        this.setup(2, 61440, false);
        this.createJournal();
        this.startJournal();
        this.journal.setAutoReclaim(false);
        this.load();
        this.add(1L);
        this.updateTx(2L, 1L);
        this.rollback(2L);
        this.journal.testCompact();
        this.stopJournal();
        this.startJournal();
        this.loadAndCheck();
        this.stopJournal();
    }

    @Test
    public void testCompactSecondFileReclaimed() throws Exception {
        this.setup(2, 61440, false);
        this.createJournal();
        this.startJournal();
        this.load();
        this.addTx(1L, 1L, 2L, 3L, 4L);
        this.journal.forceMoveNextFile();
        this.addTx(1L, 5L, 6L, 7L, 8L);
        this.commit(1L);
        this.journal.forceMoveNextFile();
        this.journal.testCompact();
        this.add(10L);
        this.stopJournal();
        this.startJournal();
        this.loadAndCheck();
        this.stopJournal();
    }

    @Test
    public void testIncompleteTXDuringcompact() throws Exception {
        this.setup(2, 61440, false);
        this.createJournal();
        this.startJournal();
        this.load();
        this.add(1L);
        this.updateTx(2L, 1L);
        this.journal.testCompact();
        this.journal.testCompact();
        this.commit(2L);
        this.stopJournal();
        this.startJournal();
        this.loadAndCheck();
        this.stopJournal();
    }

    private void internalCompactTest(boolean preXA, boolean postXA, boolean regularAdd, boolean performAppend, boolean performUpdate, boolean performDelete, boolean performNonTransactionalDelete, boolean pendingTransactions, boolean deleteTransactRecords, boolean delayCommit, final boolean createControlFile, final boolean deleteControlFile, final boolean renameFilesAfterCompacting) throws Exception {
        int i;
        if (performNonTransactionalDelete) {
            performDelete = false;
        }
        if (performDelete) {
            performNonTransactionalDelete = false;
        }
        this.setup(2, 245760, true);
        ArrayList<Long> liveIDs = new ArrayList<Long>();
        ArrayList<Pair> transactedRecords = new ArrayList<Pair>();
        final CountDownLatch latchDone = new CountDownLatch(1);
        final CountDownLatch latchWait = new CountDownLatch(1);
        this.journal = new JournalImpl(this.fileSize, this.minFiles, this.minFiles, 0, 0, this.fileFactory, this.filePrefix, this.fileExtension, this.maxAIO){

            protected SequentialFile createControlFile(List<JournalFile> files, List<JournalFile> newFiles, Pair<String, String> pair) throws Exception {
                if (createControlFile) {
                    return super.createControlFile(files, newFiles, pair);
                }
                throw new IllegalStateException("Simulating a crash during compact creation");
            }

            protected void deleteControlFile(SequentialFile controlFile) throws Exception {
                if (deleteControlFile) {
                    super.deleteControlFile(controlFile);
                }
            }

            protected void renameFiles(List<JournalFile> oldFiles, List<JournalFile> newFiles) throws Exception {
                if (renameFilesAfterCompacting) {
                    super.renameFiles(oldFiles, newFiles);
                }
            }

            public void onCompactDone() {
                latchDone.countDown();
                NIOJournalCompactTest.this.instanceLog.debug((Object)"Waiting on Compact");
                try {
                    ActiveMQTestBase.waitForLatch((CountDownLatch)latchWait);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                NIOJournalCompactTest.this.instanceLog.debug((Object)"Done");
            }
        };
        this.journal.setAutoReclaim(false);
        this.startJournal();
        this.load();
        long transactionID = 0L;
        if (regularAdd) {
            for (i = 0; i < 50; ++i) {
                this.add(i);
                if (i % 10 == 0 && i > 0) {
                    this.journal.forceMoveNextFile();
                }
                this.update(i);
            }
            for (i = 50; i < 100; ++i) {
                this.addTx(transactionID, i);
                this.updateTx(transactionID, i);
                if (i % 10 == 0) {
                    this.journal.forceMoveNextFile();
                }
                this.commit(transactionID++);
                this.update(i);
            }
        }
        for (i = 0; i < 10; ++i) {
            this.journal.appendAddEvent(this.idGenerator.generateID(), (byte)0, (Persister)EncoderPersister.getInstance(), (Object)new ByteArrayEncoding(new byte[10]), false, null);
        }
        if (pendingTransactions) {
            for (long i2 = 0L; i2 < 100L; ++i2) {
                long recordID = this.idGenerator.generateID();
                this.addTx(transactionID, recordID);
                this.updateTx(transactionID, recordID);
                if (preXA) {
                    this.prepare(transactionID, new SimpleEncoding(10, 0));
                }
                transactedRecords.add(new Pair((Object)transactionID++, (Object)recordID));
            }
        }
        if (regularAdd) {
            for (int i3 = 0; i3 < 100; ++i3) {
                if (i3 % 10 != 0) {
                    this.delete(i3);
                    continue;
                }
                liveIDs.add(Long.valueOf(i3));
            }
        }
        this.journal.forceMoveNextFile();
        Thread t = new Thread(){

            @Override
            public void run() {
                try {
                    NIOJournalCompactTest.this.journal.testCompact();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        };
        t.start();
        ActiveMQTestBase.waitForLatch((CountDownLatch)latchDone);
        int nextID = 100;
        if (performAppend) {
            int i4;
            for (i4 = 0; i4 < 50; ++i4) {
                this.add(nextID++);
                if (i4 % 10 != 0) continue;
                this.journal.forceMoveNextFile();
            }
            for (i4 = 0; i4 < 50; ++i4) {
                this.addTx(transactionID, nextID++);
                this.commit(transactionID++);
                if (i4 % 10 != 0) continue;
                this.journal.forceMoveNextFile();
            }
        }
        if (performUpdate) {
            int count = 0;
            for (Long liveID : liveIDs) {
                if (count++ % 2 == 0) {
                    this.update(liveID);
                    continue;
                }
                this.updateTx(transactionID, liveID);
                this.commit(transactionID++);
            }
        }
        if (performDelete) {
            int count = 0;
            Iterator iterator = liveIDs.iterator();
            while (iterator.hasNext()) {
                long liveID = (Long)iterator.next();
                if (count++ % 2 == 0) {
                    this.instanceLog.debug((Object)("Deleting no trans " + liveID));
                    this.delete(liveID);
                } else {
                    this.instanceLog.debug((Object)("Deleting TX " + liveID));
                    this.deleteTx(transactionID, liveID);
                    this.commit(transactionID++);
                }
                this.instanceLog.debug((Object)("Deletes are going into " + ((JournalImpl)this.journal).getCurrentFile()));
            }
        }
        if (performNonTransactionalDelete) {
            Iterator count = liveIDs.iterator();
            while (count.hasNext()) {
                long liveID = (Long)count.next();
                this.delete(liveID);
            }
        }
        if (pendingTransactions && !delayCommit) {
            for (Pair tx : transactedRecords) {
                if (postXA) {
                    this.prepare((Long)tx.getA(), new SimpleEncoding(10, 0));
                }
                if ((Long)tx.getA() % 2L == 0L) {
                    this.commit((Long)tx.getA());
                    if (!deleteTransactRecords) continue;
                    this.delete((Long)tx.getB());
                    continue;
                }
                this.rollback((Long)tx.getA());
            }
        }
        for (int i5 = 0; i5 < 1000; ++i5) {
            long id = this.idGenerator.generateID();
            this.add(id);
            this.delete(id);
            if (i5 % 100 != 0) continue;
            this.journal.forceMoveNextFile();
        }
        this.journal.forceMoveNextFile();
        latchWait.countDown();
        t.join();
        if (pendingTransactions && delayCommit) {
            for (Pair tx : transactedRecords) {
                if (postXA) {
                    this.prepare((Long)tx.getA(), new SimpleEncoding(10, 0));
                }
                if ((Long)tx.getA() % 2L == 0L) {
                    this.commit((Long)tx.getA());
                    if (!deleteTransactRecords) continue;
                    this.delete((Long)tx.getB());
                    continue;
                }
                this.rollback((Long)tx.getA());
            }
        }
        long lastId = this.idGenerator.generateID();
        this.add(lastId);
        if (createControlFile && deleteControlFile && renameFilesAfterCompacting) {
            this.journal.testCompact();
        }
        this.journal.flush();
        this.stopJournal();
        this.createJournal();
        this.startJournal();
        this.loadAndCheck();
        this.journal.forceMoveNextFile();
        this.update(lastId);
        this.stopJournal();
        this.createJournal();
        this.startJournal();
        this.loadAndCheck();
    }

    @Test
    public void testCompactAddAndUpdateFollowedByADelete() throws Exception {
        this.setup(2, 61440, false);
        SimpleIDGenerator idGen = new SimpleIDGenerator(1000L);
        this.createJournal();
        this.journal.setAutoReclaim(false);
        this.startJournal();
        this.load();
        long consumerTX = idGen.generateID();
        long firstID = idGen.generateID();
        long appendTX = idGen.generateID();
        long addedRecord = idGen.generateID();
        this.addTx(consumerTX, firstID);
        this.startCompact();
        this.addTx(appendTX, addedRecord);
        this.commit(appendTX);
        this.updateTx(consumerTX, addedRecord);
        this.commit(consumerTX);
        this.delete(addedRecord);
        this.finishCompact();
        this.journal.forceMoveNextFile();
        long newRecord = idGen.generateID();
        this.add(newRecord);
        this.update(newRecord);
        this.journal.testCompact();
        this.instanceLog.debug((Object)("Debug after compact\n" + this.journal.debug()));
        this.stopJournal();
        this.createJournal();
        this.startJournal();
        this.loadAndCheck();
    }

    @Test
    public void testStressAppends() throws Exception {
        this.setup(2, 61440, true);
        int NUMBER_OF_RECORDS = 200;
        SimpleIDGenerator idGen = new SimpleIDGenerator(1000L);
        this.createJournal();
        this.journal.setAutoReclaim(false);
        this.startJournal();
        this.load();
        final AtomicBoolean running = new AtomicBoolean(true);
        Thread t = new Thread(){

            @Override
            public void run() {
                while (running.get()) {
                    NIOJournalCompactTest.this.journal.testCompact();
                }
            }
        };
        t.start();
        for (int i = 0; i < 200; ++i) {
            long tx = idGen.generateID();
            this.addTx(tx, idGen.generateID());
            LockSupport.parkNanos(1000L);
            this.commit(tx);
        }
        running.set(false);
        t.join(50000L);
        if (t.isAlive()) {
            t.interrupt();
            Assert.fail((String)"supposed to join thread");
        }
        this.stopJournal();
        this.createJournal();
        this.startJournal();
        this.loadAndCheck();
    }

    @Test
    public void testSimpleCommitCompactInBetween() throws Exception {
        this.setup(2, 61440, false);
        boolean NUMBER_OF_RECORDS = true;
        SimpleIDGenerator idGen = new SimpleIDGenerator(1000L);
        this.createJournal();
        this.journal.setAutoReclaim(false);
        this.startJournal();
        this.load();
        for (int i = 0; i < 1; ++i) {
            long tx = idGen.generateID();
            this.addTx(tx, idGen.generateID());
            this.journal.testCompact();
            this.journal.testCompact();
            this.journal.testCompact();
            this.journal.testCompact();
            logger.debug((Object)"going to commit");
            this.commit(tx);
        }
        this.stopJournal();
        this.createJournal();
        this.startJournal();
        this.loadAndCheck();
    }

    @Test
    public void testCompactAddAndUpdateFollowedByADelete2() throws Exception {
        this.setup(2, 61440, false);
        SimpleIDGenerator idGen = new SimpleIDGenerator(1000L);
        this.createJournal();
        this.journal.setAutoReclaim(false);
        this.startJournal();
        this.load();
        long firstID = idGen.generateID();
        long consumerTX = idGen.generateID();
        long appendTX = idGen.generateID();
        long addedRecord = idGen.generateID();
        this.addTx(consumerTX, firstID);
        this.startCompact();
        this.addTx(appendTX, addedRecord);
        this.commit(appendTX);
        this.updateTx(consumerTX, addedRecord);
        this.commit(consumerTX);
        long deleteTXID = idGen.generateID();
        this.deleteTx(deleteTXID, addedRecord);
        this.commit(deleteTXID);
        this.finishCompact();
        this.journal.forceMoveNextFile();
        this.journal.testCompact();
        this.stopJournal();
        this.createJournal();
        this.startJournal();
        this.loadAndCheck();
    }

    @Test
    public void testCompactAddAndUpdateFollowedByADelete3() throws Exception {
        this.setup(2, 61440, false);
        SimpleIDGenerator idGen = new SimpleIDGenerator(1000L);
        this.createJournal();
        this.journal.setAutoReclaim(false);
        this.startJournal();
        this.load();
        long firstID = idGen.generateID();
        long consumerTX = idGen.generateID();
        long addedRecord = idGen.generateID();
        this.add(firstID);
        this.updateTx(consumerTX, firstID);
        this.startCompact();
        this.addTx(consumerTX, addedRecord);
        this.commit(consumerTX);
        this.delete(addedRecord);
        this.finishCompact();
        this.journal.testCompact();
        this.stopJournal();
        this.createJournal();
        this.startJournal();
        this.loadAndCheck();
    }

    @Test
    public void testCompactAddAndUpdateFollowedByADelete4() throws Exception {
        this.setup(2, 61440, false);
        SimpleIDGenerator idGen = new SimpleIDGenerator(1000L);
        this.createJournal();
        this.startJournal();
        this.load();
        long consumerTX = idGen.generateID();
        long firstID = idGen.generateID();
        long appendTX = idGen.generateID();
        long addedRecord = idGen.generateID();
        this.startCompact();
        this.addTx(consumerTX, firstID);
        this.addTx(appendTX, addedRecord);
        this.commit(appendTX);
        this.updateTx(consumerTX, addedRecord);
        this.commit(consumerTX);
        this.delete(addedRecord);
        this.finishCompact();
        this.journal.forceMoveNextFile();
        long newRecord = idGen.generateID();
        this.add(newRecord);
        this.update(newRecord);
        this.journal.testCompact();
        this.stopJournal();
        this.createJournal();
        this.startJournal();
        this.loadAndCheck();
    }

    @Test
    public void testCompactAddAndUpdateFollowedByADelete6() throws Exception {
        this.setup(2, 61440, false);
        SimpleIDGenerator idGen = new SimpleIDGenerator(1000L);
        this.createJournal();
        this.journal.setAutoReclaim(false);
        this.startJournal();
        this.load();
        long tx0 = idGen.generateID();
        long tx1 = idGen.generateID();
        long add1 = idGen.generateID();
        long add2 = idGen.generateID();
        this.startCompact();
        this.addTx(tx0, add1);
        this.rollback(tx0);
        this.addTx(tx1, add1, add2);
        this.commit(tx1);
        this.finishCompact();
        long tx2 = idGen.generateID();
        this.updateTx(tx2, add1, add2);
        this.commit(tx2);
        this.delete(add1);
        this.startCompact();
        this.delete(add2);
        this.finishCompact();
        this.journal.forceMoveNextFile();
        this.journal.testCompact();
        this.stopJournal();
        this.createJournal();
        this.startJournal();
        this.loadAndCheck();
    }

    @Test
    public void testDeleteWhileCleanup() throws Exception {
        int i;
        this.setup(2, 61440, false);
        this.createJournal();
        this.startJournal();
        this.load();
        for (i = 0; i < 100; ++i) {
            this.add(i);
        }
        this.journal.forceMoveNextFile();
        for (i = 10; i < 90; ++i) {
            this.delete(i);
        }
        this.startCompact();
        for (i = 1; i < 5; ++i) {
            this.delete(i);
        }
        this.finishCompact();
        for (i = 5; i < 10; ++i) {
            this.delete(i);
        }
        NIOJournalCompactTest.assertEquals((long)9L, (long)this.journal.getCurrentFile().getNegCount(this.journal.getDataFiles()[0]));
        this.journal.forceMoveNextFile();
        this.stopJournal();
        this.createJournal();
        this.startJournal();
        this.loadAndCheck();
    }

    @Test
    public void testCompactAddAndUpdateFollowedByADelete5() throws Exception {
        this.setup(2, 61440, false);
        SimpleIDGenerator idGen = new SimpleIDGenerator(1000L);
        this.createJournal();
        this.startJournal();
        this.load();
        long appendTX = idGen.generateID();
        long appendOne = idGen.generateID();
        long appendTwo = idGen.generateID();
        long updateTX = idGen.generateID();
        this.addTx(appendTX, appendOne);
        this.startCompact();
        this.addTx(appendTX, appendTwo);
        this.commit(appendTX);
        this.updateTx(updateTX, appendOne);
        this.updateTx(updateTX, appendTwo);
        this.commit(updateTX);
        this.finishCompact();
        this.journal.testCompact();
        this.stopJournal();
        this.createJournal();
        this.startJournal();
        this.loadAndCheck();
    }

    @Test
    public void testSimpleCompacting() throws Exception {
        int i;
        this.setup(2, 61440, false);
        this.createJournal();
        this.startJournal();
        this.load();
        int NUMBER_OF_RECORDS = 1000;
        ArrayList<Long> ids = new ArrayList<Long>();
        for (int i2 = 0; i2 < NUMBER_OF_RECORDS; ++i2) {
            long id = this.idGenerator.generateID();
            ids.add(id);
            this.add(id);
            if (i2 <= 0 || i2 % 100 != 0) continue;
            this.journal.forceMoveNextFile();
        }
        for (Long id : ids) {
            this.delete(id);
        }
        this.journal.forceMoveNextFile();
        this.journal.checkReclaimStatus();
        long transactionID = 0L;
        for (i = 0; i < NUMBER_OF_RECORDS / 2; ++i) {
            this.add(i);
            if (i % 10 == 0 && i > 0) {
                this.journal.forceMoveNextFile();
            }
            this.update(i);
        }
        for (i = NUMBER_OF_RECORDS / 2; i < NUMBER_OF_RECORDS; ++i) {
            this.addTx(transactionID, i);
            this.updateTx(transactionID, i);
            if (i % 10 == 0) {
                this.journal.forceMoveNextFile();
            }
            this.commit(transactionID++);
            this.update(i);
        }
        for (i = 0; i < NUMBER_OF_RECORDS; ++i) {
            if (i % 10 == 0) continue;
            this.delete(i);
        }
        for (i = 0; i < 10; ++i) {
            this.journal.appendAddEvent(this.idGenerator.generateID(), (byte)0, (Persister)EncoderPersister.getInstance(), (Object)new ByteArrayEncoding(new byte[10]), false, null);
        }
        this.journal.forceMoveNextFile();
        this.instanceLog.debug((Object)("Number of Files: " + this.journal.getDataFilesCount()));
        this.instanceLog.debug((Object)"Before compact ****************************");
        this.instanceLog.debug((Object)this.journal.debug());
        this.instanceLog.debug((Object)"*****************************************");
        this.journal.testCompact();
        this.add(this.idGenerator.generateID());
        this.journal.testCompact();
        this.stopJournal();
        this.createJournal();
        this.startJournal();
        this.loadAndCheck();
    }

    @Test
    public void testLiveSize() throws Exception {
        JournalFile[] files3;
        this.setup(2, 61440, true);
        this.createJournal();
        this.startJournal();
        this.loadAndCheck();
        ArrayList<Long> listToDelete = new ArrayList<Long>();
        ArrayList<Integer> expectedSizes = new ArrayList<Integer>();
        for (int i = 0; i < 10; ++i) {
            long id = this.idGenerator.generateID();
            listToDelete.add(id);
            expectedSizes.add(this.recordLength + 22 + 1);
            this.add(id);
            this.journal.forceMoveNextFile();
            this.update(id);
            expectedSizes.add(this.recordLength + 22 + 1);
            this.journal.forceMoveNextFile();
        }
        JournalFile[] files = this.journal.getDataFiles();
        this.stopJournal();
        this.createJournal();
        this.startJournal();
        this.loadAndCheck();
        this.journal.forceMoveNextFile();
        JournalFile[] files2 = this.journal.getDataFiles();
        Assert.assertEquals((long)files.length, (long)files2.length);
        for (int i = 0; i < files.length; ++i) {
            Assert.assertEquals((long)((Integer)expectedSizes.get(i)).intValue(), (long)files[i].getLiveSize());
            Assert.assertEquals((long)((Integer)expectedSizes.get(i)).intValue(), (long)files2[i].getLiveSize());
        }
        Iterator i = listToDelete.iterator();
        while (i.hasNext()) {
            long id = (Long)i.next();
            this.delete(id);
        }
        this.journal.forceMoveNextFile();
        for (JournalFile file : files3 = this.journal.getDataFiles()) {
            Assert.assertEquals((long)0L, (long)file.getLiveSize());
        }
        this.stopJournal();
        this.createJournal();
        this.startJournal();
        this.loadAndCheck();
        for (JournalFile file : files3 = this.journal.getDataFiles()) {
            Assert.assertEquals((long)0L, (long)file.getLiveSize());
        }
    }

    @Test
    public void testCompactFirstFileWithPendingCommits() throws Exception {
        this.setup(2, 61440, true);
        this.createJournal();
        this.startJournal();
        this.loadAndCheck();
        long tx = this.idGenerator.generateID();
        for (int i = 0; i < 10; ++i) {
            this.addTx(tx, this.idGenerator.generateID());
        }
        this.journal.forceMoveNextFile();
        ArrayList<Long> listToDelete = new ArrayList<Long>();
        for (int i = 0; i < 10; ++i) {
            if (i == 5) {
                this.commit(tx);
            }
            long id = this.idGenerator.generateID();
            listToDelete.add(id);
            this.add(id);
        }
        this.journal.forceMoveNextFile();
        for (Long id : listToDelete) {
            this.delete(id);
        }
        this.journal.forceMoveNextFile();
        this.journal.testCompact();
        this.journal.checkReclaimStatus();
        this.journal.testCompact();
        this.stopJournal();
        this.createJournal();
        this.startJournal();
        this.loadAndCheck();
    }

    @Test
    public void testCompactFirstFileWithPendingCommits3() throws Exception {
        this.setup(2, 61440, true);
        this.createJournal();
        this.startJournal();
        this.loadAndCheck();
        long tx = this.idGenerator.generateID();
        for (int i = 0; i < 10; ++i) {
            this.addTx(tx, this.idGenerator.generateID());
        }
        this.journal.forceMoveNextFile();
        ArrayList<Long> listToDelete = new ArrayList<Long>();
        for (int i = 0; i < 10; ++i) {
            long id = this.idGenerator.generateID();
            listToDelete.add(id);
            this.add(id);
        }
        this.journal.forceMoveNextFile();
        for (Long id : listToDelete) {
            this.delete(id);
        }
        this.journal.forceMoveNextFile();
        this.rollback(tx);
        this.journal.forceMoveNextFile();
        this.journal.checkReclaimStatus();
        this.journal.testCompact();
        this.stopJournal();
        this.createJournal();
        this.startJournal();
        this.loadAndCheck();
    }

    @Test
    public void testCompactFirstFileWithPendingCommits2() throws Exception {
        this.setup(2, 61440, true);
        this.createJournal();
        this.startJournal();
        this.loadAndCheck();
        long tx = this.idGenerator.generateID();
        for (int i = 0; i < 10; ++i) {
            this.addTx(tx, this.idGenerator.generateID());
        }
        this.journal.forceMoveNextFile();
        ArrayList<Long> listToDelete = new ArrayList<Long>();
        for (int i = 0; i < 10; ++i) {
            long id = this.idGenerator.generateID();
            listToDelete.add(id);
            this.add(id);
        }
        this.journal.forceMoveNextFile();
        for (Long id : listToDelete) {
            this.delete(id);
        }
        this.journal.forceMoveNextFile();
        this.startCompact();
        this.instanceLog.debug((Object)("Committing TX " + tx));
        this.commit(tx);
        this.finishCompact();
        this.journal.checkReclaimStatus();
        this.journal.testCompact();
        this.stopJournal();
        this.createJournal();
        this.startJournal();
        this.loadAndCheck();
    }

    @Test
    public void testCompactFirstFileWithPendingCommits4() throws Exception {
        this.setup(2, 61440, true);
        this.createJournal();
        this.startJournal();
        this.loadAndCheck();
        long[] ids = new long[10];
        long tx0 = this.idGenerator.generateID();
        for (int i = 0; i < 10; ++i) {
            ids[i] = this.idGenerator.generateID();
            this.addTx(tx0, ids[i]);
        }
        long tx1 = this.idGenerator.generateID();
        this.journal.forceMoveNextFile();
        ArrayList<Long> listToDelete = new ArrayList<Long>();
        for (int i = 0; i < 10; ++i) {
            long id = this.idGenerator.generateID();
            listToDelete.add(id);
            this.add(id);
        }
        this.journal.forceMoveNextFile();
        for (Long id : listToDelete) {
            this.delete(id);
        }
        this.journal.forceMoveNextFile();
        this.startCompact();
        this.instanceLog.debug((Object)("Committing TX " + tx1));
        this.rollback(tx0);
        for (int i = 0; i < 10; ++i) {
            this.addTx(tx1, ids[i]);
        }
        this.journal.forceMoveNextFile();
        this.commit(tx1);
        this.finishCompact();
        this.journal.checkReclaimStatus();
        this.journal.testCompact();
        this.stopJournal();
        this.createJournal();
        this.startJournal();
        this.loadAndCheck();
    }

    @Test
    public void testCompactFirstFileWithPendingCommits5() throws Exception {
        this.setup(2, 61440, true);
        this.createJournal();
        this.startJournal();
        this.loadAndCheck();
        long[] ids = new long[10];
        long tx0 = this.idGenerator.generateID();
        for (int i = 0; i < 10; ++i) {
            ids[i] = this.idGenerator.generateID();
            this.addTx(tx0, ids[i]);
        }
        long tx1 = this.idGenerator.generateID();
        this.journal.forceMoveNextFile();
        ArrayList<Long> listToDelete = new ArrayList<Long>();
        for (int i = 0; i < 10; ++i) {
            long id = this.idGenerator.generateID();
            listToDelete.add(id);
            this.add(id);
        }
        this.journal.forceMoveNextFile();
        for (Long id : listToDelete) {
            this.delete(id);
        }
        this.journal.forceMoveNextFile();
        this.startCompact();
        this.instanceLog.debug((Object)("Committing TX " + tx1));
        this.rollback(tx0);
        for (int i = 0; i < 10; ++i) {
            this.addTx(tx1, ids[i]);
        }
        this.journal.forceMoveNextFile();
        this.commit(tx1);
        this.finishCompact();
        this.journal.checkReclaimStatus();
        this.journal.testCompact();
        this.stopJournal();
        this.createJournal();
        this.startJournal();
        this.loadAndCheck();
    }

    @Test
    public void testCompactFirstFileWithPendingCommits6() throws Exception {
        int i;
        this.setup(2, 61440, true);
        this.createJournal();
        this.startJournal();
        this.loadAndCheck();
        long[] ids = new long[10];
        long tx0 = this.idGenerator.generateID();
        for (i = 0; i < 10; ++i) {
            ids[i] = this.idGenerator.generateID();
            this.addTx(tx0, ids[i]);
        }
        this.commit(tx0);
        this.startCompact();
        for (i = 0; i < 10; ++i) {
            this.delete(ids[i]);
        }
        this.finishCompact();
        this.stopJournal();
        this.createJournal();
        this.startJournal();
        this.loadAndCheck();
    }

    @Test
    public void testCompactFirstFileWithPendingCommits7() throws Exception {
        this.setup(2, 61440, true);
        this.createJournal();
        this.startJournal();
        this.loadAndCheck();
        long tx0 = this.idGenerator.generateID();
        this.add(this.idGenerator.generateID());
        long[] ids = new long[]{this.idGenerator.generateID(), this.idGenerator.generateID()};
        this.addTx(tx0, ids[0]);
        this.addTx(tx0, ids[1]);
        this.journal.forceMoveNextFile();
        this.commit(tx0);
        this.journal.forceMoveNextFile();
        this.delete(ids[0]);
        this.delete(ids[1]);
        this.journal.forceMoveNextFile();
        this.journal.testCompact();
        this.stopJournal();
        this.createJournal();
        this.startJournal();
        this.loadAndCheck();
    }

    @Test
    public void testLiveSizeTransactional() throws Exception {
        JournalFile[] files3;
        this.setup(2, 61440, true);
        this.createJournal();
        this.startJournal();
        this.loadAndCheck();
        ArrayList<Long> listToDelete = new ArrayList<Long>();
        ArrayList<Integer> expectedSizes = new ArrayList<Integer>();
        for (int i = 0; i < 10; ++i) {
            long tx = this.idGenerator.generateID();
            long id = this.idGenerator.generateID();
            listToDelete.add(id);
            this.addTx(tx, id);
            expectedSizes.add(this.recordLength);
            this.journal.forceMoveNextFile();
            this.updateTx(tx, id);
            expectedSizes.add(this.recordLength);
            this.journal.forceMoveNextFile();
            expectedSizes.add(0);
            this.commit(tx);
            this.journal.forceMoveNextFile();
        }
        JournalFile[] files = this.journal.getDataFiles();
        this.stopJournal();
        this.createJournal();
        this.startJournal();
        this.loadAndCheck();
        this.journal.forceMoveNextFile();
        JournalFile[] files2 = this.journal.getDataFiles();
        Assert.assertEquals((long)files.length, (long)files2.length);
        for (int i = 0; i < files.length; ++i) {
            Assert.assertEquals((long)((Integer)expectedSizes.get(i)).intValue(), (long)files[i].getLiveSize());
            Assert.assertEquals((long)((Integer)expectedSizes.get(i)).intValue(), (long)files2[i].getLiveSize());
        }
        long tx = this.idGenerator.generateID();
        Iterator iterator = listToDelete.iterator();
        while (iterator.hasNext()) {
            long id = (Long)iterator.next();
            this.deleteTx(tx, id);
        }
        this.commit(tx);
        this.journal.forceMoveNextFile();
        for (JournalFile file : files3 = this.journal.getDataFiles()) {
            Assert.assertEquals((long)0L, (long)file.getLiveSize());
        }
        this.stopJournal();
        this.createJournal();
        this.startJournal();
        this.loadAndCheck();
        for (JournalFile file : files3 = this.journal.getDataFiles()) {
            Assert.assertEquals((long)0L, (long)file.getLiveSize());
        }
    }

    @Test
    public void testStressDeletesNoSync() throws Throwable {
        ConfigurationImpl config = this.createBasicConfig().setJournalFileSize(102400).setJournalSyncNonTransactional(false).setJournalSyncTransactional(false).setJournalCompactMinFiles(0).setJournalCompactPercentage(0);
        final AtomicInteger errors = new AtomicInteger(0);
        final AtomicBoolean running = new AtomicBoolean(true);
        final AtomicLong seqGenerator = new AtomicLong(1L);
        final ExecutorService executor = Executors.newCachedThreadPool((ThreadFactory)ActiveMQThreadFactory.defaultThreadFactory());
        ExecutorService ioexecutor = Executors.newCachedThreadPool((ThreadFactory)ActiveMQThreadFactory.defaultThreadFactory());
        OrderedExecutorFactory factory = new OrderedExecutorFactory((Executor)executor);
        OrderedExecutorFactory iofactory = new OrderedExecutorFactory((Executor)ioexecutor);
        final ExecutorService deleteExecutor = Executors.newCachedThreadPool((ThreadFactory)ActiveMQThreadFactory.defaultThreadFactory());
        final JournalStorageManager storage = new JournalStorageManager((Configuration)config, (CriticalAnalyzer)EmptyCriticalAnalyzer.getInstance(), (ExecutorFactory)factory, (ExecutorFactory)iofactory);
        storage.start();
        try {
            storage.loadInternalOnly();
            ((JournalImpl)storage.getMessageJournal()).setAutoReclaim(false);
            final LinkedList survivingMsgs = new LinkedList();
            Runnable producerRunnable = new Runnable(){

                @Override
                public void run() {
                    try {
                        while (running.get()) {
                            final long[] values = new long[100];
                            long tx = seqGenerator.incrementAndGet();
                            OperationContextImpl ctx = new OperationContextImpl((Executor)executor);
                            storage.setContext((OperationContext)ctx);
                            for (int i = 0; i < 100; ++i) {
                                long id;
                                values[i] = id = seqGenerator.incrementAndGet();
                                CoreMessage message = new CoreMessage(id, 100);
                                message.getBodyBuffer().writeBytes(new byte[1024]);
                                storage.storeMessageTransactional(tx, (Message)message);
                            }
                            CoreMessage message = new CoreMessage(seqGenerator.incrementAndGet(), 100);
                            survivingMsgs.add(message.getMessageID());
                            logger.debug((Object)("Going to store " + message));
                            storage.storeMessage((Message)message);
                            logger.debug((Object)("message stored " + message));
                            logger.debug((Object)("Going to commit " + tx));
                            storage.commit(tx);
                            logger.debug((Object)("Committed " + tx));
                            ctx.executeOnCompletion(new IOCallback(){

                                public void onError(int errorCode, String errorMessage) {
                                }

                                public void done() {
                                    deleteExecutor.execute(new Runnable(){

                                        @Override
                                        public void run() {
                                            try {
                                                for (long messageID : values) {
                                                    storage.deleteMessage(messageID);
                                                }
                                            }
                                            catch (Throwable e) {
                                                e.printStackTrace();
                                                errors.incrementAndGet();
                                            }
                                        }
                                    });
                                }
                            });
                        }
                    }
                    catch (Throwable e) {
                        e.printStackTrace();
                        errors.incrementAndGet();
                    }
                }
            };
            Runnable compressRunnable = new Runnable(){

                @Override
                public void run() {
                    try {
                        while (running.get()) {
                            Thread.sleep(500L);
                            NIOJournalCompactTest.this.instanceLog.debug((Object)"Compacting");
                            ((JournalImpl)storage.getMessageJournal()).testCompact();
                            ((JournalImpl)storage.getMessageJournal()).checkReclaimStatus();
                        }
                    }
                    catch (Throwable e) {
                        e.printStackTrace();
                        errors.incrementAndGet();
                    }
                }
            };
            Thread producerThread = new Thread(producerRunnable);
            producerThread.start();
            Thread compactorThread = new Thread(compressRunnable);
            compactorThread.start();
            Thread.sleep(1000L);
            running.set(false);
            producerThread.join();
            compactorThread.join();
            deleteExecutor.shutdown();
            NIOJournalCompactTest.assertTrue((String)"delete executor failted to terminate", (boolean)deleteExecutor.awaitTermination(30L, TimeUnit.SECONDS));
            storage.stop();
            executor.shutdown();
            NIOJournalCompactTest.assertTrue((String)"executor failed to terminate", (boolean)executor.awaitTermination(30L, TimeUnit.SECONDS));
            ioexecutor.shutdown();
            NIOJournalCompactTest.assertTrue((String)"ioexecutor failed to terminate", (boolean)ioexecutor.awaitTermination(30L, TimeUnit.SECONDS));
            Assert.assertEquals((long)0L, (long)errors.get());
        }
        catch (Throwable e) {
            e.printStackTrace();
            throw e;
        }
        finally {
            try {
                storage.stop();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            executor.shutdownNow();
            deleteExecutor.shutdownNow();
            ioexecutor.shutdownNow();
        }
    }

    @Override
    @After
    public void tearDown() throws Exception {
        File[] files;
        File testDir = new File(this.getTestDir());
        for (File file : files = testDir.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.startsWith(NIOJournalCompactTest.this.filePrefix) && name.endsWith(NIOJournalCompactTest.this.fileExtension);
            }
        })) {
            NIOJournalCompactTest.assertEquals((String)("File " + file + " doesn't have the expected number of bytes"), (long)this.fileSize, (long)file.length());
        }
        super.tearDown();
    }

    @Override
    protected SequentialFileFactory getFileFactory() throws Exception {
        return new NIOSequentialFileFactory(this.getTestDirfile(), 1);
    }
}

