/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.management;

import jakarta.json.JsonArray;
import jakarta.json.JsonObject;
import jakarta.json.JsonValue;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import javax.management.MBeanServer;
import org.apache.activemq.artemis.api.core.ActiveMQBuffer;
import org.apache.activemq.artemis.api.core.JsonUtil;
import org.apache.activemq.artemis.api.core.Message;
import org.apache.activemq.artemis.api.core.QueueConfiguration;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.api.core.client.ClientConsumer;
import org.apache.activemq.artemis.api.core.client.ClientMessage;
import org.apache.activemq.artemis.api.core.client.ClientProducer;
import org.apache.activemq.artemis.api.core.client.ClientSession;
import org.apache.activemq.artemis.api.core.client.ClientSessionFactory;
import org.apache.activemq.artemis.api.core.client.ServerLocator;
import org.apache.activemq.artemis.api.core.management.QueueControl;
import org.apache.activemq.artemis.core.config.Configuration;
import org.apache.activemq.artemis.core.server.ActiveMQServer;
import org.apache.activemq.artemis.core.server.ActiveMQServers;
import org.apache.activemq.artemis.core.settings.impl.AddressFullMessagePolicy;
import org.apache.activemq.artemis.core.settings.impl.AddressSettings;
import org.apache.activemq.artemis.tests.integration.management.ManagementTestBase;
import org.apache.activemq.artemis.tests.util.ActiveMQTestBase;
import org.apache.activemq.artemis.utils.RandomUtil;
import org.apache.johnzon.core.JsonLongImpl;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class ManagementWithPagingServerTest
extends ManagementTestBase {
    private ActiveMQServer server;
    private ClientSession session1;
    private ClientSession session2;
    private ServerLocator locator;

    @Test
    public void testListMessagesAsJSON() throws Exception {
        SimpleString address = RandomUtil.randomSimpleString();
        SimpleString queue = RandomUtil.randomSimpleString();
        this.session1.createQueue(new QueueConfiguration(queue).setAddress(address));
        QueueControl queueControl = this.createManagementControl(address, queue);
        int num = 1000;
        SenderThread sender = new SenderThread(address, num, 0L);
        ReceiverThread receiver = new ReceiverThread(queue, num, 0L);
        sender.start();
        sender.join();
        ManagementWithPagingServerTest.assertNull((Object)sender.getError());
        long count = queueControl.countMessages(null);
        ManagementWithPagingServerTest.assertEquals((long)num, (long)count);
        String result = queueControl.listMessagesAsJSON(null);
        JsonArray array = JsonUtil.readJsonArray((String)result);
        ArrayList<Long> longs = new ArrayList<Long>();
        for (JsonValue jsonValue : array) {
            JsonValue val = (JsonValue)((JsonObject)jsonValue).get((Object)"messageID");
            Long l = ((JsonLongImpl)val).longValue();
            longs.add(l);
        }
        ManagementWithPagingServerTest.assertEquals((long)num, (long)array.size());
        receiver.start();
        receiver.join();
        ManagementWithPagingServerTest.assertNull((Object)receiver.getError());
        result = queueControl.listMessagesAsJSON(null);
        array = JsonUtil.readJsonArray((String)result);
        ManagementWithPagingServerTest.assertEquals((long)0L, (long)array.size());
    }

    @Test
    public void testListMessagesAsJSONWithFilter() throws Exception {
        SimpleString address = RandomUtil.randomSimpleString();
        SimpleString queue = RandomUtil.randomSimpleString();
        this.session1.createQueue(new QueueConfiguration(queue).setAddress(address));
        QueueControl queueControl = this.createManagementControl(address, queue);
        int num = 1000;
        SimpleString key = new SimpleString("key");
        long matchingValue = RandomUtil.randomLong();
        long unmatchingValue = matchingValue + 1L;
        String filter = key + " =" + matchingValue;
        byte[] body = new byte[64];
        ByteBuffer bb = ByteBuffer.wrap(body);
        for (int j = 1; j <= 64; ++j) {
            bb.put(ManagementWithPagingServerTest.getSamplebyte((long)j));
        }
        ClientProducer producer = this.session1.createProducer(address);
        for (int i = 0; i < num; ++i) {
            ClientMessage message = this.session1.createMessage(true);
            if (i % 2 == 0) {
                message.putLongProperty(key, matchingValue);
            } else {
                message.putLongProperty(key, unmatchingValue);
            }
            producer.send((Message)message);
        }
        String jsonString = queueControl.listMessagesAsJSON(filter);
        Assert.assertNotNull((Object)jsonString);
        JsonArray array = JsonUtil.readJsonArray((String)jsonString);
        Assert.assertEquals((long)(num / 2), (long)array.size());
        long l = Long.parseLong(((JsonValue)array.getJsonObject(0).get((Object)"key")).toString().replaceAll("\"", ""));
        Assert.assertEquals((long)matchingValue, (long)l);
        long n = queueControl.countMessages(filter);
        ManagementWithPagingServerTest.assertEquals((long)(num / 2), (long)n);
        ReceiverThread receiver = new ReceiverThread(queue, num, 1L);
        receiver.start();
        receiver.join();
    }

    @Test
    public void testListMessagesAsJSONWhilePagingOnGoing() throws Exception {
        SimpleString address = RandomUtil.randomSimpleString();
        SimpleString queue = RandomUtil.randomSimpleString();
        this.session1.createQueue(new QueueConfiguration(queue).setAddress(address));
        QueueControl queueControl = this.createManagementControl(address, queue);
        int num = 1000;
        SenderThread sender = new SenderThread(address, num, 1L);
        ReceiverThread receiver = new ReceiverThread(queue, num, 2L);
        ManagementThread console = new ManagementThread(queueControl);
        sender.start();
        console.start();
        sender.join();
        ManagementWithPagingServerTest.assertNull((Object)sender.getError());
        receiver.start();
        receiver.join();
        ManagementWithPagingServerTest.assertNull((Object)receiver.getError());
        console.exit();
        console.join();
        ManagementWithPagingServerTest.assertNull((Object)console.getError());
    }

    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
        Configuration config = this.createDefaultInVMConfig().setJMXManagementEnabled(true);
        this.server = this.addServer(ActiveMQServers.newActiveMQServer((Configuration)config, (MBeanServer)this.mbeanServer, (boolean)true));
        AddressSettings defaultSetting = new AddressSettings().setPageSizeBytes(5120).setMaxSizeBytes(10240L).setAddressFullMessagePolicy(AddressFullMessagePolicy.PAGE).setManagementBrowsePageSize(1000);
        this.server.getAddressSettingsRepository().addMatch("#", (Object)defaultSetting);
        this.server.start();
        this.locator = this.createInVMNonHALocator().setBlockOnNonDurableSend(false).setConsumerWindowSize(0);
        ClientSessionFactory sf = this.createSessionFactory(this.locator);
        this.session1 = sf.createSession(false, true, false);
        this.session1.start();
        this.session2 = sf.createSession(false, true, false);
        this.session2.start();
    }

    private class ManagementThread
    extends Thread {
        private QueueControl queueControl;
        private volatile boolean stop = false;
        private Exception error = null;

        private ManagementThread(QueueControl queueControl) {
            this.queueControl = queueControl;
        }

        @Override
        public void run() {
            try {
                while (!this.stop) {
                    this.queueControl.countMessages(null);
                    this.queueControl.listMessagesAsJSON(null);
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
            catch (Exception e) {
                this.error = e;
            }
        }

        public Exception getError() {
            return this.error;
        }

        public void exit() {
            this.stop = true;
        }
    }

    private class ReceiverThread
    extends Thread {
        private SimpleString queue;
        private int num;
        private long delay;
        private volatile Exception error = null;

        private ReceiverThread(SimpleString queue, int num, long delay) {
            this.queue = queue;
            this.num = num;
            this.delay = delay;
        }

        @Override
        public void run() {
            try {
                ClientConsumer consumer = ManagementWithPagingServerTest.this.session2.createConsumer(this.queue);
                for (int i = 0; i < this.num; ++i) {
                    ClientMessage message = consumer.receive(5000L);
                    message.acknowledge();
                    ManagementWithPagingServerTest.this.session2.commit();
                    try {
                        Thread.sleep(this.delay);
                        continue;
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
            }
            catch (Exception e) {
                this.error = e;
            }
        }

        public Exception getError() {
            return this.error;
        }
    }

    private class SenderThread
    extends Thread {
        private SimpleString address;
        private int num;
        private long delay;
        private volatile Exception error = null;

        private SenderThread(SimpleString address, int num, long delay) {
            this.address = address;
            this.num = num;
            this.delay = delay;
        }

        @Override
        public void run() {
            byte[] body = new byte[128];
            ByteBuffer bb = ByteBuffer.wrap(body);
            for (int j = 1; j <= 128; ++j) {
                bb.put(ActiveMQTestBase.getSamplebyte((long)j));
            }
            try {
                ClientProducer producer = ManagementWithPagingServerTest.this.session1.createProducer(this.address);
                for (int i = 0; i < this.num; ++i) {
                    ClientMessage message = ManagementWithPagingServerTest.this.session1.createMessage(true);
                    message.setPriority((byte)1);
                    ActiveMQBuffer buffer = message.getBodyBuffer();
                    buffer.writeBytes(body);
                    producer.send((Message)message);
                    try {
                        Thread.sleep(this.delay);
                        continue;
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
            }
            catch (Exception e) {
                this.error = e;
            }
        }

        public Exception getError() {
            return this.error;
        }
    }
}

