/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.openwire;

import jakarta.jms.BytesMessage;
import jakarta.jms.Connection;
import jakarta.jms.Destination;
import jakarta.jms.InvalidDestinationException;
import jakarta.jms.JMSException;
import jakarta.jms.MapMessage;
import jakarta.jms.Message;
import jakarta.jms.MessageConsumer;
import jakarta.jms.MessageListener;
import jakarta.jms.MessageProducer;
import jakarta.jms.ObjectMessage;
import jakarta.jms.Queue;
import jakarta.jms.QueueReceiver;
import jakarta.jms.QueueSender;
import jakarta.jms.QueueSession;
import jakarta.jms.Session;
import jakarta.jms.StreamMessage;
import jakarta.jms.TemporaryQueue;
import jakarta.jms.TemporaryTopic;
import jakarta.jms.TextMessage;
import jakarta.jms.Topic;
import jakarta.jms.TopicConnection;
import jakarta.jms.TopicPublisher;
import jakarta.jms.TopicSession;
import jakarta.jms.TopicSubscriber;
import jakarta.jms.XAConnection;
import jakarta.jms.XASession;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import javax.transaction.xa.XAException;
import javax.transaction.xa.Xid;
import org.apache.activemq.ActiveMQConnection;
import org.apache.activemq.ActiveMQConnectionFactory;
import org.apache.activemq.ActiveMQSession;
import org.apache.activemq.artemis.api.core.QueueConfiguration;
import org.apache.activemq.artemis.api.core.RoutingType;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.api.jms.ActiveMQJMSClient;
import org.apache.activemq.artemis.core.postoffice.PostOffice;
import org.apache.activemq.artemis.core.postoffice.impl.LocalQueueBinding;
import org.apache.activemq.artemis.core.protocol.openwire.OpenWireConnection;
import org.apache.activemq.artemis.core.protocol.openwire.OpenWireProtocolManager;
import org.apache.activemq.artemis.core.remoting.impl.netty.NettyAcceptor;
import org.apache.activemq.artemis.core.settings.impl.AddressSettings;
import org.apache.activemq.artemis.core.transaction.Transaction;
import org.apache.activemq.artemis.core.transaction.impl.XidImpl;
import org.apache.activemq.artemis.spi.core.protocol.RemotingConnection;
import org.apache.activemq.artemis.tests.integration.openwire.BasicOpenWireTest;
import org.apache.activemq.artemis.tests.util.RandomUtil;
import org.apache.activemq.artemis.tests.util.Wait;
import org.apache.activemq.command.ActiveMQQueue;
import org.apache.activemq.command.ActiveMQTopic;
import org.apache.activemq.command.SessionInfo;
import org.apache.activemq.state.SessionState;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Test;

public class SimpleOpenWireTest
extends BasicOpenWireTest {
    private final String testString = "simple test string";
    private final String testProp = "BASE_DATE";
    private final String propValue = "2017-11-01";

    @Override
    @Before
    public void setUp() throws Exception {
        System.setProperty("org.apache.activemq.transport.AbstractInactivityMonitor.keepAliveTime", "2");
        this.realStore = true;
        super.setUp();
    }

    @Test
    public void testSimple() throws Exception {
        Connection connection = this.factory.createConnection();
        LinkedList<Session> sessions = new LinkedList<Session>();
        for (int i = 0; i < 10; ++i) {
            Session session = connection.createSession(true, 0);
            sessions.add(session);
        }
        connection.close();
    }

    @Test
    public void testDuplicateTemporaryDestination() throws Exception {
        Connection connection = this.factory.createConnection();
        Session session = connection.createSession(false, 1);
        TemporaryQueue queue = session.createTemporaryQueue();
        for (int i = 0; i < 10; ++i) {
            MessageProducer producer = session.createProducer((Destination)queue);
            producer.close();
        }
        int tempDestinationCount = 0;
        for (RemotingConnection remotingConnection : this.server.getRemotingService().getConnections()) {
            OpenWireConnection openWireConnection;
            if (!(remotingConnection instanceof OpenWireConnection) || (openWireConnection = (OpenWireConnection)remotingConnection).getState() == null || openWireConnection.getState().getTempDestinations() == null) continue;
            tempDestinationCount += openWireConnection.getState().getTempDestinations().size();
        }
        SimpleOpenWireTest.assertTrue((tempDestinationCount <= 1 ? (byte)1 : 0) != 0);
        session.close();
        connection.close();
    }

    @Test
    public void testTransactionalSimple() throws Exception {
        try (Connection connection = this.factory.createConnection();){
            Session session = connection.createSession(true, 0);
            Queue queue = session.createQueue(this.queueName);
            MessageProducer producer = session.createProducer((Destination)queue);
            MessageConsumer consumer = session.createConsumer((Destination)queue);
            producer.send((Message)session.createTextMessage("test"));
            session.commit();
            Assert.assertNull((Object)consumer.receive(100L));
            connection.start();
            TextMessage message = (TextMessage)consumer.receive(5000L);
            Assert.assertEquals((Object)"test", (Object)message.getText());
            Assert.assertNotNull((Object)message);
            message.acknowledge();
        }
    }

    @Test
    public void testSendEmpty() throws Exception {
        try (Connection connection = this.factory.createConnection();){
            Session session = connection.createSession(false, 1);
            Queue queue = session.createQueue(this.queueName);
            MessageProducer producer = session.createProducer((Destination)queue);
            MessageConsumer consumer = session.createConsumer((Destination)queue);
            producer.send((Message)session.createTextMessage());
            Assert.assertNull((Object)consumer.receive(100L));
            connection.start();
            TextMessage message = (TextMessage)consumer.receive(5000L);
            Assert.assertNotNull((Object)message);
            message.acknowledge();
        }
    }

    @Test
    public void testSendNullMapMessage() throws Exception {
        try (Connection connection = this.factory.createConnection();){
            Session session = connection.createSession(false, 1);
            Queue queue = session.createQueue(this.queueName);
            MessageProducer producer = session.createProducer((Destination)queue);
            MessageConsumer consumer = session.createConsumer((Destination)queue);
            producer.send((Message)session.createMapMessage());
            Assert.assertNull((Object)consumer.receive(100L));
            connection.start();
            MapMessage message = (MapMessage)consumer.receive(5000L);
            Assert.assertNotNull((Object)message);
            message.acknowledge();
        }
    }

    @Test
    public void testSendEmptyMessages() throws Exception {
        ActiveMQQueue dest = new ActiveMQQueue(this.queueName);
        QueueSession defaultQueueSession = this.connection.createQueueSession(false, 1);
        QueueSender defaultSender = defaultQueueSession.createSender((Queue)dest);
        defaultSender.setDeliveryMode(1);
        this.connection.start();
        Message msg = defaultQueueSession.createMessage();
        msg.setStringProperty("testName", "testSendEmptyMessages");
        defaultSender.send(msg);
        QueueReceiver queueReceiver = defaultQueueSession.createReceiver((Queue)dest);
        SimpleOpenWireTest.assertNotNull((String)"Didn't receive message", (Object)queueReceiver.receive(1000L));
        BytesMessage bytesMessage = defaultQueueSession.createBytesMessage();
        bytesMessage.setStringProperty("testName", "testSendEmptyMessages");
        defaultSender.send((Message)bytesMessage);
        SimpleOpenWireTest.assertNotNull((String)"Didn't receive message", (Object)queueReceiver.receive(1000L));
        MapMessage mapMessage = defaultQueueSession.createMapMessage();
        mapMessage.setStringProperty("testName", "testSendEmptyMessages");
        defaultSender.send((Message)mapMessage);
        SimpleOpenWireTest.assertNotNull((String)"Didn't receive message", (Object)queueReceiver.receive(1000L));
        ObjectMessage objMessage = defaultQueueSession.createObjectMessage();
        objMessage.setStringProperty("testName", "testSendEmptyMessages");
        defaultSender.send((Message)objMessage);
        SimpleOpenWireTest.assertNotNull((String)"Didn't receive message", (Object)queueReceiver.receive(1000L));
        StreamMessage streamMessage = defaultQueueSession.createStreamMessage();
        streamMessage.setStringProperty("testName", "testSendEmptyMessages");
        defaultSender.send((Message)streamMessage);
        SimpleOpenWireTest.assertNotNull((String)"Didn't receive message", (Object)queueReceiver.receive(1000L));
        TextMessage textMessage = defaultQueueSession.createTextMessage();
        textMessage.setStringProperty("testName", "testSendEmptyMessages");
        defaultSender.send((Message)textMessage);
        SimpleOpenWireTest.assertNotNull((String)"Didn't receive message", (Object)queueReceiver.receive(1000L));
    }

    @Test
    public void testXASimple() throws Exception {
        XAConnection connection = this.xaFactory.createXAConnection();
        LinkedList<XASession> sessions = new LinkedList<XASession>();
        for (int i = 0; i < 10; ++i) {
            XASession session = connection.createXASession();
            session.getXAResource().start((Xid)this.newXID(), 0);
            sessions.add(session);
        }
        connection.close();
    }

    @Test
    public void testClientACK() throws Exception {
        try {
            Connection connection = this.factory.createConnection();
            Session session = connection.createSession(false, 2);
            Queue queue = session.createQueue(this.queueName);
            MessageProducer producer = session.createProducer((Destination)queue);
            MessageConsumer consumer = session.createConsumer((Destination)queue);
            producer.send((Message)session.createTextMessage("test"));
            Assert.assertNull((Object)consumer.receive(100L));
            connection.start();
            TextMessage message = (TextMessage)consumer.receive(5000L);
            Assert.assertNotNull((Object)message);
            message.acknowledge();
            connection.close();
            System.err.println("Done!!!");
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    @Test
    public void testSessionCloseWithOpenConnection() throws Exception {
        try (Connection connection = this.factory.createConnection();){
            Session session = connection.createSession(false, 2);
            Queue queue = session.createQueue(this.queueName);
            session.createConsumer((Destination)queue);
            session.createConsumer((Destination)queue);
            connection.start();
            Field infoField = ActiveMQSession.class.getDeclaredField("info");
            infoField.setAccessible(true);
            SessionInfo info = (SessionInfo)infoField.get(session);
            NettyAcceptor acceptor = (NettyAcceptor)this.server.getRemotingService().getAcceptor("netty");
            OpenWireProtocolManager protocolManager = (OpenWireProtocolManager)acceptor.getProtocolMap().get("OPENWIRE");
            List connections = protocolManager.getConnections();
            SimpleOpenWireTest.assertEquals((long)1L, (long)connections.size());
            OpenWireConnection conn = (OpenWireConnection)connections.get(0);
            SessionState sessionState = conn.getState().getSessionState(info.getSessionId());
            Wait.assertEquals((int)2, sessionState.getConsumerIds()::size, (long)5000L);
            session.close();
            Wait.assertEquals((int)0, sessionState.getConsumerIds()::size, (long)5000L);
        }
    }

    @Test
    public void testRollback() throws Exception {
        try (Connection connection = this.factory.createConnection();){
            Session session = connection.createSession(true, 0);
            Queue queue = session.createQueue(this.queueName);
            MessageProducer producer = session.createProducer((Destination)queue);
            MessageConsumer consumer = session.createConsumer((Destination)queue);
            producer.send((Message)session.createTextMessage("test"));
            producer.send((Message)session.createTextMessage("test2"));
            connection.start();
            Assert.assertNull((Object)consumer.receiveNoWait());
            session.rollback();
            producer.send((Message)session.createTextMessage("test2"));
            Assert.assertNull((Object)consumer.receiveNoWait());
            session.commit();
            TextMessage msg = (TextMessage)consumer.receive(1000L);
            Assert.assertNotNull((Object)msg);
            Assert.assertEquals((Object)"test2", (Object)msg.getText());
        }
    }

    @Test
    public void testAutoAck() throws Exception {
        Connection connection = this.factory.createConnection();
        LinkedList sessions = new LinkedList();
        Session session = connection.createSession(false, 1);
        Queue queue = session.createQueue(this.queueName);
        MessageProducer producer = session.createProducer((Destination)queue);
        MessageConsumer consumer = session.createConsumer((Destination)queue);
        TextMessage msg = session.createTextMessage("test");
        msg.setStringProperty("abc", "testAutoACK");
        producer.send((Message)msg);
        Assert.assertNull((Object)consumer.receive(100L));
        connection.start();
        TextMessage message = (TextMessage)consumer.receive(5000L);
        Assert.assertNotNull((Object)message);
        connection.close();
        System.err.println("Done!!!");
    }

    @Test
    public void testProducerFlowControl() throws Exception {
        ActiveMQConnectionFactory factory = new ActiveMQConnectionFactory("tcp://localhost:61616?wireFormat.cacheEnabled=true");
        factory.setProducerWindowSize(65536);
        Connection connection = factory.createConnection();
        Session session = connection.createSession(true, 0);
        Queue queue = session.createQueue(this.queueName);
        MessageProducer producer = session.createProducer((Destination)queue);
        producer.send((Message)session.createTextMessage("test"));
        connection.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCompression() throws Exception {
        Connection cconnection = null;
        Connection connection = null;
        try {
            ActiveMQConnectionFactory cfactory = new ActiveMQConnectionFactory("tcp://localhost:61616");
            cconnection = cfactory.createConnection();
            cconnection.start();
            Session csession = cconnection.createSession(false, 1);
            Queue cQueue = csession.createQueue(this.queueName);
            MessageConsumer consumer = csession.createConsumer((Destination)cQueue);
            ActiveMQConnectionFactory factory = new ActiveMQConnectionFactory("tcp://localhost:61616?jms.useCompression=true");
            connection = factory.createConnection();
            Session session = connection.createSession(false, 1);
            Queue queue = session.createQueue(this.queueName);
            MessageProducer producer = session.createProducer((Destination)queue);
            producer.setDeliveryMode(2);
            TextMessage textMessage = session.createTextMessage();
            textMessage.setText("simple test string");
            TextMessage receivedMessage = this.sendAndReceive(textMessage, producer, consumer);
            String receivedText = receivedMessage.getText();
            SimpleOpenWireTest.assertEquals((Object)"simple test string", (Object)receivedText);
            MapMessage mapMessage = session.createMapMessage();
            mapMessage.setString("BASE_DATE", "2017-11-01");
            MapMessage receivedMapMessage = this.sendAndReceive(mapMessage, producer, consumer);
            String value = receivedMapMessage.getString("BASE_DATE");
            SimpleOpenWireTest.assertEquals((Object)"2017-11-01", (Object)value);
            ObjectMessage objMessage = session.createObjectMessage();
            objMessage.setObject((Serializable)((Object)"simple test string"));
            ObjectMessage receivedObjMessage = this.sendAndReceive(objMessage, producer, consumer);
            String receivedObj = (String)((Object)receivedObjMessage.getObject());
            SimpleOpenWireTest.assertEquals((Object)"simple test string", (Object)receivedObj);
            StreamMessage streamMessage = session.createStreamMessage();
            streamMessage.writeString("simple test string");
            StreamMessage receivedStreamMessage = this.sendAndReceive(streamMessage, producer, consumer);
            String streamValue = receivedStreamMessage.readString();
            SimpleOpenWireTest.assertEquals((Object)"simple test string", (Object)streamValue);
            BytesMessage byteMessage = session.createBytesMessage();
            byte[] bytes = "simple test string".getBytes();
            byteMessage.writeBytes(bytes);
            BytesMessage receivedByteMessage = this.sendAndReceive(byteMessage, producer, consumer);
            long receivedBodylength = receivedByteMessage.getBodyLength();
            SimpleOpenWireTest.assertEquals((String)"bodylength Correct", (long)bytes.length, (long)receivedBodylength);
            byte[] receivedBytes = new byte[(int)receivedBodylength];
            receivedByteMessage.readBytes(receivedBytes);
            String receivedString = new String(receivedBytes);
            SimpleOpenWireTest.assertEquals((Object)"simple test string", (Object)receivedString);
            Message m = session.createMessage();
            this.sendAndReceive(m, producer, consumer);
        }
        finally {
            if (cconnection != null) {
                connection.close();
            }
            if (connection != null) {
                cconnection.close();
            }
        }
    }

    private <T extends Message> T sendAndReceive(T m, MessageProducer producer, MessageConsumer consumer) throws JMSException {
        m.setStringProperty("BASE_DATE", "2017-11-01");
        producer.send(m);
        Message receivedMessage = consumer.receive(1000L);
        String receivedProp = receivedMessage.getStringProperty("BASE_DATE");
        SimpleOpenWireTest.assertEquals((Object)"2017-11-01", (Object)receivedProp);
        return (T)receivedMessage;
    }

    @Test
    public void testSimpleQueue() throws Exception {
        this.connection.start();
        Session session = this.connection.createSession(false, 1);
        ActiveMQQueue dest = new ActiveMQQueue(this.queueName);
        MessageProducer producer = session.createProducer((Destination)dest);
        boolean num = true;
        String msgBase = "MfromAMQ-";
        for (int i = 0; i < 1; ++i) {
            TextMessage msg = session.createTextMessage("MfromAMQ-" + i);
            producer.send((Message)msg);
        }
        MessageConsumer consumer = session.createConsumer((Destination)dest);
        for (int i = 0; i < 1; ++i) {
            TextMessage msg = (TextMessage)consumer.receive(5000L);
            String content = msg.getText();
            SimpleOpenWireTest.assertEquals((Object)("MfromAMQ-" + i), (Object)content);
        }
        SimpleOpenWireTest.assertNull((Object)consumer.receive(1000L));
        session.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSendReceiveDifferentEncoding() throws Exception {
        this.connection.start();
        Session session = this.connection.createSession(false, 1);
        ActiveMQQueue dest = new ActiveMQQueue(this.queueName);
        MessageProducer producer = session.createProducer((Destination)dest);
        int num = 10;
        String msgBase = "MfromAMQ-";
        for (int i = 0; i < 10; ++i) {
            TextMessage msg = session.createTextMessage("MfromAMQ-" + i);
            producer.send((Message)msg);
        }
        try (ActiveMQConnection looseConn = (ActiveMQConnection)this.looseFactory.createConnection();){
            looseConn.start();
            Session looseSession = looseConn.createSession(false, 1);
            MessageConsumer looseConsumer = looseSession.createConsumer((Destination)dest);
            for (int i = 0; i < 10; ++i) {
                TextMessage msg = (TextMessage)looseConsumer.receive(5000L);
                String content = msg.getText();
                SimpleOpenWireTest.assertEquals((Object)("MfromAMQ-" + i), (Object)content);
            }
            SimpleOpenWireTest.assertNull((Object)looseConsumer.receive(1000L));
            looseConsumer.close();
            MessageProducer looseProducer = looseSession.createProducer((Destination)dest);
            for (int i = 0; i < 10; ++i) {
                TextMessage msg = looseSession.createTextMessage("MfromAMQ-" + i);
                looseProducer.send((Message)msg);
            }
            MessageConsumer consumer = session.createConsumer((Destination)dest);
            for (int i = 0; i < 10; ++i) {
                TextMessage msg = (TextMessage)consumer.receive(5000L);
                SimpleOpenWireTest.assertNotNull((Object)msg);
                String content = msg.getText();
                SimpleOpenWireTest.assertEquals((Object)("MfromAMQ-" + i), (Object)content);
            }
            SimpleOpenWireTest.assertNull((Object)consumer.receive(1000L));
            session.close();
            looseSession.close();
        }
    }

    @Test
    @Ignore(value="ignored for now")
    public void testKeepAlive() throws Exception {
        this.connection.start();
        Thread.sleep(30000L);
        this.connection.createSession(false, 1);
    }

    @Test
    public void testSimpleTopic() throws Exception {
        String content;
        TextMessage msg;
        int i;
        this.connection.start();
        Session session = this.connection.createSession(false, 1);
        ActiveMQTopic dest = new ActiveMQTopic(this.topicName);
        MessageConsumer consumer1 = session.createConsumer((Destination)dest);
        MessageConsumer consumer2 = session.createConsumer((Destination)dest);
        MessageProducer producer = session.createProducer((Destination)dest);
        boolean num = true;
        String msgBase = "MfromAMQ-";
        for (i = 0; i < 1; ++i) {
            msg = session.createTextMessage("MfromAMQ-" + i);
            producer.send((Message)msg);
        }
        for (i = 0; i < 1; ++i) {
            msg = (TextMessage)consumer1.receive(5000L);
            content = msg.getText();
            SimpleOpenWireTest.assertEquals((Object)("MfromAMQ-" + i), (Object)content);
        }
        SimpleOpenWireTest.assertNull((Object)consumer1.receive(500L));
        for (i = 0; i < 1; ++i) {
            msg = (TextMessage)consumer2.receive(5000L);
            content = msg.getText();
            SimpleOpenWireTest.assertEquals((Object)("MfromAMQ-" + i), (Object)content);
        }
        SimpleOpenWireTest.assertNull((Object)consumer2.receive(500L));
        session.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testTopicNoLocal() throws Exception {
        this.connection.start();
        Session session = this.connection.createSession(false, 1);
        ActiveMQTopic dest = new ActiveMQTopic(this.topicName);
        MessageConsumer nolocalConsumer = session.createConsumer((Destination)dest, null, true);
        MessageConsumer consumer = session.createConsumer((Destination)dest, null, false);
        MessageConsumer selectorConsumer = session.createConsumer((Destination)dest, "TESTKEY = 'test'", false);
        MessageProducer producer = session.createProducer((Destination)dest);
        String body1 = "MfromAMQ-1";
        String body2 = "MfromAMQ-2";
        TextMessage msg = session.createTextMessage("MfromAMQ-1");
        producer.send((Message)msg);
        msg = session.createTextMessage("MfromAMQ-2");
        msg.setStringProperty("TESTKEY", "test");
        producer.send((Message)msg);
        TextMessage receivedMsg = (TextMessage)nolocalConsumer.receive(1000L);
        SimpleOpenWireTest.assertNull((String)("nolocal consumer got: " + receivedMsg), (Object)receivedMsg);
        receivedMsg = (TextMessage)consumer.receive(1000L);
        SimpleOpenWireTest.assertNotNull((Object)receivedMsg);
        SimpleOpenWireTest.assertEquals((Object)"MfromAMQ-1", (Object)receivedMsg.getText());
        receivedMsg = (TextMessage)consumer.receive(1000L);
        SimpleOpenWireTest.assertNotNull((Object)receivedMsg);
        SimpleOpenWireTest.assertEquals((Object)"MfromAMQ-2", (Object)receivedMsg.getText());
        SimpleOpenWireTest.assertNull((Object)consumer.receiveNoWait());
        receivedMsg = (TextMessage)selectorConsumer.receive(1000L);
        SimpleOpenWireTest.assertNotNull((Object)receivedMsg);
        SimpleOpenWireTest.assertEquals((Object)"MfromAMQ-2", (Object)receivedMsg.getText());
        SimpleOpenWireTest.assertEquals((Object)"test", (Object)receivedMsg.getStringProperty("TESTKEY"));
        SimpleOpenWireTest.assertNull((Object)selectorConsumer.receiveNoWait());
        try (Connection anotherConn = this.factory.createConnection();){
            anotherConn.start();
            Session anotherSession = anotherConn.createSession(false, 1);
            MessageProducer anotherProducer = anotherSession.createProducer((Destination)dest);
            TextMessage anotherMsg = anotherSession.createTextMessage("MfromAMQ-1");
            anotherProducer.send((Message)anotherMsg);
            SimpleOpenWireTest.assertNotNull((Object)consumer.receive(1000L));
            SimpleOpenWireTest.assertNull((Object)selectorConsumer.receive(1000L));
            SimpleOpenWireTest.assertNotNull((Object)nolocalConsumer.receive(1000L));
        }
        session.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testTopicNoLocalDurable() throws Exception {
        this.connection.setClientID("forNoLocal-1");
        this.connection.start();
        TopicSession session = this.connection.createTopicSession(false, 1);
        ActiveMQTopic dest = new ActiveMQTopic(this.topicName);
        TopicSubscriber nolocalConsumer = session.createDurableSubscriber((Topic)dest, "nolocal-subscriber1", "", true);
        TopicSubscriber consumer = session.createDurableSubscriber((Topic)dest, "normal-subscriber", null, false);
        TopicSubscriber selectorConsumer = session.createDurableSubscriber((Topic)dest, "selector-subscriber", "TESTKEY = 'test'", false);
        MessageProducer producer = session.createProducer((Destination)dest);
        String body1 = "MfromAMQ-1";
        String body2 = "MfromAMQ-2";
        TextMessage msg = session.createTextMessage("MfromAMQ-1");
        producer.send((Message)msg);
        msg = session.createTextMessage("MfromAMQ-2");
        msg.setStringProperty("TESTKEY", "test");
        producer.send((Message)msg);
        TextMessage receivedMsg = (TextMessage)nolocalConsumer.receive(1000L);
        SimpleOpenWireTest.assertNull((String)("nolocal consumer got: " + receivedMsg), (Object)receivedMsg);
        receivedMsg = (TextMessage)consumer.receive(1000L);
        SimpleOpenWireTest.assertNotNull((Object)receivedMsg);
        SimpleOpenWireTest.assertEquals((Object)"MfromAMQ-1", (Object)receivedMsg.getText());
        receivedMsg = (TextMessage)consumer.receive(1000L);
        SimpleOpenWireTest.assertNotNull((Object)receivedMsg);
        SimpleOpenWireTest.assertEquals((Object)"MfromAMQ-2", (Object)receivedMsg.getText());
        SimpleOpenWireTest.assertNull((Object)consumer.receiveNoWait());
        receivedMsg = (TextMessage)selectorConsumer.receive(1000L);
        SimpleOpenWireTest.assertNotNull((Object)receivedMsg);
        SimpleOpenWireTest.assertEquals((Object)"MfromAMQ-2", (Object)receivedMsg.getText());
        SimpleOpenWireTest.assertEquals((Object)"test", (Object)receivedMsg.getStringProperty("TESTKEY"));
        SimpleOpenWireTest.assertNull((Object)selectorConsumer.receiveNoWait());
        try (Connection anotherConn = this.factory.createConnection();){
            anotherConn.start();
            Session anotherSession = anotherConn.createSession(false, 1);
            MessageProducer anotherProducer = anotherSession.createProducer((Destination)dest);
            TextMessage anotherMsg = anotherSession.createTextMessage("MfromAMQ-1");
            anotherProducer.send((Message)anotherMsg);
            SimpleOpenWireTest.assertNotNull((Object)consumer.receive(1000L));
            SimpleOpenWireTest.assertNull((Object)selectorConsumer.receive(1000L));
            SimpleOpenWireTest.assertNotNull((Object)nolocalConsumer.receive(1000L));
        }
        session.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testTempTopicDelete() throws Exception {
        this.connection.start();
        TopicSession topicSession = this.connection.createTopicSession(false, 1);
        TemporaryTopic tempTopic = topicSession.createTemporaryTopic();
        try (ActiveMQConnection newConn = (ActiveMQConnection)this.factory.createConnection();){
            TopicSession newTopicSession = newConn.createTopicSession(false, 1);
            TopicPublisher publisher = newTopicSession.createPublisher((Topic)tempTopic);
            SimpleOpenWireTest.assertTrue((boolean)Wait.waitFor(() -> newConn.activeTempDestinations.size() == 1, (long)2000L, (long)100L));
            TextMessage msg = newTopicSession.createTextMessage("Test Message");
            publisher.publish((Message)msg);
            try {
                TopicSubscriber consumer = newTopicSession.createSubscriber((Topic)tempTopic);
                SimpleOpenWireTest.fail((String)("should have gotten exception but got consumer: " + consumer));
            }
            catch (JMSException consumer) {
                // empty catch block
            }
            this.connection.close();
            try {
                Message newMsg = newTopicSession.createMessage();
                publisher.publish(newMsg);
            }
            catch (JMSException jMSException) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testTempQueueDelete() throws Exception {
        this.connection.start();
        QueueSession queueSession = this.connection.createQueueSession(false, 1);
        TemporaryQueue tempQueue = queueSession.createTemporaryQueue();
        try (ActiveMQConnection newConn = (ActiveMQConnection)this.factory.createConnection();){
            QueueSession newQueueSession = newConn.createQueueSession(false, 1);
            QueueSender queueSender = newQueueSession.createSender((Queue)tempQueue);
            Message msg = queueSession.createMessage();
            queueSender.send(msg);
            try {
                QueueReceiver consumer = newQueueSession.createReceiver((Queue)tempQueue);
                SimpleOpenWireTest.fail((String)("should have gotten exception but got consumer: " + consumer));
            }
            catch (JMSException consumer) {
                // empty catch block
            }
            this.connection.close();
            try {
                Message newMsg = newQueueSession.createMessage();
                queueSender.send(newMsg);
            }
            catch (JMSException jMSException) {
                // empty catch block
            }
        }
    }

    @Test
    public void testSimpleTempTopic() throws Exception {
        String content;
        TextMessage msg;
        int i;
        this.connection.start();
        Session session = this.connection.createSession(false, 1);
        TemporaryTopic tempTopic = session.createTemporaryTopic();
        MessageConsumer consumer1 = session.createConsumer((Destination)tempTopic);
        MessageConsumer consumer2 = session.createConsumer((Destination)tempTopic);
        MessageProducer producer = session.createProducer((Destination)tempTopic);
        boolean num = true;
        String msgBase = "MfromAMQ-";
        for (i = 0; i < 1; ++i) {
            msg = session.createTextMessage("MfromAMQ-" + i);
            producer.send((Message)msg);
        }
        for (i = 0; i < 1; ++i) {
            msg = (TextMessage)consumer1.receive(5000L);
            content = msg.getText();
            SimpleOpenWireTest.assertEquals((Object)("MfromAMQ-" + i), (Object)content);
        }
        SimpleOpenWireTest.assertNull((Object)consumer1.receive(500L));
        for (i = 0; i < 1; ++i) {
            msg = (TextMessage)consumer2.receive(5000L);
            content = msg.getText();
            SimpleOpenWireTest.assertEquals((Object)("MfromAMQ-" + i), (Object)content);
        }
        SimpleOpenWireTest.assertNull((Object)consumer2.receive(500L));
        session.close();
    }

    @Test
    public void testSimpleTempQueue() throws Exception {
        TextMessage msg;
        int i;
        AddressSettings addressSetting = new AddressSettings();
        addressSetting.setAutoCreateQueues(Boolean.valueOf(true));
        addressSetting.setAutoCreateAddresses(Boolean.valueOf(true));
        String address = "#";
        this.server.getAddressSettingsRepository().addMatch(address, (Object)addressSetting);
        this.connection.start();
        Session session = this.connection.createSession(false, 1);
        TemporaryQueue tempQueue = session.createTemporaryQueue();
        MessageConsumer consumer1 = session.createConsumer((Destination)tempQueue);
        MessageProducer producer = session.createProducer((Destination)tempQueue);
        boolean num = true;
        String msgBase = "MfromAMQ-";
        for (i = 0; i < 1; ++i) {
            msg = session.createTextMessage("MfromAMQ-" + i);
            producer.send((Message)msg);
        }
        for (i = 0; i < 1; ++i) {
            msg = (TextMessage)consumer1.receive(5000L);
            String content = msg.getText();
            SimpleOpenWireTest.assertEquals((Object)("MfromAMQ-" + i), (Object)content);
        }
        SimpleOpenWireTest.assertNull((Object)consumer1.receive(500L));
        session.close();
    }

    @Test
    public void testInvalidDestinationExceptionWhenNoQueueExistsOnCreateProducer() throws Exception {
        this.connection.start();
        Session session = this.connection.createSession(false, 1);
        Queue queue = session.createQueue("foo");
        try {
            session.createProducer((Destination)queue);
            SimpleOpenWireTest.fail((String)"Should have thrown an exception creating a producer here");
        }
        catch (JMSException jMSException) {
            // empty catch block
        }
        session.close();
    }

    @Test
    public void testAutoDestinationCreationOnProducerSend() throws JMSException {
        AddressSettings addressSetting = new AddressSettings();
        addressSetting.setAutoCreateQueues(Boolean.valueOf(true));
        addressSetting.setAutoCreateAddresses(Boolean.valueOf(true));
        String address = "foo";
        this.server.getAddressSettingsRepository().addMatch(address, (Object)addressSetting);
        this.connection.start();
        Session session = this.connection.createSession(false, 1);
        TextMessage message = session.createTextMessage("bar");
        ActiveMQQueue queue = new ActiveMQQueue(address);
        MessageProducer producer = session.createProducer(null);
        producer.send((Destination)queue, (Message)message);
        MessageConsumer consumer = session.createConsumer((Destination)queue);
        TextMessage message1 = (TextMessage)consumer.receive(1000L);
        SimpleOpenWireTest.assertTrue((boolean)message1.getText().equals(message.getText()));
    }

    @Test
    public void testAutoDestinationCreationAndDeletionOnConsumer() throws Exception {
        AddressSettings addressSetting = new AddressSettings();
        addressSetting.setAutoCreateQueues(Boolean.valueOf(true));
        addressSetting.setAutoCreateAddresses(Boolean.valueOf(true));
        addressSetting.setAutoDeleteQueues(Boolean.valueOf(true));
        addressSetting.setAutoDeleteAddresses(Boolean.valueOf(true));
        String address = "foo";
        this.server.getAddressSettingsRepository().addMatch(address, (Object)addressSetting);
        this.connection.start();
        Session session = this.connection.createSession(false, 1);
        TextMessage message = session.createTextMessage("bar");
        ActiveMQQueue queue = new ActiveMQQueue(address);
        MessageConsumer consumer = session.createConsumer((Destination)queue);
        SimpleOpenWireTest.assertTrue((boolean)Wait.waitFor(() -> this.server.locateQueue(SimpleString.toSimpleString((String)"foo")) != null, (long)2000L, (long)100L));
        SimpleOpenWireTest.assertTrue((boolean)Wait.waitFor(() -> this.server.getAddressInfo(SimpleString.toSimpleString((String)"foo")) != null, (long)2000L, (long)100L));
        MessageProducer producer = session.createProducer(null);
        producer.send((Destination)queue, (Message)message);
        TextMessage message1 = (TextMessage)consumer.receive(1000L);
        SimpleOpenWireTest.assertTrue((boolean)message1.getText().equals(message.getText()));
        SimpleOpenWireTest.assertNotNull((Object)this.server.locateQueue(SimpleString.toSimpleString((String)"foo")));
        consumer.close();
        this.connection.close();
        SimpleOpenWireTest.assertTrue((boolean)Wait.waitFor(() -> this.server.locateQueue(SimpleString.toSimpleString((String)"foo")) == null, (long)2000L, (long)100L));
        SimpleOpenWireTest.assertTrue((boolean)Wait.waitFor(() -> this.server.getAddressInfo(SimpleString.toSimpleString((String)"foo")) == null, (long)2000L, (long)100L));
    }

    @Test
    public void testAutoDestinationNoCreationOnConsumer() throws JMSException {
        AddressSettings addressSetting = new AddressSettings();
        addressSetting.setAutoCreateQueues(Boolean.valueOf(false));
        String address = "foo";
        this.server.getAddressSettingsRepository().addMatch(address, (Object)addressSetting);
        this.connection.start();
        Session session = this.connection.createSession(false, 1);
        TextMessage message = session.createTextMessage("bar");
        ActiveMQQueue queue = new ActiveMQQueue(address);
        try {
            MessageConsumer consumer = session.createConsumer((Destination)queue);
            SimpleOpenWireTest.fail((String)"supposed to throw an exception here");
        }
        catch (JMSException jMSException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testFailoverTransportReconnect() throws Exception {
        try (Connection exConn = null;){
            String urlString = "failover:(tcp://localhost:61616)";
            ActiveMQConnectionFactory exFact = new ActiveMQConnectionFactory(urlString);
            ActiveMQQueue queue = new ActiveMQQueue(this.durableQueueName);
            exConn = exFact.createConnection();
            exConn.start();
            Session session = exConn.createSession(false, 1);
            MessageProducer messageProducer = session.createProducer((Destination)queue);
            messageProducer.send((Message)session.createTextMessage("Test"));
            MessageConsumer consumer = session.createConsumer((Destination)queue);
            SimpleOpenWireTest.assertNotNull((Object)consumer.receive(5000L));
            this.server.stop();
            Thread.sleep(3000L);
            this.server.start();
            this.server.waitForActivation(10L, TimeUnit.SECONDS);
            messageProducer.send((Message)session.createTextMessage("Test2"));
            SimpleOpenWireTest.assertNotNull((Object)consumer.receive(5000L));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testOpenWireExample() throws Exception {
        Connection exConn = null;
        SimpleString durableQueue = new SimpleString("exampleQueue");
        this.server.createQueue(new QueueConfiguration(durableQueue).setRoutingType(RoutingType.ANYCAST));
        try {
            ActiveMQConnectionFactory exFact = new ActiveMQConnectionFactory();
            ActiveMQQueue queue = new ActiveMQQueue(this.durableQueueName);
            exConn = exFact.createConnection();
            exConn.start();
            Session session = exConn.createSession(false, 1);
            MessageProducer producer = session.createProducer((Destination)queue);
            TextMessage message = session.createTextMessage("This is a text message");
            producer.send((Message)message);
            MessageConsumer messageConsumer = session.createConsumer((Destination)queue);
            TextMessage messageReceived = (TextMessage)messageConsumer.receive(5000L);
            SimpleOpenWireTest.assertEquals((Object)"This is a text message", (Object)messageReceived.getText());
        }
        finally {
            if (exConn != null) {
                exConn.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testMultipleConsumers() throws Exception {
        Connection exConn = null;
        SimpleString durableQueue = new SimpleString("exampleQueue");
        this.server.createQueue(new QueueConfiguration(durableQueue).setRoutingType(RoutingType.ANYCAST));
        try {
            ActiveMQConnectionFactory exFact = new ActiveMQConnectionFactory();
            ActiveMQQueue queue = new ActiveMQQueue(this.durableQueueName);
            exConn = exFact.createConnection();
            exConn.start();
            Session session = exConn.createSession(false, 1);
            MessageProducer producer = session.createProducer((Destination)queue);
            TextMessage message = session.createTextMessage("This is a text message");
            producer.send((Message)message);
            MessageConsumer messageConsumer = session.createConsumer((Destination)queue);
            TextMessage messageReceived = (TextMessage)messageConsumer.receive(5000L);
            SimpleOpenWireTest.assertEquals((Object)"This is a text message", (Object)messageReceived.getText());
        }
        finally {
            if (exConn != null) {
                exConn.close();
            }
        }
    }

    @Test
    public void testMixedOpenWireExample() throws Exception {
        Connection openConn = null;
        SimpleString durableQueue = new SimpleString("exampleQueue");
        this.server.createQueue(new QueueConfiguration(durableQueue).setRoutingType(RoutingType.ANYCAST));
        ActiveMQConnectionFactory openCF = new ActiveMQConnectionFactory();
        ActiveMQQueue queue = new ActiveMQQueue("exampleQueue");
        openConn = openCF.createConnection();
        openConn.start();
        Session openSession = openConn.createSession(false, 1);
        MessageProducer producer = openSession.createProducer((Destination)queue);
        TextMessage message = openSession.createTextMessage("This is a text message");
        producer.send((Message)message);
        org.apache.activemq.artemis.jms.client.ActiveMQConnectionFactory artemisCF = new org.apache.activemq.artemis.jms.client.ActiveMQConnectionFactory();
        Connection artemisConn = artemisCF.createConnection();
        Session artemisSession = artemisConn.createSession(false, 1);
        artemisConn.start();
        MessageConsumer messageConsumer = artemisSession.createConsumer((Destination)artemisSession.createQueue("exampleQueue"));
        TextMessage messageReceived = (TextMessage)messageConsumer.receive(5000L);
        SimpleOpenWireTest.assertEquals((Object)"This is a text message", (Object)messageReceived.getText());
        openConn.close();
        artemisConn.close();
    }

    @Test
    public void testMixedOpenWireExample2() throws Exception {
        Connection conn1 = null;
        SimpleString durableQueue = new SimpleString("exampleQueue");
        this.server.createQueue(new QueueConfiguration(durableQueue).setRoutingType(RoutingType.ANYCAST));
        Queue queue = ActiveMQJMSClient.createQueue((String)"exampleQueue");
        org.apache.activemq.artemis.jms.client.ActiveMQConnectionFactory artemisCF = new org.apache.activemq.artemis.jms.client.ActiveMQConnectionFactory();
        conn1 = artemisCF.createConnection();
        conn1.start();
        Session session1 = conn1.createSession(false, 1);
        MessageProducer producer = session1.createProducer((Destination)queue);
        for (int i = 0; i < 10; ++i) {
            TextMessage message = session1.createTextMessage("This is a text message");
            producer.send((Message)message);
        }
        ActiveMQConnectionFactory openCF = new ActiveMQConnectionFactory();
        Connection conn2 = openCF.createConnection();
        Session sess2 = conn2.createSession(false, 1);
        conn2.start();
        MessageConsumer messageConsumer = sess2.createConsumer((Destination)sess2.createQueue("exampleQueue"));
        for (int i = 0; i < 10; ++i) {
            TextMessage messageReceived = (TextMessage)messageConsumer.receive(5000L);
            SimpleOpenWireTest.assertEquals((Object)"This is a text message", (Object)messageReceived.getText());
        }
        conn1.close();
        conn2.close();
    }

    @Test
    public void testXAConsumer() throws Exception {
        Queue queue;
        try (Session session = this.connection.createSession(false, 2);){
            queue = session.createQueue(this.queueName);
            MessageProducer producer = session.createProducer((Destination)queue);
            for (int i = 0; i < 10; ++i) {
                TextMessage msg = session.createTextMessage("test" + i);
                msg.setStringProperty("myobj", "test" + i);
                producer.send((Message)msg);
            }
            session.close();
        }
        var3_2 = null;
        try (XAConnection xaconnection = this.xaFactory.createXAConnection();){
            XidImpl xid = this.newXID();
            XASession session = xaconnection.createXASession();
            session.getXAResource().start((Xid)xid, 0);
            MessageConsumer consumer = session.createConsumer((Destination)queue);
            xaconnection.start();
            for (int i = 0; i < 5; ++i) {
                TextMessage message = (TextMessage)consumer.receive(5000L);
                Assert.assertNotNull((Object)message);
                Assert.assertEquals((Object)("test" + i), (Object)message.getText());
            }
            session.getXAResource().end((Xid)xid, 0x4000000);
            session.getXAResource().rollback((Xid)xid);
            consumer.close();
            xaconnection.close();
        }
        catch (Throwable xid) {
            var3_2 = xid;
            throw xid;
        }
        session = this.connection.createSession(false, 1);
        var3_2 = null;
        try {
            this.connection.start();
            MessageConsumer consumer = session.createConsumer((Destination)queue);
            for (int i = 0; i < 10; ++i) {
                TextMessage message = (TextMessage)consumer.receive(5000L);
                Assert.assertNotNull((Object)message);
            }
            this.checkDuplicate(consumer);
            session.close();
        }
        catch (Throwable throwable) {
            var3_2 = throwable;
            throw throwable;
        }
        finally {
            if (session != null) {
                if (var3_2 != null) {
                    try {
                        session.close();
                    }
                    catch (Throwable throwable) {
                        var3_2.addSuppressed(throwable);
                    }
                } else {
                    session.close();
                }
            }
        }
        System.err.println("Done!!!");
    }

    @Test
    public void testXASameConsumerRollback() throws Exception {
        Queue queue;
        try (Session session = this.connection.createSession(false, 2);){
            queue = session.createQueue(this.queueName);
            MessageProducer producer = session.createProducer((Destination)queue);
            for (int i = 0; i < 10; ++i) {
                TextMessage msg = session.createTextMessage("test" + i);
                msg.setStringProperty("myobj", "test" + i);
                producer.send((Message)msg);
            }
            session.close();
        }
        var3_2 = null;
        try (XAConnection xaconnection = this.xaFactory.createXAConnection();){
            TextMessage message;
            int i;
            XidImpl xid = this.newXID();
            XASession session = xaconnection.createXASession();
            session.getXAResource().start((Xid)xid, 0);
            MessageConsumer consumer = session.createConsumer((Destination)queue);
            xaconnection.start();
            for (i = 0; i < 5; ++i) {
                message = (TextMessage)consumer.receive(5000L);
                Assert.assertNotNull((Object)message);
                Assert.assertEquals((Object)("test" + i), (Object)message.getText());
            }
            session.getXAResource().end((Xid)xid, 0x4000000);
            session.getXAResource().rollback((Xid)xid);
            xid = this.newXID();
            session.getXAResource().start((Xid)xid, 0);
            for (i = 0; i < 10; ++i) {
                message = (TextMessage)consumer.receive(5000L);
                Assert.assertNotNull((Object)message);
                Assert.assertEquals((Object)("test" + i), (Object)message.getText());
            }
            this.checkDuplicate(consumer);
            session.getXAResource().end((Xid)xid, 0x4000000);
            session.getXAResource().commit((Xid)xid, true);
        }
        catch (Throwable throwable) {
            var3_2 = throwable;
            throw throwable;
        }
    }

    @Test
    public void testXAPrepare() throws Exception {
        try {
            XAConnection connection = this.xaFactory.createXAConnection();
            XASession xasession = connection.createXASession();
            XidImpl xid = this.newXID();
            xasession.getXAResource().start((Xid)xid, 0);
            Queue queue = xasession.createQueue(this.queueName);
            MessageProducer producer = xasession.createProducer((Destination)queue);
            producer.send((Message)xasession.createTextMessage("hello"));
            producer.send((Message)xasession.createTextMessage("hello"));
            xasession.getXAResource().end((Xid)xid, 0x4000000);
            xasession.getXAResource().prepare((Xid)xid);
            connection.close();
            System.err.println("Done!!!");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Test
    public void testAutoSend() throws Exception {
        int i;
        this.connection.start();
        Session session = this.connection.createSession(false, 1);
        Queue queue = session.createQueue(this.queueName);
        MessageConsumer consumer = session.createConsumer((Destination)queue);
        MessageProducer producer = session.createProducer((Destination)queue);
        for (i = 0; i < 10; ++i) {
            producer.send((Message)session.createTextMessage("testXX" + i));
        }
        this.connection.start();
        for (i = 0; i < 10; ++i) {
            TextMessage txt = (TextMessage)consumer.receive(5000L);
            Assert.assertEquals((Object)("testXX" + i), (Object)txt.getText());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSendReceiveUsingTtl() throws Exception {
        String brokerUri = "failover://tcp://localhost:61616?wireFormat.maxInactivityDuration=5000&wireFormat.maxInactivityDurationInitalDelay=1000";
        ActiveMQConnectionFactory testFactory = new ActiveMQConnectionFactory(brokerUri);
        Connection sendConnection = testFactory.createConnection();
        Connection receiveConnection = testFactory.createConnection();
        try {
            int nMsg = 10;
            long delay = 2L;
            AsyncConsumer consumer = new AsyncConsumer(this.queueName, receiveConnection, 2, 2L, 10);
            Session sendSession = sendConnection.createSession(false, 1);
            Queue queue = sendSession.createQueue(this.queueName);
            MessageProducer producer = sendSession.createProducer((Destination)queue);
            for (int i = 0; i < 10; ++i) {
                producer.send((Message)sendSession.createTextMessage("testXX" + i));
            }
            consumer.waitFor(40L);
        }
        finally {
            sendConnection.close();
            receiveConnection.close();
        }
    }

    @Test
    public void testCommitCloseConsumerBefore() throws Exception {
        this.testCommitCloseConsumer(true);
    }

    @Test
    public void testCommitCloseConsumerAfter() throws Exception {
        this.testCommitCloseConsumer(false);
    }

    private void testCommitCloseConsumer(boolean closeBefore) throws Exception {
        TextMessage txt;
        int i;
        this.connection.start();
        Session session = this.connection.createSession(true, 0);
        Queue queue = session.createQueue(this.queueName);
        MessageConsumer consumer = session.createConsumer((Destination)queue);
        MessageProducer producer = session.createProducer((Destination)queue);
        for (i = 0; i < 10; ++i) {
            TextMessage msg = session.createTextMessage("testXX" + i);
            msg.setStringProperty("count", "str " + i);
            producer.send((Message)msg);
        }
        session.commit();
        this.connection.start();
        for (i = 0; i < 5; ++i) {
            txt = (TextMessage)consumer.receive(5000L);
            Assert.assertEquals((Object)("testXX" + i), (Object)txt.getText());
        }
        if (closeBefore) {
            consumer.close();
        }
        session.commit();
        if (!closeBefore) {
            consumer.close();
        }
        consumer = session.createConsumer((Destination)queue);
        for (i = 5; i < 10; ++i) {
            txt = (TextMessage)consumer.receive(5000L);
            Assert.assertEquals((Object)("testXX" + i), (Object)txt.getText());
        }
        Assert.assertNull((Object)consumer.receiveNoWait());
    }

    @Test
    public void testRollbackWithAcked() throws Exception {
        TextMessage txt;
        int i;
        this.connection.start();
        Session session = this.connection.createSession(true, 0);
        Queue queue = session.createQueue(this.queueName);
        MessageConsumer consumer = session.createConsumer((Destination)queue);
        MessageProducer producer = session.createProducer((Destination)queue);
        for (i = 0; i < 10; ++i) {
            TextMessage msg = session.createTextMessage("testXX" + i);
            msg.setStringProperty("count", "str " + i);
            producer.send((Message)msg);
        }
        session.commit();
        this.connection.start();
        for (i = 0; i < 5; ++i) {
            txt = (TextMessage)consumer.receive(5000L);
            Assert.assertEquals((Object)("testXX" + i), (Object)txt.getText());
        }
        session.rollback();
        consumer.close();
        consumer = session.createConsumer((Destination)queue);
        for (i = 0; i < 10; ++i) {
            txt = (TextMessage)consumer.receive(5000L);
            Assert.assertNotNull((Object)txt);
        }
        session.commit();
        this.checkDuplicate(consumer);
    }

    @Test
    public void testRollbackLocal() throws Exception {
        TextMessage txt;
        int i;
        this.connection.start();
        Session session = this.connection.createSession(true, 0);
        Queue queue = session.createQueue(this.queueName);
        MessageConsumer consumer = session.createConsumer((Destination)queue);
        MessageProducer producer = session.createProducer((Destination)queue);
        for (i = 0; i < 10; ++i) {
            TextMessage msg = session.createTextMessage("testXX" + i);
            msg.setStringProperty("count", "str " + i);
            producer.send((Message)msg);
        }
        session.commit();
        this.connection.start();
        for (i = 0; i < 5; ++i) {
            txt = (TextMessage)consumer.receive(500L);
            Assert.assertEquals((Object)("testXX" + i), (Object)txt.getText());
        }
        session.rollback();
        for (i = 0; i < 10; ++i) {
            txt = (TextMessage)consumer.receive(5000L);
            Assert.assertNotNull((Object)txt);
            Assert.assertEquals((Object)("testXX" + i), (Object)txt.getText());
        }
        this.checkDuplicate(consumer);
        session.commit();
    }

    private void checkDuplicate(MessageConsumer consumer) throws JMSException {
        TextMessage txt;
        boolean duplicatedMessages = false;
        while ((txt = (TextMessage)consumer.receiveNoWait()) != null) {
            duplicatedMessages = true;
            this.instanceLog.warn((Object)("received in duplicate:" + txt.getText()));
        }
        Assert.assertFalse((String)"received messages in duplicate", (boolean)duplicatedMessages);
    }

    @Test
    public void testIndividualAck() throws Exception {
        TextMessage txt;
        int i;
        this.connection.start();
        Session session = this.connection.createSession(false, 4);
        Queue queue = session.createQueue(this.queueName);
        MessageConsumer consumer = session.createConsumer((Destination)queue);
        MessageProducer producer = session.createProducer((Destination)queue);
        for (i = 0; i < 10; ++i) {
            TextMessage msg = session.createTextMessage("testXX" + i);
            msg.setStringProperty("count", "str " + i);
            producer.send((Message)msg);
        }
        this.connection.start();
        for (i = 0; i < 5; ++i) {
            txt = (TextMessage)consumer.receive(5000L);
            if (i == 4) {
                txt.acknowledge();
            }
            Assert.assertEquals((Object)("testXX" + i), (Object)txt.getText());
        }
        consumer.close();
        consumer = session.createConsumer((Destination)queue);
        for (i = 0; i < 4; ++i) {
            txt = (TextMessage)consumer.receive(5000L);
            txt.acknowledge();
            Assert.assertEquals((Object)("testXX" + i), (Object)txt.getText());
        }
        for (i = 5; i < 10; ++i) {
            txt = (TextMessage)consumer.receive(5000L);
            txt.acknowledge();
            Assert.assertEquals((Object)("testXX" + i), (Object)txt.getText());
        }
        this.checkDuplicate(consumer);
        Assert.assertNull((Object)consumer.receiveNoWait());
    }

    @Test
    public void testCommitCloseConsumeXA() throws Exception {
        this.connection.start();
        Session session = this.connection.createSession(true, 0);
        Queue queue = session.createQueue(this.queueName);
        Object producer = session.createProducer((Destination)queue);
        for (int i = 0; i < 10; ++i) {
            TextMessage msg = session.createTextMessage("testXX" + i);
            msg.setStringProperty("count", "str " + i);
            producer.send((Message)msg);
        }
        session.commit();
        XAConnection xaconnection = this.xaFactory.createXAConnection();
        producer = null;
        try {
            xaconnection.start();
            XASession xasession = xaconnection.createXASession();
            XidImpl xid = this.newXID();
            xasession.getXAResource().start((Xid)xid, 0);
            MessageConsumer consumer = xasession.createConsumer((Destination)queue);
            for (int i = 0; i < 5; ++i) {
                TextMessage txt = (TextMessage)consumer.receive(5000L);
                Assert.assertEquals((Object)("testXX" + i), (Object)txt.getText());
            }
            consumer.close();
            xasession.getXAResource().end((Xid)xid, 0x4000000);
            xasession.getXAResource().prepare((Xid)xid);
            xasession.getXAResource().commit((Xid)xid, false);
            xaconnection.close();
        }
        catch (Throwable throwable) {
            producer = throwable;
            throw throwable;
        }
        finally {
            if (xaconnection != null) {
                if (producer != null) {
                    try {
                        xaconnection.close();
                    }
                    catch (Throwable throwable) {
                        ((Throwable)producer).addSuppressed(throwable);
                    }
                } else {
                    xaconnection.close();
                }
            }
        }
        this.connection.start();
        session = this.connection.createSession(true, 0);
        try (MessageConsumer consumer = session.createConsumer((Destination)queue);){
            for (int i = 5; i < 10; ++i) {
                TextMessage txt = (TextMessage)consumer.receive(5000L);
                Assert.assertEquals((Object)("testXX" + i), (Object)txt.getText());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testTempQueueSendAfterConnectionClose() throws Exception {
        Connection connection1 = null;
        Connection connection2 = this.factory.createConnection();
        try {
            connection1 = this.factory.createConnection();
            connection1.start();
            connection2.start();
            Session session1 = connection1.createSession(false, 1);
            TemporaryQueue tempQueue = session1.createTemporaryQueue();
            Session session2 = connection2.createSession(false, 1);
            MessageProducer producer = session2.createProducer((Destination)tempQueue);
            SimpleOpenWireTest.assertTrue((boolean)Wait.waitFor(() -> ((ActiveMQConnection)connection2).activeTempDestinations.size() == 1, (long)2000L, (long)100L));
            producer.setDeliveryMode(1);
            TextMessage m = session2.createTextMessage("Hello temp queue");
            producer.send((Message)m);
            MessageConsumer consumer = session1.createConsumer((Destination)tempQueue);
            TextMessage received = (TextMessage)consumer.receive(5000L);
            SimpleOpenWireTest.assertNotNull((Object)received);
            SimpleOpenWireTest.assertEquals((Object)"Hello temp queue", (Object)received.getText());
            connection1.close();
            SimpleOpenWireTest.assertTrue((boolean)Wait.waitFor(() -> ((ActiveMQConnection)connection2).activeTempDestinations.size() == 0, (long)2000L, (long)100L));
            this.waitForBindings(this.server, tempQueue.getQueueName(), true, 0, 0, 5000L);
            try {
                producer.send((Message)m);
                SimpleOpenWireTest.fail((String)"Send should fail since temp destination should not exist anymore.");
            }
            catch (InvalidDestinationException invalidDestinationException) {
                // empty catch block
            }
        }
        finally {
            if (connection1 != null) {
                connection1.close();
            }
            if (connection2 != null) {
                connection2.close();
            }
        }
    }

    @Test
    public void testNotificationProperties() throws Exception {
        try (TopicConnection topicConnection = this.factory.createTopicConnection();){
            TopicSession topicSession = topicConnection.createTopicSession(false, 1);
            Topic notificationsTopic = topicSession.createTopic("activemq.notifications");
            TopicSubscriber subscriber = topicSession.createSubscriber(notificationsTopic);
            CopyOnWriteArrayList receivedMessages = new CopyOnWriteArrayList();
            subscriber.setMessageListener(receivedMessages::add);
            topicConnection.start();
            Wait.waitFor(() -> receivedMessages.size() > 0);
            Assert.assertTrue((receivedMessages.size() > 0 ? (byte)1 : 0) != 0);
            for (Message message : receivedMessages) {
                SimpleOpenWireTest.assertNotNull((Object)message);
                SimpleOpenWireTest.assertNotNull((Object)message.getStringProperty("_AMQ_NotifType"));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testXAResourceCommitSuspendedNotRemoved() throws Exception {
        Queue queue = null;
        XidImpl xid = this.newXID();
        try (XAConnection xaconnection = this.xaFactory.createXAConnection();){
            XASession session = xaconnection.createXASession();
            queue = session.createQueue(this.queueName);
            session.getXAResource().start((Xid)xid, 0);
            session.getXAResource().end((Xid)xid, 0x2000000);
            XidImpl xid1 = new XidImpl((Xid)xid);
            Transaction transaction = this.server.getResourceManager().getTransaction((Xid)xid1);
            transaction.suspend();
            session.getXAResource().commit((Xid)xid, true);
        }
        catch (XAException xid1) {
        }
        finally {
            XidImpl xid1 = new XidImpl((Xid)xid);
            Transaction transaction = this.server.getResourceManager().getTransaction((Xid)xid1);
            SimpleOpenWireTest.assertNotNull((Object)transaction);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testXAResourceRolledBackSuspendedNotRemoved() throws Exception {
        Queue queue = null;
        XidImpl xid = this.newXID();
        try (XAConnection xaconnection = this.xaFactory.createXAConnection();){
            XASession session = xaconnection.createXASession();
            queue = session.createQueue(this.queueName);
            session.getXAResource().start((Xid)xid, 0);
            session.getXAResource().end((Xid)xid, 0x2000000);
            XidImpl xid1 = new XidImpl((Xid)xid);
            Transaction transaction = this.server.getResourceManager().getTransaction((Xid)xid1);
            transaction.suspend();
            session.getXAResource().rollback((Xid)xid);
        }
        catch (XAException xid1) {
        }
        finally {
            XidImpl xid1 = new XidImpl((Xid)xid);
            Transaction transaction = this.server.getResourceManager().getTransaction((Xid)xid1);
            SimpleOpenWireTest.assertNotNull((Object)transaction);
        }
    }

    @Test
    public void testXAResourceCommittedRemoved() throws Exception {
        Queue queue = null;
        XidImpl xid = this.newXID();
        try (XAConnection xaconnection = this.xaFactory.createXAConnection();){
            XASession session = xaconnection.createXASession();
            queue = session.createQueue(this.queueName);
            session.getXAResource().start((Xid)xid, 0);
            MessageProducer producer = session.createProducer((Destination)queue);
            producer.send((Message)session.createTextMessage("xa message"));
            session.getXAResource().end((Xid)xid, 0x4000000);
            session.getXAResource().commit((Xid)xid, true);
        }
        XidImpl xid1 = new XidImpl((Xid)xid);
        Transaction transaction = this.server.getResourceManager().getTransaction((Xid)xid1);
        SimpleOpenWireTest.assertNull((Object)transaction);
    }

    @Test
    public void testXAResourceRolledBackRemoved() throws Exception {
        Queue queue = null;
        XidImpl xid = this.newXID();
        try (XAConnection xaconnection = this.xaFactory.createXAConnection();){
            XASession session = xaconnection.createXASession();
            queue = session.createQueue(this.queueName);
            session.getXAResource().start((Xid)xid, 0);
            MessageProducer producer = session.createProducer((Destination)queue);
            producer.send((Message)session.createTextMessage("xa message"));
            session.getXAResource().end((Xid)xid, 0x4000000);
            session.getXAResource().rollback((Xid)xid);
        }
        XidImpl xid1 = new XidImpl((Xid)xid);
        Transaction transaction = this.server.getResourceManager().getTransaction((Xid)xid1);
        SimpleOpenWireTest.assertNull((Object)transaction);
    }

    @Test
    public void testPropertyConversions() throws Exception {
        String BROKER_PATH = RandomUtil.randomString();
        String CLUSTER = RandomUtil.randomString();
        String USER_ID = RandomUtil.randomString();
        try (Connection connection = this.factory.createConnection();){
            Session session = connection.createSession(false, 1);
            Queue queue = session.createQueue(this.queueName);
            MessageProducer producer = session.createProducer((Destination)queue);
            TextMessage message = session.createTextMessage("This is a text message");
            message.setStringProperty("__HDR_BROKER_PATH", BROKER_PATH);
            message.setStringProperty("__HDR_CLUSTER", CLUSTER);
            message.setStringProperty("__HDR_USER_ID", USER_ID);
            producer.send((Message)message);
            MessageConsumer messageConsumer = session.createConsumer((Destination)queue);
            connection.start();
            TextMessage messageReceived = (TextMessage)messageConsumer.receive(5000L);
            SimpleOpenWireTest.assertNotNull((Object)messageReceived);
            SimpleOpenWireTest.assertEquals((Object)BROKER_PATH, (Object)messageReceived.getStringProperty("__HDR_BROKER_PATH"));
            SimpleOpenWireTest.assertEquals((Object)CLUSTER, (Object)messageReceived.getStringProperty("__HDR_CLUSTER"));
            SimpleOpenWireTest.assertEquals((Object)USER_ID, (Object)messageReceived.getStringProperty("__HDR_USER_ID"));
        }
    }

    private void checkQueueEmpty(String qName) {
        PostOffice po = this.server.getPostOffice();
        LocalQueueBinding binding = (LocalQueueBinding)po.getBinding(SimpleString.toSimpleString((String)qName));
        try {
            Thread.sleep(1000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        SimpleOpenWireTest.assertEquals((long)0L, (long)binding.getQueue().getMessageCount());
    }

    private class AsyncConsumer {
        private List<Message> messages = new ArrayList<Message>();
        private CountDownLatch latch = new CountDownLatch(1);
        private int nMsgs;
        private String queueName;
        private MessageConsumer consumer;

        AsyncConsumer(String queueName, Connection receiveConnection, final int ackMode, final long delay, final int expectedMsgs) throws JMSException {
            this.queueName = queueName;
            this.nMsgs = expectedMsgs;
            Session session = receiveConnection.createSession(false, ackMode);
            Queue queue = session.createQueue(queueName);
            this.consumer = session.createConsumer((Destination)queue);
            this.consumer.setMessageListener(new MessageListener(){

                public void onMessage(Message message) {
                    AsyncConsumer.this.messages.add(message);
                    if (AsyncConsumer.this.messages.size() < expectedMsgs) {
                        try {
                            TimeUnit.SECONDS.sleep(delay);
                        }
                        catch (InterruptedException e) {
                            e.printStackTrace();
                        }
                    }
                    if (ackMode == 2) {
                        try {
                            message.acknowledge();
                        }
                        catch (JMSException e) {
                            System.err.println("Failed to acknowledge " + message);
                            e.printStackTrace();
                        }
                    }
                    if (AsyncConsumer.this.messages.size() == expectedMsgs) {
                        AsyncConsumer.this.latch.countDown();
                    }
                }
            });
            receiveConnection.start();
        }

        public void waitFor(long timeout) throws TimeoutException, InterruptedException, JMSException {
            boolean result = this.latch.await(timeout, TimeUnit.SECONDS);
            Assert.assertTrue((boolean)result);
            SimpleOpenWireTest.this.checkQueueEmpty(this.queueName);
            Assert.assertEquals((long)this.nMsgs, (long)this.messages.size());
        }
    }
}

