/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.server;

import java.util.ArrayList;
import org.apache.activemq.artemis.api.core.ActiveMQException;
import org.apache.activemq.artemis.api.core.ActiveMQQueueExistsException;
import org.apache.activemq.artemis.api.core.Message;
import org.apache.activemq.artemis.api.core.QueueConfiguration;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.api.core.client.ClientConsumer;
import org.apache.activemq.artemis.api.core.client.ClientMessage;
import org.apache.activemq.artemis.api.core.client.ClientProducer;
import org.apache.activemq.artemis.api.core.client.ClientSession;
import org.apache.activemq.artemis.api.core.client.ClientSessionFactory;
import org.apache.activemq.artemis.api.core.client.ServerLocator;
import org.apache.activemq.artemis.core.config.Configuration;
import org.apache.activemq.artemis.core.postoffice.Bindings;
import org.apache.activemq.artemis.core.server.ActiveMQServer;
import org.apache.activemq.artemis.core.server.ActiveMQServers;
import org.apache.activemq.artemis.tests.util.ActiveMQTestBase;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class PredefinedQueueTest
extends ActiveMQTestBase {
    private Configuration configuration = null;

    @Before
    public void setUp() throws Exception {
        super.setUp();
        this.configuration = this.createDefaultInVMConfig();
    }

    @Test
    public void testFailOnCreatePredefinedQueues() throws Exception {
        String testAddress = "testAddress";
        String queueName1 = "queue1";
        String queueName2 = "queue2";
        String queueName3 = "queue3";
        QueueConfiguration queue1 = new QueueConfiguration("queue1").setAddress("testAddress");
        QueueConfiguration queue2 = new QueueConfiguration("queue2").setAddress("testAddress");
        QueueConfiguration queue3 = new QueueConfiguration("queue3").setAddress("testAddress");
        ArrayList<QueueConfiguration> queueConfs = new ArrayList<QueueConfiguration>();
        queueConfs.add(queue1);
        queueConfs.add(queue2);
        queueConfs.add(queue3);
        this.configuration.setQueueConfigs(queueConfs);
        ActiveMQServer server = this.addServer(ActiveMQServers.newActiveMQServer((Configuration)this.configuration, (boolean)false));
        server.start();
        ServerLocator locator = this.createInVMNonHALocator();
        ClientSessionFactory sf = this.createSessionFactory(locator);
        ClientSession session = this.addClientSession(sf.createSession(false, true, true));
        try {
            session.createQueue(new QueueConfiguration("queue1").setAddress("testAddress").setFilterString("").setDurable(Boolean.valueOf(false)));
            Assert.fail((String)"Should throw exception");
        }
        catch (ActiveMQQueueExistsException activeMQQueueExistsException) {
        }
        catch (ActiveMQException e) {
            PredefinedQueueTest.fail((String)("Invalid Exception type:" + e.getType()));
        }
        try {
            session.createQueue(new QueueConfiguration("queue2").setAddress("testAddress").setDurable(Boolean.valueOf(false)));
            Assert.fail((String)"Should throw exception");
        }
        catch (ActiveMQQueueExistsException e) {
        }
        catch (ActiveMQException e) {
            PredefinedQueueTest.fail((String)("Invalid Exception type:" + e.getType()));
        }
        try {
            session.createQueue(new QueueConfiguration("queue3").setAddress("testAddress").setDurable(Boolean.valueOf(false)));
            Assert.fail((String)"Should throw exception");
        }
        catch (ActiveMQQueueExistsException e) {
        }
        catch (ActiveMQException e) {
            PredefinedQueueTest.fail((String)("Invalid Exception type:" + e.getType()));
        }
    }

    @Test
    public void testDeploySameNames() throws Exception {
        ClientMessage message;
        int i;
        String testAddress = "testAddress";
        String queueName1 = "queue1";
        String queueName2 = "queue2";
        QueueConfiguration queue1 = new QueueConfiguration("queue1").setAddress("testAddress");
        QueueConfiguration queue2 = new QueueConfiguration("queue2").setAddress("testAddress");
        this.configuration.addQueueConfiguration(queue1).addQueueConfiguration(queue2);
        ActiveMQServer server = this.addServer(ActiveMQServers.newActiveMQServer((Configuration)this.configuration, (boolean)false));
        server.start();
        Bindings bindings = server.getPostOffice().getBindingsForAddress(new SimpleString("testAddress"));
        Assert.assertEquals((long)2L, (long)bindings.getBindings().size());
        ServerLocator locator = this.createInVMNonHALocator();
        ClientSessionFactory sf = this.createSessionFactory(locator);
        ClientSession session = this.addClientSession(sf.createSession(false, true, true));
        session.start();
        ClientProducer producer = this.addClientProducer(session.createProducer(new SimpleString("testAddress")));
        ClientConsumer consumer1 = this.addClientConsumer(session.createConsumer("queue1"));
        ClientConsumer consumer2 = this.addClientConsumer(session.createConsumer("queue2"));
        int numMessages = 10;
        SimpleString propKey = new SimpleString("testkey");
        for (i = 0; i < 10; ++i) {
            message = session.createMessage(false);
            message.putIntProperty(propKey, i);
            producer.send((Message)message);
        }
        for (i = 0; i < 10; ++i) {
            message = consumer1.receive(200L);
            Assert.assertNotNull((Object)message);
            Assert.assertEquals((Object)i, (Object)message.getObjectProperty(propKey));
            message.acknowledge();
            message = consumer2.receive(200L);
            Assert.assertNotNull((Object)message);
            Assert.assertEquals((Object)i, (Object)message.getObjectProperty(propKey));
            message.acknowledge();
        }
        Assert.assertNull((Object)consumer1.receiveImmediate());
        Assert.assertNull((Object)consumer2.receiveImmediate());
    }

    @Test
    public void testDeployPreexistingQueues() throws Exception {
        ClientMessage message;
        int i;
        String testAddress = "testAddress";
        String queueName1 = "queue1";
        String queueName2 = "queue2";
        String queueName3 = "queue3";
        ActiveMQServer server = this.addServer(ActiveMQServers.newActiveMQServer((Configuration)this.configuration));
        server.start();
        ServerLocator locator = this.createInVMNonHALocator();
        ClientSessionFactory sf = this.createSessionFactory(locator);
        ClientSession session = this.addClientSession(sf.createSession(false, true, true));
        session.createQueue(new QueueConfiguration("queue1").setAddress("testAddress"));
        session.createQueue(new QueueConfiguration("queue2").setAddress("testAddress"));
        session.createQueue(new QueueConfiguration("queue3").setAddress("testAddress"));
        session.close();
        sf.close();
        server.stop();
        QueueConfiguration queue1 = new QueueConfiguration("queue1").setAddress("testAddress");
        QueueConfiguration queue2 = new QueueConfiguration("queue2").setAddress("testAddress");
        QueueConfiguration queue3 = new QueueConfiguration("queue3").setAddress("testAddress");
        this.configuration.addQueueConfiguration(queue1).addQueueConfiguration(queue2).addQueueConfiguration(queue3);
        server.start();
        sf = this.createSessionFactory(locator);
        session = this.addClientSession(sf.createSession(false, true, true));
        session.start();
        ClientProducer producer = session.createProducer(new SimpleString("testAddress"));
        ClientConsumer consumer1 = session.createConsumer("queue1");
        ClientConsumer consumer2 = session.createConsumer("queue2");
        ClientConsumer consumer3 = session.createConsumer("queue3");
        int numMessages = 10;
        SimpleString propKey = new SimpleString("testkey");
        for (i = 0; i < 10; ++i) {
            message = session.createMessage(false);
            message.putIntProperty(propKey, i);
            producer.send((Message)message);
        }
        for (i = 0; i < 10; ++i) {
            message = consumer1.receive(200L);
            Assert.assertNotNull((Object)message);
            Assert.assertEquals((Object)i, (Object)message.getObjectProperty(propKey));
            message.acknowledge();
            message = consumer2.receive(200L);
            Assert.assertNotNull((Object)message);
            Assert.assertEquals((Object)i, (Object)message.getObjectProperty(propKey));
            message.acknowledge();
            message = consumer3.receive(200L);
            Assert.assertNotNull((Object)message);
            Assert.assertEquals((Object)i, (Object)message.getObjectProperty(propKey));
            message.acknowledge();
        }
        Assert.assertNull((Object)consumer1.receiveImmediate());
        Assert.assertNull((Object)consumer2.receiveImmediate());
        Assert.assertNull((Object)consumer3.receiveImmediate());
    }

    @Test
    public void testDurableNonDurable() throws Exception {
        String testAddress = "testAddress";
        String queueName1 = "queue1";
        String queueName2 = "queue2";
        QueueConfiguration queue1 = new QueueConfiguration("queue1").setAddress("testAddress").setDurable(Boolean.valueOf(false));
        QueueConfiguration queue2 = new QueueConfiguration("queue2").setAddress("testAddress");
        ArrayList<QueueConfiguration> queueConfs = new ArrayList<QueueConfiguration>();
        queueConfs.add(queue1);
        queueConfs.add(queue2);
        this.configuration.addQueueConfiguration(queue1).addQueueConfiguration(queue2);
        ActiveMQServer server = this.addServer(ActiveMQServers.newActiveMQServer((Configuration)this.configuration));
        server.start();
        ServerLocator locator = this.createInVMNonHALocator();
        ClientSessionFactory sf = this.createSessionFactory(locator);
        ClientSession session = this.addClientSession(sf.createSession(false, true, true));
        ClientProducer producer = session.createProducer(new SimpleString("testAddress"));
        SimpleString propKey = new SimpleString("testkey");
        boolean numMessages = true;
        this.instanceLog.debug((Object)"sending messages");
        for (int i = 0; i < 1; ++i) {
            ClientMessage message = session.createMessage(true);
            message.putIntProperty(propKey, i);
            producer.send((Message)message);
        }
        session.close();
        this.instanceLog.debug((Object)"stopping");
        sf.close();
        server.stop();
        server.start();
        sf = this.createSessionFactory(locator);
        session = this.addClientSession(sf.createSession(false, true, true));
        session.start();
        ClientConsumer consumer1 = session.createConsumer("queue1");
        ClientConsumer consumer2 = session.createConsumer("queue2");
        ClientMessage message = consumer1.receiveImmediate();
        Assert.assertNull((Object)message);
        for (int i = 0; i < 1; ++i) {
            message = consumer2.receive(200L);
            Assert.assertNotNull((Object)message);
            Assert.assertEquals((Object)i, (Object)message.getObjectProperty(propKey));
            message.acknowledge();
        }
        Assert.assertNull((Object)consumer1.receiveImmediate());
        Assert.assertNull((Object)consumer2.receiveImmediate());
    }

    @Test
    public void testDeployWithFilter() throws Exception {
        ClientMessage message;
        int i;
        String testAddress = "testAddress";
        String queueName1 = "queue1";
        String filter = "cheese='camembert'";
        QueueConfiguration queue1 = new QueueConfiguration("queue1").setAddress("testAddress").setFilterString("cheese='camembert'").setDurable(Boolean.valueOf(false));
        this.configuration.addQueueConfiguration(queue1);
        ActiveMQServer server = this.addServer(ActiveMQServers.newActiveMQServer((Configuration)this.configuration, (boolean)false));
        server.start();
        ServerLocator locator = this.createInVMNonHALocator();
        ClientSessionFactory sf = this.createSessionFactory(locator);
        ClientSession session = this.addClientSession(sf.createSession(false, true, true));
        ClientProducer producer = session.createProducer(new SimpleString("testAddress"));
        SimpleString propKey = new SimpleString("testkey");
        boolean numMessages = true;
        this.instanceLog.debug((Object)"sending messages");
        for (int i2 = 0; i2 < 1; ++i2) {
            ClientMessage message2 = session.createMessage(true);
            message2.putStringProperty(new SimpleString("cheese"), new SimpleString("camembert"));
            message2.putIntProperty(propKey, i2);
            producer.send((Message)message2);
        }
        session.start();
        ClientConsumer consumer1 = session.createConsumer("queue1");
        for (i = 0; i < 1; ++i) {
            message = consumer1.receive(200L);
            Assert.assertNotNull((Object)message);
            Assert.assertEquals((Object)i, (Object)message.getObjectProperty(propKey));
            message.acknowledge();
        }
        Assert.assertNull((Object)consumer1.receiveImmediate());
        for (i = 0; i < 1; ++i) {
            message = session.createMessage(true);
            message.putStringProperty(new SimpleString("cheese"), new SimpleString("roquefort"));
            message.putIntProperty(propKey, i);
            producer.send((Message)message);
        }
        Assert.assertNull((Object)consumer1.receiveImmediate());
    }
}

