/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.stomp;

import java.util.Arrays;
import java.util.Collection;
import org.apache.activemq.artemis.api.core.QueueConfiguration;
import org.apache.activemq.artemis.api.core.RoutingType;
import org.apache.activemq.artemis.tests.integration.largemessage.LargeMessageTestBase;
import org.apache.activemq.artemis.tests.integration.stomp.StompTestBase;
import org.apache.activemq.artemis.tests.integration.stomp.util.ClientStompFrame;
import org.apache.activemq.artemis.tests.integration.stomp.util.StompClientConnection;
import org.apache.activemq.artemis.tests.integration.stomp.util.StompClientConnectionFactory;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
@Ignore
public class StompWithLargeMessagesTest
extends StompTestBase {
    @Parameterized.Parameters(name="{0}")
    public static Collection<Object[]> data() {
        return Arrays.asList({"tcp+v10.stomp"}, {"tcp+v12.stomp"});
    }

    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
    }

    @Override
    public boolean isCompressLargeMessages() {
        return true;
    }

    @Override
    public boolean isPersistenceEnabled() {
        return true;
    }

    @Override
    public Integer getStompMinLargeMessageSize() {
        return 2048;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSendReceiveLargeMessage() throws Exception {
        StompClientConnection conn = StompClientConnectionFactory.createClientConnection(this.uri);
        try {
            String address = "testLargeMessageAddress";
            this.server.createQueue(new QueueConfiguration(address).setRoutingType(RoutingType.ANYCAST));
            int largeMessageStringSize = 0xA00000;
            StringBuilder b = new StringBuilder(largeMessageStringSize);
            for (int i = 0; i < largeMessageStringSize; ++i) {
                b.append('t');
            }
            String payload = b.toString();
            conn.connect(this.defUser, this.defPass);
            StompWithLargeMessagesTest.subscribe(conn, null, "auto", null, null, address, true);
            StompWithLargeMessagesTest.send(conn, address, null, payload);
            ClientStompFrame frame = conn.receiveFrame();
            StompWithLargeMessagesTest.assertTrue((boolean)frame.getBody().equals(payload));
        }
        finally {
            conn.disconnect();
        }
    }

    @Test
    public void testSendReceiveLargePersistentMessages() throws Exception {
        StompClientConnection conn = StompClientConnectionFactory.createClientConnection(this.uri);
        conn.connect(this.defUser, this.defPass);
        int count = 10;
        int msgSize = 0x100000;
        char[] contents = new char[msgSize];
        for (int i = 0; i < msgSize; ++i) {
            contents[i] = 65;
        }
        String body = new String(contents);
        for (int i = 0; i < count; ++i) {
            ClientStompFrame frame = conn.createFrame("SEND");
            frame.addHeader("destination", StompWithLargeMessagesTest.getQueuePrefix() + StompWithLargeMessagesTest.getQueueName());
            frame.addHeader("persistent", "true");
            frame.setBody(body);
            conn.sendFrame(frame);
        }
        ClientStompFrame subFrame = conn.createFrame("SUBSCRIBE");
        subFrame.addHeader("subscription-type", "ANYCAST");
        subFrame.addHeader("destination", StompWithLargeMessagesTest.getQueuePrefix() + StompWithLargeMessagesTest.getQueueName());
        subFrame.addHeader("ack", "auto");
        conn.sendFrame(subFrame);
        for (int i = 0; i < count; ++i) {
            ClientStompFrame frame = conn.receiveFrame(60000L);
            Assert.assertNotNull((Object)frame);
            Assert.assertTrue((boolean)frame.getCommand().equals("MESSAGE"));
            Assert.assertTrue((boolean)frame.getHeader("destination").equals(StompWithLargeMessagesTest.getQueuePrefix() + StompWithLargeMessagesTest.getQueueName()));
            int index = frame.getBody().indexOf("AAAA");
            StompWithLargeMessagesTest.assertEquals((long)msgSize, (long)(frame.getBody().length() - index));
        }
        ClientStompFrame unsubFrame = conn.createFrame("UNSUBSCRIBE");
        unsubFrame.addHeader("destination", StompWithLargeMessagesTest.getQueuePrefix() + StompWithLargeMessagesTest.getQueueName());
        unsubFrame.addHeader("receipt", "567");
        ClientStompFrame response = conn.sendFrame(unsubFrame);
        StompWithLargeMessagesTest.assertNotNull((Object)response);
        StompWithLargeMessagesTest.assertNotNull((Object)response.getCommand().equals("RECEIPT"));
        conn.disconnect();
    }

    @Test
    public void testReceiveLargePersistentMessagesFromCore() throws Exception {
        StompClientConnection conn = StompClientConnectionFactory.createClientConnection(this.uri);
        conn.connect(this.defUser, this.defPass);
        int msgSize = 307200;
        char[] contents = new char[msgSize];
        for (int i = 0; i < msgSize; ++i) {
            contents[i] = 66;
        }
        String msg = new String(contents);
        int count = 10;
        for (int i = 0; i < count; ++i) {
            this.sendJmsMessage(msg);
        }
        ClientStompFrame subFrame = conn.createFrame("SUBSCRIBE");
        subFrame.addHeader("subscription-type", "ANYCAST");
        subFrame.addHeader("destination", StompWithLargeMessagesTest.getQueuePrefix() + StompWithLargeMessagesTest.getQueueName());
        subFrame.addHeader("ack", "auto");
        conn.sendFrame(subFrame);
        for (int i = 0; i < count; ++i) {
            ClientStompFrame frame = conn.receiveFrame(60000L);
            Assert.assertNotNull((Object)frame);
            Assert.assertTrue((boolean)frame.getCommand().equals("MESSAGE"));
            Assert.assertTrue((boolean)frame.getHeader("destination").equals(StompWithLargeMessagesTest.getQueuePrefix() + StompWithLargeMessagesTest.getQueueName()));
            int index = frame.getBody().indexOf("BBB");
            StompWithLargeMessagesTest.assertEquals((long)msgSize, (long)(frame.getBody().length() - index));
        }
        ClientStompFrame unsubFrame = conn.createFrame("UNSUBSCRIBE");
        unsubFrame.addHeader("destination", StompWithLargeMessagesTest.getQueuePrefix() + StompWithLargeMessagesTest.getQueueName());
        unsubFrame.addHeader("receipt", "567");
        ClientStompFrame response = conn.sendFrame(unsubFrame);
        StompWithLargeMessagesTest.assertNotNull((Object)response);
        StompWithLargeMessagesTest.assertNotNull((Object)response.getCommand().equals("RECEIPT"));
        conn.disconnect();
    }

    @Test
    public void testReceiveLargeCompressedToRegularPersistentMessagesFromCore() throws Exception {
        StompClientConnection conn = StompClientConnectionFactory.createClientConnection(this.uri);
        conn.connect(this.defUser, this.defPass);
        LargeMessageTestBase.TestLargeMessageInputStream input = new LargeMessageTestBase.TestLargeMessageInputStream(102400, true);
        LargeMessageTestBase.adjustLargeCompression(true, input, 102400);
        char[] contents = input.toArray();
        String msg = new String(contents);
        String leadingPart = msg.substring(0, 100);
        int count = 10;
        for (int i = 0; i < count; ++i) {
            this.sendJmsMessage(msg);
        }
        ClientStompFrame subFrame = conn.createFrame("SUBSCRIBE");
        subFrame.addHeader("subscription-type", "ANYCAST");
        subFrame.addHeader("destination", StompWithLargeMessagesTest.getQueuePrefix() + StompWithLargeMessagesTest.getQueueName());
        subFrame.addHeader("ack", "auto");
        conn.sendFrame(subFrame);
        for (int i = 0; i < count; ++i) {
            ClientStompFrame receiveFrame = conn.receiveFrame(30000L);
            Assert.assertNotNull((Object)receiveFrame);
            Assert.assertTrue((boolean)receiveFrame.getCommand().equals("MESSAGE"));
            Assert.assertEquals((Object)receiveFrame.getHeader("destination"), (Object)(StompWithLargeMessagesTest.getQueuePrefix() + StompWithLargeMessagesTest.getQueueName()));
            int index = receiveFrame.getBody().indexOf(leadingPart);
            StompWithLargeMessagesTest.assertEquals((long)msg.length(), (long)(receiveFrame.getBody().length() - index));
        }
        ClientStompFrame unsubFrame = conn.createFrame("UNSUBSCRIBE");
        unsubFrame.addHeader("destination", StompWithLargeMessagesTest.getQueuePrefix() + StompWithLargeMessagesTest.getQueueName());
        unsubFrame.addHeader("receipt", "567");
        ClientStompFrame response = conn.sendFrame(unsubFrame);
        StompWithLargeMessagesTest.assertNotNull((Object)response);
        StompWithLargeMessagesTest.assertNotNull((Object)response.getCommand().equals("RECEIPT"));
        conn.disconnect();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testReceiveLargeCompressedToLargePersistentMessagesFromCore() throws Exception {
        StompClientConnection conn = StompClientConnectionFactory.createClientConnection(this.uri);
        try {
            LargeMessageTestBase.TestLargeMessageInputStream input = new LargeMessageTestBase.TestLargeMessageInputStream(102400, true);
            input.setSize(1024000);
            LargeMessageTestBase.adjustLargeCompression(false, input, 1024000);
            char[] contents = input.toArray();
            String msg = new String(contents);
            String leadingPart = msg.substring(0, 100);
            int count = 10;
            for (int i = 0; i < count; ++i) {
                this.sendJmsMessage(msg);
            }
            conn.connect(this.defUser, this.defPass);
            ClientStompFrame subFrame = conn.createFrame("SUBSCRIBE");
            subFrame.addHeader("subscription-type", "ANYCAST");
            subFrame.addHeader("destination", StompWithLargeMessagesTest.getQueuePrefix() + StompWithLargeMessagesTest.getQueueName());
            subFrame.addHeader("ack", "auto");
            conn.sendFrame(subFrame);
            for (int i = 0; i < count; ++i) {
                ClientStompFrame frame = conn.receiveFrame(60000L);
                Assert.assertNotNull((Object)frame);
                this.instanceLog.debug((Object)frame.toString());
                this.instanceLog.debug((Object)("part of frame: " + frame.getBody().substring(0, 250)));
                Assert.assertTrue((boolean)frame.getCommand().equals("MESSAGE"));
                Assert.assertTrue((boolean)frame.getHeader("destination").equals(StompWithLargeMessagesTest.getQueuePrefix() + StompWithLargeMessagesTest.getQueueName()));
                int index = frame.getBody().toString().indexOf(leadingPart);
                StompWithLargeMessagesTest.assertEquals((long)msg.length(), (long)(frame.getBody().toString().length() - index));
            }
            ClientStompFrame unsubFrame = conn.createFrame("UNSUBSCRIBE");
            unsubFrame.addHeader("destination", StompWithLargeMessagesTest.getQueuePrefix() + StompWithLargeMessagesTest.getQueueName());
            unsubFrame.addHeader("receipt", "567");
            conn.sendFrame(unsubFrame);
        }
        finally {
            conn.disconnect();
            conn.closeTransport();
        }
    }
}

