/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.clustering.controller;

import java.util.Map;
import java.util.function.Predicate;
import org.jboss.as.clustering.controller.Capability;
import org.jboss.as.clustering.controller.Registration;
import org.jboss.as.clustering.controller.ResourceServiceHandler;
import org.jboss.as.clustering.controller.WriteAttributeStepHandlerDescriptor;
import org.jboss.as.controller.AbstractWriteAttributeHandler;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.ReloadRequiredWriteAttributeHandler;
import org.jboss.as.controller.registry.AttributeAccess;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.dmr.ModelNode;

public class WriteAttributeStepHandler
extends ReloadRequiredWriteAttributeHandler
implements Registration<ManagementResourceRegistration> {
    private final WriteAttributeStepHandlerDescriptor descriptor;
    private final ResourceServiceHandler handler;

    public WriteAttributeStepHandler(WriteAttributeStepHandlerDescriptor descriptor) {
        this(descriptor, null);
    }

    public WriteAttributeStepHandler(WriteAttributeStepHandlerDescriptor descriptor, ResourceServiceHandler handler) {
        super(descriptor.getAttributes());
        this.descriptor = descriptor;
        this.handler = handler;
    }

    protected boolean requiresRuntime(OperationContext context) {
        return super.requiresRuntime(context) && this.handler != null;
    }

    @Override
    public void register(ManagementResourceRegistration registration) {
        for (AttributeDefinition attribute : this.descriptor.getAttributes()) {
            registration.registerReadWriteAttribute(attribute, null, (OperationStepHandler)this);
        }
    }

    protected void recordCapabilitiesAndRequirements(OperationContext context, AttributeDefinition attribute, ModelNode newValue, ModelNode oldValue) {
        Map<Capability, Predicate<ModelNode>> capabilities = this.descriptor.getCapabilities();
        if (!capabilities.isEmpty()) {
            PathAddress address = context.getCurrentAddress();
            ModelNode newModel = context.readResource(PathAddress.EMPTY_ADDRESS).getModel();
            ModelNode oldModel = newModel.clone();
            oldModel.get(attribute.getName()).set(oldValue);
            for (Map.Entry<Capability, Predicate<ModelNode>> entry : capabilities.entrySet()) {
                Capability capability = entry.getKey();
                Predicate<ModelNode> predicate = entry.getValue();
                boolean registered = predicate.test(oldModel);
                boolean shouldRegister = predicate.test(newModel);
                if (!registered && shouldRegister) {
                    context.registerCapability(capability.resolve(address));
                    continue;
                }
                if (!registered || shouldRegister) continue;
                context.deregisterCapability(capability.resolve(address).getName());
            }
        }
        super.recordCapabilitiesAndRequirements(context, attribute, newValue, oldValue);
    }

    protected boolean applyUpdateToRuntime(OperationContext context, ModelNode operation, String attributeName, ModelNode resolvedValue, ModelNode currentValue, AbstractWriteAttributeHandler.HandbackHolder<Void> handback) throws OperationFailedException {
        boolean updated = super.applyUpdateToRuntime(context, operation, attributeName, resolvedValue, currentValue, handback);
        if (updated) {
            PathAddress address = context.getCurrentAddress();
            if (context.isResourceServiceRestartAllowed() && this.getAttributeDefinition(attributeName).getFlags().contains(AttributeAccess.Flag.RESTART_RESOURCE_SERVICES) && context.markResourceRestarted(address, (Object)this.handler)) {
                this.restartServices(context);
                return false;
            }
        }
        return updated;
    }

    protected void revertUpdateToRuntime(OperationContext context, ModelNode operation, String attributeName, ModelNode valueToRestore, ModelNode resolvedValue, Void handback) throws OperationFailedException {
        PathAddress address = context.getCurrentAddress();
        if (context.isResourceServiceRestartAllowed() && this.getAttributeDefinition(attributeName).getFlags().contains(AttributeAccess.Flag.RESTART_RESOURCE_SERVICES) && context.revertResourceRestarted(address, (Object)this.handler)) {
            this.restartServices(context);
        }
    }

    private void restartServices(OperationContext context) throws OperationFailedException {
        this.handler.removeServices(context, context.getOriginalRootResource().navigate(context.getCurrentAddress()).getModel());
        this.handler.installServices(context, context.readResource(PathAddress.EMPTY_ADDRESS).getModel());
    }
}

