/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.bytecode.enhance.spi;

import jakarta.persistence.ElementCollection;
import jakarta.persistence.Embeddable;
import jakarta.persistence.Entity;
import jakarta.persistence.ManyToMany;
import jakarta.persistence.MappedSuperclass;
import jakarta.persistence.OneToMany;
import jakarta.persistence.Transient;
import org.hibernate.bytecode.enhance.spi.EnhancementContext;
import org.hibernate.bytecode.enhance.spi.UnloadedClass;
import org.hibernate.bytecode.enhance.spi.UnloadedField;

public class DefaultEnhancementContext
implements EnhancementContext {
    @Override
    public ClassLoader getLoadingClassLoader() {
        return this.getClass().getClassLoader();
    }

    @Override
    public boolean isEntityClass(UnloadedClass classDescriptor) {
        return classDescriptor.hasAnnotation(Entity.class);
    }

    @Override
    public boolean isCompositeClass(UnloadedClass classDescriptor) {
        return classDescriptor.hasAnnotation(Embeddable.class);
    }

    @Override
    public boolean isMappedSuperclassClass(UnloadedClass classDescriptor) {
        return classDescriptor.hasAnnotation(MappedSuperclass.class);
    }

    @Override
    public boolean doBiDirectionalAssociationManagement(UnloadedField field) {
        return true;
    }

    @Override
    public boolean doDirtyCheckingInline(UnloadedClass classDescriptor) {
        return true;
    }

    @Override
    public boolean doExtendedEnhancement(UnloadedClass classDescriptor) {
        return false;
    }

    @Override
    public boolean hasLazyLoadableAttributes(UnloadedClass classDescriptor) {
        return true;
    }

    @Override
    public boolean isLazyLoadable(UnloadedField field) {
        return true;
    }

    @Override
    public boolean isPersistentField(UnloadedField ctField) {
        return !ctField.hasAnnotation(Transient.class);
    }

    @Override
    public boolean isMappedCollection(UnloadedField field) {
        return field.hasAnnotation(OneToMany.class) || field.hasAnnotation(ManyToMany.class) || field.hasAnnotation(ElementCollection.class);
    }

    @Override
    public UnloadedField[] order(UnloadedField[] persistentFields) {
        return persistentFields;
    }
}

