/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.el;

import jakarta.el.ELContext;
import jakarta.el.ELException;
import jakarta.el.ELResolver;
import jakarta.faces.context.FacesContext;
import jakarta.faces.el.EvaluationException;
import jakarta.faces.el.PropertyResolver;
import java.beans.FeatureDescriptor;
import java.util.Iterator;
import java.util.List;

public class PropertyResolverChainWrapper
extends ELResolver {
    private PropertyResolver legacyPR = null;

    public PropertyResolverChainWrapper(PropertyResolver propertyResolver) {
        this.legacyPR = propertyResolver;
    }

    public Object getValue(ELContext context, Object base, Object property) throws ELException {
        Object result;
        if (base == null || property == null) {
            return null;
        }
        context.setPropertyResolved(true);
        FacesContext facesContext = (FacesContext)context.getContext(FacesContext.class);
        ELContext jsfEL = facesContext.getELContext();
        jsfEL.setPropertyResolved(true);
        if (base instanceof List || base.getClass().isArray()) {
            Object indexObj = facesContext.getApplication().getExpressionFactory().coerceToType(property, Integer.class);
            int index = (Integer)indexObj;
            try {
                result = this.legacyPR.getValue(base, index);
            }
            catch (EvaluationException ex) {
                context.setPropertyResolved(false);
                throw new ELException((Throwable)ex);
            }
        }
        try {
            result = this.legacyPR.getValue(base, property);
        }
        catch (EvaluationException ex) {
            context.setPropertyResolved(false);
            throw new ELException((Throwable)ex);
        }
        context.setPropertyResolved(jsfEL.isPropertyResolved());
        return result;
    }

    public Class<?> getType(ELContext context, Object base, Object property) throws ELException {
        Class result;
        if (base == null || property == null) {
            return null;
        }
        context.setPropertyResolved(true);
        FacesContext facesContext = (FacesContext)context.getContext(FacesContext.class);
        ELContext jsfEL = facesContext.getELContext();
        jsfEL.setPropertyResolved(true);
        if (base instanceof List || base.getClass().isArray()) {
            Object indexObj = facesContext.getApplication().getExpressionFactory().coerceToType(property, Integer.class);
            int index = (Integer)indexObj;
            try {
                result = this.legacyPR.getType(base, index);
            }
            catch (EvaluationException ex) {
                context.setPropertyResolved(false);
                throw new ELException((Throwable)ex);
            }
        }
        try {
            result = this.legacyPR.getType(base, property);
        }
        catch (EvaluationException ex) {
            context.setPropertyResolved(false);
            throw new ELException((Throwable)ex);
        }
        context.setPropertyResolved(jsfEL.isPropertyResolved());
        return result;
    }

    public void setValue(ELContext context, Object base, Object property, Object val) throws ELException {
        if (base == null || property == null) {
            return;
        }
        context.setPropertyResolved(true);
        FacesContext facesContext = (FacesContext)context.getContext(FacesContext.class);
        ELContext jsfEL = facesContext.getELContext();
        jsfEL.setPropertyResolved(true);
        if (base instanceof List || base.getClass().isArray()) {
            Object indexObj = facesContext.getApplication().getExpressionFactory().coerceToType(property, Integer.class);
            int index = (Integer)indexObj;
            try {
                this.legacyPR.setValue(base, index, val);
            }
            catch (EvaluationException ex) {
                context.setPropertyResolved(false);
                throw new ELException((Throwable)ex);
            }
        }
        try {
            this.legacyPR.setValue(base, property, val);
        }
        catch (EvaluationException ex) {
            context.setPropertyResolved(false);
            throw new ELException((Throwable)ex);
        }
        context.setPropertyResolved(jsfEL.isPropertyResolved());
    }

    public boolean isReadOnly(ELContext context, Object base, Object property) throws ELException {
        boolean result;
        if (base == null || property == null) {
            return false;
        }
        context.setPropertyResolved(true);
        FacesContext facesContext = (FacesContext)context.getContext(FacesContext.class);
        ELContext jsfEL = facesContext.getELContext();
        jsfEL.setPropertyResolved(true);
        if (base instanceof List || base.getClass().isArray()) {
            Object indexObj = facesContext.getApplication().getExpressionFactory().coerceToType(property, Integer.class);
            int index = (Integer)indexObj;
            try {
                result = this.legacyPR.isReadOnly(base, index);
            }
            catch (EvaluationException ex) {
                context.setPropertyResolved(false);
                throw new ELException((Throwable)ex);
            }
        }
        try {
            result = this.legacyPR.isReadOnly(base, property);
        }
        catch (EvaluationException ex) {
            context.setPropertyResolved(false);
            throw new ELException((Throwable)ex);
        }
        context.setPropertyResolved(jsfEL.isPropertyResolved());
        return result;
    }

    public Iterator<FeatureDescriptor> getFeatureDescriptors(ELContext context, Object base) {
        return null;
    }

    public Class<?> getCommonPropertyType(ELContext context, Object base) {
        if (base == null) {
            return Object.class;
        }
        return null;
    }
}

