/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.plugins.providers.jaxb;

import jakarta.xml.bind.Binder;
import jakarta.xml.bind.JAXBContext;
import jakarta.xml.bind.JAXBException;
import jakarta.xml.bind.JAXBIntrospector;
import jakarta.xml.bind.Marshaller;
import jakarta.xml.bind.PropertyException;
import jakarta.xml.bind.SchemaOutputResolver;
import jakarta.xml.bind.Unmarshaller;
import jakarta.xml.bind.Validator;
import jakarta.xml.bind.annotation.XmlNs;
import java.io.IOException;
import java.io.InputStream;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.function.BiFunction;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import org.jboss.resteasy.annotations.providers.jaxb.JAXBConfig;
import org.jboss.resteasy.plugins.providers.jaxb.hacks.RiHacks;
import org.jboss.resteasy.plugins.providers.jaxb.i18n.LogMessages;
import org.jboss.resteasy.plugins.providers.jaxb.i18n.Messages;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

public class JAXBContextWrapper
extends JAXBContext {
    private static final String NAMESPACE_PREFIX_MAPPER = "com.sun.xml.bind.namespacePrefixMapper";
    private final JAXBContext wrappedContext;
    private final ThreadLocal<Unmarshaller> unmarshaller = new ThreadLocal();
    private Object mapper;
    private Schema schema;

    public JAXBContextWrapper(JAXBContext wrappedContext, JAXBConfig config) throws JAXBException {
        this.processConfig(config);
        this.wrappedContext = wrappedContext;
    }

    public JAXBContextWrapper(final Class<?>[] classes, final Map<String, Object> properties, JAXBConfig config) throws JAXBException {
        this.processConfig(config);
        try {
            this.wrappedContext = System.getSecurityManager() == null ? JAXBContext.newInstance((Class[])classes, properties) : AccessController.doPrivileged(new PrivilegedExceptionAction<JAXBContext>(){

                @Override
                public JAXBContext run() throws JAXBException {
                    return JAXBContext.newInstance((Class[])classes, (Map)properties);
                }
            });
        }
        catch (PrivilegedActionException paex) {
            throw new JAXBException(paex.getMessage());
        }
    }

    public JAXBContextWrapper(final String contextPath, JAXBConfig config) throws JAXBException {
        this.processConfig(config);
        try {
            this.wrappedContext = System.getSecurityManager() == null ? JAXBContext.newInstance((String)contextPath) : AccessController.doPrivileged(new PrivilegedExceptionAction<JAXBContext>(){

                @Override
                public JAXBContext run() throws JAXBException {
                    return JAXBContext.newInstance((String)contextPath);
                }
            });
        }
        catch (PrivilegedActionException paex) {
            throw new JAXBException(paex.getMessage());
        }
    }

    public JAXBContextWrapper(JAXBConfig config, Class<?> ... classes) throws JAXBException {
        this(classes, Collections.emptyMap(), config);
    }

    private void processConfig(JAXBConfig config) throws JAXBException {
        if (config != null) {
            if (config.useNameSpacePrefix()) {
                try {
                    HashMap<String, String> namespaces = new HashMap<String, String>();
                    for (XmlNs xmlNs : config.namespaces()) {
                        namespaces.put(xmlNs.namespaceURI(), xmlNs.prefix());
                    }
                    BiFunction<String, String, String> mapperFunction = (namespace, suggestion) -> {
                        if (namespaces.containsKey(namespace)) {
                            return (String)namespaces.get(namespace);
                        }
                        return suggestion;
                    };
                    this.mapper = RiHacks.createNamespacePrefixMapper(mapperFunction);
                }
                catch (JAXBException e) {
                    throw e;
                }
                catch (Exception e) {
                    throw Messages.MESSAGES.namespacePrefixMapperNotInClassPath(e);
                }
            }
            if (!"".equals(config.schema())) {
                SchemaFactory schemaFactory = SchemaFactory.newInstance(config.schemaType());
                try {
                    InputStream in = Thread.currentThread().getContextClassLoader().getResourceAsStream(config.schema());
                    this.schema = schemaFactory.newSchema(new StreamSource(in));
                }
                catch (SAXException e) {
                    throw new JAXBException(Messages.MESSAGES.errorTryingToLoadSchema(config.schema()), (Throwable)e);
                }
            }
        }
    }

    public Schema getSchema() {
        return this.schema;
    }

    public void setSchema(Schema schema) {
        this.schema = schema;
    }

    public Binder<Node> createBinder() {
        return this.wrappedContext.createBinder();
    }

    public <T> Binder<T> createBinder(Class<T> domType) {
        return this.wrappedContext.createBinder(domType);
    }

    public JAXBIntrospector createJAXBIntrospector() {
        return this.wrappedContext.createJAXBIntrospector();
    }

    public Marshaller createMarshaller() throws JAXBException {
        Marshaller marshaller = RiHacks.createMarshaller(this.wrappedContext);
        if (this.mapper != null) {
            try {
                marshaller.setProperty(NAMESPACE_PREFIX_MAPPER, this.mapper);
            }
            catch (PropertyException e) {
                LogMessages.LOGGER.warn(e.getMessage());
            }
        }
        return marshaller;
    }

    public Unmarshaller createUnmarshaller() throws JAXBException {
        Unmarshaller u = this.unmarshaller.get();
        if (u == null) {
            u = RiHacks.createUnmarshaller(this.wrappedContext);
            this.unmarshaller.set(u);
        }
        return u;
    }

    public Validator createValidator() throws JAXBException {
        return this.wrappedContext.createValidator();
    }

    public void generateSchema(SchemaOutputResolver outputResolver) throws IOException {
        this.wrappedContext.generateSchema(outputResolver);
    }
}

