/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.undertow.security.jaspi;

import io.undertow.server.HttpHandler;
import io.undertow.server.HttpServerExchange;
import io.undertow.servlet.handlers.ServletRequestContext;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import javax.security.auth.Subject;
import javax.security.auth.callback.CallbackHandler;
import org.wildfly.extension.undertow.logging.UndertowLogger;
import org.wildfly.extension.undertow.security.jaspi.JASPICAuthenticationMechanism;
import org.wildfly.extension.undertow.security.jaspi.JASPICContext;

public class JASPICSecureResponseHandler
implements HttpHandler {
    private final HttpHandler next;

    public JASPICSecureResponseHandler(HttpHandler next) {
        this.next = next;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleRequest(HttpServerExchange exchange) throws Exception {
        try {
            this.next.handleRequest(exchange);
        }
        finally {
            try {
                JASPICContext context = (JASPICContext)exchange.getAttachment(JASPICContext.ATTACHMENT_KEY);
                if (!JASPICAuthenticationMechanism.wasAuthExceptionThrown(exchange) && context != null) {
                    ServletRequestContext requestContext = (ServletRequestContext)exchange.getAttachment(ServletRequestContext.ATTACHMENT_KEY);
                    String applicationIdentifier = JASPICAuthenticationMechanism.buildApplicationIdentifier(requestContext);
                    UndertowLogger.ROOT_LOGGER.debugf("secureResponse for layer [%s] and applicationContextIdentifier [%s].", "HttpServlet", applicationIdentifier);
                    context.getSam().secureResponse(context.getMessageInfo(), new Subject(), "HttpServlet", applicationIdentifier, (CallbackHandler)context.getCbh());
                    ServletRequestContext servletRequestContext = (ServletRequestContext)exchange.getAttachment(ServletRequestContext.ATTACHMENT_KEY);
                    servletRequestContext.setServletRequest((ServletRequest)((HttpServletRequest)context.getMessageInfo().getRequestMessage()));
                    servletRequestContext.setServletResponse((ServletResponse)((HttpServletResponse)context.getMessageInfo().getResponseMessage()));
                }
            }
            catch (Exception e) {
                UndertowLogger.ROOT_LOGGER.errorInvokingSecureResponse(e);
            }
        }
    }
}

