/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.api.core.management;

import jakarta.json.JsonArray;
import org.apache.activemq.artemis.api.core.ICoreMessage;
import org.apache.activemq.artemis.api.core.JsonUtil;
import org.apache.activemq.artemis.api.core.Message;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.core.message.impl.CoreMessage;

public final class ManagementHelper {
    public static final SimpleString HDR_RESOURCE_NAME = new SimpleString("_AMQ_ResourceName");
    public static final SimpleString HDR_ATTRIBUTE = new SimpleString("_AMQ_Attribute");
    public static final SimpleString HDR_OPERATION_NAME = new SimpleString("_AMQ_OperationName");
    public static final SimpleString HDR_OPERATION_SUCCEEDED = new SimpleString("_AMQ_OperationSucceeded");
    public static final SimpleString HDR_NOTIFICATION_TYPE = new SimpleString("_AMQ_NotifType");
    public static final SimpleString HDR_NOTIFICATION_TIMESTAMP = new SimpleString("_AMQ_NotifTimestamp");
    public static final SimpleString HDR_ROUTING_NAME = new SimpleString("_AMQ_RoutingName");
    public static final SimpleString HDR_CLUSTER_NAME = new SimpleString("_AMQ_ClusterName");
    public static final SimpleString HDR_ADDRESS = new SimpleString("_AMQ_Address");
    public static final SimpleString HDR_ROUTING_TYPE = new SimpleString("_AMQ_Routing_Type");
    public static final SimpleString HDR_BINDING_ID = new SimpleString("_AMQ_Binding_ID");
    public static final SimpleString HDR_BINDING_TYPE = new SimpleString("_AMQ_Binding_Type");
    public static final SimpleString HDR_FILTERSTRING = new SimpleString("_AMQ_FilterString");
    public static final SimpleString HDR_DISTANCE = new SimpleString("_AMQ_Distance");
    public static final SimpleString HDR_CONSUMER_COUNT = new SimpleString("_AMQ_ConsumerCount");
    public static final SimpleString HDR_USER = new SimpleString("_AMQ_User");
    public static final SimpleString HDR_VALIDATED_USER = new SimpleString("_AMQ_ValidatedUser");
    public static final SimpleString HDR_CERT_SUBJECT_DN = new SimpleString("_AMQ_CertSubjectDN");
    public static final SimpleString HDR_CHECK_TYPE = new SimpleString("_AMQ_CheckType");
    public static final SimpleString HDR_SESSION_NAME = new SimpleString("_AMQ_SessionName");
    public static final SimpleString HDR_REMOTE_ADDRESS = new SimpleString("_AMQ_RemoteAddress");
    public static final SimpleString HDR_PROPOSAL_GROUP_ID = new SimpleString("_JBM_ProposalGroupId");
    public static final SimpleString HDR_PROPOSAL_VALUE = new SimpleString("_JBM_ProposalValue");
    public static final SimpleString HDR_PROPOSAL_ALT_VALUE = new SimpleString("_JBM_ProposalAltValue");
    public static final SimpleString HDR_CONSUMER_NAME = new SimpleString("_AMQ_ConsumerName");
    public static final SimpleString HDR_CONNECTION_NAME = new SimpleString("_AMQ_ConnectionName");
    public static final SimpleString HDR_MESSAGE_ID = new SimpleString("_AMQ_Message_ID");
    public static final SimpleString HDR_PROTOCOL_NAME = new SimpleString("_AMQ_Protocol_Name");
    public static final SimpleString HDR_CLIENT_ID = new SimpleString("_AMQ_Client_ID");

    public static void putAttribute(ICoreMessage message, String resourceName, String attribute) {
        message.putStringProperty(HDR_RESOURCE_NAME, new SimpleString(resourceName));
        message.putStringProperty(HDR_ATTRIBUTE, new SimpleString(attribute));
    }

    public static void putOperationInvocation(ICoreMessage message, String resourceName, String operationName) throws Exception {
        ManagementHelper.putOperationInvocation(message, resourceName, operationName, null);
    }

    public static void putOperationInvocation(ICoreMessage message, String resourceName, String operationName, Object ... parameters) throws Exception {
        String paramString;
        message.putStringProperty(HDR_RESOURCE_NAME, new SimpleString(resourceName));
        message.putStringProperty(HDR_OPERATION_NAME, new SimpleString(operationName));
        if (parameters != null) {
            JsonArray jsonArray = JsonUtil.toJSONArray(parameters);
            paramString = jsonArray.toString();
        } else {
            paramString = null;
        }
        message.getBodyBuffer().writeNullableSimpleString(SimpleString.toSimpleString(paramString));
    }

    public static Object[] retrieveOperationParameters(Message message) throws Exception {
        String jsonString;
        SimpleString sstring = message.toCore().getReadOnlyBodyBuffer().readNullableSimpleString();
        String string = jsonString = sstring == null ? null : sstring.toString();
        if (jsonString != null) {
            JsonArray jsonArray = JsonUtil.readJsonArray(jsonString);
            return JsonUtil.fromJsonArray(jsonArray);
        }
        return null;
    }

    public static boolean isOperationResult(Message message) {
        return message.containsProperty(HDR_OPERATION_SUCCEEDED);
    }

    public static boolean isAttributesResult(Message message) {
        return !ManagementHelper.isOperationResult(message);
    }

    public static void storeResult(CoreMessage message, Object result) throws Exception {
        String resultString;
        if (result != null) {
            JsonArray jsonArray = JsonUtil.toJSONArray(new Object[]{result});
            resultString = jsonArray.toString();
        } else {
            resultString = null;
        }
        message.getBodyBuffer().writeNullableSimpleString(SimpleString.toSimpleString(resultString));
    }

    public static Object[] getResults(ICoreMessage message) throws Exception {
        String jsonString;
        SimpleString sstring = message.getReadOnlyBodyBuffer().readNullableSimpleString();
        String string = jsonString = sstring == null ? null : sstring.toString();
        if (jsonString != null) {
            JsonArray jsonArray = JsonUtil.readJsonArray(jsonString);
            return JsonUtil.fromJsonArray(jsonArray);
        }
        return null;
    }

    public static Object getResult(ICoreMessage message) throws Exception {
        return ManagementHelper.getResult(message, null);
    }

    public static Object getResult(ICoreMessage message, Class desiredType) throws Exception {
        Object[] res = ManagementHelper.getResults(message);
        if (res != null) {
            return JsonUtil.convertJsonValue(res[0], desiredType);
        }
        return null;
    }

    public static boolean hasOperationSucceeded(Message message) {
        if (!ManagementHelper.isOperationResult(message)) {
            return false;
        }
        if (message.containsProperty(HDR_OPERATION_SUCCEEDED)) {
            return message.getBooleanProperty(HDR_OPERATION_SUCCEEDED);
        }
        return false;
    }

    private ManagementHelper() {
    }
}

