/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.mod_cluster.undertow;

import java.net.InetAddress;
import org.jboss.modcluster.container.Connector;
import org.wildfly.extension.undertow.AjpListenerService;
import org.wildfly.extension.undertow.HttpListenerService;
import org.wildfly.extension.undertow.UndertowListener;
import org.wildfly.mod_cluster.undertow.metric.BytesReceivedStreamSourceConduit;
import org.wildfly.mod_cluster.undertow.metric.BytesSentStreamSinkConduit;
import org.wildfly.mod_cluster.undertow.metric.RequestCountHttpHandler;
import org.wildfly.mod_cluster.undertow.metric.RunningRequestsHttpHandler;

public class UndertowConnector
implements Connector {
    private final UndertowListener listener;
    private InetAddress address;

    public UndertowConnector(UndertowListener listener) {
        this.listener = listener;
    }

    public boolean isReverse() {
        return false;
    }

    public Connector.Type getType() {
        if (this.listener instanceof AjpListenerService) {
            return Connector.Type.AJP;
        }
        if (this.listener instanceof HttpListenerService) {
            if (this.listener.isSecure()) {
                return Connector.Type.HTTPS;
            }
            return Connector.Type.HTTP;
        }
        return null;
    }

    public InetAddress getAddress() {
        return this.address == null ? this.listener.getSocketBinding().getAddress() : this.address;
    }

    public void setAddress(InetAddress address) {
        this.address = address;
    }

    public int getPort() {
        return this.listener.getSocketBinding().getAbsolutePort();
    }

    public boolean isAvailable() {
        return !this.listener.isShutdown();
    }

    public int getMaxThreads() {
        return -1;
    }

    public int getBusyThreads() {
        return RunningRequestsHttpHandler.getRunningRequestCount();
    }

    public long getBytesSent() {
        return BytesSentStreamSinkConduit.getBytesSent();
    }

    public long getBytesReceived() {
        return BytesReceivedStreamSourceConduit.getBytesReceived();
    }

    public long getRequestCount() {
        return RequestCountHttpHandler.getRequestCount();
    }

    public String toString() {
        return this.listener.getName();
    }

    public boolean equals(Object object) {
        if (!(object instanceof UndertowConnector)) {
            return false;
        }
        UndertowConnector connector = (UndertowConnector)object;
        return this.listener.getName().equals(connector.listener.getName());
    }

    public int hashCode() {
        return this.listener.getName().hashCode();
    }
}

