/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.cluster.failover;

import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.apache.activemq.artemis.api.core.Message;
import org.apache.activemq.artemis.api.core.QueueConfiguration;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.api.core.TransportConfiguration;
import org.apache.activemq.artemis.api.core.client.ClientConsumer;
import org.apache.activemq.artemis.api.core.client.ClientMessage;
import org.apache.activemq.artemis.api.core.client.ClientProducer;
import org.apache.activemq.artemis.api.core.client.ClientSession;
import org.apache.activemq.artemis.api.core.client.ClientSessionFactory;
import org.apache.activemq.artemis.api.core.client.ServerLocator;
import org.apache.activemq.artemis.api.core.client.SessionFailureListener;
import org.apache.activemq.artemis.core.client.impl.ClientSessionFactoryInternal;
import org.apache.activemq.artemis.core.client.impl.ServerLocatorInternal;
import org.apache.activemq.artemis.core.config.HAPolicyConfiguration;
import org.apache.activemq.artemis.core.config.ha.SharedStoreMasterPolicyConfiguration;
import org.apache.activemq.artemis.core.config.ha.SharedStoreSlavePolicyConfiguration;
import org.apache.activemq.artemis.core.server.cluster.ha.SharedStoreSlavePolicy;
import org.apache.activemq.artemis.core.server.impl.InVMNodeManager;
import org.apache.activemq.artemis.tests.integration.cluster.failover.FailoverTestBase;
import org.apache.activemq.artemis.tests.util.CountDownSessionFailureListener;
import org.apache.activemq.artemis.tests.util.TransportConfigurationUtils;
import org.jboss.logging.Logger;
import org.junit.Before;
import org.junit.Test;

public class FailBackAutoTest
extends FailoverTestBase {
    private static final Logger log = Logger.getLogger(FailBackAutoTest.class);
    private static final int NUM_MESSAGES = 100;
    private ServerLocatorInternal locator;
    private ClientSessionFactoryInternal sf;

    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
        this.locator = this.getServerLocator();
    }

    @Test
    public void testAutoFailback() throws Exception {
        ((SharedStoreSlavePolicy)this.backupServer.getServer().getHAPolicy()).setRestartBackup(false);
        this.createSessionFactory();
        CountDownLatch latch = new CountDownLatch(1);
        ClientSession session = this.sendAndConsume((ClientSessionFactory)this.sf, true);
        CountDownSessionFailureListener listener = new CountDownSessionFailureListener(latch, session);
        session.addFailureListener((SessionFailureListener)listener);
        this.liveServer.crash(new ClientSession[0]);
        FailBackAutoTest.assertTrue((boolean)latch.await(5L, TimeUnit.SECONDS));
        log.debug((Object)("backup (nowLive) topology = " + this.backupServer.getServer().getClusterManager().getDefaultConnection(null).getTopology().describe()));
        log.debug((Object)"Server Crash!!!");
        ClientProducer producer = session.createProducer(ADDRESS);
        ClientMessage message = session.createMessage(true);
        this.setBody(0, message);
        producer.send((Message)message);
        this.verifyMessageOnServer(1, 1);
        session.removeFailureListener((SessionFailureListener)listener);
        CountDownLatch latch2 = new CountDownLatch(1);
        listener = new CountDownSessionFailureListener(latch2, session);
        session.addFailureListener((SessionFailureListener)listener);
        log.debug((Object)"******* starting live server back");
        this.liveServer.start();
        Thread.sleep(1000L);
        log.debug((Object)("After failback: " + this.locator.getTopology().describe()));
        FailBackAutoTest.assertTrue((boolean)latch2.await(5L, TimeUnit.SECONDS));
        message = session.createMessage(true);
        this.setBody(1, message);
        producer.send((Message)message);
        session.close();
        this.verifyMessageOnServer(0, 1);
        this.wrapUpSessionFactory();
    }

    private void verifyMessageOnServer(int server, int numberOfMessages) throws Exception {
        ServerLocator backupLocator = this.createInVMLocator(server);
        ClientSessionFactory factorybkp = this.addSessionFactory(this.createSessionFactory(backupLocator));
        ClientSession sessionbkp = factorybkp.createSession(false, false);
        sessionbkp.start();
        ClientConsumer consumerbkp = sessionbkp.createConsumer(ADDRESS);
        for (int i = 0; i < numberOfMessages; ++i) {
            ClientMessage msg = consumerbkp.receive(1000L);
            FailBackAutoTest.assertNotNull((Object)msg);
            msg.acknowledge();
            sessionbkp.commit();
        }
        sessionbkp.close();
        factorybkp.close();
        backupLocator.close();
    }

    @Test
    public void testAutoFailbackThenFailover() throws Exception {
        this.createSessionFactory();
        ClientSession session = this.sendAndConsume((ClientSessionFactory)this.sf, true);
        CountDownSessionFailureListener listener = new CountDownSessionFailureListener(session);
        session.addFailureListener((SessionFailureListener)listener);
        log.debug((Object)"Crashing live server...");
        this.liveServer.crash(session);
        ClientProducer producer = session.createProducer(ADDRESS);
        ClientMessage message = session.createMessage(true);
        this.setBody(0, message);
        producer.send((Message)message);
        session.removeFailureListener((SessionFailureListener)listener);
        listener = new CountDownSessionFailureListener(session);
        session.addFailureListener((SessionFailureListener)listener);
        log.debug((Object)"restarting live node now");
        this.liveServer.start();
        FailBackAutoTest.assertTrue((String)"expected a session failure 1", (boolean)listener.getLatch().await(5L, TimeUnit.SECONDS));
        message = session.createMessage(true);
        this.setBody(1, message);
        producer.send((Message)message);
        session.removeFailureListener((SessionFailureListener)listener);
        listener = new CountDownSessionFailureListener(session);
        session.addFailureListener((SessionFailureListener)listener);
        this.waitForBackup(this.sf, 10);
        log.debug((Object)"Crashing live server again...");
        this.liveServer.crash(new ClientSession[0]);
        FailBackAutoTest.assertTrue((String)"expected a session failure 2", (boolean)listener.getLatch().await(5L, TimeUnit.SECONDS));
        session.close();
        this.wrapUpSessionFactory();
    }

    @Test
    public void testFailBack() throws Exception {
        ((SharedStoreSlavePolicy)this.backupServer.getServer().getHAPolicy()).setRestartBackup(false);
        this.createSessionFactory();
        ClientSession session = this.sendAndConsume((ClientSessionFactory)this.sf, true);
        ClientProducer producer = session.createProducer(ADDRESS);
        this.sendMessages(session, producer, 100);
        session.commit();
        this.crash(session);
        session.start();
        ClientConsumer consumer = session.createConsumer(ADDRESS);
        this.receiveMessages(consumer, 0, 100, true);
        producer = session.createProducer(ADDRESS);
        this.sendMessages(session, producer, 200);
        session.commit();
        FailBackAutoTest.assertFalse((String)"must NOT be a backup", (boolean)this.liveServer.getServer().getHAPolicy().isBackup());
        this.adaptLiveConfigForReplicatedFailBack(this.liveServer);
        CountDownSessionFailureListener listener = new CountDownSessionFailureListener(session);
        session.addFailureListener((SessionFailureListener)listener);
        this.liveServer.start();
        FailBackAutoTest.assertTrue((boolean)listener.getLatch().await(5L, TimeUnit.SECONDS));
        FailBackAutoTest.assertTrue((String)"live initialized after restart", (boolean)this.liveServer.getServer().waitForActivation(15L, TimeUnit.SECONDS));
        session.start();
        this.receiveMessages(consumer, 0, 100, true);
    }

    private void createSessionFactory() throws Exception {
        this.locator.setBlockOnNonDurableSend(true).setBlockOnDurableSend(true).setReconnectAttempts(15);
        this.sf = this.createSessionFactoryAndWaitForTopology((ServerLocator)this.locator, 2);
    }

    private void wrapUpSessionFactory() {
        this.sf.close();
        FailBackAutoTest.assertEquals((long)0L, (long)this.sf.numSessions());
        FailBackAutoTest.assertEquals((long)0L, (long)this.sf.numConnections());
    }

    @Override
    protected void createConfigs() throws Exception {
        this.nodeManager = new InVMNodeManager(false);
        TransportConfiguration liveConnector = this.getConnectorTransportConfiguration(true);
        TransportConfiguration backupConnector = this.getConnectorTransportConfiguration(false);
        this.backupConfig = super.createDefaultInVMConfig().clearAcceptorConfigurations().addAcceptorConfiguration(this.getAcceptorTransportConfiguration(false)).setHAPolicyConfiguration((HAPolicyConfiguration)new SharedStoreSlavePolicyConfiguration().setRestartBackup(true)).addConnectorConfiguration(liveConnector.getName(), liveConnector).addConnectorConfiguration(backupConnector.getName(), backupConnector).addClusterConfiguration(FailBackAutoTest.basicClusterConnectionConfig((String)backupConnector.getName(), (String[])new String[]{liveConnector.getName()}));
        this.backupServer = this.createTestableServer(this.backupConfig);
        this.liveConfig = super.createDefaultInVMConfig().clearAcceptorConfigurations().addAcceptorConfiguration(this.getAcceptorTransportConfiguration(true)).setHAPolicyConfiguration((HAPolicyConfiguration)new SharedStoreMasterPolicyConfiguration()).addClusterConfiguration(FailBackAutoTest.basicClusterConnectionConfig((String)liveConnector.getName(), (String[])new String[]{backupConnector.getName()})).addConnectorConfiguration(liveConnector.getName(), liveConnector).addConnectorConfiguration(backupConnector.getName(), backupConnector);
        this.liveServer = this.createTestableServer(this.liveConfig);
    }

    @Override
    protected TransportConfiguration getAcceptorTransportConfiguration(boolean live) {
        return TransportConfigurationUtils.getInVMAcceptor(live);
    }

    @Override
    protected TransportConfiguration getConnectorTransportConfiguration(boolean live) {
        return TransportConfigurationUtils.getInVMConnector(live);
    }

    private ClientSession sendAndConsume(ClientSessionFactory sf, boolean createQueue) throws Exception {
        ClientSession session = sf.createSession(false, true, true);
        if (createQueue) {
            session.createQueue(new QueueConfiguration(ADDRESS));
        }
        ClientProducer producer = session.createProducer(ADDRESS);
        int numMessages = 1000;
        for (int i = 0; i < 1000; ++i) {
            ClientMessage message = session.createMessage((byte)3, false, 0L, System.currentTimeMillis(), (byte)1);
            message.putIntProperty(new SimpleString("count"), i);
            message.getBodyBuffer().writeString("aardvarks");
            producer.send((Message)message);
        }
        ClientConsumer consumer = session.createConsumer(ADDRESS);
        session.start();
        for (int i = 0; i < 1000; ++i) {
            ClientMessage message2 = consumer.receive();
            FailBackAutoTest.assertEquals((Object)"aardvarks", (Object)message2.getBodyBuffer().readString());
            FailBackAutoTest.assertEquals((Object)i, (Object)message2.getObjectProperty(new SimpleString("count")));
            message2.acknowledge();
        }
        ClientMessage message3 = consumer.receiveImmediate();
        consumer.close();
        FailBackAutoTest.assertNull((Object)message3);
        return session;
    }
}

