/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.cluster.failover.quorum;

import org.apache.activemq.artemis.api.core.client.ClientSession;
import org.apache.activemq.artemis.api.core.client.ClientSessionFactory;
import org.apache.activemq.artemis.core.config.ha.ReplicationBackupPolicyConfiguration;
import org.apache.activemq.artemis.core.server.ActiveMQServer;
import org.apache.activemq.artemis.tests.integration.cluster.failover.LargeMessageFailoverTest;
import org.apache.activemq.artemis.tests.integration.cluster.failover.quorum.PluggableQuorumNettyNoGroupNameReplicatedFailoverTest;
import org.apache.activemq.artemis.tests.integration.cluster.util.TestableServer;
import org.jboss.logging.Logger;

public class PluggableQuorumReplicatedLargeMessageFailoverTest
extends LargeMessageFailoverTest {
    private static final Logger log = Logger.getLogger(PluggableQuorumReplicatedLargeMessageFailoverTest.class);

    @Override
    protected void createConfigs() throws Exception {
        this.createPluggableReplicatedConfigs();
    }

    @Override
    protected void setupHAPolicyConfiguration() {
        ((ReplicationBackupPolicyConfiguration)this.backupConfig.getHAPolicyConfiguration()).setMaxSavedReplicatedJournalsSize(2).setAllowFailBack(true);
    }

    @Override
    protected void crash(boolean waitFailure, ClientSession ... sessions) throws Exception {
        if (sessions.length > 0) {
            for (ClientSession session : sessions) {
                PluggableQuorumReplicatedLargeMessageFailoverTest.waitForRemoteBackup((ClientSessionFactory)session.getSessionFactory(), (int)5, (boolean)true, (ActiveMQServer)this.backupServer.getServer());
            }
        } else {
            PluggableQuorumReplicatedLargeMessageFailoverTest.waitForRemoteBackup(null, (int)5, (boolean)true, (ActiveMQServer)this.backupServer.getServer());
        }
        super.crash(waitFailure, sessions);
    }

    @Override
    protected void crash(ClientSession ... sessions) throws Exception {
        if (sessions.length > 0) {
            for (ClientSession session : sessions) {
                PluggableQuorumReplicatedLargeMessageFailoverTest.waitForRemoteBackup((ClientSessionFactory)session.getSessionFactory(), (int)5, (boolean)true, (ActiveMQServer)this.backupServer.getServer());
            }
        } else {
            PluggableQuorumReplicatedLargeMessageFailoverTest.waitForRemoteBackup(null, (int)5, (boolean)true, (ActiveMQServer)this.backupServer.getServer());
        }
        super.crash(sessions);
    }

    @Override
    protected void decrementActivationSequenceForForceRestartOf(TestableServer liveServer) throws Exception {
        PluggableQuorumNettyNoGroupNameReplicatedFailoverTest.doDecrementActivationSequenceForForceRestartOf(log, this.nodeManager, this.managerConfiguration);
    }
}

