/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.cluster.topology;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.apache.activemq.artemis.api.core.ActiveMQException;
import org.apache.activemq.artemis.api.core.ActiveMQExceptionType;
import org.apache.activemq.artemis.api.core.ActiveMQObjectClosedException;
import org.apache.activemq.artemis.api.core.ActiveMQUnBlockedException;
import org.apache.activemq.artemis.api.core.QueueConfiguration;
import org.apache.activemq.artemis.api.core.client.ClientConsumer;
import org.apache.activemq.artemis.api.core.client.ClientProducer;
import org.apache.activemq.artemis.api.core.client.ClientSession;
import org.apache.activemq.artemis.api.core.client.ClientSessionFactory;
import org.apache.activemq.artemis.api.core.client.ClusterTopologyListener;
import org.apache.activemq.artemis.api.core.client.ServerLocator;
import org.apache.activemq.artemis.api.core.client.TopologyMember;
import org.apache.activemq.artemis.core.config.Configuration;
import org.apache.activemq.artemis.core.server.ActiveMQServer;
import org.apache.activemq.artemis.core.server.cluster.ClusterConnection;
import org.apache.activemq.artemis.core.server.cluster.ClusterManager;
import org.apache.activemq.artemis.tests.integration.cluster.distribution.ClusterTestBase;
import org.apache.activemq.artemis.tests.util.Wait;
import org.apache.activemq.artemis.utils.RandomUtil;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public abstract class TopologyClusterTestBase
extends ClusterTestBase {
    protected abstract ServerLocator createHAServerLocator();

    protected abstract void setupServers() throws Exception;

    protected abstract void setupCluster() throws Exception;

    protected abstract boolean isNetty() throws Exception;

    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
        this.setupServers();
        this.setupCluster();
    }

    protected void checkOrder(int[] expected, String[] nodeIDs, List<String> actual) {
        Assert.assertEquals((long)expected.length, (long)actual.size());
        for (int i = 0; i < expected.length; ++i) {
            Assert.assertEquals((String)("did not receive expected nodeID at " + i), (Object)nodeIDs[expected[i]], (Object)actual.get(i));
        }
    }

    protected void checkContains(int[] expected, String[] nodeIDs, List<String> actual) {
        long start = System.currentTimeMillis();
        do {
            if (expected.length != actual.size()) continue;
            boolean ok = true;
            for (int element : expected) {
                ok = ok && actual.contains(nodeIDs[element]);
            }
            if (!ok) continue;
            return;
        } while (System.currentTimeMillis() - start < 5000L);
        Assert.fail((String)("did not contain all expected node ID: " + actual));
    }

    protected String[] getNodeIDs(int ... nodes) {
        String[] nodeIDs = new String[nodes.length];
        for (int i = 0; i < nodes.length; ++i) {
            nodeIDs[i] = this.servers[i].getNodeID().toString();
        }
        return nodeIDs;
    }

    protected ClientSession checkSessionOrReconnect(ClientSession session, ServerLocator locator) throws Exception {
        try {
            String rand = RandomUtil.randomString();
            session.createQueue(new QueueConfiguration(rand));
            session.deleteQueue(rand);
            return session;
        }
        catch (ActiveMQObjectClosedException oce) {
            ClientSessionFactory sf = this.createSessionFactory(locator);
            return sf.createSession();
        }
        catch (ActiveMQUnBlockedException obe) {
            ClientSessionFactory sf = this.createSessionFactory(locator);
            return sf.createSession();
        }
    }

    protected void waitForClusterConnections(int node, int expected) throws Exception {
        int nodesCount;
        ActiveMQServer server = this.servers[node];
        if (server == null) {
            throw new IllegalArgumentException("No server at " + node);
        }
        ClusterManager clusterManager = server.getClusterManager();
        long start = System.currentTimeMillis();
        do {
            nodesCount = 0;
            for (ClusterConnection clusterConn : clusterManager.getClusterConnections()) {
                Map nodes = clusterConn.getNodes();
                for (String id : nodes.keySet()) {
                    if (!clusterConn.isNodeActive(id)) continue;
                    ++nodesCount;
                }
            }
            if (nodesCount == expected) {
                return;
            }
            Thread.sleep(10L);
        } while (System.currentTimeMillis() - start < 30000L);
        this.instanceLog.error((Object)this.clusterDescription(this.servers[node]));
        Assert.assertEquals((String)("Timed out waiting for cluster connections for server " + node), (long)expected, (long)nodesCount);
    }

    @Test
    public void testReceiveNotificationsWhenOtherNodesAreStartedAndStopped() throws Throwable {
        this.startServers(0);
        ServerLocator locator = this.createHAServerLocator();
        locator.getTopology().setOwner((Object)"testReceive");
        List<String> nodes = Collections.synchronizedList(new ArrayList());
        CountDownLatch upLatch = new CountDownLatch(5);
        CountDownLatch downLatch = new CountDownLatch(4);
        locator.addClusterTopologyListener((ClusterTopologyListener)new LatchListener(upLatch, nodes, downLatch));
        ClientSessionFactory sf = this.createSessionFactory(locator);
        this.startServers(1, 4, 3, 2);
        String[] nodeIDs = this.getNodeIDs(0, 1, 2, 3, 4);
        Assert.assertTrue((String)"Was not notified that all servers are UP", (boolean)upLatch.await(10L, TimeUnit.SECONDS));
        this.checkContains(new int[]{0, 1, 4, 3, 2}, nodeIDs, nodes);
        this.waitForClusterConnections(0, 4);
        this.waitForClusterConnections(1, 4);
        this.waitForClusterConnections(2, 4);
        this.waitForClusterConnections(3, 4);
        this.waitForClusterConnections(4, 4);
        this.stopServers(2, 3, 1, 4);
        Assert.assertTrue((String)"Was not notified that all servers are DOWN", (boolean)downLatch.await(10L, TimeUnit.SECONDS));
        this.checkContains(new int[]{0}, nodeIDs, nodes);
        sf.close();
        locator.close();
        this.stopServers(0);
    }

    @Test
    public void testReceiveNotifications() throws Throwable {
        this.startServers(0, 1, 2, 3, 4);
        String[] nodeIDs = this.getNodeIDs(0, 1, 2, 3, 4);
        ServerLocator locator = this.createHAServerLocator();
        this.waitForClusterConnections(0, 4);
        this.waitForClusterConnections(1, 4);
        this.waitForClusterConnections(2, 4);
        this.waitForClusterConnections(3, 4);
        this.waitForClusterConnections(4, 4);
        List<String> nodes = Collections.synchronizedList(new ArrayList());
        CountDownLatch upLatch = new CountDownLatch(5);
        CountDownLatch downLatch = new CountDownLatch(4);
        locator.addClusterTopologyListener((ClusterTopologyListener)new LatchListener(upLatch, nodes, downLatch));
        ClientSessionFactory sf = this.createSessionFactory(locator);
        Assert.assertTrue((String)"Was not notified that all servers are UP", (boolean)upLatch.await(10L, TimeUnit.SECONDS));
        this.checkContains(new int[]{0, 1, 2, 3, 4}, nodeIDs, nodes);
        ClientSession session = sf.createSession();
        this.stopServers(0);
        session = this.checkSessionOrReconnect(session, locator);
        this.checkContains(new int[]{1, 2, 3, 4}, nodeIDs, nodes);
        this.stopServers(2);
        session = this.checkSessionOrReconnect(session, locator);
        this.checkContains(new int[]{1, 3, 4}, nodeIDs, nodes);
        this.stopServers(4);
        session = this.checkSessionOrReconnect(session, locator);
        this.checkContains(new int[]{1, 3}, nodeIDs, nodes);
        this.stopServers(3);
        session = this.checkSessionOrReconnect(session, locator);
        this.checkContains(new int[]{1}, nodeIDs, nodes);
        this.stopServers(1);
        Assert.assertTrue((String)"Was not notified that all servers are DOWN", (boolean)downLatch.await(10L, TimeUnit.SECONDS));
        this.checkContains(new int[0], nodeIDs, nodes);
        sf.close();
    }

    @Test
    public void testStopNodes() throws Throwable {
        this.startServers(0, 1, 2, 3, 4);
        String[] nodeIDs = this.getNodeIDs(0, 1, 2, 3, 4);
        ServerLocator locator = this.createHAServerLocator();
        this.waitForClusterConnections(0, 4);
        this.waitForClusterConnections(1, 4);
        this.waitForClusterConnections(2, 4);
        this.waitForClusterConnections(3, 4);
        this.waitForClusterConnections(4, 4);
        List<String> nodes = Collections.synchronizedList(new ArrayList());
        CountDownLatch upLatch = new CountDownLatch(5);
        locator.addClusterTopologyListener((ClusterTopologyListener)new LatchListener(upLatch, nodes, new CountDownLatch(0)));
        ClientSessionFactory sf = this.createSessionFactory(locator);
        Assert.assertTrue((String)"Was not notified that all servers are UP", (boolean)upLatch.await(10L, TimeUnit.SECONDS));
        this.checkContains(new int[]{0, 1, 2, 3, 4}, nodeIDs, nodes);
        ClientSession session = sf.createSession();
        this.stopServers(0);
        Assert.assertFalse((boolean)this.servers[0].isStarted());
        session = this.checkSessionOrReconnect(session, locator);
        this.checkContains(new int[]{1, 2, 3, 4}, nodeIDs, nodes);
        this.stopServers(2);
        Assert.assertFalse((boolean)this.servers[2].isStarted());
        session = this.checkSessionOrReconnect(session, locator);
        this.checkContains(new int[]{1, 3, 4}, nodeIDs, nodes);
        this.stopServers(4);
        Assert.assertFalse((boolean)this.servers[4].isStarted());
        session = this.checkSessionOrReconnect(session, locator);
        this.checkContains(new int[]{1, 3}, nodeIDs, nodes);
        this.stopServers(3);
        Assert.assertFalse((boolean)this.servers[3].isStarted());
        session = this.checkSessionOrReconnect(session, locator);
        this.checkContains(new int[]{1}, nodeIDs, nodes);
        this.stopServers(1);
        Assert.assertFalse((boolean)this.servers[1].isStarted());
        try {
            session = this.checkSessionOrReconnect(session, locator);
            Assert.fail();
        }
        catch (ActiveMQException expected) {
            Assert.assertEquals((Object)ActiveMQExceptionType.NOT_CONNECTED, (Object)expected.getType());
        }
    }

    @Test
    public void testWrongPasswordTriggersClusterConnectionStop() throws Exception {
        Configuration config = this.servers[4].getConfiguration();
        for (ActiveMQServer s : this.servers) {
            if (s == null) continue;
            s.getConfiguration().setSecurityEnabled(true);
        }
        Assert.assertEquals((Object)"UnitTestsClusterPassword", (Object)config.getClusterPassword());
        config.setClusterPassword(config.getClusterPassword() + "-1-2-3-");
        this.startServers(0, 4);
        Assert.assertTrue((String)"one or the other cluster managers should stop", (boolean)Wait.waitFor(() -> !this.servers[4].getClusterManager().isStarted() || !this.servers[0].getClusterManager().isStarted(), (long)5000L));
        String address = "foo1235";
        ServerLocator locator = this.createNonHALocator(this.isNetty());
        ClientSessionFactory sf = this.createSessionFactory(locator);
        ClientSession session = sf.createSession(config.getClusterUser(), "UnitTestsClusterPassword", false, true, true, false, 1);
        session.createQueue(new QueueConfiguration("foo1235"));
        ClientProducer producer = session.createProducer("foo1235");
        this.sendMessages(session, producer, 100);
        ClientConsumer consumer = session.createConsumer("foo1235");
        session.start();
        this.receiveMessages(consumer, 0, 100, true);
    }

    @Test
    public void testMultipleClientSessionFactories() throws Throwable {
        this.startServers(0, 1, 2, 3, 4);
        String[] nodeIDs = this.getNodeIDs(0, 1, 2, 3, 4);
        ServerLocator locator = this.createHAServerLocator();
        this.waitForClusterConnections(0, 4);
        this.waitForClusterConnections(1, 4);
        this.waitForClusterConnections(2, 4);
        this.waitForClusterConnections(3, 4);
        this.waitForClusterConnections(4, 4);
        List<String> nodes = Collections.synchronizedList(new ArrayList());
        CountDownLatch upLatch = new CountDownLatch(5);
        CountDownLatch downLatch = new CountDownLatch(4);
        locator.addClusterTopologyListener((ClusterTopologyListener)new LatchListener(upLatch, nodes, downLatch));
        ClientSessionFactory[] sfs = new ClientSessionFactory[]{locator.createSessionFactory(), locator.createSessionFactory(), locator.createSessionFactory(), locator.createSessionFactory(), locator.createSessionFactory()};
        Assert.assertTrue((String)"Was not notified that all servers are UP", (boolean)upLatch.await(10L, TimeUnit.SECONDS));
        this.checkContains(new int[]{0, 1, 2, 3, 4}, nodeIDs, nodes);
        this.stopServers(4, 2, 3, 1);
        boolean ok = downLatch.await(10L, TimeUnit.SECONDS);
        if (!ok) {
            this.instanceLog.warn((Object)"TopologyClusterTestBase.testMultipleClientSessionFactories will fail");
        }
        Assert.assertTrue((String)"Was not notified that all servers are Down", (boolean)ok);
        this.checkContains(new int[]{0}, nodeIDs, nodes);
        for (ClientSessionFactory sf : sfs) {
            sf.close();
        }
        locator.close();
        this.stopServers(0);
    }

    private static final class LatchListener
    implements ClusterTopologyListener {
        private final CountDownLatch upLatch;
        private final List<String> nodes;
        private final CountDownLatch downLatch;
        private final List<String> seenUp = new ArrayList<String>();

        private LatchListener(CountDownLatch upLatch, List<String> nodes, CountDownLatch downLatch) {
            this.upLatch = upLatch;
            this.nodes = nodes;
            this.downLatch = downLatch;
        }

        public synchronized void nodeUP(TopologyMember topologyMember, boolean last) {
            String nodeID = topologyMember.getNodeId();
            if (!this.seenUp.contains(nodeID)) {
                this.nodes.add(nodeID);
                this.seenUp.add(nodeID);
                this.upLatch.countDown();
            }
        }

        public synchronized void nodeDown(long uniqueEventID, String nodeID) {
            if (this.nodes.contains(nodeID)) {
                this.nodes.remove(nodeID);
                this.downLatch.countDown();
            }
        }
    }
}

