/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.server.balancing.targets;

import org.apache.activemq.artemis.api.core.ActiveMQException;
import org.apache.activemq.artemis.api.core.TransportConfiguration;
import org.apache.activemq.artemis.api.core.client.ActiveMQClient;
import org.apache.activemq.artemis.api.core.client.ClientSessionFactory;
import org.apache.activemq.artemis.api.core.client.ServerLocator;
import org.apache.activemq.artemis.api.core.management.ActiveMQManagementProxy;
import org.apache.activemq.artemis.core.remoting.FailureListener;
import org.apache.activemq.artemis.core.server.balancing.targets.AbstractTarget;
import org.apache.activemq.artemis.spi.core.protocol.RemotingConnection;
import org.apache.activemq.artemis.utils.UUIDGenerator;
import org.jboss.logging.Logger;

public class ActiveMQTarget
extends AbstractTarget
implements FailureListener {
    private static final Logger logger = Logger.getLogger(ActiveMQTarget.class);
    private boolean connected = false;
    private final ServerLocator serverLocator;
    private ClientSessionFactory sessionFactory;
    private RemotingConnection remotingConnection;
    private ActiveMQManagementProxy managementProxy;

    @Override
    public boolean isLocal() {
        return false;
    }

    @Override
    public boolean isConnected() {
        return this.connected;
    }

    public ActiveMQTarget(TransportConfiguration connector, String nodeID) {
        super(connector, nodeID);
        this.serverLocator = ActiveMQClient.createServerLocatorWithoutHA((TransportConfiguration[])new TransportConfiguration[]{connector});
    }

    @Override
    public void connect() throws Exception {
        this.sessionFactory = this.serverLocator.createSessionFactory();
        this.remotingConnection = this.sessionFactory.getConnection();
        this.remotingConnection.addFailureListener((FailureListener)this);
        this.managementProxy = new ActiveMQManagementProxy(this.sessionFactory.createSession(this.getUsername(), this.getPassword(), false, true, true, false, 0x100000, "$.artemis.internal.balancer.client." + UUIDGenerator.getInstance().generateStringUUID()).start());
        this.connected = true;
        this.fireConnectedEvent();
    }

    @Override
    public void disconnect() throws Exception {
        if (this.connected) {
            this.connected = false;
            this.managementProxy.close();
            this.remotingConnection.removeFailureListener((FailureListener)this);
            this.sessionFactory.close();
            this.fireDisconnectedEvent();
        }
    }

    @Override
    public boolean checkReadiness() {
        try {
            if (this.getNodeID() == null) {
                this.setNodeID(this.getAttribute("broker", "NodeID", String.class, 3000));
            }
            return this.getAttribute("broker", "Active", Boolean.class, 3000);
        }
        catch (Exception e) {
            logger.warn((Object)"Error on check readiness", (Throwable)e);
            return false;
        }
    }

    @Override
    public <T> T getAttribute(String resourceName, String attributeName, Class<T> attributeClass, int timeout) throws Exception {
        return (T)this.managementProxy.getAttribute(resourceName, attributeName, attributeClass, timeout);
    }

    @Override
    public <T> T invokeOperation(String resourceName, String operationName, Object[] operationParams, Class<T> operationClass, int timeout) throws Exception {
        return (T)this.managementProxy.invokeOperation(resourceName, operationName, operationParams, operationClass, timeout);
    }

    public void connectionFailed(ActiveMQException exception, boolean failedOver) {
        this.connectionFailed(exception, failedOver, null);
    }

    public void connectionFailed(ActiveMQException exception, boolean failedOver, String scaleDownTargetNodeID) {
        try {
            if (this.connected) {
                this.disconnect();
            }
        }
        catch (Exception e) {
            logger.debug((Object)"Exception on disconnecting: ", (Throwable)e);
        }
    }
}

