/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.commands.irac;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.concurrent.CompletionStage;
import org.infinispan.commands.irac.IracUpdateKeyCommand;
import org.infinispan.metadata.impl.IracMetadata;
import org.infinispan.util.ByteString;
import org.infinispan.xsite.BackupReceiver;

public class IracRemoveKeyCommand
extends IracUpdateKeyCommand {
    public static final byte COMMAND_ID = 15;
    private Object key;
    private IracMetadata iracMetadata;
    private boolean expiration;

    public IracRemoveKeyCommand() {
        super((byte)15, null);
    }

    public IracRemoveKeyCommand(ByteString cacheName) {
        super((byte)15, cacheName);
    }

    public IracRemoveKeyCommand(ByteString cacheName, Object key, IracMetadata iracMetadata, boolean expiration) {
        super((byte)15, cacheName);
        this.key = key;
        this.iracMetadata = iracMetadata;
        this.expiration = expiration;
    }

    @Override
    public CompletionStage<Void> executeOperation(BackupReceiver receiver) {
        return receiver.removeKey(this.key, this.iracMetadata, this.expiration);
    }

    @Override
    public byte getCommandId() {
        return 15;
    }

    @Override
    public void writeTo(ObjectOutput output) throws IOException {
        output.writeObject(this.key);
        IracMetadata.writeTo(output, this.iracMetadata);
        output.writeBoolean(this.expiration);
    }

    @Override
    public void readFrom(ObjectInput input) throws IOException, ClassNotFoundException {
        this.key = input.readObject();
        this.iracMetadata = IracMetadata.readFrom(input);
        this.expiration = input.readBoolean();
    }

    @Override
    public String toString() {
        return "IracRemoveKeyCommand{key=" + this.key + ", iracMetadata=" + this.iracMetadata + ", originSite='" + this.originSite + '\'' + ", cacheName=" + this.cacheName + '}';
    }
}

