/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jca.core.workmanager;

import jakarta.resource.spi.work.ExecutionContext;
import jakarta.resource.spi.work.SecurityContext;
import jakarta.resource.spi.work.TransactionContext;
import jakarta.resource.spi.work.Work;
import jakarta.resource.spi.work.WorkCompletedException;
import jakarta.resource.spi.work.WorkContext;
import jakarta.resource.spi.work.WorkContextLifecycleListener;
import jakarta.resource.spi.work.WorkEvent;
import jakarta.resource.spi.work.WorkException;
import jakarta.resource.spi.work.WorkListener;
import jakarta.security.auth.message.callback.CallerPrincipalCallback;
import jakarta.security.auth.message.callback.GroupPrincipalCallback;
import java.security.Principal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.transaction.xa.Xid;
import org.jboss.jca.core.CoreBundle;
import org.jboss.jca.core.CoreLogger;
import org.jboss.jca.core.api.workmanager.WorkManager;
import org.jboss.jca.core.spi.security.SecurityIntegration;
import org.jboss.jca.core.workmanager.SecurityActions;
import org.jboss.jca.core.workmanager.WorkManagerImpl;
import org.jboss.logging.Logger;
import org.jboss.logging.Messages;

public class WorkWrapper
implements Runnable {
    private static CoreLogger log = (CoreLogger)Logger.getMessageLogger(CoreLogger.class, (String)WorkWrapper.class.getName());
    private static CoreBundle bundle = (CoreBundle)Messages.getBundle(CoreBundle.class);
    private Work work;
    private ExecutionContext executionContext;
    private Map<Class<? extends WorkContext>, WorkContext> workContexts;
    private WorkListener workListener;
    protected WorkManagerImpl workManager;
    protected SecurityIntegration securityIntegration;
    private long startTime;
    private WorkException exception;
    private CountDownLatch startedLatch;
    private CountDownLatch completedLatch;

    public WorkWrapper(WorkManagerImpl workManager, SecurityIntegration si, Work work, ExecutionContext executionContext, WorkListener workListener, CountDownLatch startedLatch, CountDownLatch completedLatch, long startTime) {
        if (workManager == null) {
            throw new IllegalArgumentException("Null work manager");
        }
        if (si == null) {
            throw new IllegalArgumentException("Null security integration");
        }
        if (work == null) {
            throw new IllegalArgumentException("Null work");
        }
        if (executionContext == null) {
            throw new IllegalArgumentException("Null execution context");
        }
        this.workManager = workManager;
        this.securityIntegration = si;
        this.work = work;
        this.executionContext = executionContext;
        this.workListener = workListener;
        this.startedLatch = startedLatch;
        this.completedLatch = completedLatch;
        this.startTime = startTime;
        this.workContexts = null;
    }

    public WorkManager getWorkManager() {
        return this.workManager;
    }

    public Work getWork() {
        return this.work;
    }

    public ExecutionContext getExecutionContext() {
        return this.executionContext;
    }

    public WorkListener getWorkListener() {
        return this.workListener;
    }

    public WorkException getWorkException() {
        return this.exception;
    }

    void setWorkException(WorkException e) {
        this.exception = e;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        ClassLoader oldCL = SecurityActions.getThreadContextClassLoader();
        SecurityActions.setThreadContextClassLoader(this.work.getClass().getClassLoader());
        org.jboss.jca.core.spi.security.SecurityContext oldSC = this.securityIntegration.getSecurityContext();
        try {
            this.start();
            this.workManager.addWorkWrapper(this);
            if (this.startedLatch != null) {
                this.startedLatch.countDown();
            }
            this.runWork();
            this.end();
        }
        catch (Throwable t) {
            this.exception = t instanceof WorkCompletedException ? (WorkCompletedException)t : new WorkCompletedException(t.getMessage(), t);
            this.cancel();
        }
        finally {
            this.workManager.removeWorkWrapper(this);
            this.work.release();
            if (this.workListener != null) {
                WorkEvent event = new WorkEvent((Object)this.workManager, 4, this.work, this.exception);
                this.workListener.workCompleted(event);
            }
            this.securityIntegration.setSecurityContext(oldSC);
            SecurityActions.setThreadContextClassLoader(oldCL);
            if (this.startedLatch != null) {
                while (this.startedLatch.getCount() != 0L) {
                    this.startedLatch.countDown();
                }
            }
            if (this.completedLatch != null) {
                this.completedLatch.countDown();
            }
            log.tracef("Executed work: %s", this);
        }
    }

    protected void start() throws WorkException {
        Xid xid;
        Xid xid2;
        ExecutionContext ctx;
        log.tracef("Starting work: %s", this);
        if (this.workListener != null) {
            long duration = System.currentTimeMillis() - this.startTime;
            if (duration < 0L) {
                duration = -1L;
            }
            WorkEvent event = new WorkEvent((Object)this.workManager, 3, this.work, null, duration);
            this.workListener.workStarted(event);
        }
        if ((ctx = (ExecutionContext)this.getWorkContext(TransactionContext.class)) == null) {
            ctx = this.getExecutionContext();
        }
        if (ctx != null && (xid2 = ctx.getXid()) != null) {
            long timeout = ctx.getTransactionTimeout() * 1000L;
            this.workManager.getXATerminator().registerWork(this.work, xid2, timeout);
        }
        this.fireWorkContextSetupComplete(ctx);
        SecurityContext securityContext = this.getWorkContext(SecurityContext.class);
        if (securityContext != null && this.workManager.getCallbackSecurity() != null) {
            log.tracef("Setting security context: %s", securityContext);
            try {
                org.jboss.jca.core.spi.security.SecurityContext sc = null;
                CallbackHandler cbh = null;
                if (this.workManager.getCallbackSecurity() != null) {
                    cbh = this.securityIntegration.createCallbackHandler(this.workManager.getCallbackSecurity());
                }
                if (cbh == null) {
                    cbh = this.securityIntegration.createCallbackHandler();
                }
                Subject executionSubject = null;
                Subject serviceSubject = null;
                log.tracef("Callback security: %s", this.workManager.getCallbackSecurity());
                if (this.securityIntegration.getSecurityContext() == null || this.workManager.getCallbackSecurity().getDomain() != null) {
                    String scDomain = this.workManager.getCallbackSecurity().getDomain();
                    log.tracef("Creating security context: %s", scDomain);
                    if (scDomain == null || scDomain.trim().equals("")) {
                        this.fireWorkContextSetupFailed(securityContext);
                        throw new WorkException(bundle.securityContextSetupFailedSinceCallbackSecurityDomainWasEmpty());
                    }
                    sc = this.securityIntegration.createSecurityContext(scDomain);
                    this.securityIntegration.setSecurityContext(sc);
                } else {
                    sc = this.securityIntegration.getSecurityContext();
                    log.tracef("Using security context: %s", sc);
                }
                executionSubject = sc.getAuthenticatedSubject();
                if (executionSubject == null) {
                    log.trace("Creating empty subject");
                    executionSubject = new Subject();
                }
                securityContext.setupSecurityContext(cbh, executionSubject, serviceSubject);
                if (this.workManager.getCallbackSecurity() != null) {
                    ArrayList<Object> callbacks = new ArrayList<Object>();
                    if (this.workManager.getCallbackSecurity().getDefaultPrincipal() != null) {
                        Principal defaultPrincipal = this.workManager.getCallbackSecurity().getDefaultPrincipal();
                        log.tracef("Adding default principal: %s", defaultPrincipal);
                        CallerPrincipalCallback cpc = new CallerPrincipalCallback(executionSubject, defaultPrincipal);
                        callbacks.add(cpc);
                    }
                    if (this.workManager.getCallbackSecurity().getDefaultGroups() != null) {
                        Object[] defaultGroups = this.workManager.getCallbackSecurity().getDefaultGroups();
                        if (log.isTraceEnabled()) {
                            log.tracef("Adding default groups: %s", Arrays.toString(defaultGroups));
                        }
                        GroupPrincipalCallback gpc = new GroupPrincipalCallback(executionSubject, (String[])defaultGroups);
                        callbacks.add(gpc);
                    }
                    if (callbacks.size() > 0) {
                        Callback[] cb = new Callback[callbacks.size()];
                        cbh.handle(callbacks.toArray(cb));
                    }
                }
                log.tracef("Setting authenticated subject (%s) on security context (%s)", executionSubject, sc);
                sc.setAuthenticatedSubject(executionSubject);
                this.fireWorkContextSetupComplete(securityContext);
            }
            catch (Throwable t) {
                log.securityContextSetupFailed(t.getMessage(), t);
                this.fireWorkContextSetupFailed(securityContext);
                throw new WorkException(bundle.securityContextSetupFailed(t.getMessage()), t);
            }
        } else if (securityContext != null && this.workManager.getCallbackSecurity() == null) {
            log.securityContextSetupFailedCallbackSecurityNull();
            this.fireWorkContextSetupFailed(securityContext);
            throw new WorkException(bundle.securityContextSetupFailedSinceCallbackSecurityWasNull());
        }
        if (ctx != null && (xid = ctx.getXid()) != null) {
            this.workManager.getXATerminator().startWork(this.work, xid);
        }
        log.tracef("Started work: %s", this);
    }

    protected void runWork() throws WorkCompletedException {
        this.work.run();
    }

    protected void end() {
        Xid xid;
        log.tracef("Ending work: %s", this);
        ExecutionContext ctx = (ExecutionContext)this.getWorkContext(TransactionContext.class);
        if (ctx == null) {
            ctx = this.getExecutionContext();
        }
        if (ctx != null && (xid = ctx.getXid()) != null) {
            this.workManager.getXATerminator().endWork(this.work, xid);
        }
        log.tracef("Ended work: %s", this);
    }

    protected void cancel() {
        Xid xid;
        log.tracef("Cancel work: %s", this);
        ExecutionContext ctx = (ExecutionContext)this.getWorkContext(TransactionContext.class);
        if (ctx == null) {
            ctx = this.getExecutionContext();
        }
        if (ctx != null && (xid = ctx.getXid()) != null) {
            this.workManager.getXATerminator().cancelWork(this.work, xid);
        }
        log.tracef("Canceled work: %s", this);
    }

    public <T> T getWorkContext(Class<T> workContextClass) {
        T instance = null;
        if (this.workContexts != null && this.workContexts.containsKey(workContextClass)) {
            instance = workContextClass.cast(this.workContexts.get(workContextClass));
        }
        return instance;
    }

    public void addWorkContext(Class<? extends WorkContext> workContextClass, WorkContext workContext) {
        if (workContextClass == null) {
            throw new IllegalArgumentException("Work context class is null");
        }
        if (workContext == null) {
            throw new IllegalArgumentException("Work context is null");
        }
        if (this.workContexts == null) {
            this.workContexts = new HashMap<Class<? extends WorkContext>, WorkContext>(1);
        }
        log.tracef("Adding work context %s for %s", workContextClass, this);
        this.workContexts.put(workContextClass, workContext);
    }

    private void fireWorkContextSetupComplete(Object workContext) {
        if (workContext != null && workContext instanceof WorkContextLifecycleListener) {
            log.tracef("WorkContextSetupComplete(%s) for %s", workContext, this);
            WorkContextLifecycleListener listener = (WorkContextLifecycleListener)workContext;
            listener.contextSetupComplete();
        }
    }

    private void fireWorkContextSetupFailed(Object workContext) {
        if (workContext != null && workContext instanceof WorkContextLifecycleListener) {
            log.tracef("WorkContextSetupFailed(%s) for %s", workContext, this);
            WorkContextLifecycleListener listener = (WorkContextLifecycleListener)workContext;
            listener.contextSetupFailed("3");
        }
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder(100);
        buffer.append("WorkWrapper@").append(Integer.toHexString(System.identityHashCode(this)));
        buffer.append("[workManger=").append(this.workManager);
        buffer.append(" work=").append(this.work);
        if (this.executionContext != null && this.executionContext.getXid() != null) {
            buffer.append(" xid=").append(this.executionContext.getXid());
            buffer.append(" txTimeout=").append(this.executionContext.getTransactionTimeout());
        }
        buffer.append(" workListener=").append(this.workListener);
        buffer.append(" workContexts=").append(this.workContexts);
        buffer.append(" exception=").append(this.exception);
        buffer.append("]");
        return buffer.toString();
    }
}

