/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.application.view;

import com.sun.faces.util.MessageUtils;
import jakarta.faces.application.FacesMessage;
import jakarta.faces.component.ActionSource;
import jakarta.faces.component.ActionSource2;
import jakarta.faces.component.EditableValueHolder;
import jakarta.faces.component.UIComponent;
import jakarta.faces.component.UIForm;
import jakarta.faces.component.UIViewRoot;
import jakarta.faces.component.visit.VisitContext;
import jakarta.faces.component.visit.VisitHint;
import jakarta.faces.component.visit.VisitResult;
import jakarta.faces.context.FacesContext;
import java.util.EnumSet;
import java.util.List;

class FormOmittedChecker {
    private static String SKIP_ITERATION_HINT = "jakarta.faces.visit.SKIP_ITERATION";

    private FormOmittedChecker() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void check(FacesContext context) {
        FacesContext finalContext = context;
        UIViewRoot viewRoot = context.getViewRoot();
        List children = viewRoot.getChildren();
        for (UIComponent child : children) {
            try {
                context.getAttributes().put(SKIP_ITERATION_HINT, true);
                EnumSet<VisitHint> hints = EnumSet.of(VisitHint.SKIP_ITERATION);
                VisitContext visitContext = VisitContext.createVisitContext((FacesContext)context, null, hints);
                child.visitTree(visitContext, (visitContext1, component) -> {
                    VisitResult result = VisitResult.ACCEPT;
                    if (FormOmittedChecker.isForm(component)) {
                        result = VisitResult.REJECT;
                    } else if (FormOmittedChecker.isInNeedOfForm(component)) {
                        FormOmittedChecker.addFormOmittedMessage(finalContext, component);
                    }
                    return result;
                });
            }
            finally {
                context.getAttributes().remove(SKIP_ITERATION_HINT);
            }
        }
    }

    private static boolean isForm(UIComponent component) {
        return component instanceof UIForm || component.getFamily() != null && component.getFamily().endsWith("Form");
    }

    private static boolean isInNeedOfForm(UIComponent component) {
        return component instanceof ActionSource || component instanceof ActionSource2 || component instanceof EditableValueHolder;
    }

    private static void addFormOmittedMessage(FacesContext context, UIComponent component) {
        String key = "com.sun.faces.MISSING_FORM_ERROR";
        Object[] parameters = new Object[]{component.getClientId(context)};
        boolean missingFormReported = false;
        FacesMessage message = MessageUtils.getExceptionMessage(key, parameters);
        List messages = context.getMessageList();
        for (FacesMessage item : messages) {
            if (!item.getDetail().equals(message.getDetail())) continue;
            missingFormReported = true;
            break;
        }
        if (!missingFormReported) {
            message.setSeverity(FacesMessage.SEVERITY_WARN);
            context.addMessage(null, message);
        }
    }
}

