/*
 * Decompiled with CFR 0.152.
 */
package org.jberet.job.model;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.Serializable;
import java.net.URI;
import java.net.URL;
import java.util.Scanner;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import org.jberet._private.BatchLogger;
import org.jberet._private.BatchMessages;

public class Script
implements Serializable,
Cloneable {
    private static final long serialVersionUID = 3048730979495066553L;
    private static volatile ScriptEngineManager scriptEngineManager;
    String type;
    String src;
    String content;

    Script(String type, String src) {
        this.type = type;
        this.src = src;
    }

    public Script(String type, String src, String content) {
        this.type = type;
        this.src = src;
        this.content = content;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getContent(ClassLoader classLoader) {
        if (this.content != null) {
            return this.content;
        }
        InputStream is = classLoader.getResourceAsStream(this.src);
        if (is == null) {
            BatchLogger.LOGGER.tracef("script src %s is not loadable by ClassLoader, next try file", this.src);
            try {
                File file = new File(this.src);
                if (file.exists() && file.isFile()) {
                    is = new FileInputStream(file);
                }
            }
            catch (Exception e) {
                BatchLogger.LOGGER.tracef(e, "exception when loading script src %s as a file, next try URL", this.src);
            }
            if (is == null) {
                try {
                    URL url = new URI(this.src).toURL();
                    is = url.openStream();
                }
                catch (Exception e) {
                    BatchLogger.LOGGER.tracef(e, "exception when loading script src %s as URL", this.src);
                }
            }
        }
        if (is == null) {
            throw BatchMessages.MESSAGES.failToGetScriptContent(null, this.src);
        }
        Scanner scanner = null;
        try {
            scanner = new Scanner(is).useDelimiter("\\A");
            String string = this.content = scanner.hasNext() ? scanner.next() : "";
            return string;
        }
        finally {
            if (scanner != null) {
                try {
                    scanner.close();
                }
                catch (Exception e) {
                    BatchLogger.LOGGER.tracef(e, "Failed to close resource %s", this.src);
                }
            }
        }
    }

    public String getContent() {
        if (this.content == null) {
            throw new IllegalStateException();
        }
        return this.content;
    }

    public String getSrc() {
        return this.src;
    }

    public String getType() {
        return this.type;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public ScriptEngine getEngine(ClassLoader classLoader) {
        ScriptEngineManager mgr = scriptEngineManager;
        if (mgr == null) {
            Class<Script> clazz = Script.class;
            // MONITORENTER : org.jberet.job.model.Script.class
            mgr = scriptEngineManager;
            if (mgr == null) {
                scriptEngineManager = mgr = new ScriptEngineManager(classLoader);
            }
            // MONITOREXIT : clazz
        }
        Object engine = null;
        if (this.type != null) {
            engine = this.type.indexOf(47) > 0 ? mgr.getEngineByMimeType(this.type) : mgr.getEngineByName(this.type);
        } else if (this.src != null) {
            int fileExtensionDot = this.src.lastIndexOf(46);
            if (fileExtensionDot < 0) {
                throw BatchMessages.MESSAGES.invalidScriptAttributes(this.type, this.src);
            }
            String ext = this.src.substring(fileExtensionDot + 1);
            engine = mgr.getEngineByExtension(ext);
        }
        if (engine == null) throw BatchMessages.MESSAGES.invalidScriptAttributes(this.type, this.src);
        if (engine.getClass().getSimpleName().indexOf("Groovy") <= -1) return engine;
        engine.getContext().setAttribute("#jsr223.groovy.engine.keep.globals", "weak", 100);
        return engine;
    }

    protected Script clone() {
        Script c = new Script(this.type, this.src);
        c.content = this.content;
        return c;
    }
}

