/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.yasson.internal;

import jakarta.json.bind.JsonbConfig;
import jakarta.json.bind.JsonbException;
import jakarta.json.bind.config.PropertyNamingStrategy;
import jakarta.json.bind.config.PropertyVisibilityStrategy;
import jakarta.json.bind.serializer.JsonbSerializer;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.time.temporal.ChronoField;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.TreeMap;
import java.util.function.Consumer;
import org.eclipse.yasson.internal.model.PropertyModel;
import org.eclipse.yasson.internal.model.ReverseTreeMap;
import org.eclipse.yasson.internal.model.customization.PropertyOrdering;
import org.eclipse.yasson.internal.model.customization.StrategiesProvider;
import org.eclipse.yasson.internal.properties.MessageKeys;
import org.eclipse.yasson.internal.properties.Messages;
import org.eclipse.yasson.internal.serializer.JsonbDateFormatter;
import org.eclipse.yasson.internal.serializer.NullSerializer;

public class JsonbConfigProperties {
    private final JsonbConfig jsonbConfig;
    private final PropertyVisibilityStrategy propertyVisibilityStrategy;
    private final PropertyNamingStrategy propertyNamingStrategy;
    private final PropertyOrdering propertyOrdering;
    private final JsonbDateFormatter dateFormatter;
    private final Locale locale;
    private final String binaryDataStrategy;
    private final boolean nullable;
    private final boolean failOnUnknownProperties;
    private final boolean strictIJson;
    private final boolean zeroTimeDefaulting;
    private final Map<Class<?>, Class<?>> userTypeMapping;
    private final Class<?> defaultMapImplType;
    private final JsonbSerializer<Object> nullSerializer;
    private final Set<Class<?>> eagerInitClasses;
    private final boolean forceMapArraySerializerForNullKeys;

    public JsonbConfigProperties(JsonbConfig jsonbConfig) {
        this.jsonbConfig = jsonbConfig;
        this.binaryDataStrategy = this.initBinaryDataStrategy();
        this.propertyNamingStrategy = this.initPropertyNamingStrategy();
        this.propertyVisibilityStrategy = this.initPropertyVisibilityStrategy();
        this.propertyOrdering = new PropertyOrdering(this.initOrderStrategy());
        this.locale = this.initConfigLocale();
        this.dateFormatter = this.initDateFormatter(this.locale);
        this.nullable = this.initConfigNullable();
        this.failOnUnknownProperties = this.initConfigFailOnUnknownProperties();
        this.strictIJson = this.initStrictJson();
        this.userTypeMapping = this.initUserTypeMapping();
        this.zeroTimeDefaulting = this.initZeroTimeDefaultingForJavaTime();
        this.defaultMapImplType = this.initDefaultMapImplType();
        this.nullSerializer = this.initNullSerializer();
        this.eagerInitClasses = this.initEagerInitClasses();
        this.forceMapArraySerializerForNullKeys = this.initForceMapArraySerializerForNullKeys();
    }

    private Class<?> initDefaultMapImplType() {
        Optional<String> os = this.getPropertyOrderStrategy();
        if (os.isPresent()) {
            switch (os.get()) {
                case "LEXICOGRAPHICAL": {
                    return TreeMap.class;
                }
                case "REVERSE": {
                    return ReverseTreeMap.class;
                }
            }
            return HashMap.class;
        }
        return HashMap.class;
    }

    private boolean initZeroTimeDefaultingForJavaTime() {
        return this.getBooleanConfigProperty("jsonb.zero-time-defaulting", false);
    }

    private Map<Class<?>, Class<?>> initUserTypeMapping() {
        Optional property = this.jsonbConfig.getProperty("jsonb.user-type-mapping");
        if (!property.isPresent()) {
            return Collections.emptyMap();
        }
        Object result = property.get();
        if (!(result instanceof Map)) {
            throw new JsonbException(Messages.getMessage(MessageKeys.JSONB_CONFIG_PROPERTY_INVALID_TYPE, "jsonb.user-type-mapping", Map.class.getSimpleName()));
        }
        return (Map)result;
    }

    private JsonbDateFormatter initDateFormatter(Locale locale) {
        String dateFormat = this.getGlobalConfigJsonbDateFormat();
        if ("##default".equals(dateFormat) || "##time-in-millis".equals(dateFormat)) {
            return new JsonbDateFormatter(dateFormat, locale.toLanguageTag());
        }
        DateTimeFormatterBuilder builder = new DateTimeFormatterBuilder();
        builder.appendPattern(dateFormat);
        if (this.isZeroTimeDefaulting()) {
            builder.parseDefaulting(ChronoField.SECOND_OF_MINUTE, 0L);
            builder.parseDefaulting(ChronoField.MINUTE_OF_HOUR, 0L);
            builder.parseDefaulting(ChronoField.HOUR_OF_DAY, 0L);
        }
        DateTimeFormatter dateTimeFormatter = builder.toFormatter(locale);
        return new JsonbDateFormatter(dateTimeFormatter, dateFormat, locale.toLanguageTag());
    }

    private String getGlobalConfigJsonbDateFormat() {
        Optional formatProperty = this.jsonbConfig.getProperty("jsonb.date-format");
        return formatProperty.map(f -> {
            if (!(f instanceof String)) {
                throw new JsonbException(Messages.getMessage(MessageKeys.JSONB_CONFIG_PROPERTY_INVALID_TYPE, "jsonb.date-format", String.class.getSimpleName()));
            }
            return (String)f;
        }).orElse("##default");
    }

    private Consumer<List<PropertyModel>> initOrderStrategy() {
        Optional<String> strategy = this.getPropertyOrderStrategy();
        return strategy.map(StrategiesProvider::getOrderingFunction).orElseGet(() -> StrategiesProvider.getOrderingFunction("LEXICOGRAPHICAL"));
    }

    private Optional<String> getPropertyOrderStrategy() {
        Optional property = this.jsonbConfig.getProperty("jsonb.property-order-strategy");
        if (property.isPresent()) {
            Object strategy = property.get();
            if (!(strategy instanceof String)) {
                throw new JsonbException(Messages.getMessage(MessageKeys.PROPERTY_ORDER, strategy));
            }
            switch ((String)strategy) {
                case "LEXICOGRAPHICAL": 
                case "REVERSE": 
                case "ANY": {
                    return Optional.of((String)strategy);
                }
            }
            throw new JsonbException(Messages.getMessage(MessageKeys.PROPERTY_ORDER, strategy));
        }
        return Optional.empty();
    }

    private PropertyNamingStrategy initPropertyNamingStrategy() {
        Optional property = this.jsonbConfig.getProperty("jsonb.property-naming-strategy");
        if (!property.isPresent()) {
            return StrategiesProvider.getPropertyNamingStrategy("IDENTITY");
        }
        Object propertyNamingStrategy = property.get();
        if (propertyNamingStrategy instanceof String) {
            return StrategiesProvider.getPropertyNamingStrategy((String)propertyNamingStrategy);
        }
        if (!(propertyNamingStrategy instanceof PropertyNamingStrategy)) {
            throw new JsonbException(Messages.getMessage(MessageKeys.PROPERTY_NAMING_STRATEGY_INVALID, new Object[0]));
        }
        return (PropertyNamingStrategy)property.get();
    }

    private PropertyVisibilityStrategy initPropertyVisibilityStrategy() {
        Optional property = this.jsonbConfig.getProperty("jsonb.property-visibility-strategy");
        if (!property.isPresent()) {
            return null;
        }
        Object propertyVisibilityStrategy = property.get();
        if (!(propertyVisibilityStrategy instanceof PropertyVisibilityStrategy)) {
            throw new JsonbException("JsonbConfig.PROPERTY_VISIBILITY_STRATEGY must be instance of " + PropertyVisibilityStrategy.class);
        }
        return (PropertyVisibilityStrategy)propertyVisibilityStrategy;
    }

    private String initBinaryDataStrategy() {
        Optional<Boolean> iJson = this.jsonbConfig.getProperty("jsonb.strict-ijson").map(obj -> (Boolean)obj);
        if (iJson.isPresent() && iJson.get().booleanValue()) {
            return "BASE_64_URL";
        }
        Optional<String> strategy = this.jsonbConfig.getProperty("jsonb.binary-data-strategy").map(obj -> (String)obj);
        return strategy.orElse("BYTE");
    }

    private boolean initConfigNullable() {
        return this.getBooleanConfigProperty("jsonb.null-values", false);
    }

    private boolean initConfigFailOnUnknownProperties() {
        return this.getBooleanConfigProperty("jsonb.fail-on-unknown-properties", false);
    }

    private JsonbSerializer<Object> initNullSerializer() {
        Optional property = this.jsonbConfig.getProperty("yasson.null-root-serializer");
        if (!property.isPresent()) {
            return new NullSerializer();
        }
        Object nullSerializer = property.get();
        if (!(nullSerializer instanceof JsonbSerializer)) {
            throw new JsonbException("YassonConfig.NULL_ROOT_SERIALIZER must be instance of " + JsonbSerializer.class + "<Object>");
        }
        return (JsonbSerializer)nullSerializer;
    }

    private Set<Class<?>> initEagerInitClasses() {
        Optional property = this.jsonbConfig.getProperty("yasson.eager-parse-classes");
        if (!property.isPresent()) {
            return Collections.emptySet();
        }
        Object eagerInitClasses = property.get();
        if (!(eagerInitClasses instanceof Class[])) {
            throw new JsonbException("YassonConfig.EAGER_PARSE_CLASSES must be instance of Class<?>[]");
        }
        return new HashSet(Arrays.asList((Class[])eagerInitClasses));
    }

    private boolean initForceMapArraySerializerForNullKeys() {
        return this.getBooleanConfigProperty("yasson.force-map-array-serializer-for-null-keys", false);
    }

    public boolean getConfigNullable() {
        return this.nullable;
    }

    public boolean getConfigFailOnUnknownProperties() {
        return this.failOnUnknownProperties;
    }

    private boolean getBooleanConfigProperty(String propertyName, boolean defaultValue) {
        Optional property = this.jsonbConfig.getProperty(propertyName);
        if (property.isPresent()) {
            Object result = property.get();
            if (!(result instanceof Boolean)) {
                throw new JsonbException(Messages.getMessage(MessageKeys.JSONB_CONFIG_PROPERTY_INVALID_TYPE, propertyName, Boolean.class.getSimpleName()));
            }
            return (Boolean)result;
        }
        return defaultValue;
    }

    public String getBinaryDataStrategy() {
        return this.binaryDataStrategy;
    }

    public Locale getLocale(String locale) {
        if (locale.equals("##default")) {
            return this.locale;
        }
        return Locale.forLanguageTag(locale);
    }

    private Locale initConfigLocale() {
        Optional localeProperty = this.jsonbConfig.getProperty("jsonb.locale");
        return localeProperty.map(loc -> {
            if (!(loc instanceof Locale)) {
                throw new JsonbException(Messages.getMessage(MessageKeys.JSONB_CONFIG_PROPERTY_INVALID_TYPE, "jsonb.locale", Locale.class.getSimpleName()));
            }
            return (Locale)loc;
        }).orElseGet(Locale::getDefault);
    }

    private boolean initStrictJson() {
        return this.getBooleanConfigProperty("jsonb.strict-ijson", false);
    }

    public PropertyVisibilityStrategy getPropertyVisibilityStrategy() {
        return this.propertyVisibilityStrategy;
    }

    public PropertyNamingStrategy getPropertyNamingStrategy() {
        return this.propertyNamingStrategy;
    }

    public JsonbDateFormatter getConfigDateFormatter() {
        return this.dateFormatter;
    }

    public PropertyOrdering getPropertyOrdering() {
        return this.propertyOrdering;
    }

    public boolean isStrictIJson() {
        return this.strictIJson;
    }

    public Map<Class<?>, Class<?>> getUserTypeMapping() {
        return this.userTypeMapping;
    }

    public boolean isZeroTimeDefaulting() {
        return this.zeroTimeDefaulting;
    }

    public Class<?> getDefaultMapImplType() {
        return this.defaultMapImplType;
    }

    public JsonbSerializer<Object> getNullSerializer() {
        return this.nullSerializer;
    }

    public Set<Class<?>> getEagerInitClasses() {
        return this.eagerInitClasses;
    }

    public boolean isForceMapArraySerializerForNullKeys() {
        return this.forceMapArraySerializerForNullKeys;
    }
}

