/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.amqp;

import java.util.HashMap;
import java.util.concurrent.TimeUnit;
import org.apache.activemq.artemis.tests.integration.amqp.AmqpClientTestSupport;
import org.apache.activemq.transport.amqp.client.AmqpClient;
import org.apache.activemq.transport.amqp.client.AmqpConnection;
import org.apache.activemq.transport.amqp.client.AmqpMessage;
import org.apache.activemq.transport.amqp.client.AmqpReceiver;
import org.apache.activemq.transport.amqp.client.AmqpSession;
import org.apache.qpid.proton.amqp.Symbol;
import org.apache.qpid.proton.amqp.UnsignedInteger;
import org.junit.Test;

public class AmqpReceiverPriorityTest
extends AmqpClientTestSupport {
    @Test(timeout=30000L)
    public void testPriority() throws Exception {
        AmqpMessage message1;
        int i;
        AmqpClient client = this.createAmqpClient();
        AmqpConnection connection = this.addConnection(client.connect());
        AmqpSession session = connection.createSession();
        HashMap<Symbol, Integer> properties1 = new HashMap<Symbol, Integer>();
        properties1.put(Symbol.getSymbol((String)"priority"), 5);
        AmqpReceiver receiver1 = session.createReceiver(this.getQueueName(), null, false, false, properties1);
        receiver1.flow(100);
        HashMap<Symbol, Integer> properties2 = new HashMap<Symbol, Integer>();
        properties2.put(Symbol.getSymbol((String)"priority"), 50);
        AmqpReceiver receiver2 = session.createReceiver(this.getQueueName(), null, false, false, properties2);
        receiver2.flow(100);
        HashMap<Symbol, Integer> properties3 = new HashMap<Symbol, Integer>();
        properties3.put(Symbol.getSymbol((String)"priority"), 10);
        AmqpReceiver receiver3 = session.createReceiver(this.getQueueName(), null, false, false, properties3);
        receiver3.flow(100);
        this.sendMessages(this.getQueueName(), 5);
        for (i = 0; i < 5; ++i) {
            message1 = receiver1.receiveNoWait();
            AmqpMessage message2 = receiver2.receive(250L, TimeUnit.MILLISECONDS);
            AmqpMessage message3 = receiver3.receiveNoWait();
            AmqpReceiverPriorityTest.assertNotNull((String)"did not receive message first time", (Object)message2);
            AmqpReceiverPriorityTest.assertEquals((Object)("MessageID:" + i), (Object)message2.getMessageId());
            message2.accept();
            AmqpReceiverPriorityTest.assertNull((String)"message is not meant to goto lower priority receiver", (Object)message1);
            AmqpReceiverPriorityTest.assertNull((String)"message is not meant to goto lower priority receiver", (Object)message3);
        }
        this.assertNoMessage(receiver1);
        this.assertNoMessage(receiver3);
        receiver2.close();
        this.sendMessages(this.getQueueName(), 5);
        for (i = 0; i < 5; ++i) {
            message1 = receiver1.receiveNoWait();
            AmqpMessage message3 = receiver3.receive(250L, TimeUnit.MILLISECONDS);
            AmqpReceiverPriorityTest.assertNotNull((String)"did not receive message first time", (Object)message3);
            AmqpReceiverPriorityTest.assertEquals((Object)("MessageID:" + i), (Object)message3.getMessageId());
            message3.accept();
            AmqpReceiverPriorityTest.assertNull((String)"message is not meant to goto lower priority receiver", (Object)message1);
        }
        this.assertNoMessage(receiver1);
        connection.close();
    }

    public void assertNoMessage(AmqpReceiver receiver) throws Exception {
        AmqpMessage message = receiver.receive(250L, TimeUnit.MILLISECONDS);
        AmqpReceiverPriorityTest.assertNull((String)"message is not meant to goto lower priority receiver", (Object)message);
    }

    @Test(timeout=30000L)
    public void testPriorityProvidedAsByte() throws Exception {
        this.testPriorityNumber((byte)5);
    }

    @Test(timeout=30000L)
    public void testPriorityProvidedAsUnsignedInteger() throws Exception {
        this.testPriorityNumber((Number)UnsignedInteger.valueOf((int)5));
    }

    private void testPriorityNumber(Number number) throws Exception {
        AmqpClient client = this.createAmqpClient();
        AmqpConnection connection = this.addConnection(client.connect());
        AmqpSession session = connection.createSession();
        HashMap<Symbol, Number> properties1 = new HashMap<Symbol, Number>();
        properties1.put(Symbol.getSymbol((String)"priority"), number);
        AmqpReceiver receiver1 = session.createReceiver(this.getQueueName(), null, false, false, properties1);
        receiver1.flow(100);
        this.sendMessages(this.getQueueName(), 2);
        for (int i = 0; i < 2; ++i) {
            AmqpMessage message1 = receiver1.receive(3000L, TimeUnit.MILLISECONDS);
            AmqpReceiverPriorityTest.assertNotNull((String)("did not receive message" + i), (Object)message1);
            AmqpReceiverPriorityTest.assertEquals((Object)("MessageID:" + i), (Object)message1.getMessageId());
            message1.accept();
        }
        connection.close();
    }
}

