/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.cluster.bridge;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import org.apache.activemq.artemis.api.core.Message;
import org.apache.activemq.artemis.api.core.QueueConfiguration;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.api.core.TransportConfiguration;
import org.apache.activemq.artemis.api.core.client.ActiveMQClient;
import org.apache.activemq.artemis.api.core.client.ClientConsumer;
import org.apache.activemq.artemis.api.core.client.ClientMessage;
import org.apache.activemq.artemis.api.core.client.ClientProducer;
import org.apache.activemq.artemis.api.core.client.ClientSession;
import org.apache.activemq.artemis.api.core.client.ClientSessionFactory;
import org.apache.activemq.artemis.api.core.client.ServerLocator;
import org.apache.activemq.artemis.core.config.BridgeConfiguration;
import org.apache.activemq.artemis.core.server.ActiveMQServer;
import org.apache.activemq.artemis.core.server.cluster.Bridge;
import org.apache.activemq.artemis.tests.util.ActiveMQTestBase;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class BridgeStartTest
extends ActiveMQTestBase {
    private final boolean netty;

    @Parameterized.Parameters(name="isNetty={0}")
    public static Collection getParameters() {
        return Arrays.asList({true}, {false});
    }

    public BridgeStartTest(boolean netty) {
        this.netty = netty;
    }

    protected boolean isNetty() {
        return this.netty;
    }

    private String getConnector() {
        if (this.isNetty()) {
            return NETTY_CONNECTOR_FACTORY;
        }
        return INVM_CONNECTOR_FACTORY;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testStartStop() throws Exception {
        HashMap server0Params = new HashMap();
        ActiveMQServer server0 = this.createClusteredServerWithParams(this.isNetty(), 0, true, server0Params);
        HashMap<String, Integer> server1Params = new HashMap<String, Integer>();
        if (this.isNetty()) {
            server1Params.put("port", 61617);
        } else {
            server1Params.put("serverId", 1);
        }
        ActiveMQServer server1 = this.createClusteredServerWithParams(this.isNetty(), 1, true, server1Params);
        ServerLocator locator = null;
        try {
            ClientMessage message;
            int i;
            ClientMessage message2;
            int i2;
            String testAddress = "testAddress";
            String queueName0 = "queue0";
            String forwardAddress = "forwardAddress";
            String queueName1 = "queue1";
            HashMap<String, TransportConfiguration> connectors = new HashMap<String, TransportConfiguration>();
            TransportConfiguration server0tc = new TransportConfiguration(this.getConnector(), server0Params);
            TransportConfiguration server1tc = new TransportConfiguration(this.getConnector(), server1Params);
            connectors.put(server1tc.getName(), server1tc);
            server0.getConfiguration().setConnectorConfigurations(connectors);
            ArrayList<String> staticConnectors = new ArrayList<String>();
            staticConnectors.add(server1tc.getName());
            String bridgeName = "bridge1";
            BridgeConfiguration bridgeConfiguration = new BridgeConfiguration().setName("bridge1").setQueueName("queue0").setForwardingAddress("forwardAddress").setRetryInterval(1000L).setReconnectAttempts(0).setReconnectAttemptsOnSameNode(0).setConfirmationWindowSize(1024).setStaticConnectors(staticConnectors);
            ArrayList<BridgeConfiguration> bridgeConfigs = new ArrayList<BridgeConfiguration>();
            bridgeConfigs.add(bridgeConfiguration);
            server0.getConfiguration().setBridgeConfigurations(bridgeConfigs);
            QueueConfiguration queueConfig0 = new QueueConfiguration("queue0").setAddress("testAddress");
            ArrayList<QueueConfiguration> queueConfigs0 = new ArrayList<QueueConfiguration>();
            queueConfigs0.add(queueConfig0);
            server0.getConfiguration().setQueueConfigs(queueConfigs0);
            QueueConfiguration queueConfig1 = new QueueConfiguration("queue1").setAddress("forwardAddress");
            ArrayList<QueueConfiguration> queueConfigs1 = new ArrayList<QueueConfiguration>();
            queueConfigs1.add(queueConfig1);
            server1.getConfiguration().setQueueConfigs(queueConfigs1);
            server1.start();
            this.waitForServerToStart(server1);
            server0.start();
            this.waitForServerToStart(server0);
            locator = ActiveMQClient.createServerLocatorWithoutHA((TransportConfiguration[])new TransportConfiguration[]{server0tc, server1tc});
            ClientSessionFactory sf0 = locator.createSessionFactory(server0tc);
            ClientSessionFactory sf1 = locator.createSessionFactory(server1tc);
            ClientSession session0 = sf0.createSession(false, true, true);
            ClientSession session1 = sf1.createSession(false, true, true);
            ClientProducer producer0 = session0.createProducer(new SimpleString("testAddress"));
            ClientConsumer consumer1 = session1.createConsumer("queue1");
            session1.start();
            int numMessages = 10;
            SimpleString propKey = new SimpleString("testkey");
            for (i2 = 0; i2 < 10; ++i2) {
                message2 = session0.createMessage(false);
                message2.putIntProperty(propKey, i2);
                producer0.send((Message)message2);
            }
            for (i2 = 0; i2 < 10; ++i2) {
                message2 = consumer1.receive(200L);
                Assert.assertNotNull((Object)message2);
                Assert.assertEquals((Object)i2, (Object)message2.getObjectProperty(propKey));
                message2.acknowledge();
            }
            Assert.assertNull((Object)consumer1.receiveImmediate());
            Bridge bridge = (Bridge)server0.getClusterManager().getBridges().get("bridge1");
            bridge.stop();
            bridge.flushExecutor();
            for (i = 0; i < 10; ++i) {
                message = session0.createMessage(false);
                message.putIntProperty(propKey, i);
                producer0.send((Message)message);
            }
            Assert.assertNull((Object)consumer1.receiveImmediate());
            bridge.start();
            for (i = 0; i < 10; ++i) {
                message = consumer1.receive(1000L);
                Assert.assertNotNull((Object)message);
                Assert.assertEquals((Object)i, (Object)message.getObjectProperty(propKey));
                message.acknowledge();
            }
            Assert.assertNull((Object)consumer1.receiveImmediate());
            session0.close();
            session1.close();
            sf0.close();
            sf1.close();
        }
        finally {
            if (locator != null) {
                locator.close();
            }
            server0.stop();
            server1.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testTargetServerUpAndDown() throws Exception {
        HashMap server0Params = new HashMap();
        ActiveMQServer server0 = this.createClusteredServerWithParams(this.isNetty(), 0, true, server0Params);
        HashMap<String, Integer> server1Params = new HashMap<String, Integer>();
        if (this.isNetty()) {
            server1Params.put("port", 61617);
        } else {
            server1Params.put("serverId", 1);
        }
        ActiveMQServer server1 = this.createClusteredServerWithParams(this.isNetty(), 1, true, server1Params);
        String testAddress = "testAddress";
        String queueName0 = "queue0";
        String forwardAddress = "forwardAddress";
        String queueName1 = "queue1";
        HashMap<String, TransportConfiguration> connectors = new HashMap<String, TransportConfiguration>();
        TransportConfiguration server0tc = new TransportConfiguration(this.getConnector(), server0Params);
        TransportConfiguration server1tc = new TransportConfiguration(this.getConnector(), server1Params);
        connectors.put(server1tc.getName(), server1tc);
        server0.getConfiguration().setConnectorConfigurations(connectors);
        ArrayList<String> staticConnectors = new ArrayList<String>();
        staticConnectors.add(server1tc.getName());
        String bridgeName = "bridge1";
        BridgeConfiguration bridgeConfiguration = new BridgeConfiguration().setName("bridge1").setQueueName("queue0").setForwardingAddress("forwardAddress").setRetryInterval(500L).setReconnectAttempts(-1).setReconnectAttemptsOnSameNode(0).setConfirmationWindowSize(1024).setStaticConnectors(staticConnectors);
        ArrayList<BridgeConfiguration> bridgeConfigs = new ArrayList<BridgeConfiguration>();
        bridgeConfigs.add(bridgeConfiguration);
        server0.getConfiguration().setBridgeConfigurations(bridgeConfigs);
        QueueConfiguration queueConfig0 = new QueueConfiguration("queue0").setAddress("testAddress");
        ArrayList<QueueConfiguration> queueConfigs0 = new ArrayList<QueueConfiguration>();
        queueConfigs0.add(queueConfig0);
        server0.getConfiguration().setQueueConfigs(queueConfigs0);
        QueueConfiguration queueConfig1 = new QueueConfiguration("queue1").setAddress("forwardAddress");
        ArrayList<QueueConfiguration> queueConfigs1 = new ArrayList<QueueConfiguration>();
        queueConfigs1.add(queueConfig1);
        server1.getConfiguration().setQueueConfigs(queueConfigs1);
        ServerLocator locator = null;
        try {
            ClientMessage message;
            int i;
            server0.start();
            this.waitForServerToStart(server0);
            locator = ActiveMQClient.createServerLocatorWithoutHA((TransportConfiguration[])new TransportConfiguration[]{server0tc, server1tc});
            ClientSessionFactory sf0 = locator.createSessionFactory(server0tc);
            ClientSession session0 = sf0.createSession(false, true, true);
            ClientProducer producer0 = session0.createProducer(new SimpleString("testAddress"));
            int numMessages = 10;
            SimpleString propKey = new SimpleString("testkey");
            for (int i2 = 0; i2 < 10; ++i2) {
                ClientMessage message2 = session0.createMessage(false);
                message2.putIntProperty(propKey, i2);
                producer0.send((Message)message2);
            }
            Thread.sleep(1000L);
            server1.start();
            this.waitForServerToStart(server1);
            ClientSessionFactory sf1 = locator.createSessionFactory(server1tc);
            ClientSession session1 = sf1.createSession(false, true, true);
            ClientConsumer consumer1 = session1.createConsumer("queue1");
            session1.start();
            for (i = 0; i < 10; ++i) {
                message = consumer1.receive(1000L);
                Assert.assertNotNull((Object)message);
                Assert.assertEquals((Object)i, (Object)message.getObjectProperty(propKey));
                message.acknowledge();
            }
            Assert.assertNull((Object)consumer1.receiveImmediate());
            for (i = 0; i < 10; ++i) {
                message = session0.createMessage(false);
                message.putIntProperty(propKey, i);
                producer0.send((Message)message);
            }
            for (i = 0; i < 10; ++i) {
                message = consumer1.receive(1000L);
                Assert.assertNotNull((Object)message);
                Assert.assertEquals((Object)i, (Object)message.getObjectProperty(propKey));
                message.acknowledge();
            }
            Assert.assertNull((Object)consumer1.receiveImmediate());
            session1.close();
            sf1.close();
            server1.stop();
            for (i = 0; i < 10; ++i) {
                message = session0.createMessage(false);
                message.putIntProperty(propKey, i);
                producer0.send((Message)message);
            }
            server1.start();
            this.waitForServerToStart(server1);
            sf1 = locator.createSessionFactory(server1tc);
            session1 = sf1.createSession(false, true, true);
            consumer1 = session1.createConsumer("queue1");
            session1.start();
            for (i = 0; i < 10; ++i) {
                message = consumer1.receive(1000L);
                Assert.assertNotNull((Object)message);
                Assert.assertEquals((Object)i, (Object)message.getObjectProperty(propKey));
                message.acknowledge();
            }
            Assert.assertNull((Object)consumer1.receiveImmediate());
            session1.close();
            sf1.close();
            session0.close();
            sf0.close();
            locator.close();
        }
        finally {
            if (locator != null) {
                locator.close();
            }
            server0.stop();
            server1.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testTargetServerNotAvailableNoReconnectTries() throws Exception {
        HashMap server0Params = new HashMap();
        ActiveMQServer server0 = this.createClusteredServerWithParams(this.isNetty(), 0, false, server0Params);
        HashMap<String, Integer> server1Params = new HashMap<String, Integer>();
        if (this.isNetty()) {
            server1Params.put("port", 61617);
        } else {
            server1Params.put("serverId", 1);
        }
        ActiveMQServer server1 = this.createClusteredServerWithParams(this.isNetty(), 1, false, server1Params);
        String testAddress = "testAddress";
        String queueName0 = "queue0";
        String forwardAddress = "forwardAddress";
        String queueName1 = "queue1";
        ServerLocator locator = null;
        try {
            HashMap<String, TransportConfiguration> connectors = new HashMap<String, TransportConfiguration>();
            TransportConfiguration server0tc = new TransportConfiguration(this.getConnector(), server0Params);
            TransportConfiguration server1tc = new TransportConfiguration(this.getConnector(), server1Params);
            connectors.put(server1tc.getName(), server1tc);
            server0.getConfiguration().setConnectorConfigurations(connectors);
            ArrayList<String> staticConnectors = new ArrayList<String>();
            staticConnectors.add(server1tc.getName());
            String bridgeName = "bridge1";
            BridgeConfiguration bridgeConfiguration = new BridgeConfiguration().setName("bridge1").setQueueName("queue0").setForwardingAddress("forwardAddress").setRetryInterval(1000L).setReconnectAttempts(0).setReconnectAttemptsOnSameNode(0).setUseDuplicateDetection(false).setConfirmationWindowSize(1024).setStaticConnectors(staticConnectors);
            ArrayList<BridgeConfiguration> bridgeConfigs = new ArrayList<BridgeConfiguration>();
            bridgeConfigs.add(bridgeConfiguration);
            server0.getConfiguration().setBridgeConfigurations(bridgeConfigs);
            QueueConfiguration queueConfig0 = new QueueConfiguration("queue0").setAddress("testAddress");
            ArrayList<QueueConfiguration> queueConfigs0 = new ArrayList<QueueConfiguration>();
            queueConfigs0.add(queueConfig0);
            server0.getConfiguration().setQueueConfigs(queueConfigs0);
            QueueConfiguration queueConfig1 = new QueueConfiguration("queue1").setAddress("forwardAddress");
            ArrayList<QueueConfiguration> queueConfigs1 = new ArrayList<QueueConfiguration>();
            queueConfigs1.add(queueConfig1);
            server1.getConfiguration().setQueueConfigs(queueConfigs1);
            server0.start();
            this.waitForServerToStart(server0);
            locator = ActiveMQClient.createServerLocatorWithoutHA((TransportConfiguration[])new TransportConfiguration[]{server0tc, server1tc});
            ClientSessionFactory sf0 = locator.createSessionFactory(server0tc);
            ClientSession session0 = sf0.createSession(false, true, true);
            ClientProducer producer0 = session0.createProducer(new SimpleString("testAddress"));
            int numMessages = 10;
            SimpleString propKey = new SimpleString("testkey");
            for (int i = 0; i < 10; ++i) {
                ClientMessage message = session0.createMessage(false);
                message.putIntProperty(propKey, i);
                producer0.send((Message)message);
            }
            Thread.sleep(1000L);
            server1.start();
            this.waitForServerToStart(server1);
            ClientSessionFactory sf1 = locator.createSessionFactory(server1tc);
            ClientSession session1 = sf1.createSession(false, true, true);
            ClientConsumer consumer1 = session1.createConsumer("queue1");
            session1.start();
            Assert.assertNull((Object)consumer1.receiveImmediate());
            Bridge bridge = (Bridge)server0.getClusterManager().getBridges().get("bridge1");
            bridge.start();
            for (int i = 0; i < 10; ++i) {
                ClientMessage message = consumer1.receive(3000L);
                Assert.assertNotNull((Object)message);
                Assert.assertEquals((Object)i, (Object)message.getObjectProperty(propKey));
                message.acknowledge();
            }
            Assert.assertNull((Object)consumer1.receiveImmediate());
            session1.close();
            sf1.close();
            session0.close();
            sf0.close();
        }
        finally {
            if (locator != null) {
                locator.close();
            }
            server0.stop();
            server1.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testManualStopStart() throws Exception {
        HashMap server0Params = new HashMap();
        ActiveMQServer server0 = this.createClusteredServerWithParams(this.isNetty(), 0, false, server0Params);
        HashMap<String, Integer> server1Params = new HashMap<String, Integer>();
        if (this.isNetty()) {
            server1Params.put("port", 61617);
        } else {
            server1Params.put("serverId", 1);
        }
        ActiveMQServer server1 = this.createClusteredServerWithParams(this.isNetty(), 1, false, server1Params);
        String testAddress = "testAddress";
        String queueName0 = "queue0";
        String forwardAddress = "forwardAddress";
        String queueName1 = "queue1";
        ServerLocator locator = null;
        try {
            ClientMessage message;
            int i;
            HashMap<String, TransportConfiguration> connectors = new HashMap<String, TransportConfiguration>();
            TransportConfiguration server0tc = new TransportConfiguration(this.getConnector(), server0Params);
            TransportConfiguration server1tc = new TransportConfiguration(this.getConnector(), server1Params);
            connectors.put(server1tc.getName(), server1tc);
            server0.getConfiguration().setConnectorConfigurations(connectors);
            ArrayList<String> staticConnectors = new ArrayList<String>();
            staticConnectors.add(server1tc.getName());
            String bridgeName = "bridge1";
            BridgeConfiguration bridgeConfiguration = new BridgeConfiguration().setName("bridge1").setQueueName("queue0").setForwardingAddress("forwardAddress").setRetryInterval(1000L).setReconnectAttempts(1).setReconnectAttemptsOnSameNode(0).setConfirmationWindowSize(1024).setStaticConnectors(staticConnectors);
            ArrayList<BridgeConfiguration> bridgeConfigs = new ArrayList<BridgeConfiguration>();
            bridgeConfigs.add(bridgeConfiguration);
            server0.getConfiguration().setBridgeConfigurations(bridgeConfigs);
            QueueConfiguration queueConfig0 = new QueueConfiguration("queue0").setAddress("testAddress");
            ArrayList<QueueConfiguration> queueConfigs0 = new ArrayList<QueueConfiguration>();
            queueConfigs0.add(queueConfig0);
            server0.getConfiguration().setQueueConfigs(queueConfigs0);
            QueueConfiguration queueConfig1 = new QueueConfiguration("queue1").setAddress("forwardAddress");
            ArrayList<QueueConfiguration> queueConfigs1 = new ArrayList<QueueConfiguration>();
            queueConfigs1.add(queueConfig1);
            server1.getConfiguration().setQueueConfigs(queueConfigs1);
            server1.start();
            this.waitForServerToStart(server1);
            server0.start();
            this.waitForServerToStart(server0);
            locator = ActiveMQClient.createServerLocatorWithoutHA((TransportConfiguration[])new TransportConfiguration[]{server0tc, server1tc});
            ClientSessionFactory sf0 = locator.createSessionFactory(server0tc);
            ClientSession session0 = sf0.createSession(false, true, true);
            ClientProducer producer0 = session0.createProducer(new SimpleString("testAddress"));
            int numMessages = 10;
            SimpleString propKey = new SimpleString("testkey");
            for (int i2 = 0; i2 < 10; ++i2) {
                ClientMessage message2 = session0.createMessage(false);
                message2.putIntProperty(propKey, i2);
                producer0.send((Message)message2);
            }
            ClientSessionFactory sf1 = locator.createSessionFactory(server1tc);
            ClientSession session1 = sf1.createSession(false, true, true);
            ClientConsumer consumer1 = session1.createConsumer("queue1");
            session1.start();
            for (int i3 = 0; i3 < 10; ++i3) {
                ClientMessage message3 = consumer1.receive(1000L);
                Assert.assertNotNull((Object)message3);
                Assert.assertEquals((Object)i3, (Object)message3.getObjectProperty(propKey));
                message3.acknowledge();
            }
            Assert.assertNull((Object)consumer1.receiveImmediate());
            Bridge bridge = (Bridge)server0.getClusterManager().getBridges().get("bridge1");
            bridge.stop();
            bridge.flushExecutor();
            for (i = 10; i < 20; ++i) {
                message = session0.createMessage(false);
                message.putIntProperty(propKey, i);
                producer0.send((Message)message);
            }
            Assert.assertNull((Object)consumer1.receiveImmediate());
            bridge.start();
            for (i = 10; i < 20; ++i) {
                message = consumer1.receive(1000L);
                Assert.assertNotNull((Object)message);
                Assert.assertEquals((Object)i, (Object)message.getObjectProperty(propKey));
                message.acknowledge();
            }
            Assert.assertNull((Object)consumer1.receiveImmediate());
            bridge.stop();
            bridge.flushExecutor();
            for (i = 0; i < 10; ++i) {
                message = session0.createMessage(false);
                message.putIntProperty(propKey, i);
                producer0.send((Message)message);
            }
            Assert.assertNull((Object)consumer1.receiveImmediate());
            bridge.start();
            for (i = 0; i < 10; ++i) {
                message = consumer1.receive(1000L);
                Assert.assertNotNull((Object)message);
                Assert.assertEquals((Object)i, (Object)message.getObjectProperty(propKey));
                message.acknowledge();
            }
            Assert.assertNull((Object)consumer1.receiveImmediate());
            session1.close();
            sf1.close();
            session0.close();
            sf0.close();
        }
        finally {
            if (locator != null) {
                locator.close();
            }
            server0.stop();
            server1.stop();
        }
    }
}

